/***************************************************************************
                          interface_bindings.cpp  -  description
                             -------------------
    begin                : Thu May 3 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "interface.h"

void Interface::link_to_player(Player_Data *p_player) {

	player=p_player;
	realtime_keyboard.link_to_player(p_player);
        envelope_instruments_volume.set_player(p_player);
        envelope_instruments_pan.set_player(p_player);
        envelope_instruments_frequency.set_player(p_player);
	tracker.link_to_player(p_player);
	view_data.link_to_player(p_player);
	view_pattern.link_to_player(p_player);

}
void Interface::link_to_software_mixer(Mixer_Software *p_softmixer) {

	software_mixer=p_softmixer;
}

void Interface::link_to_sound_driver_manager(Sound_Driver_Manager *p_driver_manager) {

	driver_manager=p_driver_manager;
}

void Interface::link_to_song(Song *p_song) {

	song=p_song;


	editor.link_to_song(song);

	equivtable_instruments.link_to_editor(&editor);


	tracker.link_to_editor(&editor);
	view_data.link_to_editor(&editor);
	view_pattern.link_to_editor(&editor);
	view_pattern.link_to_song(p_song);


	orderlist_ord_pan.link_to_editor(&editor);

	tracker.key_press_event.connect(slot(this,&Interface::tracker_key_press_callback));
	orderlist_ord_pan.key_press_event.connect(slot(this,&Interface::orderlist_key_press_callback));
	equivtable_instruments.key_press_event.connect(slot(this,&Interface::equivtable_key_press_callback));


	player->play_stop();

	update_all_widgets();
}