#
#    Copyright (C) 2007 Marco Ferragina <marco.ferragina@gmail.com>
#    Copyright (C) 2009 Francesco Marella <francesco.marella@gmail.com>
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import gtk
import gobject

import os

from lib.common import *
from lib.gconfhelper import GconfHelper
from lib import utils
from lib import resources
from lib.utils import invoke_subprocess
from lib.utils import log
from statuslistener import StatusListener
import pynotify

UI_FILE = resources.get_data_file("statusicon_popupmenu.ui")

class StatusIcon(StatusListener):
	def __init__(self, crunner):
		self.cr = crunner
		StatusListener.__init__(self, crunner)
		pynotify.init("cGmail")
		
		gtk.window_set_default_icon_from_file(resources.get_data_file("nomail.png"))

		self.builder = gtk.Builder()
		self.builder.add_from_file(UI_FILE)
		self.builder.set_translation_domain("cgmail")

		self.menu = self.builder.get_object("menu")
		dic = {
			"on_configure_activate" : self.on_configure_activate,
			"on_check_mail_menu_item_activate" : self.on_check_mail_menu_item_activate,
			"on_quit_activate": self.on_quit_activate
		}

		self.builder.connect_signals(dic)
	
		self.status_icon = gtk.StatusIcon()
		self.status_icon.set_from_file(resources.get_data_file("nomail.png"))
		self.status_icon.connect("popup-menu", self.on_popup_menu)

		self.call_manage_accounts = False
		
		self.gconf_helper = GconfHelper()
		self.gconf_helper.register_key_listner("always_show_status_icon", 
						self.status_icon_key_listner)
		

		self.checkers_count = {} # checker_id : msgs_count
		
		# dirty hack to preload window list
		self.on_configure_activate(None)
		
		self.hide()
		
	def status_icon_key_listner(self, client, *args):
		"""
		Listen for gconf always_show_status_icon key changes
		"""
		if self.gconf_helper.get_key("always_show_status_icon"):
			self.status_icon.set_visible(True)
		else:
			total = 0
			for id, (count, checker_obj) in self.checkers_count.iteritems():
				total += count
			if total == 0:
				self.status_icon.set_visible(False)

	
	def hide(self):
		if not self.gconf_helper.get_key("always_show_status_icon"):
			self.status_icon.set_visible(False)
	
	def __create_status_pbuf(self, num):
		digits = []
		tmp = num
		while tmp:
			digits.append(str(tmp % 10))
			tmp = tmp / 10

		if len(digits) == 0:
			return gtk.gdk.pixbuf_new_from_file(
					resources.get_data_file("nomail.png")
			)

		if len(digits) > 2:
			digits = digits[:2]
			log("Warning: num lenght > 100. Truncating ...")
			
		status_pbuf = gtk.gdk.pixbuf_new_from_file(resources.get_data_file("mail.png"))
		if len(digits) == 1:
			fname = os.path.join(resources.get_data_file(digits[0] + ".png"))
			digit = gtk.gdk.pixbuf_new_from_file(fname)
			digit.composite(
					status_pbuf, 
					0, 0, 
					status_pbuf.get_width(), status_pbuf.get_height(), 
					15, 0,  # offsets x, y
					1, 1, # scale x, y
					gtk.gdk.INTERP_BILINEAR,
					255) # alpha 0..255

			return status_pbuf
		
		fname = os.path.join(resources.get_data_file(digits[1] + ".png"))
		digit1 = gtk.gdk.pixbuf_new_from_file(fname)
		fname = os.path.join(resources.get_data_file(digits[0] + ".png"))
		digit2 = gtk.gdk.pixbuf_new_from_file(fname)
		digit1.composite(
				status_pbuf, 
				0, 0, 
				status_pbuf.get_width(), status_pbuf.get_height(), 
				5, 0,  # offsets x, y
				1, 1, # scale x, y
				gtk.gdk.INTERP_BILINEAR,
				255) # alpha 0..255
		digit2.composite(
				status_pbuf, 
				0, 0, 
				status_pbuf.get_width(), status_pbuf.get_height(), 
				20, 0,  # offsets x, y
				1, 1, # scale x, y
				gtk.gdk.INTERP_BILINEAR,
				255) # alpha 0..255

		return status_pbuf


	def show(self):
		self.status_icon.set_visible(True)

	def on_checking_error(self, checker, title, text, is_critical):
		print "hm..."

	def on_status_changed(self, crunner, checker):
		gtk.gdk.threads_enter()

		status = checker.get_status()
		id = checker.get_id()
		self.checkers_count[id] = (status["count"], checker)
		total = 0
		for id, (count, checker_obj) in self.checkers_count.iteritems():
			total += count

		if total == 0:
			self.hide()
		else:
			self.show()

		pbuf = self.__create_status_pbuf(total)
		self.status_icon.set_from_pixbuf(pbuf)

		gtk.gdk.threads_leave()

	def on_configure_activate(self, arg):
		utils.window_is_running("cGmail")
		# hack to hide cGmail window on first run cgmailservice
		# when we are preloading window list
		if not arg: return
		try:
			invoke_subprocess("cgmail")
		except OSError:
			invoke_subprocess("./cgmail")
	
	def on_popup_menu(self, si, button, time):
		self.menu.popup(None, None, gtk.status_icon_position_menu,
				button, time, si)
	
	def on_check_mail_menu_item_activate(self, widget):
		self.cr.check()

	def on_checker_running(self, obj):
		self.status_icon.set_from_file(resources.get_data_file("sync_cgmail.png"))

	def on_quit_activate(self, *args):
		gtk.gdk.threads_leave()
		gtk.main_quit()
