import gtk
import gtk.glade
import gobject

import os

from lib.common import *
from lib.gconfhelper import GconfHelper
from lib import utils
from lib.utils import invoke_subprocess

GLADE_FILE = os.path.join(GLADE_BASE_PATH, "statusicon_popupmenu.glade")

class StatusIcon:
	def __init__(self, notifier, checker, stop_cb):
		
		self.notifier = notifier
		self.checker = checker
		self.checker.add_status_cb(self.set_status)
		self.checker.init_checkers(self.no_config)
		self.stop_main_loop = stop_cb

		gtk.window_set_default_icon_from_file(NOMAIL_ICON)

		self.widgets = gtk.glade.XML(GLADE_FILE, domain="cgmail")
		self.menu = self.widgets.get_widget("menu")
		dic = {
			"on_update_activate" : self.on_update_activate,
			"on_configure_activate" : self.on_configure_activate,
			"on_reshow_last_notification_activate" : self.on_reshow_last_notification,
			"on_exit_activate" : self.exit
		}

		self.widgets.signal_autoconnect(dic)
	
		self.status_icon = gtk.StatusIcon()
		#self.status_icon.set_from_stock(gtk.STOCK_CLOSE)
		self.status_icon.set_from_file(NOMAIL_ICON)
		self.status_icon.connect("popup-menu", self.on_popup_menu)
		self.status_icon.connect("activate", self.on_activate)

		self.call_manage_accounts = False
				
		self.gconf_helper = GconfHelper()
		self.gconf_helper.register_key_listner("always_show_status_icon", 
						self.status_icon_key_listner)
		
		#If the user click on systray icon we reshow this message
		self.notification_message = ""
		self.notification_title = ""


		self.hide()
	
	def status_icon_key_listner(self, client, *args):
		if self.gconf_helper.get_key("always_show_status_icon"):
			self.status_icon.set_visible(True)
		else:
			self.status_icon.set_visible(False)

	
	def hide(self):
		if not self.gconf_helper.get_key("always_show_status_icon"):
			self.status_icon.set_visible(False)

	def show(self):
		self.status_icon.set_visible(True)

	def no_config(self):
		print "No accounts configured founded"
		#self.checker.init_checkers(None)
	
	
	def set_status(self, mcount, title, message):
		if mcount == 0:
			self.hide()
			self.status_icon.set_from_file(NOMAIL_ICON)
			self.notification_message = ""
			self.notification_title = ""
		elif mcount > 5:
			self.status_icon.set_from_file(MORE_NEWMAIL_ICON)
			self.show()
		else:
			self.status_icon.set_from_file(NEWMAIL_ICON_BASE_PATH % mcount)
			self.show()

		if title is not None:
			self.notification_title = title
		if message is not None:
			self.notification_message = message

	def on_reshow_last_notification(self, arg):
		self.on_activate(None)

	def on_activate(self, arg):
		
		if self.notification_message != "":
			title = self.notification_title
			message = self.notification_message
			but = True
		else:
			title = _("No messages")
			message = _("There are no new messages in your mailboxes")
			but = False

		self.notifier.notify(title, message, 
				msec = 10000, force = True, buttons = but)

	def on_update_activate(self, arg):
		self.checker.reset()
		self.status_icon.set_from_file(NOMAIL_ICON)
		# force check
		try:
			thread.start_new_thread(self.checker.check, ())
		except Exception, e:
			print "Warning: ", e
	
	def on_configure_activate(self, arg):
		if not invoke_subprocess("cgmail"):
			invoke_subprocess("./cgmail.py")
	
	def on_popup_menu(self, si, button, time):
		#self.menu.popup(None, None, None, button, time, si)
		self.menu.popup(None, None, gtk.status_icon_position_menu,
				button, time, si)
	
	def exit(self, arg):
		self.stop_main_loop()

