#include "pdf/pilot.h"
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*                                                                   *
*     G R V  -  P R O T O N  - P A R A M E T R I Z A T I O N S      *
*                                                                   *
*                          1998 UPDATE                              *
*                                                                   *
*                  For a detailed explanation see                   *
*                   M. Glueck, E. Reya, A. Vogt :                   *
*        hep-ph/9806404  =  DO-TH 98/07  =  WUE-ITP-98-019          *
*                  (Eur. Phys. J. C5 (1998) 461)                    *
*                                                                   *
*   This package contains subroutines returning the light-parton    *
*   distributions in NLO (for the MSbar and DIS schemes) and LO;    * 
*   the respective light-parton, charm, and bottom contributions    *
*   to F2(electromagnetic); and the scale dependence of alpha_s.    *
*                                                                   *
*   The parton densities and F2 values are calculated from inter-   *
*   polation grids covering the regions                             *
*         Q^2/GeV^2  between   0.8   and  1.E6 ( 1.E4 for F2 )      *
*            x       between  1.E-9  and   1.                       *
*   Any call outside these regions stops the program execution.     *
*                                                                   *
*   At Q^2 = MZ^2, alpha_s reads  0.114 (0.125) in NLO (LO); the    *
*   heavy quark thresholds, QH^2 = mh^2, in the beta function are   *
*            mc = 1.4 GeV,  mb = 4.5 GeV,  mt = 175 GeV.            *
*   Note that the NLO alpha_s running is different from GRV(94).    * 
*                                                                   *
*    Questions, comments etc to:  avogt@physik.uni-wuerzburg.de     *
*                                                                   *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
*
*
*
      SUBROUTINE GRV98_lo 
     +    (DX,DQ,DUV,DDV,DUSEA,DDSEA,DSTR,DCHM,DBOT,DTOP,DGL)
C      SUBROUTINE GRV98PA (ISET, X, Q2, UV, DV, US, DS, SS, GL)
*********************************************************************
*                                                                   *
*   THE PARTON ROUTINE.                                             *
*                                     __                            *
*   INPUT:   ISET =  1 (LO),  2 (NLO, MS), or  3 (NLO, DIS)         *
*            X  =  Bjorken-x        (between  1.E-9 and 1.)         *
*            Q2 =  scale in GeV**2  (between  0.8 and 1.E6)         *
*                                                                   *
*   OUTPUT:  UV = u - u(bar),  DV = d - d(bar),  US = u(bar),       *
*            DS = d(bar),  SS = s = s(bar),  GL = gluon.            *
*            Always x times the distribution is returned.           *
*                                                                   *
*   COMMON:  The main program or the calling routine has to have    *
*            a common block  COMMON / INTINIP / IINIP , and the     *
*            integer variable  IINIP  has always to be zero when    *
*            GRV98PA is called for the first time or when  ISET     *
*            has been changed.                                      *
*                                                                   *
*   GRIDS:   1. grv98lo.grid, 2. grv98nlm.grid, 3. grv98nld.grid,   *
*            (1+1809 lines with 6 columns, 4 significant figures)   *
*                                                                   *
*******************************************************i*************
*
#include "pdf/impdp.inc"
      PARAMETER (NPART=6, NX=68, NQ=27, NARG=2)
      DIMENSION XUVF(NX,NQ), XDVF(NX,NQ), XDEF(NX,NQ), XUDF(NX,NQ),
     1          XSF(NX,NQ), XGF(NX,NQ), PARTON (NPART,NQ,NX-1), 
     2          QS(NQ), XB(NX), XT(NARG), NA(NARG), ARRF(NX+NQ) 
      CHARACTER*80 LINE
C      COMMON / INTINIP / IINIP
      SAVE XUVF, XDVF, XDEF, XUDF, XSF, XGF, NA, ARRF
       DATA ZEROD/0.D0/
*
* ..BJORKEN-X AND Q**2 VALUES OF THE GRID :
       DATA QS / 0.8E0, 
     1           1.0E0, 1.3E0, 1.8E0, 2.7E0, 4.0E0, 6.4E0,
     2           1.0E1, 1.6E1, 2.5E1, 4.0E1, 6.4E1,
     3           1.0E2, 1.8E2, 3.2E2, 5.7E2,
     4           1.0E3, 1.8E3, 3.2E3, 5.7E3,
     5           1.0E4, 2.2E4, 4.6E4,
     6           1.0E5, 2.2E5, 4.6E5, 
     7           1.E6 /
       DATA XB / 1.0E-9, 1.8E-9, 3.2E-9, 5.7E-9, 
     A           1.0E-8, 1.8E-8, 3.2E-8, 5.7E-8, 
     B           1.0E-7, 1.8E-7, 3.2E-7, 5.7E-7, 
     C           1.0E-6, 1.4E-6, 2.0E-6, 3.0E-6, 4.5E-6, 6.7E-6,
     1           1.0E-5, 1.4E-5, 2.0E-5, 3.0E-5, 4.5E-5, 6.7E-5,
     2           1.0E-4, 1.4E-4, 2.0E-4, 3.0E-4, 4.5E-4, 6.7E-4,
     3           1.0E-3, 1.4E-3, 2.0E-3, 3.0E-3, 4.5E-3, 6.7E-3,
     4           1.0E-2, 1.4E-2, 2.0E-2, 3.0E-2, 4.5E-2, 0.06, 0.08,
     5           0.1, 0.125, 0.15, 0.175, 0.2, 0.225, 0.25, 0.275,
     6           0.3, 0.325, 0.35, 0.375, 0.4,  0.45, 0.5, 0.55,
     7           0.6, 0.65,  0.7,  0.75,  0.8,  0.85, 0.9, 0.95, 1. /
       DATA IINIP/0/
C
        DATA ((PARTON(I,N,1),I=1,6),N=1,8)/
     +   .7332E-04,  .4500E-04,  .1360E-04,  .1198E+01,  .5633E+00,
     +   .6717E+02,
     +   .7573E-04,  .4648E-04,  .1404E-04,  .1963E+01,  .9456E+00,
     +   .1035E+03,
     +   .7844E-04,  .4815E-04,  .1454E-04,  .3229E+01,  .1578E+01,
     +   .1596E+03,
     +   .8166E-04,  .5012E-04,  .1513E-04,  .5443E+01,  .2685E+01,
     +   .2510E+03,
     +   .8545E-04,  .5245E-04,  .1583E-04,  .9362E+01,  .4644E+01,
     +   .4019E+03,
     +   .8897E-04,  .5461E-04,  .1648E-04,  .1460E+02,  .7262E+01,
     +   .5917E+03,
     +   .9299E-04,  .5707E-04,  .1721E-04,  .2296E+02,  .1144E+02,
     +   .8787E+03,
     +   .9663E-04,  .5931E-04,  .1788E-04,  .3323E+02,  .1658E+02,
     +   .1215E+04 /
        DATA ((PARTON(I,N,1),I=1,6),N=9,16)/
     +   .1003E-03,  .6157E-04,  .1855E-04,  .4670E+02,  .2331E+02,
     +   .1637E+04,
     +   .1037E-03,  .6363E-04,  .1917E-04,  .6215E+02,  .3104E+02,
     +   .2105E+04,
     +   .1071E-03,  .6574E-04,  .1979E-04,  .8150E+02,  .4071E+02,
     +   .2673E+04,
     +   .1104E-03,  .6778E-04,  .2040E-04,  .1041E+03,  .5203E+02,
     +   .3319E+04,
     +   .1135E-03,  .6968E-04,  .2096E-04,  .1288E+03,  .6435E+02,
     +   .4004E+04,
     +   .1175E-03,  .7210E-04,  .2168E-04,  .1661E+03,  .8302E+02,
     +   .5016E+04,
     +   .1212E-03,  .7439E-04,  .2236E-04,  .2082E+03,  .1040E+03,
     +   .6126E+04,
     +   .1249E-03,  .7663E-04,  .2302E-04,  .2559E+03,  .1279E+03,
     +   .7357E+04 /
        DATA ((PARTON(I,N,1),I=1,6),N=17,24)/
     +   .1283E-03,  .7876E-04,  .2365E-04,  .3079E+03,  .1539E+03,
     +   .8668E+04,
     +   .1319E-03,  .8092E-04,  .2429E-04,  .3681E+03,  .1840E+03,
     +   .1016E+05,
     +   .1352E-03,  .8299E-04,  .2489E-04,  .4327E+03,  .2163E+03,
     +   .1173E+05,
     +   .1385E-03,  .8502E-04,  .2549E-04,  .5034E+03,  .2517E+03,
     +   .1342E+05,
     +   .1417E-03,  .8695E-04,  .2606E-04,  .5778E+03,  .2889E+03,
     +   .1517E+05,
     +   .1460E-03,  .8959E-04,  .2683E-04,  .6913E+03,  .3456E+03,
     +   .1779E+05,
     +   .1499E-03,  .9201E-04,  .2754E-04,  .8075E+03,  .4037E+03,
     +   .2043E+05,
     +   .1540E-03,  .9449E-04,  .2826E-04,  .9401E+03,  .4700E+03,
     +   .2339E+05 /
        DATA ((PARTON(I,N,1),I=1,6),N=25,27)/
     +   .1580E-03,  .9696E-04,  .2898E-04,  .1086E+04,  .5429E+03,
     +   .2659E+05,
     +   .1617E-03,  .9923E-04,  .2965E-04,  .1232E+04,  .6161E+03,
     +   .2976E+05,
     +   .1656E-03,  .1016E-03,  .3033E-04,  .1397E+04,  .6984E+03,
     +   .3328E+05 /
        DATA ((PARTON(I,N,2),I=1,6),N=1,8)/
     +   .9722E-04,  .5967E-04,  .1802E-04,  .1119E+01,  .5208E+00,
     +   .6134E+02,
     +   .1004E-03,  .6163E-04,  .1861E-04,  .1814E+01,  .8677E+00,
     +   .9381E+02,
     +   .1040E-03,  .6384E-04,  .1927E-04,  .2953E+01,  .1437E+01,
     +   .1434E+03,
     +   .1083E-03,  .6645E-04,  .2005E-04,  .4928E+01,  .2424E+01,
     +   .2236E+03,
     +   .1133E-03,  .6954E-04,  .2098E-04,  .8392E+01,  .4156E+01,
     +   .3549E+03,
     +   .1180E-03,  .7240E-04,  .2183E-04,  .1298E+02,  .6451E+01,
     +   .5185E+03,
     +   .1233E-03,  .7566E-04,  .2280E-04,  .2025E+02,  .1009E+02,
     +   .7639E+03,
     +   .1281E-03,  .7863E-04,  .2368E-04,  .2912E+02,  .1452E+02,
     +   .1049E+04 /
        DATA ((PARTON(I,N,2),I=1,6),N=9,16)/
     +   .1330E-03,  .8162E-04,  .2457E-04,  .4067E+02,  .2030E+02,
     +   .1406E+04,
     +   .1374E-03,  .8435E-04,  .2538E-04,  .5384E+02,  .2688E+02,
     +   .1798E+04,
     +   .1420E-03,  .8714E-04,  .2621E-04,  .7025E+02,  .3508E+02,
     +   .2271E+04,
     +   .1464E-03,  .8985E-04,  .2701E-04,  .8935E+02,  .4463E+02,
     +   .2807E+04,
     +   .1505E-03,  .9236E-04,  .2775E-04,  .1101E+03,  .5499E+02,
     +   .3373E+04,
     +   .1557E-03,  .9556E-04,  .2869E-04,  .1413E+03,  .7060E+02,
     +   .4204E+04,
     +   .1607E-03,  .9861E-04,  .2959E-04,  .1763E+03,  .8809E+02,
     +   .5112E+04,
     +   .1655E-03,  .1016E-03,  .3046E-04,  .2159E+03,  .1079E+03,
     +   .6114E+04 /
        DATA ((PARTON(I,N,2),I=1,6),N=17,24)/
     +   .1701E-03,  .1044E-03,  .3129E-04,  .2587E+03,  .1293E+03,
     +   .7178E+04,
     +   .1748E-03,  .1073E-03,  .3213E-04,  .3082E+03,  .1541E+03,
     +   .8380E+04,
     +   .1792E-03,  .1100E-03,  .3293E-04,  .3612E+03,  .1806E+03,
     +   .9645E+04,
     +   .1836E-03,  .1127E-03,  .3371E-04,  .4189E+03,  .2094E+03,
     +   .1100E+05,
     +   .1878E-03,  .1152E-03,  .3446E-04,  .4794E+03,  .2397E+03,
     +   .1240E+05,
     +   .1935E-03,  .1187E-03,  .3548E-04,  .5715E+03,  .2857E+03,
     +   .1449E+05,
     +   .1987E-03,  .1219E-03,  .3641E-04,  .6654E+03,  .3327E+03,
     +   .1658E+05,
     +   .2041E-03,  .1252E-03,  .3736E-04,  .7723E+03,  .3861E+03,
     +   .1892E+05 /
        DATA ((PARTON(I,N,2),I=1,6),N=25,27)/
     +   .2094E-03,  .1285E-03,  .3831E-04,  .8893E+03,  .4446E+03,
     +   .2145E+05,
     +   .2143E-03,  .1315E-03,  .3917E-04,  .1007E+04,  .5032E+03,
     +   .2394E+05,
     +   .2194E-03,  .1346E-03,  .4007E-04,  .1138E+04,  .5689E+03,
     +   .2670E+05 /
        DATA ((PARTON(I,N,3),I=1,6),N=1,8)/
     +   .1281E-03,  .7865E-04,  .2374E-04,  .1049E+01,  .4819E+00,
     +   .5607E+02,
     +   .1323E-03,  .8123E-04,  .2452E-04,  .1679E+01,  .7968E+00,
     +   .8507E+02,
     +   .1371E-03,  .8414E-04,  .2539E-04,  .2705E+01,  .1309E+01,
     +   .1290E+03,
     +   .1427E-03,  .8758E-04,  .2641E-04,  .4469E+01,  .2191E+01,
     +   .1994E+03,
     +   .1493E-03,  .9165E-04,  .2762E-04,  .7534E+01,  .3723E+01,
     +   .3137E+03,
     +   .1555E-03,  .9541E-04,  .2874E-04,  .1156E+02,  .5737E+01,
     +   .4548E+03,
     +   .1625E-03,  .9971E-04,  .3002E-04,  .1789E+02,  .8901E+01,
     +   .6649E+03,
     +   .1688E-03,  .1036E-03,  .3118E-04,  .2555E+02,  .1273E+02,
     +   .9071E+03 /
        DATA ((PARTON(I,N,3),I=1,6),N=9,16)/
     +   .1752E-03,  .1076E-03,  .3234E-04,  .3547E+02,  .1769E+02,
     +   .1208E+04,
     +   .1811E-03,  .1111E-03,  .3340E-04,  .4671E+02,  .2331E+02,
     +   .1537E+04,
     +   .1871E-03,  .1148E-03,  .3449E-04,  .6064E+02,  .3027E+02,
     +   .1932E+04,
     +   .1929E-03,  .1184E-03,  .3554E-04,  .7678E+02,  .3834E+02,
     +   .2377E+04,
     +   .1983E-03,  .1217E-03,  .3650E-04,  .9420E+02,  .4705E+02,
     +   .2845E+04,
     +   .2052E-03,  .1259E-03,  .3774E-04,  .1203E+03,  .6012E+02,
     +   .3529E+04,
     +   .2117E-03,  .1299E-03,  .3891E-04,  .1495E+03,  .7470E+02,
     +   .4272E+04,
     +   .2181E-03,  .1338E-03,  .4005E-04,  .1823E+03,  .9112E+02,
     +   .5089E+04 /
        DATA ((PARTON(I,N,3),I=1,6),N=17,24)/
     +   .2241E-03,  .1375E-03,  .4113E-04,  .2178E+03,  .1088E+03,
     +   .5952E+04,
     +   .2303E-03,  .1413E-03,  .4223E-04,  .2585E+03,  .1292E+03,
     +   .6924E+04,
     +   .2361E-03,  .1449E-03,  .4328E-04,  .3019E+03,  .1509E+03,
     +   .7943E+04,
     +   .2419E-03,  .1484E-03,  .4430E-04,  .3491E+03,  .1745E+03,
     +   .9030E+04,
     +   .2474E-03,  .1518E-03,  .4527E-04,  .3985E+03,  .1992E+03,
     +   .1015E+05,
     +   .2549E-03,  .1564E-03,  .4660E-04,  .4733E+03,  .2366E+03,
     +   .1182E+05,
     +   .2617E-03,  .1606E-03,  .4782E-04,  .5493E+03,  .2746E+03,
     +   .1348E+05,
     +   .2688E-03,  .1649E-03,  .4906E-04,  .6354E+03,  .3177E+03,
     +   .1533E+05 /
        DATA ((PARTON(I,N,3),I=1,6),N=25,27)/
     +   .2758E-03,  .1692E-03,  .5030E-04,  .7295E+03,  .3647E+03,
     +   .1733E+05,
     +   .2822E-03,  .1731E-03,  .5143E-04,  .8235E+03,  .4117E+03,
     +   .1929E+05,
     +   .2889E-03,  .1772E-03,  .5259E-04,  .9285E+03,  .4642E+03,
     +   .2145E+05 /
        DATA ((PARTON(I,N,4),I=1,6),N=1,8)/
     +   .1690E-03,  .1038E-03,  .3131E-04,  .9831E+00,  .4453E+00,
     +   .5116E+02,
     +   .1746E-03,  .1072E-03,  .3232E-04,  .1555E+01,  .7307E+00,
     +   .7701E+02,
     +   .1808E-03,  .1110E-03,  .3346E-04,  .2477E+01,  .1192E+01,
     +   .1158E+03,
     +   .1882E-03,  .1155E-03,  .3481E-04,  .4048E+01,  .1977E+01,
     +   .1775E+03,
     +   .1970E-03,  .1209E-03,  .3640E-04,  .6754E+01,  .3329E+01,
     +   .2766E+03,
     +   .2051E-03,  .1259E-03,  .3787E-04,  .1028E+02,  .5092E+01,
     +   .3981E+03,
     +   .2143E-03,  .1315E-03,  .3955E-04,  .1577E+02,  .7839E+01,
     +   .5773E+03,
     +   .2227E-03,  .1367E-03,  .4106E-04,  .2238E+02,  .1114E+02,
     +   .7824E+03 /
        DATA ((PARTON(I,N,4),I=1,6),N=9,16)/
     +   .2311E-03,  .1418E-03,  .4259E-04,  .3087E+02,  .1538E+02,
     +   .1035E+04,
     +   .2389E-03,  .1466E-03,  .4398E-04,  .4043E+02,  .2017E+02,
     +   .1311E+04,
     +   .2468E-03,  .1514E-03,  .4540E-04,  .5222E+02,  .2606E+02,
     +   .1639E+04,
     +   .2544E-03,  .1561E-03,  .4677E-04,  .6581E+02,  .3286E+02,
     +   .2007E+04,
     +   .2615E-03,  .1605E-03,  .4804E-04,  .8042E+02,  .4016E+02,
     +   .2392E+04,
     +   .2706E-03,  .1660E-03,  .4966E-04,  .1022E+03,  .5106E+02,
     +   .2952E+04,
     +   .2792E-03,  .1713E-03,  .5119E-04,  .1264E+03,  .6317E+02,
     +   .3558E+04,
     +   .2875E-03,  .1764E-03,  .5268E-04,  .1536E+03,  .7674E+02,
     +   .4221E+04 /
        DATA ((PARTON(I,N,4),I=1,6),N=17,24)/
     +   .2955E-03,  .1813E-03,  .5409E-04,  .1828E+03,  .9133E+02,
     +   .4919E+04,
     +   .3036E-03,  .1863E-03,  .5553E-04,  .2162E+03,  .1080E+03,
     +   .5701E+04,
     +   .3113E-03,  .1910E-03,  .5689E-04,  .2517E+03,  .1258E+03,
     +   .6518E+04,
     +   .3189E-03,  .1956E-03,  .5823E-04,  .2901E+03,  .1450E+03,
     +   .7387E+04,
     +   .3261E-03,  .2001E-03,  .5950E-04,  .3302E+03,  .1650E+03,
     +   .8278E+04,
     +   .3360E-03,  .2061E-03,  .6124E-04,  .3907E+03,  .1953E+03,
     +   .9602E+04,
     +   .3450E-03,  .2116E-03,  .6282E-04,  .4519E+03,  .2259E+03,
     +   .1092E+05,
     +   .3543E-03,  .2173E-03,  .6444E-04,  .5212E+03,  .2605E+03,
     +   .1238E+05 /
        DATA ((PARTON(I,N,4),I=1,6),N=25,27)/
     +   .3635E-03,  .2230E-03,  .6604E-04,  .5965E+03,  .2982E+03,
     +   .1394E+05,
     +   .3720E-03,  .2281E-03,  .6752E-04,  .6715E+03,  .3357E+03,
     +   .1548E+05,
     +   .3807E-03,  .2335E-03,  .6904E-04,  .7550E+03,  .3775E+03,
     +   .1717E+05 /
        DATA ((PARTON(I,N,5),I=1,6),N=1,8)/
     +   .2214E-03,  .1359E-03,  .4097E-04,  .9246E+00,  .4120E+00,
     +   .4674E+02,
     +   .2286E-03,  .1403E-03,  .4229E-04,  .1443E+01,  .6710E+00,
     +   .6980E+02,
     +   .2368E-03,  .1453E-03,  .4378E-04,  .2273E+01,  .1086E+01,
     +   .1042E+03,
     +   .2465E-03,  .1513E-03,  .4554E-04,  .3676E+01,  .1786E+01,
     +   .1583E+03,
     +   .2579E-03,  .1583E-03,  .4761E-04,  .6068E+01,  .2982E+01,
     +   .2444E+03,
     +   .2685E-03,  .1648E-03,  .4952E-04,  .9159E+01,  .4527E+01,
     +   .3490E+03,
     +   .2806E-03,  .1722E-03,  .5170E-04,  .1394E+02,  .6916E+01,
     +   .5021E+03,
     +   .2915E-03,  .1789E-03,  .5367E-04,  .1964E+02,  .9764E+01,
     +   .6760E+03 /
        DATA ((PARTON(I,N,5),I=1,6),N=9,16)/
     +   .3026E-03,  .1857E-03,  .5566E-04,  .2692E+02,  .1340E+02,
     +   .8892E+03,
     +   .3127E-03,  .1919E-03,  .5747E-04,  .3507E+02,  .1748E+02,
     +   .1120E+04,
     +   .3230E-03,  .1982E-03,  .5931E-04,  .4507E+02,  .2248E+02,
     +   .1393E+04,
     +   .3331E-03,  .2044E-03,  .6109E-04,  .5654E+02,  .2821E+02,
     +   .1698E+04,
     +   .3423E-03,  .2100E-03,  .6274E-04,  .6881E+02,  .3435E+02,
     +   .2015E+04,
     +   .3542E-03,  .2173E-03,  .6484E-04,  .8704E+02,  .4347E+02,
     +   .2475E+04,
     +   .3654E-03,  .2242E-03,  .6682E-04,  .1072E+03,  .5354E+02,
     +   .2970E+04,
     +   .3763E-03,  .2309E-03,  .6876E-04,  .1297E+03,  .6478E+02,
     +   .3509E+04 /
        DATA ((PARTON(I,N,5),I=1,6),N=17,24)/
     +   .3867E-03,  .2373E-03,  .7058E-04,  .1537E+03,  .7682E+02,
     +   .4074E+04,
     +   .3973E-03,  .2437E-03,  .7244E-04,  .1812E+03,  .9054E+02,
     +   .4705E+04,
     +   .4074E-03,  .2499E-03,  .7421E-04,  .2103E+03,  .1051E+03,
     +   .5362E+04,
     +   .4173E-03,  .2560E-03,  .7594E-04,  .2417E+03,  .1208E+03,
     +   .6057E+04,
     +   .4267E-03,  .2618E-03,  .7758E-04,  .2742E+03,  .1371E+03,
     +   .6769E+04,
     +   .4396E-03,  .2696E-03,  .7982E-04,  .3233E+03,  .1616E+03,
     +   .7821E+04,
     +   .4514E-03,  .2769E-03,  .8186E-04,  .3728E+03,  .1864E+03,
     +   .8864E+04,
     +   .4635E-03,  .2843E-03,  .8395E-04,  .4286E+03,  .2142E+03,
     +   .1002E+05 /
        DATA ((PARTON(I,N,5),I=1,6),N=25,27)/
     +   .4755E-03,  .2916E-03,  .8603E-04,  .4890E+03,  .2444E+03,
     +   .1125E+05,
     +   .4866E-03,  .2984E-03,  .8793E-04,  .5490E+03,  .2744E+03,
     +   .1245E+05,
     +   .4980E-03,  .3054E-03,  .8989E-04,  .6157E+03,  .3078E+03,
     +   .1377E+05 /
        DATA ((PARTON(I,N,6),I=1,6),N=1,8)/
     +   .2935E-03,  .1801E-03,  .5426E-04,  .8686E+00,  .3794E+00,
     +   .4247E+02,
     +   .3031E-03,  .1860E-03,  .5601E-04,  .1337E+01,  .6130E+00,
     +   .6289E+02,
     +   .3139E-03,  .1927E-03,  .5797E-04,  .2079E+01,  .9837E+00,
     +   .9304E+02,
     +   .3267E-03,  .2005E-03,  .6028E-04,  .3321E+01,  .1604E+01,
     +   .1401E+03,
     +   .3419E-03,  .2098E-03,  .6301E-04,  .5421E+01,  .2654E+01,
     +   .2142E+03,
     +   .3559E-03,  .2184E-03,  .6553E-04,  .8108E+01,  .3997E+01,
     +   .3035E+03,
     +   .3719E-03,  .2282E-03,  .6839E-04,  .1223E+02,  .6056E+01,
     +   .4329E+03,
     +   .3864E-03,  .2371E-03,  .7098E-04,  .1710E+02,  .8493E+01,
     +   .5789E+03 /
        DATA ((PARTON(I,N,6),I=1,6),N=9,16)/
     +   .4010E-03,  .2461E-03,  .7359E-04,  .2329E+02,  .1158E+02,
     +   .7564E+03,
     +   .4144E-03,  .2543E-03,  .7596E-04,  .3017E+02,  .1503E+02,
     +   .9471E+03,
     +   .4281E-03,  .2627E-03,  .7838E-04,  .3856E+02,  .1922E+02,
     +   .1172E+04,
     +   .4413E-03,  .2708E-03,  .8072E-04,  .4814E+02,  .2401E+02,
     +   .1422E+04,
     +   .4536E-03,  .2783E-03,  .8288E-04,  .5833E+02,  .2911E+02,
     +   .1680E+04,
     +   .4692E-03,  .2879E-03,  .8563E-04,  .7341E+02,  .3664E+02,
     +   .2053E+04,
     +   .4841E-03,  .2970E-03,  .8823E-04,  .8998E+02,  .4493E+02,
     +   .2452E+04,
     +   .4986E-03,  .3059E-03,  .9075E-04,  .1084E+03,  .5413E+02,
     +   .2884E+04 /
        DATA ((PARTON(I,N,6),I=1,6),N=17,24)/
     +   .5123E-03,  .3143E-03,  .9314E-04,  .1280E+03,  .6394E+02,
     +   .3335E+04,
     +   .5263E-03,  .3228E-03,  .9557E-04,  .1503E+03,  .7509E+02,
     +   .3837E+04,
     +   .5396E-03,  .3310E-03,  .9788E-04,  .1738E+03,  .8685E+02,
     +   .4357E+04,
     +   .5527E-03,  .3390E-03,  .1001E-03,  .1991E+03,  .9949E+02,
     +   .4907E+04,
     +   .5652E-03,  .3466E-03,  .1023E-03,  .2253E+03,  .1126E+03,
     +   .5466E+04,
     +   .5822E-03,  .3570E-03,  .1052E-03,  .2645E+03,  .1322E+03,
     +   .6291E+04,
     +   .5978E-03,  .3666E-03,  .1079E-03,  .3040E+03,  .1519E+03,
     +   .7105E+04,
     +   .6137E-03,  .3763E-03,  .1106E-03,  .3483E+03,  .1741E+03,
     +   .8002E+04 /
        DATA ((PARTON(I,N,6),I=1,6),N=25,27)/
     +   .6296E-03,  .3861E-03,  .1133E-03,  .3961E+03,  .1980E+03,
     +   .8955E+04,
     +   .6442E-03,  .3950E-03,  .1158E-03,  .4434E+03,  .2216E+03,
     +   .9885E+04,
     +   .6593E-03,  .4042E-03,  .1183E-03,  .4959E+03,  .2479E+03,
     +   .1090E+05 /
        DATA ((PARTON(I,N,7),I=1,6),N=1,8)/
     +   .3867E-03,  .2374E-03,  .7142E-04,  .8189E+00,  .3496E+00,
     +   .3862E+02,
     +   .3994E-03,  .2451E-03,  .7370E-04,  .1241E+01,  .5603E+00,
     +   .5670E+02,
     +   .4137E-03,  .2539E-03,  .7627E-04,  .1906E+01,  .8920E+00,
     +   .8317E+02,
     +   .4305E-03,  .2642E-03,  .7930E-04,  .3007E+01,  .1442E+01,
     +   .1241E+03,
     +   .4505E-03,  .2764E-03,  .8287E-04,  .4850E+01,  .2363E+01,
     +   .1879E+03,
     +   .4689E-03,  .2877E-03,  .8615E-04,  .7189E+01,  .3532E+01,
     +   .2641E+03,
     +   .4899E-03,  .3006E-03,  .8989E-04,  .1074E+02,  .5308E+01,
     +   .3737E+03,
     +   .5090E-03,  .3123E-03,  .9327E-04,  .1492E+02,  .7394E+01,
     +   .4961E+03 /
        DATA ((PARTON(I,N,7),I=1,6),N=9,16)/
     +   .5283E-03,  .3242E-03,  .9667E-04,  .2017E+02,  .1002E+02,
     +   .6441E+03,
     +   .5459E-03,  .3349E-03,  .9976E-04,  .2599E+02,  .1293E+02,
     +   .8020E+03,
     +   .5638E-03,  .3459E-03,  .1029E-03,  .3304E+02,  .1645E+02,
     +   .9873E+03,
     +   .5812E-03,  .3566E-03,  .1059E-03,  .4104E+02,  .2045E+02,
     +   .1192E+04,
     +   .5973E-03,  .3665E-03,  .1087E-03,  .4952E+02,  .2469E+02,
     +   .1402E+04,
     +   .6179E-03,  .3791E-03,  .1123E-03,  .6199E+02,  .3093E+02,
     +   .1705E+04,
     +   .6374E-03,  .3910E-03,  .1157E-03,  .7563E+02,  .3775E+02,
     +   .2026E+04,
     +   .6565E-03,  .4027E-03,  .1190E-03,  .9072E+02,  .4529E+02,
     +   .2373E+04 /
        DATA ((PARTON(I,N,7),I=1,6),N=17,24)/
     +   .6745E-03,  .4137E-03,  .1221E-03,  .1067E+03,  .5330E+02,
     +   .2734E+04,
     +   .6929E-03,  .4249E-03,  .1252E-03,  .1248E+03,  .6235E+02,
     +   .3133E+04,
     +   .7104E-03,  .4357E-03,  .1282E-03,  .1439E+03,  .7187E+02,
     +   .3545E+04,
     +   .7276E-03,  .4462E-03,  .1311E-03,  .1643E+03,  .8207E+02,
     +   .3979E+04,
     +   .7439E-03,  .4562E-03,  .1339E-03,  .1853E+03,  .9259E+02,
     +   .4419E+04,
     +   .7663E-03,  .4698E-03,  .1377E-03,  .2168E+03,  .1083E+03,
     +   .5066E+04,
     +   .7867E-03,  .4823E-03,  .1411E-03,  .2483E+03,  .1241E+03,
     +   .5701E+04,
     +   .8077E-03,  .4951E-03,  .1447E-03,  .2834E+03,  .1416E+03,
     +   .6399E+04 /
        DATA ((PARTON(I,N,7),I=1,6),N=25,27)/
     +   .8285E-03,  .5079E-03,  .1481E-03,  .3213E+03,  .1606E+03,
     +   .7138E+04,
     +   .8476E-03,  .5195E-03,  .1513E-03,  .3587E+03,  .1793E+03,
     +   .7855E+04,
     +   .8674E-03,  .5316E-03,  .1546E-03,  .4000E+03,  .1999E+03,
     +   .8637E+04 /
        DATA ((PARTON(I,N,8),I=1,6),N=1,8)/
     +   .5101E-03,  .3131E-03,  .9405E-04,  .7737E+00,  .3216E+00,
     +   .3504E+02,
     +   .5268E-03,  .3233E-03,  .9704E-04,  .1154E+01,  .5114E+00,
     +   .5102E+02,
     +   .5456E-03,  .3348E-03,  .1004E-03,  .1747E+01,  .8075E+00,
     +   .7419E+02,
     +   .5678E-03,  .3484E-03,  .1044E-03,  .2722E+01,  .1294E+01,
     +   .1097E+03,
     +   .5940E-03,  .3645E-03,  .1090E-03,  .4336E+01,  .2100E+01,
     +   .1645E+03,
     +   .6183E-03,  .3794E-03,  .1133E-03,  .6365E+01,  .3114E+01,
     +   .2292E+03,
     +   .6460E-03,  .3964E-03,  .1182E-03,  .9422E+01,  .4642E+01,
     +   .3216E+03,
     +   .6711E-03,  .4118E-03,  .1226E-03,  .1298E+02,  .6422E+01,
     +   .4239E+03 /
        DATA ((PARTON(I,N,8),I=1,6),N=9,16)/
     +   .6964E-03,  .4273E-03,  .1270E-03,  .1744E+02,  .8648E+01,
     +   .5467E+03,
     +   .7196E-03,  .4415E-03,  .1310E-03,  .2233E+02,  .1110E+02,
     +   .6769E+03,
     +   .7432E-03,  .4559E-03,  .1351E-03,  .2823E+02,  .1404E+02,
     +   .8288E+03,
     +   .7661E-03,  .4700E-03,  .1391E-03,  .3489E+02,  .1737E+02,
     +   .9952E+03,
     +   .7873E-03,  .4829E-03,  .1427E-03,  .4191E+02,  .2089E+02,
     +   .1166E+04,
     +   .8143E-03,  .4995E-03,  .1473E-03,  .5220E+02,  .2603E+02,
     +   .1410E+04,
     +   .8400E-03,  .5152E-03,  .1517E-03,  .6338E+02,  .3162E+02,
     +   .1668E+04,
     +   .8650E-03,  .5305E-03,  .1559E-03,  .7569E+02,  .3777E+02,
     +   .1945E+04 /
        DATA ((PARTON(I,N,8),I=1,6),N=17,24)/
     +   .8887E-03,  .5450E-03,  .1600E-03,  .8870E+02,  .4427E+02,
     +   .2232E+04,
     +   .9128E-03,  .5597E-03,  .1640E-03,  .1033E+03,  .5160E+02,
     +   .2548E+04,
     +   .9358E-03,  .5738E-03,  .1679E-03,  .1187E+03,  .5927E+02,
     +   .2872E+04,
     +   .9584E-03,  .5876E-03,  .1717E-03,  .1351E+03,  .6746E+02,
     +   .3213E+04,
     +   .9798E-03,  .6007E-03,  .1752E-03,  .1519E+03,  .7588E+02,
     +   .3558E+04,
     +   .1009E-02,  .6186E-03,  .1801E-03,  .1770E+03,  .8841E+02,
     +   .4061E+04,
     +   .1036E-02,  .6350E-03,  .1846E-03,  .2020E+03,  .1009E+03,
     +   .4554E+04,
     +   .1063E-02,  .6518E-03,  .1891E-03,  .2298E+03,  .1148E+03,
     +   .5094E+04 /
        DATA ((PARTON(I,N,8),I=1,6),N=25,27)/
     +   .1091E-02,  .6685E-03,  .1936E-03,  .2597E+03,  .1298E+03,
     +   .5663E+04,
     +   .1116E-02,  .6838E-03,  .1977E-03,  .2890E+03,  .1444E+03,
     +   .6214E+04,
     +   .1142E-02,  .6996E-03,  .2019E-03,  .3213E+03,  .1606E+03,
     +   .6812E+04 /
        DATA ((PARTON(I,N,9),I=1,6),N=1,8)/
     +   .6678E-03,  .4099E-03,  .1229E-03,  .7342E+00,  .2962E+00,
     +   .3184E+02,
     +   .6897E-03,  .4232E-03,  .1268E-03,  .1077E+01,  .4672E+00,
     +   .4596E+02,
     +   .7142E-03,  .4383E-03,  .1311E-03,  .1608E+01,  .7318E+00,
     +   .6626E+02,
     +   .7432E-03,  .4561E-03,  .1363E-03,  .2470E+01,  .1163E+01,
     +   .9705E+02,
     +   .7775E-03,  .4771E-03,  .1423E-03,  .3886E+01,  .1870E+01,
     +   .1441E+03,
     +   .8092E-03,  .4965E-03,  .1478E-03,  .5649E+01,  .2750E+01,
     +   .1993E+03,
     +   .8454E-03,  .5187E-03,  .1541E-03,  .8282E+01,  .4066E+01,
     +   .2772E+03,
     +   .8782E-03,  .5388E-03,  .1598E-03,  .1132E+02,  .5587E+01,
     +   .3628E+03 /
        DATA ((PARTON(I,N,9),I=1,6),N=9,16)/
     +   .9113E-03,  .5591E-03,  .1655E-03,  .1510E+02,  .7475E+01,
     +   .4649E+03,
     +   .9415E-03,  .5775E-03,  .1707E-03,  .1923E+02,  .9539E+01,
     +   .5723E+03,
     +   .9723E-03,  .5964E-03,  .1759E-03,  .2418E+02,  .1201E+02,
     +   .6970E+03,
     +   .1002E-02,  .6147E-03,  .1810E-03,  .2973E+02,  .1479E+02,
     +   .8328E+03,
     +   .1030E-02,  .6316E-03,  .1857E-03,  .3556E+02,  .1770E+02,
     +   .9717E+03,
     +   .1065E-02,  .6532E-03,  .1916E-03,  .4405E+02,  .2194E+02,
     +   .1169E+04,
     +   .1099E-02,  .6736E-03,  .1972E-03,  .5323E+02,  .2654E+02,
     +   .1376E+04,
     +   .1131E-02,  .6936E-03,  .2027E-03,  .6329E+02,  .3157E+02,
     +   .1597E+04 /
        DATA ((PARTON(I,N,9),I=1,6),N=17,24)/
     +   .1162E-02,  .7124E-03,  .2078E-03,  .7388E+02,  .3686E+02,
     +   .1825E+04,
     +   .1193E-02,  .7316E-03,  .2130E-03,  .8575E+02,  .4279E+02,
     +   .2076E+04,
     +   .1223E-02,  .7500E-03,  .2180E-03,  .9814E+02,  .4899E+02,
     +   .2332E+04,
     +   .1253E-02,  .7679E-03,  .2228E-03,  .1113E+03,  .5557E+02,
     +   .2600E+04,
     +   .1281E-02,  .7850E-03,  .2274E-03,  .1248E+03,  .6232E+02,
     +   .2870E+04,
     +   .1319E-02,  .8083E-03,  .2336E-03,  .1448E+03,  .7234E+02,
     +   .3263E+04,
     +   .1354E-02,  .8296E-03,  .2392E-03,  .1647E+03,  .8228E+02,
     +   .3646E+04,
     +   .1390E-02,  .8514E-03,  .2450E-03,  .1868E+03,  .9331E+02,
     +   .4064E+04 /
        DATA ((PARTON(I,N,9),I=1,6),N=25,27)/
     +   .1425E-02,  .8731E-03,  .2508E-03,  .2104E+03,  .1051E+03,
     +   .4503E+04,
     +   .1458E-02,  .8930E-03,  .2560E-03,  .2335E+03,  .1167E+03,
     +   .4926E+04,
     +   .1492E-02,  .9135E-03,  .2614E-03,  .2588E+03,  .1293E+03,
     +   .5384E+04 /
        DATA ((PARTON(I,N,10),I=1,6),N=1,8)/
     +   .8851E-03,  .5432E-03,  .1625E-03,  .6975E+00,  .2713E+00,
     +   .2875E+02,
     +   .9140E-03,  .5609E-03,  .1676E-03,  .1005E+01,  .4245E+00,
     +   .4113E+02,
     +   .9464E-03,  .5808E-03,  .1732E-03,  .1475E+01,  .6591E+00,
     +   .5875E+02,
     +   .9848E-03,  .6043E-03,  .1799E-03,  .2234E+01,  .1037E+01,
     +   .8522E+02,
     +   .1030E-02,  .6321E-03,  .1878E-03,  .3464E+01,  .1652E+01,
     +   .1253E+03,
     +   .1072E-02,  .6578E-03,  .1950E-03,  .4982E+01,  .2410E+01,
     +   .1717E+03,
     +   .1120E-02,  .6870E-03,  .2032E-03,  .7229E+01,  .3533E+01,
     +   .2367E+03,
     +   .1163E-02,  .7136E-03,  .2106E-03,  .9802E+01,  .4819E+01,
     +   .3075E+03 /
        DATA ((PARTON(I,N,10),I=1,6),N=9,16)/
     +   .1207E-02,  .7403E-03,  .2180E-03,  .1297E+02,  .6404E+01,
     +   .3912E+03,
     +   .1247E-02,  .7647E-03,  .2247E-03,  .1642E+02,  .8124E+01,
     +   .4787E+03,
     +   .1287E-02,  .7896E-03,  .2315E-03,  .2051E+02,  .1017E+02,
     +   .5796E+03,
     +   .1327E-02,  .8137E-03,  .2381E-03,  .2509E+02,  .1246E+02,
     +   .6890E+03,
     +   .1363E-02,  .8360E-03,  .2442E-03,  .2987E+02,  .1485E+02,
     +   .8001E+03,
     +   .1410E-02,  .8644E-03,  .2518E-03,  .3679E+02,  .1831E+02,
     +   .9569E+03,
     +   .1454E-02,  .8914E-03,  .2591E-03,  .4424E+02,  .2203E+02,
     +   .1121E+04,
     +   .1497E-02,  .9176E-03,  .2661E-03,  .5235E+02,  .2609E+02,
     +   .1295E+04 /
        DATA ((PARTON(I,N,10),I=1,6),N=17,24)/
     +   .1538E-02,  .9425E-03,  .2728E-03,  .6085E+02,  .3034E+02,
     +   .1474E+04,
     +   .1579E-02,  .9678E-03,  .2795E-03,  .7034E+02,  .3508E+02,
     +   .1669E+04,
     +   .1619E-02,  .9919E-03,  .2858E-03,  .8020E+02,  .4001E+02,
     +   .1868E+04,
     +   .1657E-02,  .1015E-02,  .2920E-03,  .9065E+02,  .4523E+02,
     +   .2076E+04,
     +   .1694E-02,  .1038E-02,  .2979E-03,  .1013E+03,  .5057E+02,
     +   .2284E+04,
     +   .1744E-02,  .1069E-02,  .3059E-03,  .1171E+03,  .5845E+02,
     +   .2585E+04,
     +   .1790E-02,  .1097E-02,  .3132E-03,  .1327E+03,  .6624E+02,
     +   .2878E+04,
     +   .1837E-02,  .1125E-02,  .3206E-03,  .1499E+03,  .7485E+02,
     +   .3196E+04 /
        DATA ((PARTON(I,N,10),I=1,6),N=25,27)/
     +   .1884E-02,  .1154E-02,  .3280E-03,  .1682E+03,  .8402E+02,
     +   .3528E+04,
     +   .1927E-02,  .1180E-02,  .3346E-03,  .1861E+03,  .9296E+02,
     +   .3848E+04,
     +   .1971E-02,  .1207E-02,  .3415E-03,  .2057E+03,  .1028E+03,
     +   .4192E+04 /
        DATA ((PARTON(I,N,11),I=1,6),N=1,8)/
     +   .1166E-02,  .7155E-03,  .2134E-03,  .6659E+00,  .2486E+00,
     +   .2596E+02,
     +   .1204E-02,  .7387E-03,  .2199E-03,  .9415E+00,  .3858E+00,
     +   .3682E+02,
     +   .1247E-02,  .7649E-03,  .2273E-03,  .1359E+01,  .5939E+00,
     +   .5212E+02,
     +   .1297E-02,  .7958E-03,  .2360E-03,  .2026E+01,  .9264E+00,
     +   .7487E+02,
     +   .1357E-02,  .8323E-03,  .2461E-03,  .3096E+01,  .1461E+01,
     +   .1089E+03,
     +   .1412E-02,  .8660E-03,  .2555E-03,  .4403E+01,  .2114E+01,
     +   .1480E+03,
     +   .1474E-02,  .9044E-03,  .2660E-03,  .6321E+01,  .3071E+01,
     +   .2022E+03,
     +   .1531E-02,  .9391E-03,  .2755E-03,  .8498E+01,  .4159E+01,
     +   .2607E+03 /
        DATA ((PARTON(I,N,11),I=1,6),N=9,16)/
     +   .1589E-02,  .9742E-03,  .2851E-03,  .1116E+02,  .5491E+01,
     +   .3294E+03,
     +   .1641E-02,  .1006E-02,  .2937E-03,  .1403E+02,  .6925E+01,
     +   .4007E+03,
     +   .1694E-02,  .1039E-02,  .3024E-03,  .1743E+02,  .8624E+01,
     +   .4824E+03,
     +   .1746E-02,  .1070E-02,  .3109E-03,  .2120E+02,  .1051E+02,
     +   .5703E+03,
     +   .1794E-02,  .1100E-02,  .3186E-03,  .2512E+02,  .1247E+02,
     +   .6593E+03,
     +   .1855E-02,  .1137E-02,  .3285E-03,  .3076E+02,  .1529E+02,
     +   .7840E+03,
     +   .1912E-02,  .1172E-02,  .3378E-03,  .3680E+02,  .1831E+02,
     +   .9139E+03,
     +   .1969E-02,  .1206E-02,  .3468E-03,  .4335E+02,  .2158E+02,
     +   .1051E+04 /
        DATA ((PARTON(I,N,11),I=1,6),N=17,24)/
     +   .2022E-02,  .1239E-02,  .3552E-03,  .5018E+02,  .2499E+02,
     +   .1191E+04,
     +   .2076E-02,  .1272E-02,  .3638E-03,  .5777E+02,  .2879E+02,
     +   .1343E+04,
     +   .2128E-02,  .1303E-02,  .3719E-03,  .6562E+02,  .3271E+02,
     +   .1498E+04,
     +   .2178E-02,  .1334E-02,  .3798E-03,  .7391E+02,  .3686E+02,
     +   .1658E+04,
     +   .2226E-02,  .1363E-02,  .3873E-03,  .8234E+02,  .4107E+02,
     +   .1818E+04,
     +   .2292E-02,  .1404E-02,  .3975E-03,  .9474E+02,  .4727E+02,
     +   .2050E+04,
     +   .2352E-02,  .1440E-02,  .4067E-03,  .1070E+03,  .5338E+02,
     +   .2273E+04,
     +   .2414E-02,  .1477E-02,  .4161E-03,  .1204E+03,  .6010E+02,
     +   .2515E+04 /
        DATA ((PARTON(I,N,11),I=1,6),N=25,27)/
     +   .2475E-02,  .1515E-02,  .4254E-03,  .1347E+03,  .6723E+02,
     +   .2766E+04,
     +   .2531E-02,  .1549E-02,  .4339E-03,  .1485E+03,  .7417E+02,
     +   .3007E+04,
     +   .2589E-02,  .1584E-02,  .4426E-03,  .1637E+03,  .8173E+02,
     +   .3266E+04 /
        DATA ((PARTON(I,N,12),I=1,6),N=1,8)/
     +   .1537E-02,  .9432E-03,  .2801E-03,  .6385E+00,  .2273E+00,
     +   .2340E+02,
     +   .1587E-02,  .9737E-03,  .2886E-03,  .8849E+00,  .3499E+00,
     +   .3288E+02,
     +   .1643E-02,  .1008E-02,  .2982E-03,  .1255E+01,  .5340E+00,
     +   .4611E+02,
     +   .1709E-02,  .1049E-02,  .3093E-03,  .1839E+01,  .8252E+00,
     +   .6559E+02,
     +   .1788E-02,  .1097E-02,  .3224E-03,  .2767E+01,  .1288E+01,
     +   .9441E+02,
     +   .1860E-02,  .1141E-02,  .3344E-03,  .3889E+01,  .1849E+01,
     +   .1272E+03,
     +   .1942E-02,  .1191E-02,  .3480E-03,  .5519E+01,  .2663E+01,
     +   .1721E+03,
     +   .2017E-02,  .1237E-02,  .3602E-03,  .7354E+01,  .3579E+01,
     +   .2203E+03 /
        DATA ((PARTON(I,N,12),I=1,6),N=9,16)/
     +   .2092E-02,  .1283E-02,  .3724E-03,  .9582E+01,  .4693E+01,
     +   .2763E+03,
     +   .2161E-02,  .1325E-02,  .3835E-03,  .1197E+02,  .5884E+01,
     +   .3341E+03,
     +   .2230E-02,  .1367E-02,  .3947E-03,  .1477E+02,  .7286E+01,
     +   .3998E+03,
     +   .2298E-02,  .1409E-02,  .4055E-03,  .1787E+02,  .8832E+01,
     +   .4701E+03,
     +   .2361E-02,  .1447E-02,  .4154E-03,  .2106E+02,  .1043E+02,
     +   .5409E+03,
     +   .2441E-02,  .1496E-02,  .4279E-03,  .2564E+02,  .1272E+02,
     +   .6396E+03,
     +   .2516E-02,  .1542E-02,  .4397E-03,  .3052E+02,  .1516E+02,
     +   .7416E+03,
     +   .2590E-02,  .1587E-02,  .4511E-03,  .3577E+02,  .1778E+02,
     +   .8489E+03 /
        DATA ((PARTON(I,N,12),I=1,6),N=17,24)/
     +   .2660E-02,  .1629E-02,  .4619E-03,  .4123E+02,  .2051E+02,
     +   .9578E+03,
     +   .2731E-02,  .1672E-02,  .4728E-03,  .4726E+02,  .2353E+02,
     +   .1076E+04,
     +   .2798E-02,  .1713E-02,  .4830E-03,  .5348E+02,  .2664E+02,
     +   .1195E+04,
     +   .2864E-02,  .1753E-02,  .4931E-03,  .6002E+02,  .2990E+02,
     +   .1318E+04,
     +   .2927E-02,  .1792E-02,  .5026E-03,  .6664E+02,  .3322E+02,
     +   .1440E+04,
     +   .3013E-02,  .1844E-02,  .5154E-03,  .7635E+02,  .3807E+02,
     +   .1616E+04,
     +   .3091E-02,  .1891E-02,  .5271E-03,  .8587E+02,  .4283E+02,
     +   .1786E+04,
     +   .3172E-02,  .1940E-02,  .5390E-03,  .9630E+02,  .4804E+02,
     +   .1968E+04 /
        DATA ((PARTON(I,N,12),I=1,6),N=25,27)/
     +   .3251E-02,  .1989E-02,  .5507E-03,  .1073E+03,  .5355E+02,
     +   .2157E+04,
     +   .3324E-02,  .2033E-02,  .5614E-03,  .1180E+03,  .5889E+02,
     +   .2337E+04,
     +   .3400E-02,  .2079E-02,  .5724E-03,  .1296E+03,  .6469E+02,
     +   .2530E+04 /
        DATA ((PARTON(I,N,13),I=1,6),N=1,8)/
     +   .2011E-02,  .1234E-02,  .3647E-03,  .6158E+00,  .2080E+00,
     +   .2110E+02,
     +   .2076E-02,  .1274E-02,  .3756E-03,  .8362E+00,  .3175E+00,
     +   .2939E+02,
     +   .2149E-02,  .1319E-02,  .3878E-03,  .1164E+01,  .4806E+00,
     +   .4084E+02,
     +   .2236E-02,  .1372E-02,  .4020E-03,  .1676E+01,  .7358E+00,
     +   .5751E+02,
     +   .2338E-02,  .1434E-02,  .4187E-03,  .2482E+01,  .1138E+01,
     +   .8193E+02,
     +   .2432E-02,  .1491E-02,  .4340E-03,  .3446E+01,  .1619E+01,
     +   .1094E+03,
     +   .2539E-02,  .1557E-02,  .4512E-03,  .4833E+01,  .2311E+01,
     +   .1467E+03,
     +   .2636E-02,  .1616E-02,  .4667E-03,  .6381E+01,  .3085E+01,
     +   .1863E+03 /
        DATA ((PARTON(I,N,13),I=1,6),N=9,16)/
     +   .2734E-02,  .1676E-02,  .4821E-03,  .8247E+01,  .4016E+01,
     +   .2321E+03,
     +   .2823E-02,  .1730E-02,  .4961E-03,  .1023E+02,  .5007E+01,
     +   .2789E+03,
     +   .2914E-02,  .1786E-02,  .5102E-03,  .1255E+02,  .6165E+01,
     +   .3318E+03,
     +   .3002E-02,  .1840E-02,  .5239E-03,  .1509E+02,  .7435E+01,
     +   .3881E+03,
     +   .3084E-02,  .1889E-02,  .5363E-03,  .1770E+02,  .8741E+01,
     +   .4444E+03,
     +   .3187E-02,  .1952E-02,  .5521E-03,  .2142E+02,  .1060E+02,
     +   .5225E+03,
     +   .3286E-02,  .2012E-02,  .5670E-03,  .2536E+02,  .1257E+02,
     +   .6027E+03,
     +   .3381E-02,  .2070E-02,  .5813E-03,  .2959E+02,  .1468E+02,
     +   .6867E+03 /
        DATA ((PARTON(I,N,13),I=1,6),N=17,24)/
     +   .3472E-02,  .2125E-02,  .5948E-03,  .3395E+02,  .1686E+02,
     +   .7714E+03,
     +   .3563E-02,  .2181E-02,  .6084E-03,  .3875E+02,  .1926E+02,
     +   .8627E+03,
     +   .3651E-02,  .2234E-02,  .6213E-03,  .4369E+02,  .2173E+02,
     +   .9546E+03,
     +   .3737E-02,  .2286E-02,  .6338E-03,  .4884E+02,  .2431E+02,
     +   .1049E+04,
     +   .3818E-02,  .2336E-02,  .6457E-03,  .5406E+02,  .2691E+02,
     +   .1143E+04,
     +   .3929E-02,  .2403E-02,  .6617E-03,  .6167E+02,  .3072E+02,
     +   .1277E+04,
     +   .4031E-02,  .2464E-02,  .6763E-03,  .6909E+02,  .3443E+02,
     +   .1405E+04,
     +   .4135E-02,  .2527E-02,  .6911E-03,  .7719E+02,  .3848E+02,
     +   .1543E+04 /
        DATA ((PARTON(I,N,13),I=1,6),N=25,27)/
     +   .4238E-02,  .2590E-02,  .7057E-03,  .8572E+02,  .4274E+02,
     +   .1685E+04,
     +   .4332E-02,  .2647E-02,  .7190E-03,  .9396E+02,  .4686E+02,
     +   .1820E+04,
     +   .4430E-02,  .2706E-02,  .7326E-03,  .1029E+03,  .5132E+02,
     +   .1964E+04 /
        DATA ((PARTON(I,N,14),I=1,6),N=1,8)/
     +   .2362E-02,  .1449E-02,  .4268E-03,  .6040E+00,  .1970E+00,
     +   .1982E+02,
     +   .2438E-02,  .1496E-02,  .4394E-03,  .8100E+00,  .2993E+00,
     +   .2745E+02,
     +   .2524E-02,  .1548E-02,  .4534E-03,  .1114E+01,  .4507E+00,
     +   .3793E+02,
     +   .2625E-02,  .1610E-02,  .4699E-03,  .1587E+01,  .6863E+00,
     +   .5310E+02,
     +   .2745E-02,  .1683E-02,  .4891E-03,  .2326E+01,  .1055E+01,
     +   .7516E+02,
     +   .2855E-02,  .1751E-02,  .5067E-03,  .3205E+01,  .1493E+01,
     +   .9981E+02,
     +   .2980E-02,  .1827E-02,  .5265E-03,  .4463E+01,  .2121E+01,
     +   .1331E+03,
     +   .3094E-02,  .1897E-02,  .5443E-03,  .5859E+01,  .2818E+01,
     +   .1683E+03 /
        DATA ((PARTON(I,N,14),I=1,6),N=9,16)/
     +   .3209E-02,  .1967E-02,  .5620E-03,  .7533E+01,  .3654E+01,
     +   .2087E+03,
     +   .3313E-02,  .2030E-02,  .5781E-03,  .9305E+01,  .4540E+01,
     +   .2499E+03,
     +   .3419E-02,  .2095E-02,  .5943E-03,  .1137E+02,  .5570E+01,
     +   .2962E+03,
     +   .3522E-02,  .2158E-02,  .6099E-03,  .1362E+02,  .6697E+01,
     +   .3454E+03,
     +   .3617E-02,  .2215E-02,  .6241E-03,  .1593E+02,  .7851E+01,
     +   .3944E+03,
     +   .3738E-02,  .2289E-02,  .6422E-03,  .1921E+02,  .9491E+01,
     +   .4620E+03,
     +   .3853E-02,  .2359E-02,  .6592E-03,  .2267E+02,  .1122E+02,
     +   .5313E+03,
     +   .3965E-02,  .2427E-02,  .6756E-03,  .2637E+02,  .1307E+02,
     +   .6036E+03 /
        DATA ((PARTON(I,N,14),I=1,6),N=17,24)/
     +   .4070E-02,  .2491E-02,  .6910E-03,  .3018E+02,  .1497E+02,
     +   .6763E+03,
     +   .4178E-02,  .2556E-02,  .7065E-03,  .3436E+02,  .1706E+02,
     +   .7544E+03,
     +   .4280E-02,  .2618E-02,  .7212E-03,  .3864E+02,  .1920E+02,
     +   .8328E+03,
     +   .4380E-02,  .2679E-02,  .7354E-03,  .4311E+02,  .2143E+02,
     +   .9130E+03,
     +   .4475E-02,  .2736E-02,  .7489E-03,  .4762E+02,  .2369E+02,
     +   .9926E+03,
     +   .4605E-02,  .2815E-02,  .7672E-03,  .5417E+02,  .2696E+02,
     +   .1106E+04,
     +   .4723E-02,  .2886E-02,  .7837E-03,  .6055E+02,  .3015E+02,
     +   .1214E+04,
     +   .4844E-02,  .2960E-02,  .8006E-03,  .6750E+02,  .3363E+02,
     +   .1330E+04 /
        DATA ((PARTON(I,N,14),I=1,6),N=25,27)/
     +   .4964E-02,  .3032E-02,  .8171E-03,  .7480E+02,  .3727E+02,
     +   .1450E+04,
     +   .5074E-02,  .3099E-02,  .8322E-03,  .8182E+02,  .4079E+02,
     +   .1563E+04,
     +   .5188E-02,  .3167E-02,  .8477E-03,  .8942E+02,  .4458E+02,
     +   .1683E+04 /
        DATA ((PARTON(I,N,15),I=1,6),N=1,8)/
     +   .2801E-02,  .1718E-02,  .5038E-03,  .5930E+00,  .1859E+00,
     +   .1853E+02,
     +   .2891E-02,  .1774E-02,  .5184E-03,  .7846E+00,  .2809E+00,
     +   .2551E+02,
     +   .2992E-02,  .1836E-02,  .5348E-03,  .1066E+01,  .4207E+00,
     +   .3504E+02,
     +   .3112E-02,  .1909E-02,  .5539E-03,  .1500E+01,  .6368E+00,
     +   .4874E+02,
     +   .3253E-02,  .1995E-02,  .5761E-03,  .2173E+01,  .9724E+00,
     +   .6852E+02,
     +   .3383E-02,  .2074E-02,  .5965E-03,  .2970E+01,  .1369E+01,
     +   .9047E+02,
     +   .3532E-02,  .2165E-02,  .6194E-03,  .4101E+01,  .1934E+01,
     +   .1200E+03,
     +   .3666E-02,  .2247E-02,  .6400E-03,  .5351E+01,  .2558E+01,
     +   .1509E+03 /
        DATA ((PARTON(I,N,15),I=1,6),N=9,16)/
     +   .3801E-02,  .2329E-02,  .6605E-03,  .6841E+01,  .3302E+01,
     +   .1862E+03,
     +   .3924E-02,  .2404E-02,  .6790E-03,  .8412E+01,  .4087E+01,
     +   .2221E+03,
     +   .4049E-02,  .2480E-02,  .6977E-03,  .1023E+02,  .4996E+01,
     +   .2623E+03,
     +   .4171E-02,  .2554E-02,  .7156E-03,  .1222E+02,  .5987E+01,
     +   .3047E+03,
     +   .4283E-02,  .2622E-02,  .7320E-03,  .1424E+02,  .6998E+01,
     +   .3469E+03,
     +   .4426E-02,  .2709E-02,  .7528E-03,  .1710E+02,  .8429E+01,
     +   .4049E+03,
     +   .4561E-02,  .2791E-02,  .7723E-03,  .2011E+02,  .9932E+01,
     +   .4641E+03,
     +   .4693E-02,  .2871E-02,  .7911E-03,  .2332E+02,  .1153E+02,
     +   .5255E+03 /
        DATA ((PARTON(I,N,15),I=1,6),N=17,24)/
     +   .4817E-02,  .2946E-02,  .8087E-03,  .2661E+02,  .1318E+02,
     +   .5871E+03,
     +   .4943E-02,  .3023E-02,  .8265E-03,  .3021E+02,  .1498E+02,
     +   .6532E+03,
     +   .5064E-02,  .3096E-02,  .8434E-03,  .3389E+02,  .1682E+02,
     +   .7192E+03,
     +   .5181E-02,  .3167E-02,  .8597E-03,  .3771E+02,  .1873E+02,
     +   .7867E+03,
     +   .5293E-02,  .3235E-02,  .8751E-03,  .4156E+02,  .2066E+02,
     +   .8533E+03,
     +   .5446E-02,  .3327E-02,  .8960E-03,  .4715E+02,  .2345E+02,
     +   .9482E+03,
     +   .5585E-02,  .3411E-02,  .9149E-03,  .5258E+02,  .2616E+02,
     +   .1038E+04,
     +   .5727E-02,  .3497E-02,  .9341E-03,  .5846E+02,  .2910E+02,
     +   .1135E+04 /
        DATA ((PARTON(I,N,15),I=1,6),N=25,27)/
     +   .5868E-02,  .3582E-02,  .9530E-03,  .6463E+02,  .3219E+02,
     +   .1233E+04,
     +   .5998E-02,  .3660E-02,  .9702E-03,  .7056E+02,  .3515E+02,
     +   .1327E+04,
     +   .6131E-02,  .3740E-02,  .9878E-03,  .7694E+02,  .3834E+02,
     +   .1426E+04 /
        DATA ((PARTON(I,N,16),I=1,6),N=1,8)/
     +   .3399E-02,  .2085E-02,  .6077E-03,  .5824E+00,  .1738E+00,
     +   .1714E+02,
     +   .3508E-02,  .2152E-02,  .6250E-03,  .7585E+00,  .2611E+00,
     +   .2344E+02,
     +   .3630E-02,  .2227E-02,  .6443E-03,  .1015E+01,  .3885E+00,
     +   .3198E+02,
     +   .3775E-02,  .2315E-02,  .6669E-03,  .1409E+01,  .5842E+00,
     +   .4415E+02,
     +   .3945E-02,  .2419E-02,  .6932E-03,  .2014E+01,  .8856E+00,
     +   .6159E+02,
     +   .4103E-02,  .2515E-02,  .7171E-03,  .2724E+01,  .1240E+01,
     +   .8078E+02,
     +   .4282E-02,  .2624E-02,  .7441E-03,  .3726E+01,  .1740E+01,
     +   .1064E+03,
     +   .4444E-02,  .2723E-02,  .7682E-03,  .4825E+01,  .2288E+01,
     +   .1330E+03 /
        DATA ((PARTON(I,N,16),I=1,6),N=9,16)/
     +   .4607E-02,  .2822E-02,  .7923E-03,  .6128E+01,  .2939E+01,
     +   .1633E+03,
     +   .4755E-02,  .2912E-02,  .8139E-03,  .7494E+01,  .3621E+01,
     +   .1939E+03,
     +   .4907E-02,  .3004E-02,  .8358E-03,  .9071E+01,  .4408E+01,
     +   .2280E+03,
     +   .5053E-02,  .3093E-02,  .8568E-03,  .1078E+02,  .5262E+01,
     +   .2638E+03,
     +   .5188E-02,  .3175E-02,  .8759E-03,  .1252E+02,  .6130E+01,
     +   .2992E+03,
     +   .5360E-02,  .3280E-02,  .9002E-03,  .1497E+02,  .7353E+01,
     +   .3477E+03,
     +   .5523E-02,  .3378E-02,  .9229E-03,  .1752E+02,  .8632E+01,
     +   .3970E+03,
     +   .5681E-02,  .3474E-02,  .9448E-03,  .2024E+02,  .9990E+01,
     +   .4480E+03 /
        DATA ((PARTON(I,N,16),I=1,6),N=17,24)/
     +   .5831E-02,  .3565E-02,  .9653E-03,  .2302E+02,  .1138E+02,
     +   .4989E+03,
     +   .5983E-02,  .3657E-02,  .9860E-03,  .2605E+02,  .1289E+02,
     +   .5532E+03,
     +   .6128E-02,  .3744E-02,  .1006E-02,  .2914E+02,  .1444E+02,
     +   .6074E+03,
     +   .6269E-02,  .3830E-02,  .1024E-02,  .3234E+02,  .1604E+02,
     +   .6625E+03,
     +   .6403E-02,  .3911E-02,  .1042E-02,  .3555E+02,  .1764E+02,
     +   .7168E+03,
     +   .6587E-02,  .4021E-02,  .1067E-02,  .4020E+02,  .1996E+02,
     +   .7939E+03,
     +   .6754E-02,  .4122E-02,  .1088E-02,  .4469E+02,  .2221E+02,
     +   .8669E+03,
     +   .6925E-02,  .4225E-02,  .1111E-02,  .4956E+02,  .2464E+02,
     +   .9445E+03 /
        DATA ((PARTON(I,N,16),I=1,6),N=25,27)/
     +   .7094E-02,  .4327E-02,  .1132E-02,  .5463E+02,  .2718E+02,
     +   .1024E+04,
     +   .7249E-02,  .4420E-02,  .1152E-02,  .5950E+02,  .2961E+02,
     +   .1099E+04,
     +   .7409E-02,  .4516E-02,  .1173E-02,  .6473E+02,  .3223E+02,
     +   .1178E+04 /
        DATA ((PARTON(I,N,17),I=1,6),N=1,8)/
     +   .4123E-02,  .2529E-02,  .7321E-03,  .5736E+00,  .1623E+00,
     +   .1584E+02,
     +   .4255E-02,  .2610E-02,  .7525E-03,  .7353E+00,  .2423E+00,
     +   .2151E+02,
     +   .4403E-02,  .2700E-02,  .7752E-03,  .9693E+00,  .3584E+00,
     +   .2914E+02,
     +   .4578E-02,  .2807E-02,  .8017E-03,  .1325E+01,  .5352E+00,
     +   .3994E+02,
     +   .4784E-02,  .2933E-02,  .8326E-03,  .1868E+01,  .8054E+00,
     +   .5526E+02,
     +   .4974E-02,  .3048E-02,  .8607E-03,  .2500E+01,  .1120E+01,
     +   .7200E+02,
     +   .5190E-02,  .3180E-02,  .8922E-03,  .3385E+01,  .1562E+01,
     +   .9415E+02,
     +   .5385E-02,  .3299E-02,  .9204E-03,  .4350E+01,  .2043E+01,
     +   .1171E+03 /
        DATA ((PARTON(I,N,17),I=1,6),N=9,16)/
     +   .5582E-02,  .3418E-02,  .9485E-03,  .5487E+01,  .2611E+01,
     +   .1429E+03,
     +   .5761E-02,  .3527E-02,  .9737E-03,  .6673E+01,  .3203E+01,
     +   .1689E+03,
     +   .5943E-02,  .3637E-02,  .9992E-03,  .8034E+01,  .3882E+01,
     +   .1977E+03,
     +   .6119E-02,  .3744E-02,  .1024E-02,  .9503E+01,  .4616E+01,
     +   .2278E+03,
     +   .6282E-02,  .3843E-02,  .1046E-02,  .1099E+02,  .5359E+01,
     +   .2575E+03,
     +   .6489E-02,  .3968E-02,  .1074E-02,  .1308E+02,  .6402E+01,
     +   .2979E+03,
     +   .6685E-02,  .4087E-02,  .1100E-02,  .1525E+02,  .7487E+01,
     +   .3388E+03,
     +   .6875E-02,  .4202E-02,  .1126E-02,  .1755E+02,  .8635E+01,
     +   .3809E+03 /
        DATA ((PARTON(I,N,17),I=1,6),N=17,24)/
     +   .7055E-02,  .4310E-02,  .1149E-02,  .1989E+02,  .9804E+01,
     +   .4228E+03,
     +   .7237E-02,  .4420E-02,  .1173E-02,  .2243E+02,  .1108E+02,
     +   .4673E+03,
     +   .7411E-02,  .4525E-02,  .1196E-02,  .2501E+02,  .1236E+02,
     +   .5115E+03,
     +   .7581E-02,  .4628E-02,  .1218E-02,  .2768E+02,  .1370E+02,
     +   .5564E+03,
     +   .7742E-02,  .4725E-02,  .1238E-02,  .3035E+02,  .1503E+02,
     +   .6005E+03,
     +   .7962E-02,  .4857E-02,  .1266E-02,  .3420E+02,  .1696E+02,
     +   .6628E+03,
     +   .8162E-02,  .4977E-02,  .1291E-02,  .3791E+02,  .1881E+02,
     +   .7216E+03,
     +   .8367E-02,  .5100E-02,  .1317E-02,  .4192E+02,  .2081E+02,
     +   .7839E+03 /
        DATA ((PARTON(I,N,17),I=1,6),N=25,27)/
     +   .8571E-02,  .5222E-02,  .1342E-02,  .4608E+02,  .2290E+02,
     +   .8474E+03,
     +   .8756E-02,  .5334E-02,  .1365E-02,  .5007E+02,  .2489E+02,
     +   .9072E+03,
     +   .8948E-02,  .5448E-02,  .1388E-02,  .5434E+02,  .2702E+02,
     +   .9702E+03 /
        DATA ((PARTON(I,N,18),I=1,6),N=1,8)/
     +   .4984E-02,  .3057E-02,  .8776E-03,  .5668E+00,  .1515E+00,
     +   .1463E+02,
     +   .5142E-02,  .3154E-02,  .9015E-03,  .7152E+00,  .2249E+00,
     +   .1974E+02,
     +   .5321E-02,  .3262E-02,  .9280E-03,  .9285E+00,  .3306E+00,
     +   .2656E+02,
     +   .5531E-02,  .3391E-02,  .9589E-03,  .1250E+01,  .4904E+00,
     +   .3613E+02,
     +   .5778E-02,  .3541E-02,  .9948E-03,  .1737E+01,  .7326E+00,
     +   .4960E+02,
     +   .6007E-02,  .3680E-02,  .1027E-02,  .2300E+01,  .1013E+01,
     +   .6420E+02,
     +   .6266E-02,  .3838E-02,  .1064E-02,  .3082E+01,  .1403E+01,
     +   .8336E+02,
     +   .6501E-02,  .3980E-02,  .1097E-02,  .3929E+01,  .1825E+01,
     +   .1031E+03 /
        DATA ((PARTON(I,N,18),I=1,6),N=9,16)/
     +   .6737E-02,  .4124E-02,  .1129E-02,  .4922E+01,  .2320E+01,
     +   .1251E+03,
     +   .6951E-02,  .4254E-02,  .1158E-02,  .5951E+01,  .2834E+01,
     +   .1472E+03,
     +   .7170E-02,  .4386E-02,  .1188E-02,  .7127E+01,  .3421E+01,
     +   .1715E+03,
     +   .7381E-02,  .4514E-02,  .1216E-02,  .8389E+01,  .4051E+01,
     +   .1968E+03,
     +   .7576E-02,  .4632E-02,  .1242E-02,  .9663E+01,  .4688E+01,
     +   .2216E+03,
     +   .7824E-02,  .4782E-02,  .1274E-02,  .1144E+02,  .5576E+01,
     +   .2553E+03,
     +   .8059E-02,  .4923E-02,  .1304E-02,  .1329E+02,  .6497E+01,
     +   .2892E+03,
     +   .8286E-02,  .5061E-02,  .1333E-02,  .1523E+02,  .7467E+01,
     +   .3240E+03 /
        DATA ((PARTON(I,N,18),I=1,6),N=17,24)/
     +   .8502E-02,  .5190E-02,  .1361E-02,  .1720E+02,  .8452E+01,
     +   .3584E+03,
     +   .8720E-02,  .5322E-02,  .1388E-02,  .1933E+02,  .9519E+01,
     +   .3949E+03,
     +   .8928E-02,  .5447E-02,  .1414E-02,  .2149E+02,  .1060E+02,
     +   .4310E+03,
     +   .9131E-02,  .5569E-02,  .1439E-02,  .2372E+02,  .1171E+02,
     +   .4675E+03,
     +   .9323E-02,  .5684E-02,  .1463E-02,  .2594E+02,  .1282E+02,
     +   .5032E+03,
     +   .9586E-02,  .5842E-02,  .1494E-02,  .2913E+02,  .1441E+02,
     +   .5536E+03,
     +   .9825E-02,  .5985E-02,  .1523E-02,  .3219E+02,  .1594E+02,
     +   .6009E+03,
     +   .1007E-01,  .6132E-02,  .1552E-02,  .3549E+02,  .1759E+02,
     +   .6508E+03 /
        DATA ((PARTON(I,N,18),I=1,6),N=25,27)/
     +   .1031E-01,  .6277E-02,  .1581E-02,  .3891E+02,  .1930E+02,
     +   .7017E+03,
     +   .1053E-01,  .6409E-02,  .1607E-02,  .4217E+02,  .2093E+02,
     +   .7492E+03,
     +   .1076E-01,  .6545E-02,  .1633E-02,  .4565E+02,  .2267E+02,
     +   .7993E+03 /
        DATA ((PARTON(I,N,19),I=1,6),N=1,8)/
     +   .6029E-02,  .3697E-02,  .1051E-02,  .5617E+00,  .1412E+00,
     +   .1350E+02,
     +   .6220E-02,  .3814E-02,  .1079E-02,  .6977E+00,  .2083E+00,
     +   .1809E+02,
     +   .6435E-02,  .3945E-02,  .1110E-02,  .8917E+00,  .3043E+00,
     +   .2416E+02,
     +   .6687E-02,  .4099E-02,  .1146E-02,  .1182E+01,  .4483E+00,
     +   .3261E+02,
     +   .6985E-02,  .4280E-02,  .1187E-02,  .1618E+01,  .6649E+00,
     +   .4441E+02,
     +   .7260E-02,  .4446E-02,  .1225E-02,  .2117E+01,  .9134E+00,
     +   .5709E+02,
     +   .7571E-02,  .4636E-02,  .1268E-02,  .2807E+01,  .1257E+01,
     +   .7361E+02,
     +   .7853E-02,  .4806E-02,  .1305E-02,  .3548E+01,  .1626E+01,
     +   .9046E+02 /
        DATA ((PARTON(I,N,19),I=1,6),N=9,16)/
     +   .8136E-02,  .4978E-02,  .1343E-02,  .4411E+01,  .2057E+01,
     +   .1092E+03,
     +   .8394E-02,  .5134E-02,  .1376E-02,  .5301E+01,  .2501E+01,
     +   .1279E+03,
     +   .8656E-02,  .5292E-02,  .1410E-02,  .6313E+01,  .3006E+01,
     +   .1483E+03,
     +   .8909E-02,  .5445E-02,  .1442E-02,  .7395E+01,  .3546E+01,
     +   .1695E+03,
     +   .9143E-02,  .5586E-02,  .1472E-02,  .8481E+01,  .4088E+01,
     +   .1901E+03,
     +   .9440E-02,  .5765E-02,  .1509E-02,  .9992E+01,  .4843E+01,
     +   .2181E+03,
     +   .9721E-02,  .5934E-02,  .1543E-02,  .1155E+02,  .5621E+01,
     +   .2460E+03,
     +   .9993E-02,  .6098E-02,  .1577E-02,  .1319E+02,  .6438E+01,
     +   .2745E+03 /
        DATA ((PARTON(I,N,19),I=1,6),N=17,24)/
     +   .1025E-01,  .6253E-02,  .1608E-02,  .1484E+02,  .7263E+01,
     +   .3027E+03,
     +   .1051E-01,  .6409E-02,  .1639E-02,  .1662E+02,  .8155E+01,
     +   .3324E+03,
     +   .1076E-01,  .6558E-02,  .1668E-02,  .1842E+02,  .9052E+01,
     +   .3617E+03,
     +   .1100E-01,  .6704E-02,  .1697E-02,  .2027E+02,  .9976E+01,
     +   .3912E+03,
     +   .1123E-01,  .6841E-02,  .1724E-02,  .2210E+02,  .1089E+02,
     +   .4200E+03,
     +   .1155E-01,  .7029E-02,  .1760E-02,  .2473E+02,  .1221E+02,
     +   .4604E+03,
     +   .1183E-01,  .7199E-02,  .1793E-02,  .2725E+02,  .1347E+02,
     +   .4983E+03,
     +   .1212E-01,  .7373E-02,  .1826E-02,  .2995E+02,  .1482E+02,
     +   .5381E+03 /
        DATA ((PARTON(I,N,19),I=1,6),N=25,27)/
     +   .1241E-01,  .7545E-02,  .1858E-02,  .3275E+02,  .1621E+02,
     +   .5784E+03,
     +   .1267E-01,  .7703E-02,  .1888E-02,  .3540E+02,  .1754E+02,
     +   .6161E+03,
     +   .1295E-01,  .7864E-02,  .1918E-02,  .3823E+02,  .1895E+02,
     +   .6555E+03 /
        DATA ((PARTON(I,N,20),I=1,6),N=1,8)/
     +   .7073E-02,  .4337E-02,  .1222E-02,  .5587E+00,  .1329E+00,
     +   .1260E+02,
     +   .7296E-02,  .4473E-02,  .1253E-02,  .6850E+00,  .1951E+00,
     +   .1678E+02,
     +   .7547E-02,  .4626E-02,  .1288E-02,  .8638E+00,  .2835E+00,
     +   .2228E+02,
     +   .7842E-02,  .4805E-02,  .1328E-02,  .1130E+01,  .4153E+00,
     +   .2988E+02,
     +   .8189E-02,  .5016E-02,  .1375E-02,  .1526E+01,  .6120E+00,
     +   .4041E+02,
     +   .8509E-02,  .5210E-02,  .1418E-02,  .1977E+01,  .8363E+00,
     +   .5165E+02,
     +   .8873E-02,  .5430E-02,  .1465E-02,  .2596E+01,  .1145E+01,
     +   .6619E+02,
     +   .9201E-02,  .5629E-02,  .1507E-02,  .3257E+01,  .1474E+01,
     +   .8093E+02 /
        DATA ((PARTON(I,N,20),I=1,6),N=9,16)/
     +   .9531E-02,  .5829E-02,  .1549E-02,  .4023E+01,  .1856E+01,
     +   .9726E+02,
     +   .9831E-02,  .6010E-02,  .1587E-02,  .4809E+01,  .2248E+01,
     +   .1134E+03,
     +   .1014E-01,  .6194E-02,  .1625E-02,  .5699E+01,  .2692E+01,
     +   .1310E+03,
     +   .1043E-01,  .6371E-02,  .1661E-02,  .6647E+01,  .3165E+01,
     +   .1492E+03,
     +   .1070E-01,  .6534E-02,  .1693E-02,  .7595E+01,  .3638E+01,
     +   .1668E+03,
     +   .1105E-01,  .6742E-02,  .1735E-02,  .8909E+01,  .4294E+01,
     +   .1906E+03,
     +   .1137E-01,  .6938E-02,  .1773E-02,  .1026E+02,  .4968E+01,
     +   .2143E+03,
     +   .1169E-01,  .7128E-02,  .1810E-02,  .1167E+02,  .5673E+01,
     +   .2384E+03 /
        DATA ((PARTON(I,N,20),I=1,6),N=17,24)/
     +   .1199E-01,  .7307E-02,  .1845E-02,  .1309E+02,  .6383E+01,
     +   .2620E+03,
     +   .1229E-01,  .7489E-02,  .1880E-02,  .1462E+02,  .7147E+01,
     +   .2869E+03,
     +   .1258E-01,  .7661E-02,  .1912E-02,  .1616E+02,  .7915E+01,
     +   .3114E+03,
     +   .1286E-01,  .7829E-02,  .1944E-02,  .1773E+02,  .8702E+01,
     +   .3360E+03,
     +   .1313E-01,  .7988E-02,  .1974E-02,  .1930E+02,  .9482E+01,
     +   .3599E+03,
     +   .1349E-01,  .8205E-02,  .2014E-02,  .2153E+02,  .1060E+02,
     +   .3934E+03,
     +   .1382E-01,  .8401E-02,  .2050E-02,  .2366E+02,  .1166E+02,
     +   .4246E+03,
     +   .1416E-01,  .8602E-02,  .2086E-02,  .2593E+02,  .1280E+02,
     +   .4574E+03 /
        DATA ((PARTON(I,N,20),I=1,6),N=25,27)/
     +   .1449E-01,  .8801E-02,  .2122E-02,  .2828E+02,  .1397E+02,
     +   .4905E+03,
     +   .1480E-01,  .8982E-02,  .2155E-02,  .3050E+02,  .1508E+02,
     +   .5213E+03,
     +   .1511E-01,  .9168E-02,  .2188E-02,  .3287E+02,  .1627E+02,
     +   .5535E+03 /
        DATA ((PARTON(I,N,21),I=1,6),N=1,8)/
     +   .8375E-02,  .5135E-02,  .1429E-02,  .5569E+00,  .1245E+00,
     +   .1169E+02,
     +   .8638E-02,  .5295E-02,  .1465E-02,  .6733E+00,  .1818E+00,
     +   .1548E+02,
     +   .8934E-02,  .5474E-02,  .1504E-02,  .8372E+00,  .2627E+00,
     +   .2042E+02,
     +   .9281E-02,  .5685E-02,  .1550E-02,  .1079E+01,  .3824E+00,
     +   .2720E+02,
     +   .9690E-02,  .5933E-02,  .1603E-02,  .1437E+01,  .5598E+00,
     +   .3651E+02,
     +   .1007E-01,  .6161E-02,  .1651E-02,  .1841E+01,  .7606E+00,
     +   .4637E+02,
     +   .1049E-01,  .6419E-02,  .1704E-02,  .2391E+01,  .1035E+01,
     +   .5903E+02,
     +   .1088E-01,  .6652E-02,  .1752E-02,  .2976E+01,  .1326E+01,
     +   .7179E+02 /
        DATA ((PARTON(I,N,21),I=1,6),N=9,16)/
     +   .1127E-01,  .6886E-02,  .1799E-02,  .3649E+01,  .1661E+01,
     +   .8584E+02,
     +   .1162E-01,  .7098E-02,  .1841E-02,  .4337E+01,  .2004E+01,
     +   .9962E+02,
     +   .1198E-01,  .7313E-02,  .1883E-02,  .5112E+01,  .2391E+01,
     +   .1146E+03,
     +   .1232E-01,  .7521E-02,  .1923E-02,  .5934E+01,  .2801E+01,
     +   .1300E+03,
     +   .1264E-01,  .7712E-02,  .1960E-02,  .6753E+01,  .3210E+01,
     +   .1449E+03,
     +   .1305E-01,  .7955E-02,  .2006E-02,  .7883E+01,  .3774E+01,
     +   .1649E+03,
     +   .1343E-01,  .8183E-02,  .2049E-02,  .9039E+01,  .4351E+01,
     +   .1847E+03,
     +   .1380E-01,  .8405E-02,  .2090E-02,  .1024E+02,  .4952E+01,
     +   .2047E+03 /
        DATA ((PARTON(I,N,21),I=1,6),N=17,24)/
     +   .1415E-01,  .8614E-02,  .2129E-02,  .1145E+02,  .5555E+01,
     +   .2244E+03,
     +   .1450E-01,  .8825E-02,  .2167E-02,  .1275E+02,  .6202E+01,
     +   .2449E+03,
     +   .1484E-01,  .9026E-02,  .2203E-02,  .1405E+02,  .6850E+01,
     +   .2651E+03,
     +   .1517E-01,  .9222E-02,  .2239E-02,  .1537E+02,  .7513E+01,
     +   .2852E+03,
     +   .1548E-01,  .9407E-02,  .2271E-02,  .1668E+02,  .8168E+01,
     +   .3048E+03,
     +   .1590E-01,  .9659E-02,  .2316E-02,  .1855E+02,  .9101E+01,
     +   .3321E+03,
     +   .1629E-01,  .9888E-02,  .2356E-02,  .2033E+02,  .9989E+01,
     +   .3575E+03,
     +   .1668E-01,  .1012E-01,  .2396E-02,  .2222E+02,  .1093E+02,
     +   .3840E+03 /
        DATA ((PARTON(I,N,21),I=1,6),N=25,27)/
     +   .1707E-01,  .1035E-01,  .2436E-02,  .2417E+02,  .1191E+02,
     +   .4107E+03,
     +   .1743E-01,  .1056E-01,  .2472E-02,  .2601E+02,  .1283E+02,
     +   .4354E+03,
     +   .1779E-01,  .1078E-01,  .2509E-02,  .2796E+02,  .1380E+02,
     +   .4612E+03 /
        DATA ((PARTON(I,N,22),I=1,6),N=1,8)/
     +   .1015E-01,  .6219E-02,  .1704E-02,  .5563E+00,  .1154E+00,
     +   .1072E+02,
     +   .1046E-01,  .6411E-02,  .1745E-02,  .6623E+00,  .1674E+00,
     +   .1409E+02,
     +   .1082E-01,  .6626E-02,  .1790E-02,  .8104E+00,  .2404E+00,
     +   .1846E+02,
     +   .1124E-01,  .6879E-02,  .1842E-02,  .1027E+01,  .3475E+00,
     +   .2439E+02,
     +   .1173E-01,  .7177E-02,  .1902E-02,  .1344E+01,  .5048E+00,
     +   .3246E+02,
     +   .1218E-01,  .7450E-02,  .1956E-02,  .1700E+01,  .6815E+00,
     +   .4093E+02,
     +   .1269E-01,  .7759E-02,  .2017E-02,  .2181E+01,  .9207E+00,
     +   .5172E+02,
     +   .1315E-01,  .8038E-02,  .2070E-02,  .2688E+01,  .1173E+01,
     +   .6250E+02 /
        DATA ((PARTON(I,N,22),I=1,6),N=9,16)/
     +   .1362E-01,  .8317E-02,  .2123E-02,  .3268E+01,  .1462E+01,
     +   .7428E+02,
     +   .1404E-01,  .8570E-02,  .2171E-02,  .3857E+01,  .1755E+01,
     +   .8578E+02,
     +   .1447E-01,  .8827E-02,  .2218E-02,  .4518E+01,  .2085E+01,
     +   .9821E+02,
     +   .1488E-01,  .9075E-02,  .2264E-02,  .5214E+01,  .2432E+01,
     +   .1109E+03,
     +   .1526E-01,  .9303E-02,  .2305E-02,  .5905E+01,  .2776E+01,
     +   .1231E+03,
     +   .1575E-01,  .9592E-02,  .2357E-02,  .6854E+01,  .3250E+01,
     +   .1394E+03,
     +   .1620E-01,  .9864E-02,  .2405E-02,  .7820E+01,  .3732E+01,
     +   .1555E+03,
     +   .1665E-01,  .1013E-01,  .2451E-02,  .8821E+01,  .4232E+01,
     +   .1717E+03 /
        DATA ((PARTON(I,N,22),I=1,6),N=17,24)/
     +   .1706E-01,  .1038E-01,  .2494E-02,  .9821E+01,  .4731E+01,
     +   .1875E+03,
     +   .1749E-01,  .1063E-01,  .2537E-02,  .1089E+02,  .5265E+01,
     +   .2039E+03,
     +   .1789E-01,  .1087E-01,  .2578E-02,  .1196E+02,  .5798E+01,
     +   .2200E+03,
     +   .1828E-01,  .1110E-01,  .2617E-02,  .1304E+02,  .6340E+01,
     +   .2360E+03,
     +   .1865E-01,  .1132E-01,  .2654E-02,  .1411E+02,  .6875E+01,
     +   .2515E+03,
     +   .1915E-01,  .1162E-01,  .2704E-02,  .1563E+02,  .7634E+01,
     +   .2730E+03,
     +   .1961E-01,  .1189E-01,  .2748E-02,  .1707E+02,  .8353E+01,
     +   .2929E+03,
     +   .2008E-01,  .1216E-01,  .2793E-02,  .1860E+02,  .9116E+01,
     +   .3136E+03 /
        DATA ((PARTON(I,N,22),I=1,6),N=25,27)/
     +   .2054E-01,  .1244E-01,  .2837E-02,  .2017E+02,  .9899E+01,
     +   .3344E+03,
     +   .2097E-01,  .1268E-01,  .2877E-02,  .2164E+02,  .1064E+02,
     +   .3536E+03,
     +   .2140E-01,  .1294E-01,  .2918E-02,  .2320E+02,  .1142E+02,
     +   .3735E+03 /
        DATA ((PARTON(I,N,23),I=1,6),N=1,8)/
     +   .1228E-01,  .7527E-02,  .2024E-02,  .5572E+00,  .1067E+00,
     +   .9818E+01,
     +   .1266E-01,  .7757E-02,  .2070E-02,  .6536E+00,  .1539E+00,
     +   .1281E+02,
     +   .1309E-01,  .8016E-02,  .2121E-02,  .7870E+00,  .2195E+00,
     +   .1665E+02,
     +   .1359E-01,  .8319E-02,  .2180E-02,  .9806E+00,  .3151E+00,
     +   .2182E+02,
     +   .1418E-01,  .8675E-02,  .2247E-02,  .1262E+01,  .4542E+00,
     +   .2879E+02,
     +   .1473E-01,  .9002E-02,  .2309E-02,  .1574E+01,  .6092E+00,
     +   .3604E+02,
     +   .1534E-01,  .9371E-02,  .2377E-02,  .1993E+01,  .8173E+00,
     +   .4519E+02,
     +   .1589E-01,  .9704E-02,  .2437E-02,  .2431E+01,  .1035E+01,
     +   .5426E+02 /
        DATA ((PARTON(I,N,23),I=1,6),N=9,16)/
     +   .1645E-01,  .1004E-01,  .2496E-02,  .2929E+01,  .1283E+01,
     +   .6410E+02,
     +   .1695E-01,  .1034E-01,  .2549E-02,  .3432E+01,  .1533E+01,
     +   .7364E+02,
     +   .1747E-01,  .1064E-01,  .2602E-02,  .3992E+01,  .1813E+01,
     +   .8390E+02,
     +   .1796E-01,  .1094E-01,  .2653E-02,  .4580E+01,  .2106E+01,
     +   .9430E+02,
     +   .1842E-01,  .1121E-01,  .2699E-02,  .5161E+01,  .2395E+01,
     +   .1043E+03,
     +   .1899E-01,  .1155E-01,  .2756E-02,  .5954E+01,  .2791E+01,
     +   .1175E+03,
     +   .1954E-01,  .1188E-01,  .2810E-02,  .6758E+01,  .3192E+01,
     +   .1305E+03,
     +   .2006E-01,  .1219E-01,  .2861E-02,  .7587E+01,  .3606E+01,
     +   .1435E+03 /
        DATA ((PARTON(I,N,23),I=1,6),N=17,24)/
     +   .2056E-01,  .1248E-01,  .2909E-02,  .8412E+01,  .4018E+01,
     +   .1561E+03,
     +   .2106E-01,  .1278E-01,  .2957E-02,  .9291E+01,  .4456E+01,
     +   .1692E+03,
     +   .2154E-01,  .1306E-01,  .3002E-02,  .1016E+02,  .4892E+01,
     +   .1819E+03,
     +   .2201E-01,  .1334E-01,  .3045E-02,  .1105E+02,  .5334E+01,
     +   .1945E+03,
     +   .2245E-01,  .1360E-01,  .3086E-02,  .1192E+02,  .5768E+01,
     +   .2067E+03,
     +   .2305E-01,  .1395E-01,  .3141E-02,  .1315E+02,  .6383E+01,
     +   .2235E+03,
     +   .2359E-01,  .1427E-01,  .3190E-02,  .1431E+02,  .6962E+01,
     +   .2390E+03,
     +   .2415E-01,  .1460E-01,  .3240E-02,  .1554E+02,  .7576E+01,
     +   .2551E+03 /
        DATA ((PARTON(I,N,23),I=1,6),N=25,27)/
     +   .2469E-01,  .1492E-01,  .3289E-02,  .1679E+02,  .8202E+01,
     +   .2711E+03,
     +   .2519E-01,  .1521E-01,  .3333E-02,  .1797E+02,  .8790E+01,
     +   .2859E+03,
     +   .2571E-01,  .1551E-01,  .3378E-02,  .1921E+02,  .9409E+01,
     +   .3012E+03 /
        DATA ((PARTON(I,N,24),I=1,6),N=1,8)/
     +   .1481E-01,  .9073E-02,  .2387E-02,  .5595E+00,  .9862E-01,
     +   .8985E+01,
     +   .1527E-01,  .9348E-02,  .2438E-02,  .6470E+00,  .1413E+00,
     +   .1164E+02,
     +   .1578E-01,  .9656E-02,  .2495E-02,  .7671E+00,  .2003E+00,
     +   .1501E+02,
     +   .1638E-01,  .1002E-01,  .2560E-02,  .9399E+00,  .2855E+00,
     +   .1952E+02,
     +   .1708E-01,  .1044E-01,  .2636E-02,  .1189E+01,  .4085E+00,
     +   .2553E+02,
     +   .1773E-01,  .1083E-01,  .2703E-02,  .1463E+01,  .5443E+00,
     +   .3172E+02,
     +   .1846E-01,  .1127E-01,  .2779E-02,  .1827E+01,  .7253E+00,
     +   .3948E+02,
     +   .1912E-01,  .1166E-01,  .2845E-02,  .2206E+01,  .9134E+00,
     +   .4709E+02 /
        DATA ((PARTON(I,N,24),I=1,6),N=9,16)/
     +   .1979E-01,  .1206E-01,  .2911E-02,  .2633E+01,  .1126E+01,
     +   .5530E+02,
     +   .2039E-01,  .1242E-01,  .2969E-02,  .3062E+01,  .1339E+01,
     +   .6321E+02,
     +   .2100E-01,  .1278E-01,  .3028E-02,  .3537E+01,  .1576E+01,
     +   .7165E+02,
     +   .2158E-01,  .1313E-01,  .3084E-02,  .4033E+01,  .1823E+01,
     +   .8017E+02,
     +   .2212E-01,  .1345E-01,  .3134E-02,  .4520E+01,  .2066E+01,
     +   .8829E+02,
     +   .2281E-01,  .1385E-01,  .3198E-02,  .5183E+01,  .2397E+01,
     +   .9900E+02,
     +   .2345E-01,  .1424E-01,  .3257E-02,  .5852E+01,  .2730E+01,
     +   .1094E+03,
     +   .2408E-01,  .1461E-01,  .3313E-02,  .6538E+01,  .3072E+01,
     +   .1199E+03 /
        DATA ((PARTON(I,N,24),I=1,6),N=17,24)/
     +   .2467E-01,  .1495E-01,  .3365E-02,  .7217E+01,  .3411E+01,
     +   .1299E+03,
     +   .2526E-01,  .1530E-01,  .3418E-02,  .7938E+01,  .3771E+01,
     +   .1403E+03,
     +   .2583E-01,  .1563E-01,  .3467E-02,  .8652E+01,  .4127E+01,
     +   .1504E+03,
     +   .2638E-01,  .1596E-01,  .3515E-02,  .9373E+01,  .4487E+01,
     +   .1603E+03,
     +   .2690E-01,  .1626E-01,  .3560E-02,  .1008E+02,  .4840E+01,
     +   .1698E+03,
     +   .2761E-01,  .1668E-01,  .3620E-02,  .1107E+02,  .5336E+01,
     +   .1830E+03,
     +   .2825E-01,  .1705E-01,  .3674E-02,  .1201E+02,  .5803E+01,
     +   .1950E+03,
     +   .2890E-01,  .1743E-01,  .3728E-02,  .1299E+02,  .6295E+01,
     +   .2074E+03 /
        DATA ((PARTON(I,N,24),I=1,6),N=25,27)/
     +   .2955E-01,  .1781E-01,  .3781E-02,  .1400E+02,  .6796E+01,
     +   .2198E+03,
     +   .3014E-01,  .1815E-01,  .3830E-02,  .1493E+02,  .7264E+01,
     +   .2311E+03,
     +   .3074E-01,  .1850E-01,  .3879E-02,  .1592E+02,  .7756E+01,
     +   .2428E+03 /
        DATA ((PARTON(I,N,25),I=1,6),N=1,8)/
     +   .1787E-01,  .1094E-01,  .2803E-02,  .5630E+00,  .9087E-01,
     +   .8200E+01,
     +   .1841E-01,  .1127E-01,  .2860E-02,  .6421E+00,  .1294E+00,
     +   .1054E+02,
     +   .1902E-01,  .1164E-01,  .2922E-02,  .7499E+00,  .1823E+00,
     +   .1350E+02,
     +   .1974E-01,  .1207E-01,  .2994E-02,  .9036E+00,  .2579E+00,
     +   .1740E+02,
     +   .2058E-01,  .1257E-01,  .3077E-02,  .1123E+01,  .3662E+00,
     +   .2256E+02,
     +   .2136E-01,  .1303E-01,  .3151E-02,  .1362E+01,  .4847E+00,
     +   .2782E+02,
     +   .2223E-01,  .1355E-01,  .3234E-02,  .1678E+01,  .6414E+00,
     +   .3435E+02,
     +   .2302E-01,  .1402E-01,  .3307E-02,  .2003E+01,  .8030E+00,
     +   .4072E+02 /
        DATA ((PARTON(I,N,25),I=1,6),N=9,16)/
     +   .2380E-01,  .1449E-01,  .3379E-02,  .2368E+01,  .9844E+00,
     +   .4752E+02,
     +   .2452E-01,  .1491E-01,  .3443E-02,  .2732E+01,  .1165E+01,
     +   .5402E+02,
     +   .2524E-01,  .1534E-01,  .3506E-02,  .3133E+01,  .1365E+01,
     +   .6093E+02,
     +   .2594E-01,  .1576E-01,  .3567E-02,  .3549E+01,  .1572E+01,
     +   .6785E+02,
     +   .2658E-01,  .1613E-01,  .3622E-02,  .3956E+01,  .1775E+01,
     +   .7441E+02,
     +   .2739E-01,  .1661E-01,  .3692E-02,  .4507E+01,  .2050E+01,
     +   .8302E+02,
     +   .2816E-01,  .1706E-01,  .3756E-02,  .5059E+01,  .2325E+01,
     +   .9137E+02,
     +   .2890E-01,  .1750E-01,  .3817E-02,  .5624E+01,  .2606E+01,
     +   .9964E+02 /
        DATA ((PARTON(I,N,25),I=1,6),N=17,24)/
     +   .2959E-01,  .1790E-01,  .3874E-02,  .6180E+01,  .2884E+01,
     +   .1076E+03,
     +   .3030E-01,  .1831E-01,  .3931E-02,  .6768E+01,  .3177E+01,
     +   .1158E+03,
     +   .3097E-01,  .1870E-01,  .3985E-02,  .7347E+01,  .3466E+01,
     +   .1236E+03,
     +   .3162E-01,  .1908E-01,  .4037E-02,  .7931E+01,  .3758E+01,
     +   .1314E+03,
     +   .3223E-01,  .1944E-01,  .4086E-02,  .8501E+01,  .4042E+01,
     +   .1388E+03,
     +   .3306E-01,  .1992E-01,  .4151E-02,  .9299E+01,  .4440E+01,
     +   .1489E+03,
     +   .3382E-01,  .2036E-01,  .4210E-02,  .1005E+02,  .4814E+01,
     +   .1582E+03,
     +   .3459E-01,  .2081E-01,  .4269E-02,  .1083E+02,  .5206E+01,
     +   .1677E+03 /
        DATA ((PARTON(I,N,25),I=1,6),N=25,27)/
     +   .3535E-01,  .2125E-01,  .4327E-02,  .1163E+02,  .5603E+01,
     +   .1771E+03,
     +   .3604E-01,  .2165E-01,  .4379E-02,  .1237E+02,  .5973E+01,
     +   .1857E+03,
     +   .3675E-01,  .2206E-01,  .4433E-02,  .1315E+02,  .6361E+01,
     +   .1945E+03 /
        DATA ((PARTON(I,N,26),I=1,6),N=1,8)/
     +   .2091E-01,  .1280E-01,  .3194E-02,  .5667E+00,  .8465E-01,
     +   .7579E+01,
     +   .2154E-01,  .1318E-01,  .3255E-02,  .6392E+00,  .1200E+00,
     +   .9684E+01,
     +   .2225E-01,  .1360E-01,  .3322E-02,  .7373E+00,  .1680E+00,
     +   .1232E+02,
     +   .2308E-01,  .1410E-01,  .3399E-02,  .8763E+00,  .2363E+00,
     +   .1577E+02,
     +   .2406E-01,  .1468E-01,  .3488E-02,  .1073E+01,  .3333E+00,
     +   .2029E+02,
     +   .2495E-01,  .1521E-01,  .3567E-02,  .1286E+01,  .4388E+00,
     +   .2486E+02,
     +   .2596E-01,  .1582E-01,  .3655E-02,  .1565E+01,  .5772E+00,
     +   .3049E+02,
     +   .2687E-01,  .1635E-01,  .3733E-02,  .1851E+01,  .7189E+00,
     +   .3594E+02 /
        DATA ((PARTON(I,N,26),I=1,6),N=9,16)/
     +   .2778E-01,  .1689E-01,  .3810E-02,  .2169E+01,  .8772E+00,
     +   .4172E+02,
     +   .2861E-01,  .1738E-01,  .3878E-02,  .2485E+01,  .1034E+01,
     +   .4722E+02,
     +   .2944E-01,  .1787E-01,  .3947E-02,  .2831E+01,  .1207E+01,
     +   .5302E+02,
     +   .3025E-01,  .1835E-01,  .4012E-02,  .3189E+01,  .1385E+01,
     +   .5880E+02,
     +   .3099E-01,  .1878E-01,  .4070E-02,  .3538E+01,  .1558E+01,
     +   .6427E+02,
     +   .3192E-01,  .1933E-01,  .4144E-02,  .4007E+01,  .1792E+01,
     +   .7139E+02,
     +   .3280E-01,  .1984E-01,  .4213E-02,  .4476E+01,  .2026E+01,
     +   .7826E+02,
     +   .3366E-01,  .2034E-01,  .4278E-02,  .4953E+01,  .2264E+01,
     +   .8504E+02 /
        DATA ((PARTON(I,N,26),I=1,6),N=17,24)/
     +   .3446E-01,  .2080E-01,  .4339E-02,  .5422E+01,  .2497E+01,
     +   .9152E+02,
     +   .3527E-01,  .2127E-01,  .4400E-02,  .5915E+01,  .2743E+01,
     +   .9816E+02,
     +   .3603E-01,  .2172E-01,  .4458E-02,  .6399E+01,  .2985E+01,
     +   .1045E+03,
     +   .3678E-01,  .2215E-01,  .4513E-02,  .6885E+01,  .3228E+01,
     +   .1108E+03,
     +   .3748E-01,  .2256E-01,  .4565E-02,  .7358E+01,  .3464E+01,
     +   .1167E+03,
     +   .3844E-01,  .2311E-01,  .4635E-02,  .8020E+01,  .3794E+01,
     +   .1248E+03,
     +   .3930E-01,  .2361E-01,  .4697E-02,  .8637E+01,  .4102E+01,
     +   .1322E+03,
     +   .4018E-01,  .2411E-01,  .4761E-02,  .9282E+01,  .4424E+01,
     +   .1397E+03 /
        DATA ((PARTON(I,N,26),I=1,6),N=25,27)/
     +   .4105E-01,  .2461E-01,  .4823E-02,  .9934E+01,  .4749E+01,
     +   .1472E+03,
     +   .4184E-01,  .2507E-01,  .4879E-02,  .1054E+02,  .5052E+01,
     +   .1539E+03,
     +   .4265E-01,  .2553E-01,  .4936E-02,  .1117E+02,  .5368E+01,
     +   .1608E+03 /
        DATA ((PARTON(I,N,27),I=1,6),N=1,8)/
     +   .2468E-01,  .1510E-01,  .3648E-02,  .5712E+00,  .7836E-01,
     +   .6958E+01,
     +   .2542E-01,  .1554E-01,  .3713E-02,  .6371E+00,  .1104E+00,
     +   .8831E+01,
     +   .2625E-01,  .1604E-01,  .3784E-02,  .7257E+00,  .1537E+00,
     +   .1115E+02,
     +   .2722E-01,  .1661E-01,  .3866E-02,  .8502E+00,  .2149E+00,
     +   .1417E+02,
     +   .2836E-01,  .1729E-01,  .3960E-02,  .1025E+01,  .3010E+00,
     +   .1809E+02,
     +   .2941E-01,  .1791E-01,  .4045E-02,  .1212E+01,  .3938E+00,
     +   .2202E+02,
     +   .3059E-01,  .1861E-01,  .4139E-02,  .1457E+01,  .5148E+00,
     +   .2681E+02,
     +   .3165E-01,  .1923E-01,  .4221E-02,  .1704E+01,  .6378E+00,
     +   .3140E+02 /
        DATA ((PARTON(I,N,27),I=1,6),N=9,16)/
     +   .3271E-01,  .1986E-01,  .4303E-02,  .1979E+01,  .7742E+00,
     +   .3624E+02,
     +   .3367E-01,  .2042E-01,  .4376E-02,  .2250E+01,  .9088E+00,
     +   .4082E+02,
     +   .3464E-01,  .2099E-01,  .4448E-02,  .2545E+01,  .1056E+01,
     +   .4562E+02,
     +   .3557E-01,  .2153E-01,  .4517E-02,  .2849E+01,  .1207E+01,
     +   .5037E+02,
     +   .3643E-01,  .2203E-01,  .4580E-02,  .3144E+01,  .1354E+01,
     +   .5484E+02,
     +   .3751E-01,  .2266E-01,  .4659E-02,  .3538E+01,  .1550E+01,
     +   .6064E+02,
     +   .3853E-01,  .2326E-01,  .4732E-02,  .3931E+01,  .1746E+01,
     +   .6620E+02,
     +   .3952E-01,  .2383E-01,  .4802E-02,  .4328E+01,  .1944E+01,
     +   .7165E+02 /
        DATA ((PARTON(I,N,27),I=1,6),N=17,24)/
     +   .4044E-01,  .2436E-01,  .4867E-02,  .4716E+01,  .2138E+01,
     +   .7684E+02,
     +   .4138E-01,  .2490E-01,  .4932E-02,  .5124E+01,  .2341E+01,
     +   .8213E+02,
     +   .4226E-01,  .2541E-01,  .4993E-02,  .5522E+01,  .2540E+01,
     +   .8717E+02,
     +   .4312E-01,  .2591E-01,  .5052E-02,  .5921E+01,  .2739E+01,
     +   .9211E+02,
     +   .4394E-01,  .2637E-01,  .5108E-02,  .6308E+01,  .2932E+01,
     +   .9678E+02,
     +   .4504E-01,  .2700E-01,  .5182E-02,  .6846E+01,  .3201E+01,
     +   .1031E+03,
     +   .4603E-01,  .2757E-01,  .5249E-02,  .7347E+01,  .3450E+01,
     +   .1089E+03,
     +   .4705E-01,  .2815E-01,  .5317E-02,  .7868E+01,  .3711E+01,
     +   .1147E+03 /
        DATA ((PARTON(I,N,27),I=1,6),N=25,27)/
     +   .4805E-01,  .2872E-01,  .5384E-02,  .8393E+01,  .3973E+01,
     +   .1205E+03,
     +   .4895E-01,  .2923E-01,  .5444E-02,  .8879E+01,  .4215E+01,
     +   .1256E+03,
     +   .4988E-01,  .2976E-01,  .5505E-02,  .9385E+01,  .4468E+01,
     +   .1309E+03 /
        DATA ((PARTON(I,N,28),I=1,6),N=1,8)/
     +   .2978E-01,  .1820E-01,  .4208E-02,  .5767E+00,  .7156E-01,
     +   .6297E+01,
     +   .3066E-01,  .1873E-01,  .4276E-02,  .6356E+00,  .1002E+00,
     +   .7930E+01,
     +   .3165E-01,  .1931E-01,  .4352E-02,  .7141E+00,  .1386E+00,
     +   .9936E+01,
     +   .3281E-01,  .2000E-01,  .4439E-02,  .8234E+00,  .1923E+00,
     +   .1252E+02,
     +   .3417E-01,  .2080E-01,  .4538E-02,  .9752E+00,  .2672E+00,
     +   .1583E+02,
     +   .3541E-01,  .2153E-01,  .4628E-02,  .1137E+01,  .3472E+00,
     +   .1911E+02,
     +   .3681E-01,  .2236E-01,  .4728E-02,  .1346E+01,  .4505E+00,
     +   .2307E+02,
     +   .3807E-01,  .2309E-01,  .4815E-02,  .1556E+01,  .5547E+00,
     +   .2683E+02 /
        DATA ((PARTON(I,N,28),I=1,6),N=9,16)/
     +   .3933E-01,  .2383E-01,  .4902E-02,  .1786E+01,  .6694E+00,
     +   .3077E+02,
     +   .4046E-01,  .2449E-01,  .4979E-02,  .2013E+01,  .7818E+00,
     +   .3445E+02,
     +   .4161E-01,  .2516E-01,  .5057E-02,  .2258E+01,  .9039E+00,
     +   .3829E+02,
     +   .4272E-01,  .2580E-01,  .5131E-02,  .2508E+01,  .1029E+01,
     +   .4207E+02,
     +   .4373E-01,  .2638E-01,  .5197E-02,  .2750E+01,  .1149E+01,
     +   .4560E+02,
     +   .4501E-01,  .2712E-01,  .5281E-02,  .3073E+01,  .1310E+01,
     +   .5015E+02,
     +   .4621E-01,  .2781E-01,  .5360E-02,  .3391E+01,  .1468E+01,
     +   .5448E+02,
     +   .4737E-01,  .2848E-01,  .5435E-02,  .3712E+01,  .1628E+01,
     +   .5870E+02 /
        DATA ((PARTON(I,N,28),I=1,6),N=17,24)/
     +   .4846E-01,  .2910E-01,  .5504E-02,  .4024E+01,  .1784E+01,
     +   .6269E+02,
     +   .4956E-01,  .2973E-01,  .5574E-02,  .4350E+01,  .1947E+01,
     +   .6674E+02,
     +   .5060E-01,  .3032E-01,  .5640E-02,  .4667E+01,  .2105E+01,
     +   .7058E+02,
     +   .5161E-01,  .3090E-01,  .5704E-02,  .4983E+01,  .2263E+01,
     +   .7431E+02,
     +   .5256E-01,  .3144E-01,  .5764E-02,  .5288E+01,  .2415E+01,
     +   .7783E+02,
     +   .5385E-01,  .3217E-01,  .5844E-02,  .5712E+01,  .2626E+01,
     +   .8258E+02,
     +   .5501E-01,  .3283E-01,  .5917E-02,  .6103E+01,  .2822E+01,
     +   .8686E+02,
     +   .5620E-01,  .3350E-01,  .5990E-02,  .6510E+01,  .3025E+01,
     +   .9119E+02 /
        DATA ((PARTON(I,N,28),I=1,6),N=25,27)/
     +   .5736E-01,  .3415E-01,  .6062E-02,  .6917E+01,  .3228E+01,
     +   .9541E+02,
     +   .5842E-01,  .3475E-01,  .6127E-02,  .7293E+01,  .3416E+01,
     +   .9921E+02,
     +   .5950E-01,  .3535E-01,  .6193E-02,  .7682E+01,  .3610E+01,
     +   .1031E+03 /
        DATA ((PARTON(I,N,29),I=1,6),N=1,8)/
     +   .3589E-01,  .2191E-01,  .4804E-02,  .5822E+00,  .6514E-01,
     +   .5679E+01,
     +   .3694E-01,  .2254E-01,  .4876E-02,  .6345E+00,  .9062E-01,
     +   .7097E+01,
     +   .3812E-01,  .2323E-01,  .4954E-02,  .7037E+00,  .1245E+00,
     +   .8821E+01,
     +   .3950E-01,  .2404E-01,  .5045E-02,  .7991E+00,  .1714E+00,
     +   .1101E+02,
     +   .4111E-01,  .2499E-01,  .5149E-02,  .9305E+00,  .2362E+00,
     +   .1379E+02,
     +   .4259E-01,  .2585E-01,  .5243E-02,  .1069E+01,  .3049E+00,
     +   .1652E+02,
     +   .4425E-01,  .2682E-01,  .5348E-02,  .1246E+01,  .3927E+00,
     +   .1977E+02,
     +   .4574E-01,  .2768E-01,  .5440E-02,  .1423E+01,  .4805E+00,
     +   .2283E+02 /
        DATA ((PARTON(I,N,29),I=1,6),N=9,16)/
     +   .4723E-01,  .2855E-01,  .5532E-02,  .1616E+01,  .5764E+00,
     +   .2601E+02,
     +   .4857E-01,  .2932E-01,  .5614E-02,  .1804E+01,  .6698E+00,
     +   .2895E+02,
     +   .4993E-01,  .3010E-01,  .5696E-02,  .2006E+01,  .7705E+00,
     +   .3200E+02,
     +   .5123E-01,  .3085E-01,  .5774E-02,  .2211E+01,  .8728E+00,
     +   .3497E+02,
     +   .5242E-01,  .3153E-01,  .5846E-02,  .2408E+01,  .9711E+00,
     +   .3773E+02,
     +   .5393E-01,  .3239E-01,  .5936E-02,  .2670E+01,  .1101E+01,
     +   .4126E+02,
     +   .5534E-01,  .3320E-01,  .6020E-02,  .2926E+01,  .1229E+01,
     +   .4460E+02,
     +   .5670E-01,  .3397E-01,  .6100E-02,  .3183E+01,  .1358E+01,
     +   .4784E+02 /
        DATA ((PARTON(I,N,29),I=1,6),N=17,24)/
     +   .5798E-01,  .3469E-01,  .6175E-02,  .3432E+01,  .1482E+01,
     +   .5087E+02,
     +   .5927E-01,  .3542E-01,  .6251E-02,  .3690E+01,  .1611E+01,
     +   .5393E+02,
     +   .6048E-01,  .3611E-01,  .6322E-02,  .3941E+01,  .1736E+01,
     +   .5682E+02,
     +   .6166E-01,  .3677E-01,  .6391E-02,  .4190E+01,  .1860E+01,
     +   .5961E+02,
     +   .6277E-01,  .3739E-01,  .6456E-02,  .4429E+01,  .1980E+01,
     +   .6223E+02,
     +   .6427E-01,  .3824E-01,  .6543E-02,  .4759E+01,  .2144E+01,
     +   .6574E+02,
     +   .6563E-01,  .3899E-01,  .6622E-02,  .5063E+01,  .2296E+01,
     +   .6888E+02,
     +   .6701E-01,  .3976E-01,  .6702E-02,  .5376E+01,  .2453E+01,
     +   .7204E+02 /
        DATA ((PARTON(I,N,29),I=1,6),N=25,27)/
     +   .6836E-01,  .4051E-01,  .6781E-02,  .5689E+01,  .2609E+01,
     +   .7511E+02,
     +   .6959E-01,  .4120E-01,  .6852E-02,  .5977E+01,  .2753E+01,
     +   .7785E+02,
     +   .7084E-01,  .4189E-01,  .6925E-02,  .6274E+01,  .2902E+01,
     +   .8062E+02 /
        DATA ((PARTON(I,N,30),I=1,6),N=1,8)/
     +   .4306E-01,  .2626E-01,  .5407E-02,  .5870E+00,  .5920E-01,
     +   .5115E+01,
     +   .4431E-01,  .2699E-01,  .5480E-02,  .6333E+00,  .8182E-01,
     +   .6342E+01,
     +   .4570E-01,  .2781E-01,  .5561E-02,  .6939E+00,  .1116E+00,
     +   .7819E+01,
     +   .4734E-01,  .2877E-01,  .5654E-02,  .7770E+00,  .1526E+00,
     +   .9676E+01,
     +   .4925E-01,  .2987E-01,  .5763E-02,  .8901E+00,  .2086E+00,
     +   .1200E+02,
     +   .5099E-01,  .3088E-01,  .5861E-02,  .1008E+01,  .2673E+00,
     +   .1426E+02,
     +   .5295E-01,  .3201E-01,  .5971E-02,  .1158E+01,  .3417E+00,
     +   .1692E+02,
     +   .5471E-01,  .3302E-01,  .6069E-02,  .1307E+01,  .4155E+00,
     +   .1940E+02 /
        DATA ((PARTON(I,N,30),I=1,6),N=9,16)/
     +   .5646E-01,  .3403E-01,  .6166E-02,  .1467E+01,  .4955E+00,
     +   .2194E+02,
     +   .5803E-01,  .3493E-01,  .6253E-02,  .1622E+01,  .5728E+00,
     +   .2429E+02,
     +   .5963E-01,  .3583E-01,  .6341E-02,  .1788E+01,  .6557E+00,
     +   .2669E+02,
     +   .6115E-01,  .3670E-01,  .6425E-02,  .1956E+01,  .7394E+00,
     +   .2902E+02,
     +   .6255E-01,  .3749E-01,  .6502E-02,  .2116E+01,  .8193E+00,
     +   .3117E+02,
     +   .6431E-01,  .3849E-01,  .6599E-02,  .2327E+01,  .9247E+00,
     +   .3389E+02,
     +   .6596E-01,  .3941E-01,  .6690E-02,  .2533E+01,  .1027E+01,
     +   .3645E+02,
     +   .6755E-01,  .4031E-01,  .6778E-02,  .2738E+01,  .1130E+01,
     +   .3891E+02 /
        DATA ((PARTON(I,N,30),I=1,6),N=17,24)/
     +   .6903E-01,  .4114E-01,  .6859E-02,  .2936E+01,  .1229E+01,
     +   .4120E+02,
     +   .7053E-01,  .4197E-01,  .6942E-02,  .3140E+01,  .1331E+01,
     +   .4350E+02,
     +   .7194E-01,  .4276E-01,  .7020E-02,  .3337E+01,  .1429E+01,
     +   .4565E+02,
     +   .7331E-01,  .4352E-01,  .7096E-02,  .3531E+01,  .1527E+01,
     +   .4772E+02,
     +   .7459E-01,  .4423E-01,  .7167E-02,  .3717E+01,  .1620E+01,
     +   .4965E+02,
     +   .7633E-01,  .4519E-01,  .7264E-02,  .3973E+01,  .1748E+01,
     +   .5222E+02,
     +   .7790E-01,  .4606E-01,  .7351E-02,  .4208E+01,  .1865E+01,
     +   .5451E+02,
     +   .7949E-01,  .4693E-01,  .7439E-02,  .4449E+01,  .1986E+01,
     +   .5679E+02 /
        DATA ((PARTON(I,N,30),I=1,6),N=25,27)/
     +   .8105E-01,  .4779E-01,  .7526E-02,  .4688E+01,  .2106E+01,
     +   .5899E+02,
     +   .8246E-01,  .4856E-01,  .7605E-02,  .4907E+01,  .2215E+01,
     +   .6095E+02,
     +   .8390E-01,  .4935E-01,  .7686E-02,  .5132E+01,  .2328E+01,
     +   .6291E+02 /
        DATA ((PARTON(I,N,31),I=1,6),N=1,8)/
     +   .5166E-01,  .3146E-01,  .6003E-02,  .5905E+00,  .5358E-01,
     +   .4585E+01,
     +   .5314E-01,  .3232E-01,  .6078E-02,  .6311E+00,  .7356E-01,
     +   .5641E+01,
     +   .5479E-01,  .3328E-01,  .6162E-02,  .6839E+00,  .9964E-01,
     +   .6897E+01,
     +   .5673E-01,  .3440E-01,  .6259E-02,  .7555E+00,  .1352E+00,
     +   .8458E+01,
     +   .5898E-01,  .3569E-01,  .6373E-02,  .8521E+00,  .1832E+00,
     +   .1039E+02,
     +   .6104E-01,  .3687E-01,  .6477E-02,  .9522E+00,  .2331E+00,
     +   .1224E+02,
     +   .6335E-01,  .3819E-01,  .6594E-02,  .1078E+01,  .2957E+00,
     +   .1440E+02,
     +   .6542E-01,  .3937E-01,  .6699E-02,  .1201E+01,  .3573E+00,
     +   .1638E+02 /
        DATA ((PARTON(I,N,31),I=1,6),N=9,16)/
     +   .6747E-01,  .4053E-01,  .6804E-02,  .1333E+01,  .4235E+00,
     +   .1840E+02,
     +   .6932E-01,  .4157E-01,  .6899E-02,  .1460E+01,  .4870E+00,
     +   .2024E+02,
     +   .7119E-01,  .4262E-01,  .6996E-02,  .1596E+01,  .5546E+00,
     +   .2212E+02,
     +   .7297E-01,  .4362E-01,  .7088E-02,  .1731E+01,  .6225E+00,
     +   .2392E+02,
     +   .7460E-01,  .4453E-01,  .7173E-02,  .1860E+01,  .6869E+00,
     +   .2557E+02,
     +   .7666E-01,  .4568E-01,  .7281E-02,  .2028E+01,  .7713E+00,
     +   .2764E+02,
     +   .7858E-01,  .4674E-01,  .7382E-02,  .2191E+01,  .8531E+00,
     +   .2957E+02,
     +   .8042E-01,  .4776E-01,  .7479E-02,  .2353E+01,  .9342E+00,
     +   .3141E+02 /
        DATA ((PARTON(I,N,31),I=1,6),N=17,24)/
     +   .8215E-01,  .4871E-01,  .7571E-02,  .2508E+01,  .1012E+01,
     +   .3312E+02,
     +   .8388E-01,  .4967E-01,  .7664E-02,  .2667E+01,  .1092E+01,
     +   .3481E+02,
     +   .8551E-01,  .5056E-01,  .7752E-02,  .2820E+01,  .1168E+01,
     +   .3639E+02,
     +   .8709E-01,  .5143E-01,  .7837E-02,  .2971E+01,  .1244E+01,
     +   .3790E+02,
     +   .8858E-01,  .5224E-01,  .7917E-02,  .3114E+01,  .1316E+01,
     +   .3929E+02,
     +   .9058E-01,  .5333E-01,  .8027E-02,  .3310E+01,  .1414E+01,
     +   .4114E+02,
     +   .9238E-01,  .5431E-01,  .8125E-02,  .3489E+01,  .1504E+01,
     +   .4277E+02,
     +   .9421E-01,  .5530E-01,  .8226E-02,  .3671E+01,  .1596E+01,
     +   .4438E+02 /
        DATA ((PARTON(I,N,31),I=1,6),N=25,27)/
     +   .9599E-01,  .5626E-01,  .8325E-02,  .3852E+01,  .1686E+01,
     +   .4593E+02,
     +   .9761E-01,  .5713E-01,  .8414E-02,  .4016E+01,  .1769E+01,
     +   .4729E+02,
     +   .9926E-01,  .5802E-01,  .8506E-02,  .4184E+01,  .1853E+01,
     +   .4865E+02 /
        DATA ((PARTON(I,N,32),I=1,6),N=1,8)/
     +   .6014E-01,  .3657E-01,  .6473E-02,  .5919E+00,  .4915E-01,
     +   .4170E+01,
     +   .6185E-01,  .3755E-01,  .6551E-02,  .6279E+00,  .6708E-01,
     +   .5095E+01,
     +   .6376E-01,  .3865E-01,  .6639E-02,  .6745E+00,  .9030E-01,
     +   .6185E+01,
     +   .6599E-01,  .3992E-01,  .6742E-02,  .7372E+00,  .1217E+00,
     +   .7527E+01,
     +   .6858E-01,  .4140E-01,  .6864E-02,  .8212E+00,  .1637E+00,
     +   .9167E+01,
     +   .7093E-01,  .4274E-01,  .6976E-02,  .9075E+00,  .2070E+00,
     +   .1072E+02,
     +   .7358E-01,  .4423E-01,  .7103E-02,  .1015E+01,  .2609E+00,
     +   .1252E+02,
     +   .7595E-01,  .4556E-01,  .7219E-02,  .1120E+01,  .3135E+00,
     +   .1415E+02 /
        DATA ((PARTON(I,N,32),I=1,6),N=9,16)/
     +   .7829E-01,  .4687E-01,  .7334E-02,  .1231E+01,  .3697E+00,
     +   .1580E+02,
     +   .8040E-01,  .4805E-01,  .7440E-02,  .1338E+01,  .4232E+00,
     +   .1729E+02,
     +   .8253E-01,  .4923E-01,  .7547E-02,  .1450E+01,  .4798E+00,
     +   .1880E+02,
     +   .8456E-01,  .5035E-01,  .7650E-02,  .1563E+01,  .5363E+00,
     +   .2024E+02,
     +   .8641E-01,  .5137E-01,  .7745E-02,  .1669E+01,  .5897E+00,
     +   .2154E+02,
     +   .8874E-01,  .5265E-01,  .7866E-02,  .1807E+01,  .6593E+00,
     +   .2317E+02,
     +   .9091E-01,  .5384E-01,  .7980E-02,  .1940E+01,  .7263E+00,
     +   .2468E+02,
     +   .9300E-01,  .5498E-01,  .8090E-02,  .2072E+01,  .7924E+00,
     +   .2610E+02 /
        DATA ((PARTON(I,N,32),I=1,6),N=17,24)/
     +   .9494E-01,  .5604E-01,  .8194E-02,  .2197E+01,  .8555E+00,
     +   .2742E+02,
     +   .9690E-01,  .5710E-01,  .8299E-02,  .2325E+01,  .9200E+00,
     +   .2871E+02,
     +   .9874E-01,  .5809E-01,  .8399E-02,  .2447E+01,  .9817E+00,
     +   .2991E+02,
     +   .1005E+00,  .5905E-01,  .8496E-02,  .2567E+01,  .1042E+01,
     +   .3105E+02,
     +   .1022E+00,  .5995E-01,  .8588E-02,  .2681E+01,  .1099E+01,
     +   .3209E+02,
     +   .1044E+00,  .6115E-01,  .8712E-02,  .2836E+01,  .1178E+01,
     +   .3347E+02,
     +   .1064E+00,  .6223E-01,  .8824E-02,  .2977E+01,  .1248E+01,
     +   .3468E+02,
     +   .1085E+00,  .6332E-01,  .8939E-02,  .3120E+01,  .1321E+01,
     +   .3586E+02 /
        DATA ((PARTON(I,N,32),I=1,6),N=25,27)/
     +   .1105E+00,  .6438E-01,  .9051E-02,  .3261E+01,  .1392E+01,
     +   .3699E+02,
     +   .1123E+00,  .6533E-01,  .9154E-02,  .3388E+01,  .1456E+01,
     +   .3798E+02,
     +   .1141E+00,  .6630E-01,  .9258E-02,  .3519E+01,  .1522E+01,
     +   .3895E+02 /
        DATA ((PARTON(I,N,33),I=1,6),N=1,8)/
     +   .7061E-01,  .4284E-01,  .6917E-02,  .5911E+00,  .4475E-01,
     +   .3756E+01,
     +   .7260E-01,  .4398E-01,  .7002E-02,  .6225E+00,  .6066E-01,
     +   .4556E+01,
     +   .7481E-01,  .4523E-01,  .7099E-02,  .6629E+00,  .8111E-01,
     +   .5489E+01,
     +   .7739E-01,  .4669E-01,  .7214E-02,  .7169E+00,  .1085E+00,
     +   .6625E+01,
     +   .8039E-01,  .4838E-01,  .7351E-02,  .7886E+00,  .1448E+00,
     +   .7995E+01,
     +   .8311E-01,  .4990E-01,  .7479E-02,  .8617E+00,  .1819E+00,
     +   .9278E+01,
     +   .8617E-01,  .5160E-01,  .7625E-02,  .9520E+00,  .2276E+00,
     +   .1074E+02,
     +   .8889E-01,  .5311E-01,  .7758E-02,  .1039E+01,  .2718E+00,
     +   .1206E+02 /
        DATA ((PARTON(I,N,33),I=1,6),N=9,16)/
     +   .9158E-01,  .5460E-01,  .7893E-02,  .1132E+01,  .3186E+00,
     +   .1338E+02,
     +   .9400E-01,  .5592E-01,  .8015E-02,  .1219E+01,  .3630E+00,
     +   .1456E+02,
     +   .9643E-01,  .5725E-01,  .8140E-02,  .1311E+01,  .4096E+00,
     +   .1574E+02,
     +   .9875E-01,  .5852E-01,  .8262E-02,  .1402E+01,  .4558E+00,
     +   .1686E+02,
     +   .1009E+00,  .5966E-01,  .8373E-02,  .1488E+01,  .4992E+00,
     +   .1787E+02,
     +   .1035E+00,  .6110E-01,  .8516E-02,  .1599E+01,  .5555E+00,
     +   .1911E+02,
     +   .1060E+00,  .6243E-01,  .8650E-02,  .1705E+01,  .6093E+00,
     +   .2026E+02,
     +   .1083E+00,  .6370E-01,  .8780E-02,  .1809E+01,  .6621E+00,
     +   .2133E+02 /
        DATA ((PARTON(I,N,33),I=1,6),N=17,24)/
     +   .1106E+00,  .6488E-01,  .8903E-02,  .1908E+01,  .7122E+00,
     +   .2231E+02,
     +   .1128E+00,  .6606E-01,  .9027E-02,  .2009E+01,  .7632E+00,
     +   .2327E+02,
     +   .1148E+00,  .6716E-01,  .9144E-02,  .2104E+01,  .8117E+00,
     +   .2415E+02,
     +   .1168E+00,  .6822E-01,  .9259E-02,  .2197E+01,  .8590E+00,
     +   .2497E+02,
     +   .1187E+00,  .6921E-01,  .9367E-02,  .2286E+01,  .9038E+00,
     +   .2573E+02,
     +   .1212E+00,  .7053E-01,  .9513E-02,  .2405E+01,  .9644E+00,
     +   .2672E+02,
     +   .1235E+00,  .7172E-01,  .9646E-02,  .2513E+01,  .1019E+01,
     +   .2758E+02,
     +   .1258E+00,  .7291E-01,  .9780E-02,  .2622E+01,  .1074E+01,
     +   .2842E+02 /
        DATA ((PARTON(I,N,33),I=1,6),N=25,27)/
     +   .1280E+00,  .7407E-01,  .9913E-02,  .2728E+01,  .1129E+01,
     +   .2920E+02,
     +   .1300E+00,  .7511E-01,  .1003E-01,  .2825E+01,  .1178E+01,
     +   .2989E+02,
     +   .1320E+00,  .7617E-01,  .1016E-01,  .2923E+01,  .1227E+01,
     +   .3056E+02 /
        DATA ((PARTON(I,N,34),I=1,6),N=1,8)/
     +   .8466E-01,  .5122E-01,  .7336E-02,  .5861E+00,  .4012E-01,
     +   .3319E+01,
     +   .8702E-01,  .5255E-01,  .7439E-02,  .6127E+00,  .5395E-01,
     +   .3992E+01,
     +   .8964E-01,  .5401E-01,  .7558E-02,  .6465E+00,  .7153E-01,
     +   .4767E+01,
     +   .9269E-01,  .5571E-01,  .7701E-02,  .6914E+00,  .9481E-01,
     +   .5697E+01,
     +   .9623E-01,  .5766E-01,  .7872E-02,  .7505E+00,  .1254E+00,
     +   .6804E+01,
     +   .9943E-01,  .5942E-01,  .8032E-02,  .8102E+00,  .1562E+00,
     +   .7824E+01,
     +   .1030E+00,  .6138E-01,  .8217E-02,  .8832E+00,  .1938E+00,
     +   .8974E+01,
     +   .1062E+00,  .6311E-01,  .8385E-02,  .9531E+00,  .2298E+00,
     +   .9995E+01 /
        DATA ((PARTON(I,N,34),I=1,6),N=9,16)/
     +   .1093E+00,  .6481E-01,  .8555E-02,  .1027E+01,  .2676E+00,
     +   .1100E+02,
     +   .1122E+00,  .6633E-01,  .8711E-02,  .1095E+01,  .3030E+00,
     +   .1189E+02,
     +   .1150E+00,  .6784E-01,  .8869E-02,  .1167E+01,  .3400E+00,
     +   .1277E+02,
     +   .1177E+00,  .6927E-01,  .9023E-02,  .1238E+01,  .3764E+00,
     +   .1360E+02,
     +   .1201E+00,  .7057E-01,  .9164E-02,  .1304E+01,  .4104E+00,
     +   .1433E+02,
     +   .1232E+00,  .7219E-01,  .9344E-02,  .1389E+01,  .4540E+00,
     +   .1524E+02,
     +   .1260E+00,  .7368E-01,  .9514E-02,  .1470E+01,  .4956E+00,
     +   .1606E+02,
     +   .1287E+00,  .7511E-01,  .9677E-02,  .1549E+01,  .5360E+00,
     +   .1681E+02 /
        DATA ((PARTON(I,N,34),I=1,6),N=17,24)/
     +   .1312E+00,  .7642E-01,  .9831E-02,  .1623E+01,  .5741E+00,
     +   .1750E+02,
     +   .1337E+00,  .7773E-01,  .9987E-02,  .1698E+01,  .6126E+00,
     +   .1816E+02,
     +   .1361E+00,  .7896E-01,  .1013E-01,  .1769E+01,  .6490E+00,
     +   .1877E+02,
     +   .1384E+00,  .8013E-01,  .1028E-01,  .1838E+01,  .6844E+00,
     +   .1933E+02,
     +   .1405E+00,  .8123E-01,  .1041E-01,  .1902E+01,  .7176E+00,
     +   .1984E+02,
     +   .1433E+00,  .8269E-01,  .1059E-01,  .1989E+01,  .7623E+00,
     +   .2050E+02,
     +   .1459E+00,  .8399E-01,  .1076E-01,  .2067E+01,  .8024E+00,
     +   .2106E+02,
     +   .1484E+00,  .8530E-01,  .1092E-01,  .2146E+01,  .8428E+00,
     +   .2161E+02 /
        DATA ((PARTON(I,N,34),I=1,6),N=25,27)/
     +   .1509E+00,  .8656E-01,  .1109E-01,  .2222E+01,  .8821E+00,
     +   .2211E+02,
     +   .1532E+00,  .8770E-01,  .1123E-01,  .2290E+01,  .9174E+00,
     +   .2255E+02,
     +   .1554E+00,  .8884E-01,  .1138E-01,  .2360E+01,  .9530E+00,
     +   .2296E+02 /
        DATA ((PARTON(I,N,35),I=1,6),N=1,8)/
     +   .1015E+00,  .6117E-01,  .7686E-02,  .5758E+00,  .3592E-01,
     +   .2916E+01,
     +   .1043E+00,  .6271E-01,  .7828E-02,  .5977E+00,  .4785E-01,
     +   .3477E+01,
     +   .1074E+00,  .6441E-01,  .7991E-02,  .6255E+00,  .6287E-01,
     +   .4114E+01,
     +   .1110E+00,  .6637E-01,  .8187E-02,  .6621E+00,  .8253E-01,
     +   .4868E+01,
     +   .1151E+00,  .6862E-01,  .8421E-02,  .7099E+00,  .1080E+00,
     +   .5750E+01,
     +   .1189E+00,  .7065E-01,  .8640E-02,  .7577E+00,  .1334E+00,
     +   .6550E+01,
     +   .1231E+00,  .7289E-01,  .8890E-02,  .8156E+00,  .1640E+00,
     +   .7438E+01,
     +   .1268E+00,  .7485E-01,  .9118E-02,  .8705E+00,  .1930E+00,
     +   .8216E+01 /
        DATA ((PARTON(I,N,35),I=1,6),N=9,16)/
     +   .1304E+00,  .7678E-01,  .9347E-02,  .9278E+00,  .2232E+00,
     +   .8970E+01,
     +   .1337E+00,  .7850E-01,  .9555E-02,  .9810E+00,  .2512E+00,
     +   .9630E+01,
     +   .1370E+00,  .8020E-01,  .9766E-02,  .1036E+01,  .2802E+00,
     +   .1027E+02,
     +   .1400E+00,  .8181E-01,  .9970E-02,  .1090E+01,  .3085E+00,
     +   .1087E+02,
     +   .1428E+00,  .8326E-01,  .1016E-01,  .1140E+01,  .3347E+00,
     +   .1140E+02,
     +   .1463E+00,  .8506E-01,  .1039E-01,  .1204E+01,  .3682E+00,
     +   .1204E+02,
     +   .1496E+00,  .8672E-01,  .1061E-01,  .1264E+01,  .3997E+00,
     +   .1260E+02,
     +   .1526E+00,  .8830E-01,  .1083E-01,  .1322E+01,  .4302E+00,
     +   .1313E+02 /
        DATA ((PARTON(I,N,35),I=1,6),N=17,24)/
     +   .1555E+00,  .8975E-01,  .1102E-01,  .1376E+01,  .4587E+00,
     +   .1359E+02,
     +   .1583E+00,  .9119E-01,  .1122E-01,  .1431E+01,  .4874E+00,
     +   .1404E+02,
     +   .1610E+00,  .9253E-01,  .1141E-01,  .1482E+01,  .5143E+00,
     +   .1444E+02,
     +   .1635E+00,  .9381E-01,  .1159E-01,  .1532E+01,  .5403E+00,
     +   .1481E+02,
     +   .1659E+00,  .9500E-01,  .1176E-01,  .1578E+01,  .5645E+00,
     +   .1514E+02,
     +   .1691E+00,  .9658E-01,  .1199E-01,  .1640E+01,  .5970E+00,
     +   .1556E+02,
     +   .1719E+00,  .9798E-01,  .1220E-01,  .1695E+01,  .6258E+00,
     +   .1591E+02,
     +   .1747E+00,  .9938E-01,  .1240E-01,  .1749E+01,  .6547E+00,
     +   .1624E+02 /
        DATA ((PARTON(I,N,35),I=1,6),N=25,27)/
     +   .1775E+00,  .1007E+00,  .1260E-01,  .1802E+01,  .6826E+00,
     +   .1655E+02,
     +   .1799E+00,  .1019E+00,  .1278E-01,  .1850E+01,  .7075E+00,
     +   .1681E+02,
     +   .1824E+00,  .1032E+00,  .1297E-01,  .1897E+01,  .7325E+00,
     +   .1705E+02 /
        DATA ((PARTON(I,N,36),I=1,6),N=1,8)/
     +   .1213E+00,  .7276E-01,  .8082E-02,  .5590E+00,  .3222E-01,
     +   .2552E+01,
     +   .1246E+00,  .7455E-01,  .8294E-02,  .5767E+00,  .4248E-01,
     +   .3016E+01,
     +   .1283E+00,  .7650E-01,  .8534E-02,  .5990E+00,  .5525E-01,
     +   .3536E+01,
     +   .1325E+00,  .7876E-01,  .8820E-02,  .6283E+00,  .7177E-01,
     +   .4141E+01,
     +   .1374E+00,  .8133E-01,  .9158E-02,  .6662E+00,  .9289E-01,
     +   .4837E+01,
     +   .1418E+00,  .8363E-01,  .9470E-02,  .7037E+00,  .1137E+00,
     +   .5458E+01,
     +   .1466E+00,  .8616E-01,  .9823E-02,  .7488E+00,  .1384E+00,
     +   .6136E+01,
     +   .1509E+00,  .8837E-01,  .1014E-01,  .7912E+00,  .1616E+00,
     +   .6719E+01 /
        DATA ((PARTON(I,N,36),I=1,6),N=9,16)/
     +   .1551E+00,  .9054E-01,  .1046E-01,  .8349E+00,  .1855E+00,
     +   .7276E+01,
     +   .1588E+00,  .9244E-01,  .1074E-01,  .8752E+00,  .2074E+00,
     +   .7756E+01,
     +   .1625E+00,  .9433E-01,  .1103E-01,  .9166E+00,  .2299E+00,
     +   .8219E+01,
     +   .1661E+00,  .9611E-01,  .1130E-01,  .9568E+00,  .2518E+00,
     +   .8642E+01,
     +   .1692E+00,  .9770E-01,  .1155E-01,  .9937E+00,  .2718E+00,
     +   .9009E+01,
     +   .1732E+00,  .9968E-01,  .1186E-01,  .1041E+01,  .2971E+00,
     +   .9449E+01,
     +   .1768E+00,  .1015E+00,  .1215E-01,  .1084E+01,  .3208E+00,
     +   .9834E+01,
     +   .1802E+00,  .1032E+00,  .1242E-01,  .1126E+01,  .3435E+00,
     +   .1018E+02 /
        DATA ((PARTON(I,N,36),I=1,6),N=17,24)/
     +   .1834E+00,  .1048E+00,  .1268E-01,  .1165E+01,  .3646E+00,
     +   .1049E+02,
     +   .1866E+00,  .1063E+00,  .1293E-01,  .1204E+01,  .3857E+00,
     +   .1078E+02,
     +   .1895E+00,  .1077E+00,  .1317E-01,  .1240E+01,  .4053E+00,
     +   .1103E+02,
     +   .1923E+00,  .1091E+00,  .1340E-01,  .1275E+01,  .4240E+00,
     +   .1126E+02,
     +   .1949E+00,  .1104E+00,  .1361E-01,  .1307E+01,  .4415E+00,
     +   .1147E+02,
     +   .1984E+00,  .1120E+00,  .1389E-01,  .1349E+01,  .4646E+00,
     +   .1172E+02,
     +   .2015E+00,  .1135E+00,  .1414E-01,  .1387E+01,  .4851E+00,
     +   .1193E+02,
     +   .2045E+00,  .1150E+00,  .1439E-01,  .1424E+01,  .5054E+00,
     +   .1212E+02 /
        DATA ((PARTON(I,N,36),I=1,6),N=25,27)/
     +   .2075E+00,  .1164E+00,  .1463E-01,  .1459E+01,  .5248E+00,
     +   .1229E+02,
     +   .2101E+00,  .1176E+00,  .1485E-01,  .1491E+01,  .5421E+00,
     +   .1244E+02,
     +   .2128E+00,  .1189E+00,  .1507E-01,  .1522E+01,  .5592E+00,
     +   .1257E+02 /
        DATA ((PARTON(I,N,37),I=1,6),N=1,8)/
     +   .1454E+00,  .8669E-01,  .8841E-02,  .5343E+00,  .2893E-01,
     +   .2217E+01,
     +   .1494E+00,  .8874E-01,  .9166E-02,  .5481E+00,  .3770E-01,
     +   .2596E+01,
     +   .1537E+00,  .9098E-01,  .9529E-02,  .5655E+00,  .4846E-01,
     +   .3014E+01,
     +   .1586E+00,  .9354E-01,  .9953E-02,  .5882E+00,  .6219E-01,
     +   .3492E+01,
     +   .1643E+00,  .9646E-01,  .1045E-01,  .6173E+00,  .7950E-01,
     +   .4031E+01,
     +   .1694E+00,  .9904E-01,  .1089E-01,  .6459E+00,  .9629E-01,
     +   .4503E+01,
     +   .1750E+00,  .1019E+00,  .1139E-01,  .6799E+00,  .1160E+00,
     +   .5008E+01,
     +   .1799E+00,  .1043E+00,  .1183E-01,  .7114E+00,  .1343E+00,
     +   .5434E+01 /
        DATA ((PARTON(I,N,37),I=1,6),N=9,16)/
     +   .1847E+00,  .1067E+00,  .1226E-01,  .7437E+00,  .1529E+00,
     +   .5834E+01,
     +   .1889E+00,  .1088E+00,  .1265E-01,  .7732E+00,  .1698E+00,
     +   .6173E+01,
     +   .1931E+00,  .1109E+00,  .1303E-01,  .8032E+00,  .1869E+00,
     +   .6494E+01,
     +   .1970E+00,  .1128E+00,  .1339E-01,  .8321E+00,  .2034E+00,
     +   .6782E+01,
     +   .2006E+00,  .1145E+00,  .1371E-01,  .8583E+00,  .2184E+00,
     +   .7029E+01,
     +   .2050E+00,  .1166E+00,  .1411E-01,  .8913E+00,  .2372E+00,
     +   .7318E+01,
     +   .2090E+00,  .1185E+00,  .1448E-01,  .9219E+00,  .2546E+00,
     +   .7567E+01,
     +   .2128E+00,  .1203E+00,  .1482E-01,  .9508E+00,  .2711E+00,
     +   .7787E+01 /
        DATA ((PARTON(I,N,37),I=1,6),N=17,24)/
     +   .2162E+00,  .1220E+00,  .1514E-01,  .9774E+00,  .2863E+00,
     +   .7976E+01,
     +   .2197E+00,  .1236E+00,  .1545E-01,  .1004E+01,  .3014E+00,
     +   .8151E+01,
     +   .2228E+00,  .1251E+00,  .1574E-01,  .1028E+01,  .3153E+00,
     +   .8301E+01,
     +   .2259E+00,  .1265E+00,  .1601E-01,  .1051E+01,  .3285E+00,
     +   .8435E+01,
     +   .2286E+00,  .1277E+00,  .1626E-01,  .1072E+01,  .3407E+00,
     +   .8549E+01,
     +   .2323E+00,  .1294E+00,  .1660E-01,  .1100E+01,  .3568E+00,
     +   .8688E+01,
     +   .2356E+00,  .1309E+00,  .1689E-01,  .1124E+01,  .3708E+00,
     +   .8798E+01,
     +   .2388E+00,  .1324E+00,  .1718E-01,  .1148E+01,  .3846E+00,
     +   .8896E+01 /
        DATA ((PARTON(I,N,37),I=1,6),N=25,27)/
     +   .2419E+00,  .1338E+00,  .1745E-01,  .1171E+01,  .3977E+00,
     +   .8978E+01,
     +   .2447E+00,  .1350E+00,  .1770E-01,  .1190E+01,  .4092E+00,
     +   .9043E+01,
     +   .2475E+00,  .1363E+00,  .1794E-01,  .1210E+01,  .4206E+00,
     +   .9098E+01 /
        DATA ((PARTON(I,N,38),I=1,6),N=1,8)/
     +   .1699E+00,  .1006E+00,  .1019E-01,  .5071E+00,  .2651E-01,
     +   .1960E+01,
     +   .1744E+00,  .1029E+00,  .1065E-01,  .5179E+00,  .3415E-01,
     +   .2276E+01,
     +   .1793E+00,  .1053E+00,  .1115E-01,  .5316E+00,  .4341E-01,
     +   .2619E+01,
     +   .1849E+00,  .1082E+00,  .1172E-01,  .5494E+00,  .5507E-01,
     +   .3006E+01,
     +   .1914E+00,  .1114E+00,  .1238E-01,  .5720E+00,  .6958E-01,
     +   .3434E+01,
     +   .1971E+00,  .1142E+00,  .1297E-01,  .5941E+00,  .8346E-01,
     +   .3802E+01,
     +   .2033E+00,  .1172E+00,  .1361E-01,  .6200E+00,  .9961E-01,
     +   .4188E+01,
     +   .2088E+00,  .1199E+00,  .1416E-01,  .6439E+00,  .1143E+00,
     +   .4508E+01 /
        DATA ((PARTON(I,N,38),I=1,6),N=9,16)/
     +   .2140E+00,  .1224E+00,  .1470E-01,  .6681E+00,  .1292E+00,
     +   .4802E+01,
     +   .2187E+00,  .1246E+00,  .1517E-01,  .6900E+00,  .1425E+00,
     +   .5047E+01,
     +   .2232E+00,  .1268E+00,  .1564E-01,  .7121E+00,  .1560E+00,
     +   .5276E+01,
     +   .2275E+00,  .1288E+00,  .1607E-01,  .7331E+00,  .1688E+00,
     +   .5477E+01,
     +   .2313E+00,  .1305E+00,  .1645E-01,  .7521E+00,  .1803E+00,
     +   .5646E+01,
     +   .2360E+00,  .1327E+00,  .1692E-01,  .7757E+00,  .1947E+00,
     +   .5841E+01,
     +   .2403E+00,  .1347E+00,  .1734E-01,  .7974E+00,  .2078E+00,
     +   .6004E+01,
     +   .2443E+00,  .1365E+00,  .1773E-01,  .8177E+00,  .2202E+00,
     +   .6145E+01 /
        DATA ((PARTON(I,N,38),I=1,6),N=17,24)/
     +   .2480E+00,  .1381E+00,  .1809E-01,  .8362E+00,  .2315E+00,
     +   .6263E+01,
     +   .2516E+00,  .1397E+00,  .1844E-01,  .8542E+00,  .2426E+00,
     +   .6368E+01,
     +   .2549E+00,  .1412E+00,  .1876E-01,  .8708E+00,  .2528E+00,
     +   .6457E+01,
     +   .2580E+00,  .1426E+00,  .1905E-01,  .8863E+00,  .2624E+00,
     +   .6533E+01,
     +   .2609E+00,  .1438E+00,  .1932E-01,  .9005E+00,  .2712E+00,
     +   .6596E+01,
     +   .2646E+00,  .1455E+00,  .1968E-01,  .9189E+00,  .2826E+00,
     +   .6668E+01,
     +   .2680E+00,  .1469E+00,  .1998E-01,  .9347E+00,  .2926E+00,
     +   .6722E+01,
     +   .2712E+00,  .1483E+00,  .2028E-01,  .9500E+00,  .3023E+00,
     +   .6766E+01 /
        DATA ((PARTON(I,N,38),I=1,6),N=25,27)/
     +   .2743E+00,  .1496E+00,  .2056E-01,  .9643E+00,  .3114E+00,
     +   .6799E+01,
     +   .2771E+00,  .1508E+00,  .2081E-01,  .9767E+00,  .3193E+00,
     +   .6822E+01,
     +   .2798E+00,  .1519E+00,  .2105E-01,  .9887E+00,  .3271E+00,
     +   .6837E+01 /
        DATA ((PARTON(I,N,39),I=1,6),N=1,8)/
     +   .2012E+00,  .1180E+00,  .1299E-01,  .4717E+00,  .2428E-01,
     +   .1713E+01,
     +   .2064E+00,  .1205E+00,  .1360E-01,  .4798E+00,  .3083E-01,
     +   .1970E+01,
     +   .2120E+00,  .1233E+00,  .1426E-01,  .4901E+00,  .3866E-01,
     +   .2244E+01,
     +   .2184E+00,  .1264E+00,  .1501E-01,  .5033E+00,  .4838E-01,
     +   .2547E+01,
     +   .2256E+00,  .1298E+00,  .1584E-01,  .5199E+00,  .6027E-01,
     +   .2875E+01,
     +   .2320E+00,  .1328E+00,  .1657E-01,  .5360E+00,  .7148E-01,
     +   .3151E+01,
     +   .2389E+00,  .1360E+00,  .1735E-01,  .5547E+00,  .8432E-01,
     +   .3433E+01,
     +   .2449E+00,  .1388E+00,  .1801E-01,  .5717E+00,  .9587E-01,
     +   .3662E+01 /
        DATA ((PARTON(I,N,39),I=1,6),N=9,16)/
     +   .2506E+00,  .1414E+00,  .1864E-01,  .5887E+00,  .1073E+00,
     +   .3867E+01,
     +   .2556E+00,  .1437E+00,  .1918E-01,  .6040E+00,  .1176E+00,
     +   .4034E+01,
     +   .2605E+00,  .1459E+00,  .1970E-01,  .6191E+00,  .1277E+00,
     +   .4185E+01,
     +   .2650E+00,  .1479E+00,  .2018E-01,  .6334E+00,  .1373E+00,
     +   .4316E+01,
     +   .2690E+00,  .1496E+00,  .2059E-01,  .6461E+00,  .1458E+00,
     +   .4422E+01,
     +   .2739E+00,  .1518E+00,  .2109E-01,  .6617E+00,  .1564E+00,
     +   .4541E+01,
     +   .2783E+00,  .1537E+00,  .2153E-01,  .6757E+00,  .1659E+00,
     +   .4637E+01,
     +   .2824E+00,  .1554E+00,  .2194E-01,  .6888E+00,  .1748E+00,
     +   .4716E+01 /
        DATA ((PARTON(I,N,39),I=1,6),N=17,24)/
     +   .2862E+00,  .1570E+00,  .2230E-01,  .7004E+00,  .1828E+00,
     +   .4779E+01,
     +   .2898E+00,  .1585E+00,  .2264E-01,  .7117E+00,  .1906E+00,
     +   .4833E+01,
     +   .2931E+00,  .1598E+00,  .2295E-01,  .7218E+00,  .1977E+00,
     +   .4875E+01,
     +   .2962E+00,  .1611E+00,  .2323E-01,  .7312E+00,  .2043E+00,
     +   .4909E+01,
     +   .2990E+00,  .1622E+00,  .2349E-01,  .7396E+00,  .2103E+00,
     +   .4934E+01,
     +   .3027E+00,  .1637E+00,  .2381E-01,  .7504E+00,  .2180E+00,
     +   .4959E+01,
     +   .3059E+00,  .1650E+00,  .2409E-01,  .7594E+00,  .2246E+00,
     +   .4973E+01,
     +   .3090E+00,  .1662E+00,  .2435E-01,  .7680E+00,  .2310E+00,
     +   .4979E+01 /
        DATA ((PARTON(I,N,39),I=1,6),N=25,27)/
     +   .3119E+00,  .1673E+00,  .2459E-01,  .7758E+00,  .2369E+00,
     +   .4979E+01,
     +   .3145E+00,  .1682E+00,  .2479E-01,  .7824E+00,  .2420E+00,
     +   .4974E+01,
     +   .3170E+00,  .1692E+00,  .2499E-01,  .7886E+00,  .2470E+00,
     +   .4964E+01 /
        DATA ((PARTON(I,N,40),I=1,6),N=1,8)/
     +   .2459E+00,  .1422E+00,  .1893E-01,  .4244E+00,  .2211E-01,
     +   .1465E+01,
     +   .2518E+00,  .1450E+00,  .1967E-01,  .4299E+00,  .2756E-01,
     +   .1663E+01,
     +   .2582E+00,  .1479E+00,  .2046E-01,  .4368E+00,  .3396E-01,
     +   .1870E+01,
     +   .2654E+00,  .1512E+00,  .2133E-01,  .4456E+00,  .4173E-01,
     +   .2093E+01,
     +   .2734E+00,  .1547E+00,  .2226E-01,  .4566E+00,  .5105E-01,
     +   .2326E+01,
     +   .2804E+00,  .1578E+00,  .2305E-01,  .4670E+00,  .5965E-01,
     +   .2516E+01,
     +   .2878E+00,  .1610E+00,  .2387E-01,  .4789E+00,  .6930E-01,
     +   .2705E+01,
     +   .2942E+00,  .1637E+00,  .2455E-01,  .4895E+00,  .7783E-01,
     +   .2851E+01 /
        DATA ((PARTON(I,N,40),I=1,6),N=9,16)/
     +   .3002E+00,  .1663E+00,  .2516E-01,  .4999E+00,  .8615E-01,
     +   .2978E+01,
     +   .3054E+00,  .1684E+00,  .2568E-01,  .5090E+00,  .9345E-01,
     +   .3077E+01,
     +   .3103E+00,  .1704E+00,  .2616E-01,  .5179E+00,  .1006E+00,
     +   .3164E+01,
     +   .3149E+00,  .1723E+00,  .2658E-01,  .5260E+00,  .1072E+00,
     +   .3234E+01,
     +   .3189E+00,  .1738E+00,  .2694E-01,  .5332E+00,  .1131E+00,
     +   .3289E+01,
     +   .3237E+00,  .1757E+00,  .2735E-01,  .5417E+00,  .1202E+00,
     +   .3346E+01,
     +   .3280E+00,  .1773E+00,  .2771E-01,  .5492E+00,  .1265E+00,
     +   .3388E+01,
     +   .3319E+00,  .1788E+00,  .2802E-01,  .5559E+00,  .1323E+00,
     +   .3419E+01 /
        DATA ((PARTON(I,N,40),I=1,6),N=17,24)/
     +   .3354E+00,  .1801E+00,  .2828E-01,  .5618E+00,  .1374E+00,
     +   .3441E+01,
     +   .3387E+00,  .1813E+00,  .2852E-01,  .5672E+00,  .1423E+00,
     +   .3455E+01,
     +   .3417E+00,  .1823E+00,  .2873E-01,  .5720E+00,  .1468E+00,
     +   .3463E+01,
     +   .3445E+00,  .1833E+00,  .2891E-01,  .5762E+00,  .1508E+00,
     +   .3466E+01,
     +   .3470E+00,  .1841E+00,  .2906E-01,  .5799E+00,  .1544E+00,
     +   .3464E+01,
     +   .3501E+00,  .1852E+00,  .2924E-01,  .5843E+00,  .1591E+00,
     +   .3456E+01,
     +   .3528E+00,  .1860E+00,  .2939E-01,  .5878E+00,  .1629E+00,
     +   .3443E+01,
     +   .3554E+00,  .1868E+00,  .2951E-01,  .5910E+00,  .1666E+00,
     +   .3426E+01 /
        DATA ((PARTON(I,N,40),I=1,6),N=25,27)/
     +   .3578E+00,  .1875E+00,  .2961E-01,  .5936E+00,  .1699E+00,
     +   .3404E+01,
     +   .3599E+00,  .1881E+00,  .2969E-01,  .5956E+00,  .1727E+00,
     +   .3382E+01,
     +   .3618E+00,  .1886E+00,  .2975E-01,  .5973E+00,  .1754E+00,
     +   .3357E+01 /
        DATA ((PARTON(I,N,41),I=1,6),N=1,8)/
     +   .3036E+00,  .1723E+00,  .2861E-01,  .3717E+00,  .2023E-01,
     +   .1255E+01,
     +   .3101E+00,  .1751E+00,  .2930E-01,  .3749E+00,  .2470E-01,
     +   .1402E+01,
     +   .3170E+00,  .1779E+00,  .3000E-01,  .3790E+00,  .2982E-01,
     +   .1551E+01,
     +   .3246E+00,  .1811E+00,  .3073E-01,  .3842E+00,  .3590E-01,
     +   .1706E+01,
     +   .3330E+00,  .1844E+00,  .3148E-01,  .3904E+00,  .4300E-01,
     +   .1863E+01,
     +   .3401E+00,  .1872E+00,  .3207E-01,  .3962E+00,  .4939E-01,
     +   .1984E+01,
     +   .3475E+00,  .1900E+00,  .3264E-01,  .4026E+00,  .5639E-01,
     +   .2099E+01,
     +   .3537E+00,  .1923E+00,  .3307E-01,  .4081E+00,  .6243E-01,
     +   .2183E+01 /
        DATA ((PARTON(I,N,41),I=1,6),N=9,16)/
     +   .3594E+00,  .1944E+00,  .3343E-01,  .4133E+00,  .6819E-01,
     +   .2251E+01,
     +   .3642E+00,  .1960E+00,  .3370E-01,  .4177E+00,  .7315E-01,
     +   .2300E+01,
     +   .3687E+00,  .1976E+00,  .3392E-01,  .4217E+00,  .7792E-01,
     +   .2339E+01,
     +   .3728E+00,  .1989E+00,  .3410E-01,  .4252E+00,  .8225E-01,
     +   .2368E+01,
     +   .3762E+00,  .2000E+00,  .3423E-01,  .4282E+00,  .8600E-01,
     +   .2387E+01,
     +   .3803E+00,  .2012E+00,  .3434E-01,  .4315E+00,  .9046E-01,
     +   .2403E+01,
     +   .3838E+00,  .2022E+00,  .3442E-01,  .4341E+00,  .9434E-01,
     +   .2410E+01,
     +   .3869E+00,  .2030E+00,  .3445E-01,  .4363E+00,  .9783E-01,
     +   .2410E+01 /
        DATA ((PARTON(I,N,41),I=1,6),N=17,24)/
     +   .3896E+00,  .2037E+00,  .3446E-01,  .4380E+00,  .1009E+00,
     +   .2405E+01,
     +   .3921E+00,  .2043E+00,  .3444E-01,  .4393E+00,  .1037E+00,
     +   .2396E+01,
     +   .3942E+00,  .2047E+00,  .3441E-01,  .4403E+00,  .1062E+00,
     +   .2384E+01,
     +   .3962E+00,  .2051E+00,  .3435E-01,  .4410E+00,  .1084E+00,
     +   .2369E+01,
     +   .3978E+00,  .2054E+00,  .3428E-01,  .4414E+00,  .1104E+00,
     +   .2353E+01,
     +   .3999E+00,  .2056E+00,  .3417E-01,  .4416E+00,  .1128E+00,
     +   .2328E+01,
     +   .4015E+00,  .2058E+00,  .3405E-01,  .4414E+00,  .1148E+00,
     +   .2302E+01,
     +   .4030E+00,  .2059E+00,  .3391E-01,  .4410E+00,  .1166E+00,
     +   .2274E+01 /
        DATA ((PARTON(I,N,41),I=1,6),N=25,27)/
     +   .4042E+00,  .2059E+00,  .3376E-01,  .4403E+00,  .1182E+00,
     +   .2244E+01,
     +   .4052E+00,  .2058E+00,  .3360E-01,  .4394E+00,  .1195E+00,
     +   .2215E+01,
     +   .4061E+00,  .2056E+00,  .3344E-01,  .4383E+00,  .1206E+00,
     +   .2185E+01 /
        DATA ((PARTON(I,N,42),I=1,6),N=1,8)/
     +   .3546E+00,  .1977E+00,  .3732E-01,  .3321E+00,  .1897E-01,
     +   .1130E+01,
     +   .3612E+00,  .2002E+00,  .3774E-01,  .3340E+00,  .2280E-01,
     +   .1244E+01,
     +   .3680E+00,  .2028E+00,  .3813E-01,  .3363E+00,  .2710E-01,
     +   .1356E+01,
     +   .3754E+00,  .2055E+00,  .3850E-01,  .3392E+00,  .3210E-01,
     +   .1470E+01,
     +   .3833E+00,  .2082E+00,  .3882E-01,  .3426E+00,  .3781E-01,
     +   .1580E+01,
     +   .3899E+00,  .2104E+00,  .3901E-01,  .3456E+00,  .4283E-01,
     +   .1661E+01,
     +   .3966E+00,  .2125E+00,  .3913E-01,  .3488E+00,  .4822E-01,
     +   .1733E+01,
     +   .4020E+00,  .2141E+00,  .3916E-01,  .3513E+00,  .5278E-01,
     +   .1782E+01 /
        DATA ((PARTON(I,N,42),I=1,6),N=9,16)/
     +   .4069E+00,  .2155E+00,  .3913E-01,  .3535E+00,  .5704E-01,
     +   .1818E+01,
     +   .4109E+00,  .2165E+00,  .3905E-01,  .3551E+00,  .6063E-01,
     +   .1841E+01,
     +   .4145E+00,  .2173E+00,  .3893E-01,  .3565E+00,  .6403E-01,
     +   .1856E+01,
     +   .4176E+00,  .2180E+00,  .3879E-01,  .3575E+00,  .6706E-01,
     +   .1863E+01,
     +   .4202E+00,  .2184E+00,  .3862E-01,  .3581E+00,  .6964E-01,
     +   .1865E+01,
     +   .4231E+00,  .2188E+00,  .3838E-01,  .3586E+00,  .7264E-01,
     +   .1861E+01,
     +   .4255E+00,  .2191E+00,  .3812E-01,  .3587E+00,  .7520E-01,
     +   .1851E+01,
     +   .4274E+00,  .2192E+00,  .3785E-01,  .3585E+00,  .7745E-01,
     +   .1838E+01 /
        DATA ((PARTON(I,N,42),I=1,6),N=17,24)/
     +   .4290E+00,  .2192E+00,  .3758E-01,  .3581E+00,  .7936E-01,
     +   .1822E+01,
     +   .4304E+00,  .2190E+00,  .3729E-01,  .3574E+00,  .8111E-01,
     +   .1803E+01,
     +   .4315E+00,  .2188E+00,  .3700E-01,  .3565E+00,  .8260E-01,
     +   .1783E+01,
     +   .4323E+00,  .2185E+00,  .3670E-01,  .3554E+00,  .8391E-01,
     +   .1762E+01,
     +   .4330E+00,  .2182E+00,  .3642E-01,  .3543E+00,  .8503E-01,
     +   .1741E+01,
     +   .4337E+00,  .2177E+00,  .3602E-01,  .3525E+00,  .8635E-01,
     +   .1710E+01,
     +   .4340E+00,  .2171E+00,  .3564E-01,  .3507E+00,  .8739E-01,
     +   .1681E+01,
     +   .4342E+00,  .2164E+00,  .3526E-01,  .3486E+00,  .8828E-01,
     +   .1651E+01 /
        DATA ((PARTON(I,N,42),I=1,6),N=25,27)/
     +   .4342E+00,  .2157E+00,  .3487E-01,  .3464E+00,  .8902E-01,
     +   .1620E+01,
     +   .4340E+00,  .2150E+00,  .3451E-01,  .3442E+00,  .8959E-01,
     +   .1591E+01,
     +   .4337E+00,  .2142E+00,  .3414E-01,  .3419E+00,  .9005E-01,
     +   .1562E+01 /
        DATA ((PARTON(I,N,43),I=1,6),N=1,8)/
     +   .4152E+00,  .2263E+00,  .4586E-01,  .2909E+00,  .1768E-01,
     +   .1022E+01,
     +   .4211E+00,  .2281E+00,  .4578E-01,  .2914E+00,  .2089E-01,
     +   .1106E+01,
     +   .4272E+00,  .2299E+00,  .4562E-01,  .2921E+00,  .2442E-01,
     +   .1185E+01,
     +   .4336E+00,  .2317E+00,  .4536E-01,  .2929E+00,  .2841E-01,
     +   .1261E+01,
     +   .4402E+00,  .2333E+00,  .4496E-01,  .2938E+00,  .3286E-01,
     +   .1330E+01,
     +   .4453E+00,  .2344E+00,  .4454E-01,  .2944E+00,  .3666E-01,
     +   .1377E+01,
     +   .4503E+00,  .2352E+00,  .4399E-01,  .2947E+00,  .4064E-01,
     +   .1413E+01,
     +   .4541E+00,  .2357E+00,  .4346E-01,  .2948E+00,  .4391E-01,
     +   .1434E+01 /
        DATA ((PARTON(I,N,43),I=1,6),N=9,16)/
     +   .4573E+00,  .2359E+00,  .4288E-01,  .2945E+00,  .4690E-01,
     +   .1444E+01,
     +   .4597E+00,  .2358E+00,  .4234E-01,  .2940E+00,  .4935E-01,
     +   .1447E+01,
     +   .4616E+00,  .2356E+00,  .4177E-01,  .2932E+00,  .5161E-01,
     +   .1443E+01,
     +   .4632E+00,  .2352E+00,  .4121E-01,  .2922E+00,  .5358E-01,
     +   .1435E+01,
     +   .4642E+00,  .2348E+00,  .4068E-01,  .2911E+00,  .5521E-01,
     +   .1425E+01,
     +   .4652E+00,  .2340E+00,  .4001E-01,  .2895E+00,  .5706E-01,
     +   .1407E+01,
     +   .4657E+00,  .2332E+00,  .3936E-01,  .2877E+00,  .5858E-01,
     +   .1387E+01,
     +   .4659E+00,  .2322E+00,  .3874E-01,  .2858E+00,  .5987E-01,
     +   .1365E+01 /
        DATA ((PARTON(I,N,43),I=1,6),N=17,24)/
     +   .4658E+00,  .2313E+00,  .3814E-01,  .2839E+00,  .6092E-01,
     +   .1343E+01,
     +   .4655E+00,  .2302E+00,  .3755E-01,  .2817E+00,  .6184E-01,
     +   .1319E+01,
     +   .4650E+00,  .2291E+00,  .3698E-01,  .2796E+00,  .6259E-01,
     +   .1295E+01,
     +   .4643E+00,  .2280E+00,  .3644E-01,  .2774E+00,  .6322E-01,
     +   .1272E+01,
     +   .4636E+00,  .2268E+00,  .3592E-01,  .2752E+00,  .6371E-01,
     +   .1249E+01,
     +   .4623E+00,  .2253E+00,  .3523E-01,  .2721E+00,  .6426E-01,
     +   .1217E+01,
     +   .4609E+00,  .2238E+00,  .3460E-01,  .2693E+00,  .6463E-01,
     +   .1189E+01,
     +   .4593E+00,  .2222E+00,  .3397E-01,  .2662E+00,  .6490E-01,
     +   .1159E+01 /
        DATA ((PARTON(I,N,43),I=1,6),N=25,27)/
     +   .4576E+00,  .2205E+00,  .3336E-01,  .2632E+00,  .6507E-01,
     +   .1130E+01,
     +   .4559E+00,  .2190E+00,  .3281E-01,  .2603E+00,  .6515E-01,
     +   .1104E+01,
     +   .4540E+00,  .2174E+00,  .3225E-01,  .2573E+00,  .6516E-01,
     +   .1077E+01 /
        DATA ((PARTON(I,N,44),I=1,6),N=1,8)/
     +   .4684E+00,  .2497E+00,  .5054E-01,  .2572E+00,  .1655E-01,
     +   .9493E+00,
     +   .4732E+00,  .2506E+00,  .4993E-01,  .2568E+00,  .1930E-01,
     +   .1010E+01,
     +   .4780E+00,  .2514E+00,  .4921E-01,  .2563E+00,  .2225E-01,
     +   .1065E+01,
     +   .4827E+00,  .2519E+00,  .4834E-01,  .2556E+00,  .2552E-01,
     +   .1114E+01,
     +   .4872E+00,  .2521E+00,  .4728E-01,  .2547E+00,  .2906E-01,
     +   .1155E+01,
     +   .4904E+00,  .2519E+00,  .4629E-01,  .2537E+00,  .3201E-01,
     +   .1178E+01,
     +   .4931E+00,  .2513E+00,  .4516E-01,  .2522E+00,  .3502E-01,
     +   .1192E+01,
     +   .4948E+00,  .2505E+00,  .4413E-01,  .2507E+00,  .3743E-01,
     +   .1194E+01 /
        DATA ((PARTON(I,N,44),I=1,6),N=9,16)/
     +   .4959E+00,  .2494E+00,  .4311E-01,  .2489E+00,  .3957E-01,
     +   .1189E+01,
     +   .4963E+00,  .2483E+00,  .4219E-01,  .2470E+00,  .4128E-01,
     +   .1180E+01,
     +   .4964E+00,  .2469E+00,  .4127E-01,  .2450E+00,  .4281E-01,
     +   .1166E+01,
     +   .4960E+00,  .2455E+00,  .4039E-01,  .2429E+00,  .4411E-01,
     +   .1149E+01,
     +   .4954E+00,  .2441E+00,  .3960E-01,  .2408E+00,  .4515E-01,
     +   .1132E+01,
     +   .4942E+00,  .2422E+00,  .3860E-01,  .2380E+00,  .4629E-01,
     +   .1108E+01,
     +   .4928E+00,  .2403E+00,  .3768E-01,  .2353E+00,  .4718E-01,
     +   .1083E+01,
     +   .4911E+00,  .2383E+00,  .3681E-01,  .2325E+00,  .4790E-01,
     +   .1058E+01 /
        DATA ((PARTON(I,N,44),I=1,6),N=17,24)/
     +   .4893E+00,  .2364E+00,  .3601E-01,  .2298E+00,  .4845E-01,
     +   .1034E+01,
     +   .4872E+00,  .2345E+00,  .3521E-01,  .2269E+00,  .4889E-01,
     +   .1008E+01,
     +   .4851E+00,  .2325E+00,  .3447E-01,  .2242E+00,  .4922E-01,
     +   .9843E+00,
     +   .4828E+00,  .2306E+00,  .3377E-01,  .2215E+00,  .4946E-01,
     +   .9607E+00,
     +   .4806E+00,  .2288E+00,  .3311E-01,  .2189E+00,  .4962E-01,
     +   .9384E+00,
     +   .4774E+00,  .2262E+00,  .3225E-01,  .2153E+00,  .4974E-01,
     +   .9084E+00,
     +   .4743E+00,  .2239E+00,  .3148E-01,  .2120E+00,  .4976E-01,
     +   .8815E+00,
     +   .4710E+00,  .2215E+00,  .3072E-01,  .2087E+00,  .4971E-01,
     +   .8545E+00 /
        DATA ((PARTON(I,N,44),I=1,6),N=25,27)/
     +   .4677E+00,  .2191E+00,  .2999E-01,  .2054E+00,  .4959E-01,
     +   .8284E+00,
     +   .4645E+00,  .2169E+00,  .2933E-01,  .2023E+00,  .4943E-01,
     +   .8051E+00,
     +   .4612E+00,  .2146E+00,  .2868E-01,  .1992E+00,  .4922E-01,
     +   .7818E+00 /
        DATA ((PARTON(I,N,45),I=1,6),N=1,8)/
     +   .5254E+00,  .2724E+00,  .5163E-01,  .2211E+00,  .1524E-01,
     +   .8811E+00,
     +   .5282E+00,  .2720E+00,  .5048E-01,  .2197E+00,  .1752E-01,
     +   .9192E+00,
     +   .5306E+00,  .2713E+00,  .4921E-01,  .2182E+00,  .1991E-01,
     +   .9511E+00,
     +   .5326E+00,  .2701E+00,  .4773E-01,  .2163E+00,  .2249E-01,
     +   .9761E+00,
     +   .5339E+00,  .2684E+00,  .4605E-01,  .2139E+00,  .2519E-01,
     +   .9913E+00,
     +   .5342E+00,  .2664E+00,  .4455E-01,  .2116E+00,  .2737E-01,
     +   .9947E+00,
     +   .5335E+00,  .2639E+00,  .4290E-01,  .2087E+00,  .2952E-01,
     +   .9889E+00,
     +   .5323E+00,  .2614E+00,  .4147E-01,  .2059E+00,  .3118E-01,
     +   .9769E+00 /
        DATA ((PARTON(I,N,45),I=1,6),N=9,16)/
     +   .5304E+00,  .2588E+00,  .4009E-01,  .2030E+00,  .3259E-01,
     +   .9600E+00,
     +   .5283E+00,  .2562E+00,  .3888E-01,  .2003E+00,  .3369E-01,
     +   .9415E+00,
     +   .5257E+00,  .2535E+00,  .3769E-01,  .1974E+00,  .3462E-01,
     +   .9203E+00,
     +   .5229E+00,  .2508E+00,  .3658E-01,  .1945E+00,  .3537E-01,
     +   .8983E+00,
     +   .5201E+00,  .2483E+00,  .3559E-01,  .1918E+00,  .3594E-01,
     +   .8771E+00,
     +   .5162E+00,  .2450E+00,  .3438E-01,  .1884E+00,  .3652E-01,
     +   .8493E+00,
     +   .5123E+00,  .2419E+00,  .3329E-01,  .1850E+00,  .3693E-01,
     +   .8225E+00,
     +   .5082E+00,  .2388E+00,  .3227E-01,  .1818E+00,  .3722E-01,
     +   .7965E+00 /
        DATA ((PARTON(I,N,45),I=1,6),N=17,24)/
     +   .5042E+00,  .2359E+00,  .3134E-01,  .1787E+00,  .3740E-01,
     +   .7720E+00,
     +   .5001E+00,  .2329E+00,  .3044E-01,  .1756E+00,  .3750E-01,
     +   .7474E+00,
     +   .4960E+00,  .2301E+00,  .2961E-01,  .1726E+00,  .3753E-01,
     +   .7245E+00,
     +   .4919E+00,  .2273E+00,  .2882E-01,  .1697E+00,  .3750E-01,
     +   .7025E+00,
     +   .4880E+00,  .2247E+00,  .2810E-01,  .1670E+00,  .3743E-01,
     +   .6821E+00,
     +   .4825E+00,  .2211E+00,  .2716E-01,  .1633E+00,  .3727E-01,
     +   .6551E+00,
     +   .4775E+00,  .2179E+00,  .2634E-01,  .1600E+00,  .3707E-01,
     +   .6314E+00,
     +   .4723E+00,  .2147E+00,  .2554E-01,  .1567E+00,  .3682E-01,
     +   .6080E+00 /
        DATA ((PARTON(I,N,45),I=1,6),N=25,27)/
     +   .4671E+00,  .2115E+00,  .2477E-01,  .1534E+00,  .3653E-01,
     +   .5857E+00,
     +   .4624E+00,  .2086E+00,  .2410E-01,  .1505E+00,  .3623E-01,
     +   .5660E+00,
     +   .4575E+00,  .2057E+00,  .2343E-01,  .1475E+00,  .3590E-01,
     +   .5466E+00 /
        DATA ((PARTON(I,N,46),I=1,6),N=1,8)/
     +   .5721E+00,  .2885E+00,  .4885E-01,  .1892E+00,  .1396E-01,
     +   .8248E+00,
     +   .5724E+00,  .2866E+00,  .4735E-01,  .1872E+00,  .1586E-01,
     +   .8455E+00,
     +   .5722E+00,  .2843E+00,  .4573E-01,  .1850E+00,  .1781E-01,
     +   .8596E+00,
     +   .5710E+00,  .2814E+00,  .4390E-01,  .1824E+00,  .1985E-01,
     +   .8663E+00,
     +   .5686E+00,  .2776E+00,  .4186E-01,  .1791E+00,  .2192E-01,
     +   .8633E+00,
     +   .5656E+00,  .2739E+00,  .4009E-01,  .1760E+00,  .2354E-01,
     +   .8528E+00,
     +   .5614E+00,  .2696E+00,  .3819E-01,  .1724E+00,  .2507E-01,
     +   .8342E+00,
     +   .5570E+00,  .2655E+00,  .3657E-01,  .1690E+00,  .2620E-01,
     +   .8132E+00 /
        DATA ((PARTON(I,N,46),I=1,6),N=9,16)/
     +   .5521E+00,  .2613E+00,  .3504E-01,  .1656E+00,  .2713E-01,
     +   .7892E+00,
     +   .5473E+00,  .2575E+00,  .3371E-01,  .1624E+00,  .2780E-01,
     +   .7658E+00,
     +   .5421E+00,  .2535E+00,  .3243E-01,  .1592E+00,  .2834E-01,
     +   .7411E+00,
     +   .5369E+00,  .2497E+00,  .3125E-01,  .1560E+00,  .2874E-01,
     +   .7167E+00,
     +   .5319E+00,  .2462E+00,  .3022E-01,  .1531E+00,  .2902E-01,
     +   .6941E+00,
     +   .5254E+00,  .2417E+00,  .2896E-01,  .1495E+00,  .2925E-01,
     +   .6655E+00,
     +   .5191E+00,  .2375E+00,  .2784E-01,  .1460E+00,  .2937E-01,
     +   .6389E+00,
     +   .5128E+00,  .2334E+00,  .2681E-01,  .1427E+00,  .2941E-01,
     +   .6137E+00 /
        DATA ((PARTON(I,N,46),I=1,6),N=17,24)/
     +   .5069E+00,  .2296E+00,  .2588E-01,  .1396E+00,  .2937E-01,
     +   .5905E+00,
     +   .5008E+00,  .2258E+00,  .2498E-01,  .1365E+00,  .2928E-01,
     +   .5677E+00,
     +   .4949E+00,  .2223E+00,  .2417E-01,  .1336E+00,  .2915E-01,
     +   .5467E+00,
     +   .4892E+00,  .2188E+00,  .2340E-01,  .1308E+00,  .2898E-01,
     +   .5270E+00,
     +   .4838E+00,  .2156E+00,  .2271E-01,  .1282E+00,  .2879E-01,
     +   .5089E+00,
     +   .4764E+00,  .2113E+00,  .2181E-01,  .1247E+00,  .2850E-01,
     +   .4852E+00,
     +   .4697E+00,  .2074E+00,  .2103E-01,  .1217E+00,  .2820E-01,
     +   .4647E+00,
     +   .4629E+00,  .2035E+00,  .2027E-01,  .1186E+00,  .2786E-01,
     +   .4448E+00 /
        DATA ((PARTON(I,N,46),I=1,6),N=25,27)/
     +   .4562E+00,  .1998E+00,  .1955E-01,  .1156E+00,  .2751E-01,
     +   .4260E+00,
     +   .4501E+00,  .1964E+00,  .1893E-01,  .1129E+00,  .2716E-01,
     +   .4096E+00,
     +   .4439E+00,  .1930E+00,  .1831E-01,  .1103E+00,  .2680E-01,
     +   .3936E+00 /
        DATA ((PARTON(I,N,47),I=1,6),N=1,8)/
     +   .6088E+00,  .2984E+00,  .4369E-01,  .1605E+00,  .1271E-01,
     +   .7733E+00,
     +   .6065E+00,  .2951E+00,  .4203E-01,  .1582E+00,  .1429E-01,
     +   .7801E+00,
     +   .6032E+00,  .2913E+00,  .4026E-01,  .1556E+00,  .1587E-01,
     +   .7804E+00,
     +   .5986E+00,  .2866E+00,  .3831E-01,  .1526E+00,  .1749E-01,
     +   .7733E+00,
     +   .5924E+00,  .2809E+00,  .3616E-01,  .1489E+00,  .1907E-01,
     +   .7571E+00,
     +   .5860E+00,  .2755E+00,  .3432E-01,  .1455E+00,  .2026E-01,
     +   .7369E+00,
     +   .5782E+00,  .2694E+00,  .3239E-01,  .1416E+00,  .2134E-01,
     +   .7099E+00,
     +   .5706E+00,  .2639E+00,  .3076E-01,  .1380E+00,  .2209E-01,
     +   .6833E+00 /
        DATA ((PARTON(I,N,47),I=1,6),N=9,16)/
     +   .5628E+00,  .2584E+00,  .2924E-01,  .1344E+00,  .2267E-01,
     +   .6554E+00,
     +   .5554E+00,  .2534E+00,  .2794E-01,  .1312E+00,  .2305E-01,
     +   .6297E+00,
     +   .5478E+00,  .2484E+00,  .2669E-01,  .1279E+00,  .2333E-01,
     +   .6035E+00,
     +   .5403E+00,  .2436E+00,  .2556E-01,  .1247E+00,  .2350E-01,
     +   .5786E+00,
     +   .5333E+00,  .2392E+00,  .2458E-01,  .1219E+00,  .2358E-01,
     +   .5561E+00,
     +   .5244E+00,  .2338E+00,  .2340E-01,  .1183E+00,  .2360E-01,
     +   .5282E+00,
     +   .5159E+00,  .2287E+00,  .2235E-01,  .1150E+00,  .2355E-01,
     +   .5030E+00,
     +   .5077E+00,  .2239E+00,  .2139E-01,  .1119E+00,  .2343E-01,
     +   .4794E+00 /
        DATA ((PARTON(I,N,47),I=1,6),N=17,24)/
     +   .5000E+00,  .2194E+00,  .2054E-01,  .1090E+00,  .2328E-01,
     +   .4582E+00,
     +   .4922E+00,  .2150E+00,  .1972E-01,  .1061E+00,  .2308E-01,
     +   .4376E+00,
     +   .4849E+00,  .2108E+00,  .1898E-01,  .1034E+00,  .2287E-01,
     +   .4189E+00,
     +   .4777E+00,  .2069E+00,  .1830E-01,  .1009E+00,  .2264E-01,
     +   .4015E+00,
     +   .4711E+00,  .2032E+00,  .1768E-01,  .9853E-01,  .2239E-01,
     +   .3857E+00,
     +   .4620E+00,  .1983E+00,  .1688E-01,  .9541E-01,  .2204E-01,
     +   .3653E+00,
     +   .4540E+00,  .1940E+00,  .1619E-01,  .9266E-01,  .2171E-01,
     +   .3479E+00,
     +   .4458E+00,  .1897E+00,  .1553E-01,  .8994E-01,  .2134E-01,
     +   .3311E+00 /
        DATA ((PARTON(I,N,47),I=1,6),N=25,27)/
     +   .4379E+00,  .1855E+00,  .1490E-01,  .8733E-01,  .2098E-01,
     +   .3154E+00,
     +   .4307E+00,  .1818E+00,  .1436E-01,  .8501E-01,  .2063E-01,
     +   .3019E+00,
     +   .4235E+00,  .1781E+00,  .1384E-01,  .8271E-01,  .2028E-01,
     +   .2887E+00 /
        DATA ((PARTON(I,N,48),I=1,6),N=1,8)/
     +   .6360E+00,  .3029E+00,  .3738E-01,  .1346E+00,  .1149E-01,
     +   .7235E+00,
     +   .6308E+00,  .2982E+00,  .3572E-01,  .1323E+00,  .1280E-01,
     +   .7190E+00,
     +   .6244E+00,  .2928E+00,  .3398E-01,  .1296E+00,  .1407E-01,
     +   .7087E+00,
     +   .6164E+00,  .2865E+00,  .3206E-01,  .1265E+00,  .1534E-01,
     +   .6911E+00,
     +   .6063E+00,  .2790E+00,  .3000E-01,  .1227E+00,  .1654E-01,
     +   .6654E+00,
     +   .5966E+00,  .2722E+00,  .2825E-01,  .1193E+00,  .1740E-01,
     +   .6387E+00,
     +   .5852E+00,  .2646E+00,  .2643E-01,  .1153E+00,  .1814E-01,
     +   .6065E+00,
     +   .5747E+00,  .2578E+00,  .2491E-01,  .1118E+00,  .1862E-01,
     +   .5768E+00 /
        DATA ((PARTON(I,N,48),I=1,6),N=9,16)/
     +   .5641E+00,  .2512E+00,  .2351E-01,  .1083E+00,  .1894E-01,
     +   .5471E+00,
     +   .5543E+00,  .2452E+00,  .2233E-01,  .1052E+00,  .1913E-01,
     +   .5206E+00,
     +   .5444E+00,  .2393E+00,  .2120E-01,  .1021E+00,  .1923E-01,
     +   .4944E+00,
     +   .5349E+00,  .2337E+00,  .2019E-01,  .9916E-01,  .1925E-01,
     +   .4701E+00,
     +   .5261E+00,  .2287E+00,  .1931E-01,  .9650E-01,  .1922E-01,
     +   .4485E+00,
     +   .5151E+00,  .2225E+00,  .1827E-01,  .9320E-01,  .1910E-01,
     +   .4223E+00,
     +   .5048E+00,  .2168E+00,  .1735E-01,  .9018E-01,  .1894E-01,
     +   .3990E+00,
     +   .4949E+00,  .2114E+00,  .1652E-01,  .8734E-01,  .1875E-01,
     +   .3776E+00 /
        DATA ((PARTON(I,N,48),I=1,6),N=17,24)/
     +   .4857E+00,  .2064E+00,  .1578E-01,  .8473E-01,  .1853E-01,
     +   .3585E+00,
     +   .4765E+00,  .2015E+00,  .1508E-01,  .8217E-01,  .1829E-01,
     +   .3403E+00,
     +   .4679E+00,  .1970E+00,  .1445E-01,  .7981E-01,  .1803E-01,
     +   .3239E+00,
     +   .4597E+00,  .1927E+00,  .1387E-01,  .7757E-01,  .1777E-01,
     +   .3088E+00,
     +   .4520E+00,  .1887E+00,  .1334E-01,  .7551E-01,  .1752E-01,
     +   .2952E+00,
     +   .4417E+00,  .1835E+00,  .1267E-01,  .7280E-01,  .1715E-01,
     +   .2779E+00,
     +   .4325E+00,  .1789E+00,  .1210E-01,  .7043E-01,  .1682E-01,
     +   .2632E+00,
     +   .4234E+00,  .1743E+00,  .1155E-01,  .6810E-01,  .1646E-01,
     +   .2492E+00 /
        DATA ((PARTON(I,N,48),I=1,6),N=25,27)/
     +   .4145E+00,  .1699E+00,  .1104E-01,  .6588E-01,  .1611E-01,
     +   .2362E+00,
     +   .4066E+00,  .1660E+00,  .1060E-01,  .6393E-01,  .1579E-01,
     +   .2251E+00,
     +   .3986E+00,  .1621E+00,  .1017E-01,  .6199E-01,  .1546E-01,
     +   .2143E+00 /
        DATA ((PARTON(I,N,49),I=1,6),N=1,8)/
     +   .6540E+00,  .3024E+00,  .3083E-01,  .1117E+00,  .1030E-01,
     +   .6739E+00,
     +   .6459E+00,  .2963E+00,  .2928E-01,  .1094E+00,  .1137E-01,
     +   .6605E+00,
     +   .6365E+00,  .2896E+00,  .2767E-01,  .1068E+00,  .1240E-01,
     +   .6419E+00,
     +   .6250E+00,  .2819E+00,  .2592E-01,  .1037E+00,  .1338E-01,
     +   .6167E+00,
     +   .6113E+00,  .2729E+00,  .2405E-01,  .1001E+00,  .1428E-01,
     +   .5845E+00,
     +   .5984E+00,  .2648E+00,  .2248E-01,  .9681E-01,  .1489E-01,
     +   .5536E+00,
     +   .5838E+00,  .2559E+00,  .2087E-01,  .9311E-01,  .1537E-01,
     +   .5185E+00,
     +   .5706E+00,  .2481E+00,  .1954E-01,  .8983E-01,  .1565E-01,
     +   .4875E+00 /
        DATA ((PARTON(I,N,49),I=1,6),N=9,16)/
     +   .5574E+00,  .2406E+00,  .1832E-01,  .8661E-01,  .1580E-01,
     +   .4574E+00,
     +   .5456E+00,  .2339E+00,  .1730E-01,  .8375E-01,  .1585E-01,
     +   .4314E+00,
     +   .5337E+00,  .2273E+00,  .1634E-01,  .8091E-01,  .1584E-01,
     +   .4061E+00,
     +   .5223E+00,  .2211E+00,  .1547E-01,  .7825E-01,  .1576E-01,
     +   .3830E+00,
     +   .5121E+00,  .2156E+00,  .1473E-01,  .7588E-01,  .1565E-01,
     +   .3629E+00,
     +   .4992E+00,  .2088E+00,  .1386E-01,  .7294E-01,  .1546E-01,
     +   .3389E+00,
     +   .4874E+00,  .2027E+00,  .1309E-01,  .7028E-01,  .1525E-01,
     +   .3178E+00,
     +   .4761E+00,  .1969E+00,  .1240E-01,  .6779E-01,  .1501E-01,
     +   .2987E+00 /
        DATA ((PARTON(I,N,49),I=1,6),N=17,24)/
     +   .4658E+00,  .1916E+00,  .1179E-01,  .6552E-01,  .1477E-01,
     +   .2819E+00,
     +   .4555E+00,  .1864E+00,  .1122E-01,  .6330E-01,  .1450E-01,
     +   .2659E+00,
     +   .4459E+00,  .1817E+00,  .1071E-01,  .6127E-01,  .1424E-01,
     +   .2518E+00,
     +   .4368E+00,  .1772E+00,  .1023E-01,  .5936E-01,  .1398E-01,
     +   .2388E+00,
     +   .4283E+00,  .1731E+00,  .9811E-02,  .5761E-01,  .1373E-01,
     +   .2273E+00,
     +   .4170E+00,  .1676E+00,  .9272E-02,  .5532E-01,  .1338E-01,
     +   .2126E+00,
     +   .4071E+00,  .1628E+00,  .8815E-02,  .5333E-01,  .1306E-01,
     +   .2004E+00,
     +   .3972E+00,  .1582E+00,  .8378E-02,  .5138E-01,  .1274E-01,
     +   .1887E+00 /
        DATA ((PARTON(I,N,49),I=1,6),N=25,27)/
     +   .3877E+00,  .1537E+00,  .7973E-02,  .4953E-01,  .1241E-01,
     +   .1781E+00,
     +   .3793E+00,  .1497E+00,  .7626E-02,  .4791E-01,  .1212E-01,
     +   .1690E+00,
     +   .3708E+00,  .1458E+00,  .7288E-02,  .4632E-01,  .1183E-01,
     +   .1603E+00 /
        DATA ((PARTON(I,N,50),I=1,6),N=1,8)/
     +   .6633E+00,  .2975E+00,  .2463E-01,  .9150E-01,  .9151E-02,
     +   .6239E+00,
     +   .6525E+00,  .2903E+00,  .2326E-01,  .8937E-01,  .1003E-01,
     +   .6038E+00,
     +   .6401E+00,  .2825E+00,  .2185E-01,  .8697E-01,  .1084E-01,
     +   .5791E+00,
     +   .6255E+00,  .2735E+00,  .2033E-01,  .8413E-01,  .1160E-01,
     +   .5485E+00,
     +   .6083E+00,  .2632E+00,  .1872E-01,  .8082E-01,  .1225E-01,
     +   .5120E+00,
     +   .5926E+00,  .2542E+00,  .1738E-01,  .7781E-01,  .1267E-01,
     +   .4789E+00,
     +   .5750E+00,  .2442E+00,  .1601E-01,  .7445E-01,  .1296E-01,
     +   .4426E+00,
     +   .5594E+00,  .2357E+00,  .1490E-01,  .7150E-01,  .1310E-01,
     +   .4116E+00 /
        DATA ((PARTON(I,N,50),I=1,6),N=9,16)/
     +   .5440E+00,  .2274E+00,  .1389E-01,  .6862E-01,  .1313E-01,
     +   .3823E+00,
     +   .5304E+00,  .2202E+00,  .1304E-01,  .6609E-01,  .1309E-01,
     +   .3573E+00,
     +   .5168E+00,  .2131E+00,  .1225E-01,  .6360E-01,  .1300E-01,
     +   .3336E+00,
     +   .5040E+00,  .2066E+00,  .1155E-01,  .6127E-01,  .1287E-01,
     +   .3122E+00,
     +   .4925E+00,  .2007E+00,  .1095E-01,  .5920E-01,  .1272E-01,
     +   .2939E+00,
     +   .4782E+00,  .1936E+00,  .1024E-01,  .5667E-01,  .1249E-01,
     +   .2722E+00,
     +   .4651E+00,  .1872E+00,  .9626E-02,  .5438E-01,  .1225E-01,
     +   .2534E+00,
     +   .4528E+00,  .1812E+00,  .9077E-02,  .5225E-01,  .1200E-01,
     +   .2366E+00 /
        DATA ((PARTON(I,N,50),I=1,6),N=17,24)/
     +   .4415E+00,  .1758E+00,  .8596E-02,  .5033E-01,  .1175E-01,
     +   .2220E+00,
     +   .4304E+00,  .1705E+00,  .8142E-02,  .4846E-01,  .1150E-01,
     +   .2082E+00,
     +   .4202E+00,  .1656E+00,  .7739E-02,  .4676E-01,  .1124E-01,
     +   .1961E+00,
     +   .4104E+00,  .1610E+00,  .7370E-02,  .4516E-01,  .1100E-01,
     +   .1851E+00,
     +   .4014E+00,  .1569E+00,  .7041E-02,  .4370E-01,  .1076E-01,
     +   .1754E+00,
     +   .3895E+00,  .1514E+00,  .6624E-02,  .4180E-01,  .1044E-01,
     +   .1632E+00,
     +   .3791E+00,  .1466E+00,  .6272E-02,  .4016E-01,  .1015E-01,
     +   .1530E+00,
     +   .3687E+00,  .1419E+00,  .5937E-02,  .3857E-01,  .9857E-02,
     +   .1435E+00 /
        DATA ((PARTON(I,N,50),I=1,6),N=25,27)/
     +   .3588E+00,  .1375E+00,  .5628E-02,  .3706E-01,  .9572E-02,
     +   .1348E+00,
     +   .3501E+00,  .1336E+00,  .5364E-02,  .3575E-01,  .9316E-02,
     +   .1274E+00,
     +   .3414E+00,  .1297E+00,  .5109E-02,  .3445E-01,  .9058E-02,
     +   .1204E+00 /
        DATA ((PARTON(I,N,51),I=1,6),N=1,8)/
     +   .6646E+00,  .2889E+00,  .1912E-01,  .7405E-01,  .8063E-02,
     +   .5737E+00,
     +   .6512E+00,  .2808E+00,  .1796E-01,  .7216E-01,  .8774E-02,
     +   .5485E+00,
     +   .6361E+00,  .2720E+00,  .1677E-01,  .7002E-01,  .9413E-02,
     +   .5196E+00,
     +   .6185E+00,  .2620E+00,  .1551E-01,  .6750E-01,  .9984E-02,
     +   .4856E+00,
     +   .5983E+00,  .2508E+00,  .1417E-01,  .6456E-01,  .1045E-01,
     +   .4468E+00,
     +   .5800E+00,  .2409E+00,  .1308E-01,  .6190E-01,  .1071E-01,
     +   .4128E+00,
     +   .5599E+00,  .2303E+00,  .1197E-01,  .5895E-01,  .1087E-01,
     +   .3768E+00,
     +   .5422E+00,  .2211E+00,  .1107E-01,  .5638E-01,  .1090E-01,
     +   .3466E+00 /
        DATA ((PARTON(I,N,51),I=1,6),N=9,16)/
     +   .5250E+00,  .2124E+00,  .1026E-01,  .5388E-01,  .1086E-01,
     +   .3188E+00,
     +   .5099E+00,  .2049E+00,  .9586E-02,  .5170E-01,  .1077E-01,
     +   .2954E+00,
     +   .4950E+00,  .1975E+00,  .8961E-02,  .4956E-01,  .1063E-01,
     +   .2736E+00,
     +   .4810E+00,  .1907E+00,  .8407E-02,  .4757E-01,  .1046E-01,
     +   .2542E+00,
     +   .4685E+00,  .1848E+00,  .7936E-02,  .4582E-01,  .1029E-01,
     +   .2377E+00,
     +   .4532E+00,  .1775E+00,  .7386E-02,  .4368E-01,  .1005E-01,
     +   .2184E+00,
     +   .4392E+00,  .1709E+00,  .6911E-02,  .4176E-01,  .9812E-02,
     +   .2019E+00,
     +   .4262E+00,  .1649E+00,  .6488E-02,  .3998E-01,  .9567E-02,
     +   .1874E+00 /
        DATA ((PARTON(I,N,51),I=1,6),N=17,24)/
     +   .4143E+00,  .1594E+00,  .6119E-02,  .3838E-01,  .9330E-02,
     +   .1748E+00,
     +   .4026E+00,  .1541E+00,  .5773E-02,  .3684E-01,  .9086E-02,
     +   .1631E+00,
     +   .3919E+00,  .1493E+00,  .5467E-02,  .3543E-01,  .8854E-02,
     +   .1528E+00,
     +   .3817E+00,  .1448E+00,  .5188E-02,  .3412E-01,  .8627E-02,
     +   .1436E+00,
     +   .3724E+00,  .1407E+00,  .4940E-02,  .3293E-01,  .8414E-02,
     +   .1355E+00,
     +   .3602E+00,  .1353E+00,  .4627E-02,  .3139E-01,  .8128E-02,
     +   .1254E+00,
     +   .3495E+00,  .1306E+00,  .4365E-02,  .3007E-01,  .7872E-02,
     +   .1170E+00,
     +   .3390E+00,  .1261E+00,  .4116E-02,  .2878E-01,  .7616E-02,
     +   .1092E+00 /
        DATA ((PARTON(I,N,51),I=1,6),N=25,27)/
     +   .3289E+00,  .1218E+00,  .3887E-02,  .2757E-01,  .7369E-02,
     +   .1021E+00,
     +   .3201E+00,  .1180E+00,  .3692E-02,  .2652E-01,  .7149E-02,
     +   .9620E-01,
     +   .3113E+00,  .1143E+00,  .3505E-02,  .2549E-01,  .6929E-02,
     +   .9056E-01 /
        DATA ((PARTON(I,N,52),I=1,6),N=1,8)/
     +   .6586E+00,  .2771E+00,  .1444E-01,  .5920E-01,  .7042E-02,
     +   .5236E+00,
     +   .6427E+00,  .2683E+00,  .1350E-01,  .5757E-01,  .7609E-02,
     +   .4949E+00,
     +   .6252E+00,  .2587E+00,  .1254E-01,  .5573E-01,  .8104E-02,
     +   .4633E+00,
     +   .6051E+00,  .2480E+00,  .1153E-01,  .5356E-01,  .8527E-02,
     +   .4274E+00,
     +   .5821E+00,  .2361E+00,  .1046E-01,  .5102E-01,  .8844E-02,
     +   .3879E+00,
     +   .5618E+00,  .2257E+00,  .9599E-02,  .4874E-01,  .9000E-02,
     +   .3542E+00,
     +   .5395E+00,  .2146E+00,  .8726E-02,  .4622E-01,  .9057E-02,
     +   .3193E+00,
     +   .5202E+00,  .2052E+00,  .8027E-02,  .4403E-01,  .9023E-02,
     +   .2908E+00 /
        DATA ((PARTON(I,N,52),I=1,6),N=9,16)/
     +   .5015E+00,  .1962E+00,  .7396E-02,  .4191E-01,  .8928E-02,
     +   .2648E+00,
     +   .4853E+00,  .1885E+00,  .6878E-02,  .4007E-01,  .8801E-02,
     +   .2434E+00,
     +   .4693E+00,  .1811E+00,  .6399E-02,  .3827E-01,  .8642E-02,
     +   .2236E+00,
     +   .4545E+00,  .1742E+00,  .5977E-02,  .3662E-01,  .8466E-02,
     +   .2063E+00,
     +   .4414E+00,  .1682E+00,  .5620E-02,  .3516E-01,  .8291E-02,
     +   .1917E+00,
     +   .4253E+00,  .1610E+00,  .5205E-02,  .3339E-01,  .8054E-02,
     +   .1748E+00,
     +   .4107E+00,  .1545E+00,  .4849E-02,  .3181E-01,  .7822E-02,
     +   .1606E+00,
     +   .3972E+00,  .1485E+00,  .4533E-02,  .3035E-01,  .7592E-02,
     +   .1481E+00 /
        DATA ((PARTON(I,N,52),I=1,6),N=17,24)/
     +   .3850E+00,  .1431E+00,  .4259E-02,  .2905E-01,  .7374E-02,
     +   .1373E+00,
     +   .3730E+00,  .1379E+00,  .4002E-02,  .2779E-01,  .7153E-02,
     +   .1275E+00,
     +   .3620E+00,  .1332E+00,  .3776E-02,  .2666E-01,  .6944E-02,
     +   .1189E+00,
     +   .3517E+00,  .1288E+00,  .3572E-02,  .2560E-01,  .6743E-02,
     +   .1112E+00,
     +   .3423E+00,  .1248E+00,  .3391E-02,  .2465E-01,  .6556E-02,
     +   .1045E+00,
     +   .3300E+00,  .1197E+00,  .3163E-02,  .2341E-01,  .6306E-02,
     +   .9621E-01,
     +   .3193E+00,  .1152E+00,  .2972E-02,  .2236E-01,  .6085E-02,
     +   .8940E-01,
     +   .3087E+00,  .1108E+00,  .2792E-02,  .2133E-01,  .5866E-02,
     +   .8307E-01 /
        DATA ((PARTON(I,N,52),I=1,6),N=25,27)/
     +   .2988E+00,  .1068E+00,  .2628E-02,  .2038E-01,  .5656E-02,
     +   .7738E-01,
     +   .2900E+00,  .1032E+00,  .2488E-02,  .1955E-01,  .5470E-02,
     +   .7263E-01,
     +   .2813E+00,  .9967E-01,  .2354E-02,  .1874E-01,  .5286E-02,
     +   .6814E-01 /
        DATA ((PARTON(I,N,53),I=1,6),N=1,8)/
     +   .6458E+00,  .2628E+00,  .1064E-01,  .4676E-01,  .6093E-02,
     +   .4740E+00,
     +   .6278E+00,  .2534E+00,  .9898E-02,  .4540E-01,  .6541E-02,
     +   .4432E+00,
     +   .6082E+00,  .2434E+00,  .9147E-02,  .4386E-01,  .6918E-02,
     +   .4102E+00,
     +   .5859E+00,  .2322E+00,  .8356E-02,  .4203E-01,  .7222E-02,
     +   .3738E+00,
     +   .5608E+00,  .2198E+00,  .7537E-02,  .3990E-01,  .7427E-02,
     +   .3347E+00,
     +   .5387E+00,  .2092E+00,  .6874E-02,  .3798E-01,  .7503E-02,
     +   .3022E+00,
     +   .5147E+00,  .1979E+00,  .6210E-02,  .3588E-01,  .7492E-02,
     +   .2692E+00,
     +   .4942E+00,  .1883E+00,  .5681E-02,  .3405E-01,  .7415E-02,
     +   .2427E+00 /
        DATA ((PARTON(I,N,53),I=1,6),N=9,16)/
     +   .4745E+00,  .1793E+00,  .5207E-02,  .3229E-01,  .7291E-02,
     +   .2189E+00,
     +   .4574E+00,  .1716E+00,  .4821E-02,  .3077E-01,  .7148E-02,
     +   .1997E+00,
     +   .4408E+00,  .1642E+00,  .4465E-02,  .2930E-01,  .6982E-02,
     +   .1820E+00,
     +   .4254E+00,  .1575E+00,  .4152E-02,  .2794E-01,  .6807E-02,
     +   .1667E+00,
     +   .4118E+00,  .1516E+00,  .3890E-02,  .2674E-01,  .6638E-02,
     +   .1540E+00,
     +   .3953E+00,  .1445E+00,  .3585E-02,  .2531E-01,  .6415E-02,
     +   .1394E+00,
     +   .3805E+00,  .1381E+00,  .3326E-02,  .2403E-01,  .6201E-02,
     +   .1272E+00,
     +   .3668E+00,  .1324E+00,  .3096E-02,  .2285E-01,  .5992E-02,
     +   .1166E+00 /
        DATA ((PARTON(I,N,53),I=1,6),N=17,24)/
     +   .3544E+00,  .1272E+00,  .2898E-02,  .2181E-01,  .5797E-02,
     +   .1076E+00,
     +   .3424E+00,  .1222E+00,  .2714E-02,  .2080E-01,  .5601E-02,
     +   .9932E-01,
     +   .3314E+00,  .1177E+00,  .2552E-02,  .1990E-01,  .5419E-02,
     +   .9221E-01,
     +   .3212E+00,  .1135E+00,  .2406E-02,  .1906E-01,  .5244E-02,
     +   .8589E-01,
     +   .3118E+00,  .1097E+00,  .2277E-02,  .1830E-01,  .5083E-02,
     +   .8040E-01,
     +   .2996E+00,  .1048E+00,  .2115E-02,  .1733E-01,  .4869E-02,
     +   .7364E-01,
     +   .2890E+00,  .1006E+00,  .1981E-02,  .1650E-01,  .4682E-02,
     +   .6814E-01,
     +   .2787E+00,  .9652E-01,  .1854E-02,  .1570E-01,  .4497E-02,
     +   .6305E-01 /
        DATA ((PARTON(I,N,53),I=1,6),N=25,27)/
     +   .2690E+00,  .9269E-01,  .1739E-02,  .1496E-01,  .4322E-02,
     +   .5851E-01,
     +   .2604E+00,  .8936E-01,  .1642E-02,  .1431E-01,  .4167E-02,
     +   .5473E-01,
     +   .2520E+00,  .8610E-01,  .1548E-02,  .1369E-01,  .4015E-02,
     +   .5118E-01 /
        DATA ((PARTON(I,N,54),I=1,6),N=1,8)/
     +   .6270E+00,  .2465E+00,  .7640E-02,  .3649E-01,  .5223E-02,
     +   .4255E+00,
     +   .6073E+00,  .2368E+00,  .7077E-02,  .3539E-01,  .5571E-02,
     +   .3937E+00,
     +   .5860E+00,  .2265E+00,  .6508E-02,  .3413E-01,  .5852E-02,
     +   .3604E+00,
     +   .5619E+00,  .2150E+00,  .5912E-02,  .3263E-01,  .6064E-02,
     +   .3245E+00,
     +   .5350E+00,  .2025E+00,  .5299E-02,  .3088E-01,  .6185E-02,
     +   .2868E+00,
     +   .5116E+00,  .1918E+00,  .4805E-02,  .2930E-01,  .6204E-02,
     +   .2561E+00,
     +   .4865E+00,  .1805E+00,  .4315E-02,  .2757E-01,  .6148E-02,
     +   .2255E+00,
     +   .4650E+00,  .1710E+00,  .3927E-02,  .2608E-01,  .6046E-02,
     +   .2013E+00 /
        DATA ((PARTON(I,N,54),I=1,6),N=9,16)/
     +   .4447E+00,  .1622E+00,  .3581E-02,  .2465E-01,  .5908E-02,
     +   .1800E+00,
     +   .4271E+00,  .1546E+00,  .3301E-02,  .2341E-01,  .5763E-02,
     +   .1628E+00,
     +   .4101E+00,  .1474E+00,  .3043E-02,  .2222E-01,  .5600E-02,
     +   .1474E+00,
     +   .3945E+00,  .1409E+00,  .2819E-02,  .2112E-01,  .5434E-02,
     +   .1340E+00,
     +   .3808E+00,  .1352E+00,  .2631E-02,  .2017E-01,  .5277E-02,
     +   .1230E+00,
     +   .3642E+00,  .1283E+00,  .2414E-02,  .1902E-01,  .5074E-02,
     +   .1106E+00,
     +   .3493E+00,  .1223E+00,  .2230E-02,  .1800E-01,  .4882E-02,
     +   .1003E+00,
     +   .3357E+00,  .1168E+00,  .2068E-02,  .1706E-01,  .4698E-02,
     +   .9138E-01 /
        DATA ((PARTON(I,N,54),I=1,6),N=17,24)/
     +   .3234E+00,  .1119E+00,  .1929E-02,  .1624E-01,  .4528E-02,
     +   .8388E-01,
     +   .3115E+00,  .1072E+00,  .1799E-02,  .1545E-01,  .4358E-02,
     +   .7706E-01,
     +   .3007E+00,  .1030E+00,  .1686E-02,  .1474E-01,  .4202E-02,
     +   .7122E-01,
     +   .2907E+00,  .9903E-01,  .1585E-02,  .1408E-01,  .4053E-02,
     +   .6606E-01,
     +   .2815E+00,  .9548E-01,  .1496E-02,  .1349E-01,  .3916E-02,
     +   .6161E-01,
     +   .2697E+00,  .9092E-01,  .1384E-02,  .1273E-01,  .3737E-02,
     +   .5616E-01,
     +   .2594E+00,  .8701E-01,  .1291E-02,  .1209E-01,  .3581E-02,
     +   .5175E-01,
     +   .2494E+00,  .8324E-01,  .1205E-02,  .1147E-01,  .3428E-02,
     +   .4769E-01 /
        DATA ((PARTON(I,N,54),I=1,6),N=25,27)/
     +   .2401E+00,  .7971E-01,  .1126E-02,  .1090E-01,  .3283E-02,
     +   .4409E-01,
     +   .2319E+00,  .7665E-01,  .1060E-02,  .1040E-01,  .3157E-02,
     +   .4111E-01,
     +   .2238E+00,  .7367E-01,  .9967E-03,  .9924E-02,  .3032E-02,
     +   .3832E-01 /
        DATA ((PARTON(I,N,55),I=1,6),N=1,8)/
     +   .6031E+00,  .2287E+00,  .5352E-02,  .2814E-01,  .4432E-02,
     +   .3785E+00,
     +   .5820E+00,  .2189E+00,  .4935E-02,  .2727E-01,  .4699E-02,
     +   .3467E+00,
     +   .5593E+00,  .2085E+00,  .4517E-02,  .2627E-01,  .4904E-02,
     +   .3141E+00,
     +   .5339E+00,  .1970E+00,  .4081E-02,  .2506E-01,  .5044E-02,
     +   .2796E+00,
     +   .5058E+00,  .1846E+00,  .3635E-02,  .2365E-01,  .5104E-02,
     +   .2440E+00,
     +   .4815E+00,  .1740E+00,  .3279E-02,  .2238E-01,  .5084E-02,
     +   .2155E+00,
     +   .4556E+00,  .1630E+00,  .2927E-02,  .2098E-01,  .5001E-02,
     +   .1876E+00,
     +   .4337E+00,  .1537E+00,  .2650E-02,  .1978E-01,  .4888E-02,
     +   .1659E+00 /
        DATA ((PARTON(I,N,55),I=1,6),N=9,16)/
     +   .4130E+00,  .1452E+00,  .2405E-02,  .1864E-01,  .4748E-02,
     +   .1470E+00,
     +   .3952E+00,  .1379E+00,  .2207E-02,  .1765E-01,  .4607E-02,
     +   .1319E+00,
     +   .3782E+00,  .1310E+00,  .2026E-02,  .1670E-01,  .4455E-02,
     +   .1185E+00,
     +   .3626E+00,  .1247E+00,  .1869E-02,  .1583E-01,  .4304E-02,
     +   .1071E+00,
     +   .3489E+00,  .1193E+00,  .1738E-02,  .1507E-01,  .4162E-02,
     +   .9773E-01,
     +   .3325E+00,  .1129E+00,  .1588E-02,  .1416E-01,  .3982E-02,
     +   .8724E-01,
     +   .3179E+00,  .1072E+00,  .1461E-02,  .1336E-01,  .3815E-02,
     +   .7859E-01,
     +   .3045E+00,  .1020E+00,  .1350E-02,  .1263E-01,  .3656E-02,
     +   .7121E-01 /
        DATA ((PARTON(I,N,55),I=1,6),N=17,24)/
     +   .2925E+00,  .9745E-01,  .1254E-02,  .1199E-01,  .3510E-02,
     +   .6504E-01,
     +   .2809E+00,  .9308E-01,  .1166E-02,  .1137E-01,  .3366E-02,
     +   .5946E-01,
     +   .2705E+00,  .8916E-01,  .1089E-02,  .1082E-01,  .3234E-02,
     +   .5471E-01,
     +   .2608E+00,  .8553E-01,  .1021E-02,  .1031E-01,  .3110E-02,
     +   .5054E-01,
     +   .2520E+00,  .8227E-01,  .9603E-03,  .9857E-02,  .2996E-02,
     +   .4697E-01,
     +   .2406E+00,  .7808E-01,  .8853E-03,  .9276E-02,  .2848E-02,
     +   .4261E-01,
     +   .2308E+00,  .7451E-01,  .8233E-03,  .8783E-02,  .2720E-02,
     +   .3911E-01,
     +   .2213E+00,  .7107E-01,  .7655E-03,  .8312E-02,  .2595E-02,
     +   .3591E-01 /
        DATA ((PARTON(I,N,55),I=1,6),N=25,27)/
     +   .2124E+00,  .6787E-01,  .7132E-03,  .7876E-02,  .2477E-02,
     +   .3308E-01,
     +   .2047E+00,  .6511E-01,  .6692E-03,  .7502E-02,  .2375E-02,
     +   .3075E-01,
     +   .1971E+00,  .6241E-01,  .6275E-03,  .7140E-02,  .2275E-02,
     +   .2857E-01 /
        DATA ((PARTON(I,N,56),I=1,6),N=1,8)/
     +   .5747E+00,  .2100E+00,  .3655E-02,  .2145E-01,  .3723E-02,
     +   .3336E+00,
     +   .5525E+00,  .2002E+00,  .3356E-02,  .2078E-01,  .3923E-02,
     +   .3026E+00,
     +   .5289E+00,  .1899E+00,  .3057E-02,  .1999E-01,  .4068E-02,
     +   .2713E+00,
     +   .5026E+00,  .1786E+00,  .2747E-02,  .1905E-01,  .4155E-02,
     +   .2388E+00,
     +   .4737E+00,  .1665E+00,  .2433E-02,  .1793E-01,  .4171E-02,
     +   .2058E+00,
     +   .4490E+00,  .1562E+00,  .2183E-02,  .1692E-01,  .4127E-02,
     +   .1799E+00,
     +   .4227E+00,  .1456E+00,  .1937E-02,  .1581E-01,  .4031E-02,
     +   .1548E+00,
     +   .4007E+00,  .1368E+00,  .1745E-02,  .1486E-01,  .3915E-02,
     +   .1356E+00 /
        DATA ((PARTON(I,N,56),I=1,6),N=9,16)/
     +   .3801E+00,  .1286E+00,  .1576E-02,  .1395E-01,  .3781E-02,
     +   .1191E+00,
     +   .3624E+00,  .1217E+00,  .1440E-02,  .1318E-01,  .3651E-02,
     +   .1061E+00,
     +   .3456E+00,  .1152E+00,  .1317E-02,  .1243E-01,  .3513E-02,
     +   .9462E-01,
     +   .3302E+00,  .1093E+00,  .1210E-02,  .1175E-01,  .3378E-02,
     +   .8492E-01,
     +   .3169E+00,  .1043E+00,  .1121E-02,  .1116E-01,  .3254E-02,
     +   .7706E-01,
     +   .3008E+00,  .9825E-01,  .1020E-02,  .1045E-01,  .3099E-02,
     +   .6832E-01,
     +   .2867E+00,  .9299E-01,  .9344E-03,  .9828E-02,  .2955E-02,
     +   .6117E-01,
     +   .2737E+00,  .8822E-01,  .8600E-03,  .9266E-02,  .2821E-02,
     +   .5512E-01 /
        DATA ((PARTON(I,N,56),I=1,6),N=17,24)/
     +   .2622E+00,  .8401E-01,  .7965E-03,  .8769E-02,  .2698E-02,
     +   .5009E-01,
     +   .2511E+00,  .8001E-01,  .7380E-03,  .8296E-02,  .2578E-02,
     +   .4557E-01,
     +   .2411E+00,  .7642E-01,  .6873E-03,  .7875E-02,  .2469E-02,
     +   .4176E-01,
     +   .2318E+00,  .7313E-01,  .6419E-03,  .7487E-02,  .2366E-02,
     +   .3843E-01,
     +   .2235E+00,  .7017E-01,  .6023E-03,  .7141E-02,  .2273E-02,
     +   .3558E-01,
     +   .2127E+00,  .6638E-01,  .5531E-03,  .6700E-02,  .2153E-02,
     +   .3214E-01,
     +   .2035E+00,  .6316E-01,  .5127E-03,  .6328E-02,  .2049E-02,
     +   .2938E-01,
     +   .1946E+00,  .6008E-01,  .4751E-03,  .5973E-02,  .1948E-02,
     +   .2687E-01 /
        DATA ((PARTON(I,N,56),I=1,6),N=25,27)/
     +   .1863E+00,  .5721E-01,  .4412E-03,  .5645E-02,  .1854E-02,
     +   .2467E-01,
     +   .1790E+00,  .5475E-01,  .4129E-03,  .5364E-02,  .1773E-02,
     +   .2286E-01,
     +   .1720E+00,  .5235E-01,  .3860E-03,  .5093E-02,  .1693E-02,
     +   .2119E-01 /
        DATA ((PARTON(I,N,57),I=1,6),N=1,8)/
     +   .5076E+00,  .1713E+00,  .1575E-02,  .1204E-01,  .2539E-02,
     +   .2514E+00,
     +   .4844E+00,  .1621E+00,  .1434E-02,  .1167E-01,  .2645E-02,
     +   .2238E+00,
     +   .4601E+00,  .1525E+00,  .1294E-02,  .1122E-01,  .2708E-02,
     +   .1967E+00,
     +   .4333E+00,  .1422E+00,  .1151E-02,  .1066E-01,  .2728E-02,
     +   .1693E+00,
     +   .4043E+00,  .1311E+00,  .1007E-02,  .9987E-02,  .2697E-02,
     +   .1424E+00,
     +   .3797E+00,  .1220E+00,  .8945E-03,  .9378E-02,  .2634E-02,
     +   .1219E+00,
     +   .3541E+00,  .1125E+00,  .7850E-03,  .8712E-02,  .2536E-02,
     +   .1026E+00,
     +   .3329E+00,  .1048E+00,  .7003E-03,  .8139E-02,  .2434E-02,
     +   .8824E-01 /
        DATA ((PARTON(I,N,57),I=1,6),N=9,16)/
     +   .3131E+00,  .9770E-01,  .6264E-03,  .7596E-02,  .2324E-02,
     +   .7613E-01,
     +   .2965E+00,  .9180E-01,  .5676E-03,  .7132E-02,  .2222E-02,
     +   .6684E-01,
     +   .2807E+00,  .8626E-01,  .5147E-03,  .6688E-02,  .2118E-02,
     +   .5875E-01,
     +   .2665E+00,  .8131E-01,  .4694E-03,  .6287E-02,  .2019E-02,
     +   .5205E-01,
     +   .2542E+00,  .7708E-01,  .4319E-03,  .5940E-02,  .1930E-02,
     +   .4670E-01,
     +   .2396E+00,  .7209E-01,  .3895E-03,  .5529E-02,  .1820E-02,
     +   .4084E-01,
     +   .2268E+00,  .6776E-01,  .3541E-03,  .5169E-02,  .1721E-02,
     +   .3614E-01,
     +   .2151E+00,  .6387E-01,  .3235E-03,  .4846E-02,  .1629E-02,
     +   .3221E-01 /
        DATA ((PARTON(I,N,57),I=1,6),N=17,24)/
     +   .2049E+00,  .6046E-01,  .2976E-03,  .4562E-02,  .1547E-02,
     +   .2899E-01,
     +   .1951E+00,  .5724E-01,  .2739E-03,  .4294E-02,  .1468E-02,
     +   .2614E-01,
     +   .1863E+00,  .5438E-01,  .2535E-03,  .4055E-02,  .1397E-02,
     +   .2375E-01,
     +   .1783E+00,  .5176E-01,  .2353E-03,  .3838E-02,  .1331E-02,
     +   .2169E-01,
     +   .1710E+00,  .4942E-01,  .2196E-03,  .3645E-02,  .1271E-02,
     +   .1995E-01,
     +   .1618E+00,  .4646E-01,  .2002E-03,  .3400E-02,  .1194E-02,
     +   .1786E-01,
     +   .1539E+00,  .4395E-01,  .1843E-03,  .3194E-02,  .1129E-02,
     +   .1621E-01,
     +   .1463E+00,  .4157E-01,  .1697E-03,  .2999E-02,  .1067E-02,
     +   .1472E-01 /
        DATA ((PARTON(I,N,57),I=1,6),N=25,27)/
     +   .1393E+00,  .3936E-01,  .1566E-03,  .2821E-02,  .1009E-02,
     +   .1343E-01,
     +   .1333E+00,  .3748E-01,  .1457E-03,  .2669E-02,  .9594E-03,
     +   .1237E-01,
     +   .1274E+00,  .3566E-01,  .1354E-03,  .2522E-02,  .9112E-03,
     +   .1140E-01 /
        DATA ((PARTON(I,N,58),I=1,6),N=1,8)/
     +   .4316E+00,  .1336E+00,  .6048E-03,  .6465E-02,  .1648E-02,
     +   .1812E+00,
     +   .4089E+00,  .1254E+00,  .5462E-03,  .6275E-02,  .1697E-02,
     +   .1584E+00,
     +   .3852E+00,  .1171E+00,  .4885E-03,  .6029E-02,  .1716E-02,
     +   .1365E+00,
     +   .3595E+00,  .1081E+00,  .4301E-03,  .5716E-02,  .1705E-02,
     +   .1149E+00,
     +   .3321E+00,  .9870E-01,  .3720E-03,  .5335E-02,  .1661E-02,
     +   .9437E-01,
     +   .3091E+00,  .9094E-01,  .3270E-03,  .4986E-02,  .1601E-02,
     +   .7913E-01,
     +   .2854E+00,  .8306E-01,  .2838E-03,  .4604E-02,  .1520E-02,
     +   .6518E-01,
     +   .2660E+00,  .7669E-01,  .2507E-03,  .4276E-02,  .1442E-02,
     +   .5502E-01 /
        DATA ((PARTON(I,N,58),I=1,6),N=9,16)/
     +   .2482E+00,  .7090E-01,  .2222E-03,  .3966E-02,  .1361E-02,
     +   .4666E-01,
     +   .2333E+00,  .6613E-01,  .1997E-03,  .3703E-02,  .1289E-02,
     +   .4036E-01,
     +   .2193E+00,  .6169E-01,  .1796E-03,  .3453E-02,  .1217E-02,
     +   .3498E-01,
     +   .2068E+00,  .5775E-01,  .1625E-03,  .3227E-02,  .1150E-02,
     +   .3060E-01,
     +   .1961E+00,  .5441E-01,  .1485E-03,  .3034E-02,  .1091E-02,
     +   .2715E-01,
     +   .1835E+00,  .5050E-01,  .1328E-03,  .2806E-02,  .1019E-02,
     +   .2343E-01,
     +   .1725E+00,  .4714E-01,  .1198E-03,  .2608E-02,  .9556E-03,
     +   .2049E-01,
     +   .1626E+00,  .4414E-01,  .1087E-03,  .2431E-02,  .8976E-03,
     +   .1807E-01 /
        DATA ((PARTON(I,N,58),I=1,6),N=17,24)/
     +   .1539E+00,  .4154E-01,  .9928E-04,  .2276E-02,  .8462E-03,
     +   .1611E-01,
     +   .1457E+00,  .3909E-01,  .9076E-04,  .2131E-02,  .7973E-03,
     +   .1440E-01,
     +   .1384E+00,  .3693E-01,  .8347E-04,  .2003E-02,  .7536E-03,
     +   .1298E-01,
     +   .1318E+00,  .3496E-01,  .7704E-04,  .1887E-02,  .7135E-03,
     +   .1177E-01,
     +   .1258E+00,  .3322E-01,  .7149E-04,  .1784E-02,  .6777E-03,
     +   .1076E-01,
     +   .1182E+00,  .3102E-01,  .6469E-04,  .1655E-02,  .6322E-03,
     +   .9551E-02,
     +   .1118E+00,  .2918E-01,  .5919E-04,  .1547E-02,  .5938E-03,
     +   .8607E-02,
     +   .1057E+00,  .2744E-01,  .5414E-04,  .1445E-02,  .5574E-03,
     +   .7767E-02 /
        DATA ((PARTON(I,N,58),I=1,6),N=25,27)/
     +   .1001E+00,  .2584E-01,  .4964E-04,  .1352E-02,  .5239E-03,
     +   .7040E-02,
     +   .9530E-01,  .2448E-01,  .4593E-04,  .1273E-02,  .4953E-03,
     +   .6454E-02,
     +   .9065E-01,  .2317E-01,  .4245E-04,  .1198E-02,  .4678E-03,
     +   .5919E-02 /
        DATA ((PARTON(I,N,59),I=1,6),N=1,8)/
     +   .3522E+00,  .9906E-01,  .2037E-03,  .3319E-02,  .1009E-02,
     +   .1241E+00,
     +   .3312E+00,  .9233E-01,  .1824E-03,  .3227E-02,  .1027E-02,
     +   .1064E+00,
     +   .3095E+00,  .8545E-01,  .1617E-03,  .3100E-02,  .1026E-02,
     +   .8993E-01,
     +   .2862E+00,  .7817E-01,  .1409E-03,  .2932E-02,  .1006E-02,
     +   .7409E-01,
     +   .2615E+00,  .7060E-01,  .1205E-03,  .2725E-02,  .9646E-03,
     +   .5940E-01,
     +   .2412E+00,  .6444E-01,  .1048E-03,  .2534E-02,  .9177E-03,
     +   .4878E-01,
     +   .2205E+00,  .5825E-01,  .8994E-04,  .2324E-02,  .8594E-03,
     +   .3931E-01,
     +   .2037E+00,  .5331E-01,  .7869E-04,  .2145E-02,  .8055E-03,
     +   .3257E-01 /
        DATA ((PARTON(I,N,59),I=1,6),N=9,16)/
     +   .1885E+00,  .4886E-01,  .6907E-04,  .1977E-02,  .7521E-03,
     +   .2715E-01,
     +   .1759E+00,  .4523E-01,  .6156E-04,  .1834E-02,  .7052E-03,
     +   .2314E-01,
     +   .1641E+00,  .4187E-01,  .5492E-04,  .1700E-02,  .6596E-03,
     +   .1977E-01,
     +   .1537E+00,  .3893E-01,  .4931E-04,  .1580E-02,  .6178E-03,
     +   .1707E-01,
     +   .1448E+00,  .3644E-01,  .4476E-04,  .1477E-02,  .5814E-03,
     +   .1498E-01,
     +   .1345E+00,  .3356E-01,  .3968E-04,  .1357E-02,  .5382E-03,
     +   .1276E-01,
     +   .1255E+00,  .3111E-01,  .3551E-04,  .1253E-02,  .5003E-03,
     +   .1103E-01,
     +   .1175E+00,  .2893E-01,  .3196E-04,  .1161E-02,  .4662E-03,
     +   .9630E-02 /
        DATA ((PARTON(I,N,59),I=1,6),N=17,24)/
     +   .1106E+00,  .2705E-01,  .2901E-04,  .1082E-02,  .4363E-03,
     +   .8510E-02,
     +   .1041E+00,  .2530E-01,  .2634E-04,  .1007E-02,  .4082E-03,
     +   .7539E-02,
     +   .9831E-01,  .2377E-01,  .2407E-04,  .9419E-03,  .3833E-03,
     +   .6746E-02,
     +   .9307E-01,  .2238E-01,  .2208E-04,  .8830E-03,  .3607E-03,
     +   .6074E-02,
     +   .8842E-01,  .2116E-01,  .2038E-04,  .8311E-03,  .3406E-03,
     +   .5516E-02,
     +   .8255E-01,  .1962E-01,  .1830E-04,  .7661E-03,  .3153E-03,
     +   .4860E-02,
     +   .7763E-01,  .1835E-01,  .1664E-04,  .7123E-03,  .2943E-03,
     +   .4351E-02,
     +   .7297E-01,  .1715E-01,  .1512E-04,  .6618E-03,  .2744E-03,
     +   .3902E-02 /
        DATA ((PARTON(I,N,59),I=1,6),N=25,27)/
     +   .6870E-01,  .1606E-01,  .1377E-04,  .6160E-03,  .2563E-03,
     +   .3517E-02,
     +   .6506E-01,  .1513E-01,  .1267E-04,  .5775E-03,  .2409E-03,
     +   .3208E-02,
     +   .6157E-01,  .1425E-01,  .1164E-04,  .5409E-03,  .2263E-03,
     +   .2928E-02 /
        DATA ((PARTON(I,N,60),I=1,6),N=1,8)/
     +   .2744E+00,  .6937E-01,  .5870E-04,  .1624E-02,  .5763E-03,
     +   .7992E-01,
     +   .2560E+00,  .6413E-01,  .5211E-04,  .1581E-02,  .5796E-03,
     +   .6728E-01,
     +   .2372E+00,  .5885E-01,  .4576E-04,  .1517E-02,  .5718E-03,
     +   .5571E-01,
     +   .2172E+00,  .5331E-01,  .3945E-04,  .1430E-02,  .5526E-03,
     +   .4488E-01,
     +   .1964E+00,  .4761E-01,  .3334E-04,  .1321E-02,  .5219E-03,
     +   .3511E-01,
     +   .1794E+00,  .4303E-01,  .2870E-04,  .1221E-02,  .4899E-03,
     +   .2822E-01,
     +   .1622E+00,  .3848E-01,  .2434E-04,  .1111E-02,  .4523E-03,
     +   .2224E-01,
     +   .1485E+00,  .3489E-01,  .2108E-04,  .1018E-02,  .4189E-03,
     +   .1808E-01 /
        DATA ((PARTON(I,N,60),I=1,6),N=9,16)/
     +   .1362E+00,  .3169E-01,  .1833E-04,  .9312E-03,  .3866E-03,
     +   .1480E-01,
     +   .1261E+00,  .2910E-01,  .1619E-04,  .8584E-03,  .3589E-03,
     +   .1243E-01,
     +   .1168E+00,  .2673E-01,  .1432E-04,  .7901E-03,  .3324E-03,
     +   .1047E-01,
     +   .1086E+00,  .2467E-01,  .1276E-04,  .7295E-03,  .3086E-03,
     +   .8926E-02,
     +   .1016E+00,  .2294E-01,  .1150E-04,  .6782E-03,  .2881E-03,
     +   .7747E-02,
     +   .9361E-01,  .2096E-01,  .1010E-04,  .6184E-03,  .2641E-03,
     +   .6513E-02,
     +   .8674E-01,  .1928E-01,  .8970E-05,  .5674E-03,  .2434E-03,
     +   .5566E-02,
     +   .8067E-01,  .1781E-01,  .8013E-05,  .5224E-03,  .2250E-03,
     +   .4809E-02 /
        DATA ((PARTON(I,N,60),I=1,6),N=17,24)/
     +   .7542E-01,  .1654E-01,  .7220E-05,  .4837E-03,  .2090E-03,
     +   .4212E-02,
     +   .7052E-01,  .1537E-01,  .6510E-05,  .4477E-03,  .1941E-03,
     +   .3701E-02,
     +   .6623E-01,  .1435E-01,  .5911E-05,  .4165E-03,  .1810E-03,
     +   .3287E-02,
     +   .6235E-01,  .1344E-01,  .5389E-05,  .3884E-03,  .1693E-03,
     +   .2940E-02,
     +   .5892E-01,  .1264E-01,  .4945E-05,  .3638E-03,  .1589E-03,
     +   .2654E-02,
     +   .5463E-01,  .1164E-01,  .4407E-05,  .3332E-03,  .1460E-03,
     +   .2322E-02,
     +   .5106E-01,  .1081E-01,  .3979E-05,  .3080E-03,  .1353E-03,
     +   .2066E-02,
     +   .4770E-01,  .1004E-01,  .3590E-05,  .2845E-03,  .1253E-03,
     +   .1842E-02 /
        DATA ((PARTON(I,N,60),I=1,6),N=25,27)/
     +   .4464E-01,  .9346E-02,  .3250E-05,  .2634E-03,  .1163E-03,
     +   .1651E-02,
     +   .4205E-01,  .8761E-02,  .2972E-05,  .2457E-03,  .1087E-03,
     +   .1499E-02,
     +   .3958E-01,  .8204E-02,  .2715E-05,  .2290E-03,  .1015E-03,
     +   .1362E-02 /
        DATA ((PARTON(I,N,61),I=1,6),N=1,8)/
     +   .2023E+00,  .4533E-01,  .1395E-04,  .7500E-03,  .3019E-03,
     +   .4774E-01,
     +   .1872E+00,  .4155E-01,  .1227E-04,  .7294E-03,  .2999E-03,
     +   .3942E-01,
     +   .1719E+00,  .3778E-01,  .1067E-04,  .6977E-03,  .2920E-03,
     +   .3196E-01,
     +   .1558E+00,  .3386E-01,  .9100E-05,  .6540E-03,  .2780E-03,
     +   .2516E-01,
     +   .1392E+00,  .2989E-01,  .7593E-05,  .5994E-03,  .2584E-03,
     +   .1917E-01,
     +   .1258E+00,  .2673E-01,  .6464E-05,  .5493E-03,  .2392E-03,
     +   .1508E-01,
     +   .1126E+00,  .2364E-01,  .5417E-05,  .4952E-03,  .2176E-03,
     +   .1160E-01,
     +   .1021E+00,  .2122E-01,  .4643E-05,  .4498E-03,  .1989E-03,
     +   .9251E-02 /
        DATA ((PARTON(I,N,61),I=1,6),N=9,16)/
     +   .9269E-01,  .1909E-01,  .3995E-05,  .4079E-03,  .1814E-03,
     +   .7436E-02,
     +   .8510E-01,  .1738E-01,  .3498E-05,  .3731E-03,  .1667E-03,
     +   .6148E-02,
     +   .7816E-01,  .1583E-01,  .3067E-05,  .3408E-03,  .1528E-03,
     +   .5104E-02,
     +   .7211E-01,  .1450E-01,  .2709E-05,  .3123E-03,  .1406E-03,
     +   .4294E-02,
     +   .6705E-01,  .1339E-01,  .2423E-05,  .2884E-03,  .1302E-03,
     +   .3685E-02,
     +   .6122E-01,  .1213E-01,  .2109E-05,  .2609E-03,  .1181E-03,
     +   .3058E-02,
     +   .5628E-01,  .1106E-01,  .1857E-05,  .2375E-03,  .1078E-03,
     +   .2584E-02,
     +   .5196E-01,  .1014E-01,  .1645E-05,  .2172E-03,  .9882E-04,
     +   .2210E-02 /
        DATA ((PARTON(I,N,61),I=1,6),N=17,24)/
     +   .4825E-01,  .9357E-02,  .1471E-05,  .1997E-03,  .9109E-04,
     +   .1919E-02,
     +   .4481E-01,  .8636E-02,  .1317E-05,  .1837E-03,  .8395E-04,
     +   .1673E-02,
     +   .4182E-01,  .8012E-02,  .1188E-05,  .1698E-03,  .7776E-04,
     +   .1475E-02,
     +   .3913E-01,  .7456E-02,  .1076E-05,  .1575E-03,  .7222E-04,
     +   .1311E-02,
     +   .3678E-01,  .6971E-02,  .9810E-06,  .1467E-03,  .6738E-04,
     +   .1177E-02,
     +   .3384E-01,  .6372E-02,  .8673E-06,  .1334E-03,  .6139E-04,
     +   .1022E-02,
     +   .3142E-01,  .5881E-02,  .7773E-06,  .1226E-03,  .5649E-04,
     +   .9042E-03,
     +   .2916E-01,  .5425E-02,  .6964E-06,  .1125E-03,  .5194E-04,
     +   .8016E-03 /
        DATA ((PARTON(I,N,61),I=1,6),N=25,27)/
     +   .2711E-01,  .5016E-02,  .6260E-06,  .1035E-03,  .4786E-04,
     +   .7148E-03,
     +   .2540E-01,  .4674E-02,  .5689E-06,  .9607E-04,  .4447E-04,
     +   .6463E-03,
     +   .2377E-01,  .4352E-02,  .5164E-06,  .8904E-04,  .4126E-04,
     +   .5847E-03 /
        DATA ((PARTON(I,N,62),I=1,6),N=1,8)/
     +   .1393E+00,  .2715E-01,  .2588E-05,  .3201E-03,  .1414E-03,
     +   .2591E-01,
     +   .1277E+00,  .2466E-01,  .2255E-05,  .3100E-03,  .1387E-03,
     +   .2095E-01,
     +   .1161E+00,  .2219E-01,  .1941E-05,  .2946E-03,  .1331E-03,
     +   .1661E-01,
     +   .1041E+00,  .1967E-01,  .1635E-05,  .2737E-03,  .1248E-03,
     +   .1275E-01,
     +   .9181E-01,  .1714E-01,  .1346E-05,  .2481E-03,  .1140E-03,
     +   .9455E-02,
     +   .8208E-01,  .1516E-01,  .1132E-05,  .2250E-03,  .1040E-03,
     +   .7261E-02,
     +   .7252E-01,  .1324E-01,  .9367E-06,  .2004E-03,  .9309E-04,
     +   .5450E-02,
     +   .6505E-01,  .1175E-01,  .7937E-06,  .1801E-03,  .8398E-04,
     +   .4256E-02 /
        DATA ((PARTON(I,N,62),I=1,6),N=9,16)/
     +   .5848E-01,  .1047E-01,  .6754E-06,  .1617E-03,  .7560E-04,
     +   .3356E-02,
     +   .5321E-01,  .9442E-02,  .5857E-06,  .1465E-03,  .6869E-04,
     +   .2730E-02,
     +   .4843E-01,  .8523E-02,  .5086E-06,  .1326E-03,  .6231E-04,
     +   .2232E-02,
     +   .4430E-01,  .7738E-02,  .4452E-06,  .1205E-03,  .5673E-04,
     +   .1853E-02,
     +   .4088E-01,  .7092E-02,  .3950E-06,  .1104E-03,  .5207E-04,
     +   .1572E-02,
     +   .3698E-01,  .6361E-02,  .3404E-06,  .9896E-04,  .4674E-04,
     +   .1287E-02,
     +   .3371E-01,  .5754E-02,  .2969E-06,  .8933E-04,  .4226E-04,
     +   .1076E-02,
     +   .3087E-01,  .5231E-02,  .2608E-06,  .8101E-04,  .3838E-04,
     +   .9110E-03 /
        DATA ((PARTON(I,N,62),I=1,6),N=17,24)/
     +   .2845E-01,  .4790E-02,  .2314E-06,  .7396E-04,  .3508E-04,
     +   .7843E-03,
     +   .2623E-01,  .4388E-02,  .2055E-06,  .6752E-04,  .3207E-04,
     +   .6782E-03,
     +   .2431E-01,  .4043E-02,  .1839E-06,  .6201E-04,  .2948E-04,
     +   .5941E-03,
     +   .2260E-01,  .3737E-02,  .1654E-06,  .5712E-04,  .2718E-04,
     +   .5248E-03,
     +   .2111E-01,  .3472E-02,  .1499E-06,  .5290E-04,  .2519E-04,
     +   .4686E-03,
     +   .1927E-01,  .3148E-02,  .1314E-06,  .4772E-04,  .2275E-04,
     +   .4042E-03,
     +   .1776E-01,  .2884E-02,  .1168E-06,  .4353E-04,  .2077E-04,
     +   .3555E-03,
     +   .1636E-01,  .2641E-02,  .1038E-06,  .3969E-04,  .1895E-04,
     +   .3135E-03 /
        DATA ((PARTON(I,N,62),I=1,6),N=25,27)/
     +   .1511E-01,  .2425E-02,  .9264E-07,  .3627E-04,  .1734E-04,
     +   .2782E-03,
     +   .1406E-01,  .2245E-02,  .8362E-07,  .3344E-04,  .1600E-04,
     +   .2504E-03,
     +   .1308E-01,  .2077E-02,  .7539E-07,  .3081E-04,  .1475E-04,
     +   .2256E-03 /
        DATA ((PARTON(I,N,63),I=1,6),N=1,8)/
     +   .8761E-01,  .1448E-01,  .3440E-06,  .1213E-03,  .5703E-04,
     +   .1236E-01,
     +   .7951E-01,  .1302E-01,  .2966E-06,  .1165E-03,  .5510E-04,
     +   .9765E-02,
     +   .7149E-01,  .1159E-01,  .2523E-06,  .1096E-03,  .5208E-04,
     +   .7555E-02,
     +   .6327E-01,  .1014E-01,  .2097E-06,  .1005E-03,  .4800E-04,
     +   .5642E-02,
     +   .5504E-01,  .8711E-02,  .1701E-06,  .8975E-04,  .4302E-04,
     +   .4060E-02,
     +   .4859E-01,  .7606E-02,  .1412E-06,  .8031E-04,  .3860E-04,
     +   .3038E-02,
     +   .4235E-01,  .6550E-02,  .1151E-06,  .7049E-04,  .3396E-04,
     +   .2219E-02,
     +   .3753E-01,  .5747E-02,  .9634E-07,  .6254E-04,  .3019E-04,
     +   .1695E-02 /
        DATA ((PARTON(I,N,63),I=1,6),N=9,16)/
     +   .3335E-01,  .5057E-02,  .8098E-07,  .5543E-04,  .2680E-04,
     +   .1309E-02,
     +   .3004E-01,  .4516E-02,  .6947E-07,  .4970E-04,  .2405E-04,
     +   .1047E-02,
     +   .2707E-01,  .4035E-02,  .5968E-07,  .4450E-04,  .2156E-04,
     +   .8424E-03,
     +   .2453E-01,  .3628E-02,  .5173E-07,  .4004E-04,  .1942E-04,
     +   .6896E-03,
     +   .2244E-01,  .3297E-02,  .4548E-07,  .3637E-04,  .1765E-04,
     +   .5783E-03,
     +   .2009E-01,  .2926E-02,  .3877E-07,  .3223E-04,  .1566E-04,
     +   .4672E-03,
     +   .1814E-01,  .2621E-02,  .3347E-07,  .2880E-04,  .1400E-04,
     +   .3860E-03,
     +   .1646E-01,  .2361E-02,  .2911E-07,  .2587E-04,  .1259E-04,
     +   .3237E-03 /
        DATA ((PARTON(I,N,63),I=1,6),N=17,24)/
     +   .1504E-01,  .2144E-02,  .2560E-07,  .2342E-04,  .1140E-04,
     +   .2764E-03,
     +   .1375E-01,  .1947E-02,  .2254E-07,  .2120E-04,  .1033E-04,
     +   .2372E-03,
     +   .1265E-01,  .1780E-02,  .2001E-07,  .1932E-04,  .9415E-05,
     +   .2064E-03,
     +   .1167E-01,  .1633E-02,  .1786E-07,  .1766E-04,  .8613E-05,
     +   .1813E-03,
     +   .1082E-01,  .1507E-02,  .1606E-07,  .1624E-04,  .7925E-05,
     +   .1610E-03,
     +   .9790E-02,  .1353E-02,  .1394E-07,  .1452E-04,  .7088E-05,
     +   .1380E-03,
     +   .8951E-02,  .1230E-02,  .1229E-07,  .1314E-04,  .6416E-05,
     +   .1207E-03,
     +   .8180E-02,  .1117E-02,  .1083E-07,  .1188E-04,  .5804E-05,
     +   .1059E-03 /
        DATA ((PARTON(I,N,63),I=1,6),N=25,27)/
     +   .7494E-02,  .1017E-02,  .0000E+00,  .1077E-04,  .5265E-05,
     +   .9347E-04,
     +   .6926E-02,  .9353E-03,  .0000E+00,  .9864E-05,  .4823E-05,
     +   .8376E-04,
     +   .6395E-02,  .8590E-03,  .0000E+00,  .9021E-05,  .4413E-05,
     +   .7510E-04 /
        DATA ((PARTON(I,N,64),I=1,6),N=1,8)/
     +   .4849E-01,  .6553E-02,  .2830E-07,  .3801E-04,  .1853E-04,
     +   .4902E-02,
     +   .4349E-01,  .5822E-02,  .2410E-07,  .3603E-04,  .1760E-04,
     +   .3773E-02,
     +   .3860E-01,  .5115E-02,  .2023E-07,  .3339E-04,  .1635E-04,
     +   .2838E-02,
     +   .3367E-01,  .4411E-02,  .1656E-07,  .3012E-04,  .1478E-04,
     +   .2054E-02,
     +   .2881E-01,  .3726E-02,  .1320E-07,  .2639E-04,  .1296E-04,
     +   .1428E-02,
     +   .2507E-01,  .3206E-02,  .1079E-07,  .2321E-04,  .1142E-04,
     +   .1038E-02,
     +   .2150E-01,  .2717E-02,  .0000E+00,  .2001E-04,  .9848E-05,
     +   .7358E-03,
     +   .1879E-01,  .2351E-02,  .0000E+00,  .1747E-04,  .8608E-05,
     +   .5481E-03 /
        DATA ((PARTON(I,N,64),I=1,6),N=9,16)/
     +   .1648E-01,  .2041E-02,  .0000E+00,  .1525E-04,  .7520E-05,
     +   .4139E-03,
     +   .1466E-01,  .1801E-02,  .0000E+00,  .1350E-04,  .6657E-05,
     +   .3249E-03,
     +   .1306E-01,  .1590E-02,  .0000E+00,  .1193E-04,  .5887E-05,
     +   .2571E-03,
     +   .1170E-01,  .1414E-02,  .0000E+00,  .1061E-04,  .5236E-05,
     +   .2074E-03,
     +   .1060E-01,  .1272E-02,  .0000E+00,  .9534E-05,  .4707E-05,
     +   .1718E-03,
     +   .9376E-02,  .1115E-02,  .0000E+00,  .8339E-05,  .4119E-05,
     +   .1369E-03,
     +   .8370E-02,  .9875E-03,  .0000E+00,  .7365E-05,  .3639E-05,
     +   .1119E-03,
     +   .7514E-02,  .8800E-03,  .0000E+00,  .6543E-05,  .3234E-05,
     +   .9293E-04 /
        DATA ((PARTON(I,N,64),I=1,6),N=17,24)/
     +   .6800E-02,  .7911E-03,  .0000E+00,  .5862E-05,  .2898E-05,
     +   .7871E-04,
     +   .6157E-02,  .7116E-03,  .0000E+00,  .5254E-05,  .2598E-05,
     +   .6705E-04,
     +   .5612E-02,  .6446E-03,  .0000E+00,  .4743E-05,  .2346E-05,
     +   .5799E-04,
     +   .5134E-02,  .5862E-03,  .0000E+00,  .4298E-05,  .2126E-05,
     +   .5063E-04,
     +   .4724E-02,  .5366E-03,  .0000E+00,  .3921E-05,  .1940E-05,
     +   .4475E-04,
     +   .4227E-02,  .4767E-03,  .0000E+00,  .3467E-05,  .1716E-05,
     +   .3809E-04,
     +   .3828E-02,  .4291E-03,  .0000E+00,  .3107E-05,  .1538E-05,
     +   .3313E-04,
     +   .3465E-02,  .3860E-03,  .0000E+00,  .2782E-05,  .1377E-05,
     +   .2888E-04 /
        DATA ((PARTON(I,N,64),I=1,6),N=25,27)/
     +   .3145E-02,  .3483E-03,  .0000E+00,  .2498E-05,  .1237E-05,
     +   .2534E-04,
     +   .2883E-02,  .3175E-03,  .0000E+00,  .2268E-05,  .1123E-05,
     +   .2258E-04,
     +   .2640E-02,  .2892E-03,  .0000E+00,  .2057E-05,  .1019E-05,
     +   .2012E-04 /
        DATA ((PARTON(I,N,65),I=1,6),N=1,8)/
     +   .2201E-01,  .2294E-02,  .0000E+00,  .8643E-05,  .4288E-05,
     +   .1456E-02,
     +   .1946E-01,  .2009E-02,  .0000E+00,  .8044E-05,  .3993E-05,
     +   .1086E-02,
     +   .1700E-01,  .1738E-02,  .0000E+00,  .7310E-05,  .3631E-05,
     +   .7898E-03,
     +   .1457E-01,  .1472E-02,  .0000E+00,  .6449E-05,  .3205E-05,
     +   .5506E-03,
     +   .1221E-01,  .1218E-02,  .0000E+00,  .5511E-05,  .2740E-05,
     +   .3675E-03,
     +   .1044E-01,  .1029E-02,  .0000E+00,  .4745E-05,  .2360E-05,
     +   .2581E-03,
     +   .8778E-02,  .8553E-03,  .0000E+00,  .3996E-05,  .1988E-05,
     +   .1766E-03,
     +   .7543E-02,  .7273E-03,  .0000E+00,  .3423E-05,  .1703E-05,
     +   .1278E-03 /
        DATA ((PARTON(I,N,65),I=1,6),N=9,16)/
     +   .6504E-02,  .6209E-03,  .0000E+00,  .2933E-05,  .1460E-05,
     +   .9412E-04,
     +   .5705E-02,  .5398E-03,  .0000E+00,  .2553E-05,  .1271E-05,
     +   .7240E-04,
     +   .5007E-02,  .4698E-03,  .0000E+00,  .2221E-05,  .1106E-05,
     +   .5626E-04,
     +   .4427E-02,  .4121E-03,  .0000E+00,  .1946E-05,  .9689E-06,
     +   .4469E-04,
     +   .3963E-02,  .3662E-03,  .0000E+00,  .1726E-05,  .8595E-06,
     +   .3657E-04,
     +   .3451E-02,  .3162E-03,  .0000E+00,  .1486E-05,  .7399E-06,
     +   .2875E-04,
     +   .3038E-02,  .2761E-03,  .0000E+00,  .1293E-05,  .6440E-06,
     +   .2323E-04,
     +   .2692E-02,  .2428E-03,  .0000E+00,  .1133E-05,  .5643E-06,
     +   .1912E-04 /
        DATA ((PARTON(I,N,65),I=1,6),N=17,24)/
     +   .2407E-02,  .2157E-03,  .0000E+00,  .1002E-05,  .4994E-06,
     +   .1607E-04,
     +   .2153E-02,  .1917E-03,  .0000E+00,  .8873E-06,  .4421E-06,
     +   .1359E-04,
     +   .1941E-02,  .1717E-03,  .0000E+00,  .7918E-06,  .3945E-06,
     +   .1168E-04,
     +   .1757E-02,  .1545E-03,  .0000E+00,  .7097E-06,  .3537E-06,
     +   .1014E-04,
     +   .1601E-02,  .1400E-03,  .0000E+00,  .6408E-06,  .3193E-06,
     +   .8907E-05,
     +   .1413E-02,  .1227E-03,  .0000E+00,  .5589E-06,  .2785E-06,
     +   .7520E-05,
     +   .1265E-02,  .1092E-03,  .0000E+00,  .4946E-06,  .2465E-06,
     +   .6485E-05,
     +   .1132E-02,  .9704E-04,  .0000E+00,  .4373E-06,  .2180E-06,
     +   .5597E-05 /
        DATA ((PARTON(I,N,65),I=1,6),N=25,27)/
     +   .1016E-02,  .8655E-04,  .0000E+00,  .3877E-06,  .1933E-06,
     +   .4855E-05,
     +   .9216E-03,  .7811E-04,  .0000E+00,  .3478E-06,  .1733E-06,
     +   .4274E-05,
     +   .8351E-03,  .7040E-04,  .0000E+00,  .3112E-06,  .1551E-06,
     +   .3757E-05 /
        DATA ((PARTON(I,N,66),I=1,6),N=1,8)/
     +   .6985E-02,  .5053E-03,  .0000E+00,  .1073E-05,  .5358E-06,
     +   .2563E-03,
     +   .6056E-02,  .4339E-03,  .0000E+00,  .9734E-06,  .4861E-06,
     +   .1833E-03,
     +   .5181E-02,  .3673E-03,  .0000E+00,  .8607E-06,  .4298E-06,
     +   .1275E-03,
     +   .4333E-02,  .3037E-03,  .0000E+00,  .7366E-06,  .3679E-06,
     +   .8466E-04,
     +   .3535E-02,  .2446E-03,  .0000E+00,  .6087E-06,  .3040E-06,
     +   .5361E-04,
     +   .2949E-02,  .2017E-03,  .0000E+00,  .5093E-06,  .2544E-06,
     +   .3604E-04,
     +   .2416E-02,  .1632E-03,  .0000E+00,  .4159E-06,  .2078E-06,
     +   .2361E-04,
     +   .2029E-02,  .1356E-03,  .0000E+00,  .3470E-06,  .1733E-06,
     +   .1652E-04 /
        DATA ((PARTON(I,N,66),I=1,6),N=9,16)/
     +   .1710E-02,  .1132E-03,  .0000E+00,  .2900E-06,  .1449E-06,
     +   .1181E-04,
     +   .1471E-02,  .9649E-04,  .0000E+00,  .2470E-06,  .1234E-06,
     +   .8876E-05,
     +   .1266E-02,  .8235E-04,  .0000E+00,  .2104E-06,  .1051E-06,
     +   .6762E-05,
     +   .1099E-02,  .7091E-04,  .0000E+00,  .1807E-06,  .9026E-07,
     +   .5285E-05,
     +   .9677E-03,  .6198E-04,  .0000E+00,  .1574E-06,  .7865E-07,
     +   .4270E-05,
     +   .8258E-03,  .5243E-04,  .0000E+00,  .1326E-06,  .6623E-07,
     +   .3312E-05,
     +   .7135E-03,  .4494E-04,  .0000E+00,  .1131E-06,  .5651E-07,
     +   .2648E-05,
     +   .6211E-03,  .3882E-04,  .0000E+00,  .9726E-07,  .4860E-07,
     +   .2160E-05 /
        DATA ((PARTON(I,N,66),I=1,6),N=17,24)/
     +   .5463E-03,  .3392E-04,  .0000E+00,  .8460E-07,  .4227E-07,
     +   .1801E-05,
     +   .4809E-03,  .2965E-04,  .0000E+00,  .7363E-07,  .3679E-07,
     +   .1512E-05,
     +   .4270E-03,  .2616E-04,  .0000E+00,  .6468E-07,  .3231E-07,
     +   .1289E-05,
     +   .3809E-03,  .2320E-04,  .0000E+00,  .5709E-07,  .2852E-07,
     +   .1107E-05,
     +   .3425E-03,  .2074E-04,  .0000E+00,  .5077E-07,  .2537E-07,
     +   .9610E-06,
     +   .2970E-03,  .1786E-04,  .0000E+00,  .4331E-07,  .2164E-07,
     +   .7916E-06,
     +   .2617E-03,  .1564E-04,  .0000E+00,  .3744E-07,  .1871E-07,
     +   .6598E-06,
     +   .2304E-03,  .1368E-04,  .0000E+00,  .3214E-07,  .1606E-07,
     +   .5411E-06 /
        DATA ((PARTON(I,N,66),I=1,6),N=25,27)/
     +   .2036E-03,  .1201E-04,  .0000E+00,  .2745E-07,  .1371E-07,
     +   .4363E-06,
     +   .1822E-03,  .1069E-04,  .0000E+00,  .2354E-07,  .1176E-07,
     +   .3504E-06,
     +   .1628E-03,  .9504E-05,  .0000E+00,  .1983E-07,  .0000E+00,
     +   .2718E-06 /
        DATA ((PARTON(I,N,67),I=1,6),N=1,8)/
     +   .9294E-03,  .3608E-04,  .0000E+00,  .2983E-07,  .1492E-07,
     +   .1265E-04,
     +   .7805E-03,  .3002E-04,  .0000E+00,  .2595E-07,  .1298E-07,
     +   .8468E-05,
     +   .6450E-03,  .2455E-04,  .0000E+00,  .2194E-07,  .1098E-07,
     +   .5493E-05,
     +   .5186E-03,  .1952E-04,  .0000E+00,  .1788E-07,  .0000E+00,
     +   .3381E-05,
     +   .4047E-03,  .1503E-04,  .0000E+00,  .1401E-07,  .0000E+00,
     +   .1978E-05,
     +   .3245E-03,  .1192E-04,  .0000E+00,  .1119E-07,  .0000E+00,
     +   .1248E-05,
     +   .2546E-03,  .9237E-05,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .7689E-06,
     +   .2059E-03,  .7393E-05,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .5137E-06 /
        DATA ((PARTON(I,N,67),I=1,6),N=9,16)/
     +   .1674E-03,  .5949E-05,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .3530E-06,
     +   .1394E-03,  .4910E-05,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .2571E-06,
     +   .1162E-03,  .4058E-05,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .1902E-06,
     +   .9792E-04,  .3391E-05,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .1449E-06,
     +   .8392E-04,  .2885E-05,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .1147E-06,
     +   .6927E-04,  .2360E-05,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .8730E-07,
     +   .5804E-04,  .1961E-05,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .6918E-07,
     +   .4908E-04,  .1646E-05,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .5635E-07 /
        DATA ((PARTON(I,N,67),I=1,6),N=17,24)/
     +   .4204E-04,  .1399E-05,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .4689E-07,
     +   .3604E-04,  .1191E-05,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .3852E-07,
     +   .3122E-04,  .1025E-05,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .3062E-07,
     +   .2721E-04,  .8878E-06,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .2203E-07,
     +   .2393E-04,  .7764E-06,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .1240E-07,
     +   .2016E-04,  .6491E-06,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1731E-04,  .5534E-06,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1485E-04,  .4716E-06,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00 /
        DATA ((PARTON(I,N,67),I=1,6),N=25,27)/
     +   .1279E-04,  .4037E-06,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1119E-04,  .3512E-06,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .9779E-05,  .3050E-06,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00 /
C
       X  = DX
       Q  = DQ
       Q2 = DQ*DQ
*
* ..CHECK OF X AND Q2 VALUES : 
C      IF ( (X.LT.0.99D-9) .OR. (X.GT.1.D0) ) THEN
C         WRITE(6,91) 
C  91     FORMAT (2X,'PARTON INTERPOLATION: X OUT OF RANGE')
C         STOP
C      ENDIF
C      IF ( (Q2.LT.0.799) .OR. (Q2.GT.1.01E6) ) THEN
C         WRITE(6,92) 
C  92     FORMAT (2X,'PARTON INTERPOLATION: Q2 OUT OF RANGE')
C         STOP
C      ENDIF
      IF (IINIP .NE. 0) GOTO 16
*
* ..INITIALIZATION, IF REQUIRED :
*
*    SELECTION AND READING OF THE GRID : 
*    (COMMENT: FIRST NUMBER IN THE FIRST LINE OF THE GRID)
C      IF (ISET .EQ. 1) THEN
C        OPEN (11,FILE='grv98lo.grid',STATUS='old')   ! 7.332E-05
C      ELSE IF (ISET .EQ. 2) THEN
C        OPEN (11,FILE='grv98nlm.grid',STATUS='old')  ! 1.015E-04
C      ELSE IF (ISET .EQ. 3) THEN
C        OPEN (11,FILE='grv98nld.grid',STATUS='old')  ! 1.238E-04
C      ELSE
C        WRITE(6,93)
C  93    FORMAT (2X,'NO OR INVALID PARTON SET CHOICE')
C        STOP
C      END IF
C
      IINIP = 1
C
C      READ(11,89) LINE
C  89  FORMAT(A80)
C      DO 15 M = 1, NX-1 
C      DO 15 N = 1, NQ
C      READ(11,90) PARTON(1,N,M), PARTON(2,N,M), PARTON(3,N,M), 
C     1            PARTON(4,N,M), PARTON(5,N,M), PARTON(6,N,M) 
C  90  FORMAT (6(1PE10.3))
C  15  CONTINUE
C      CLOSE(11)
*
* ...ARRAYS FOR THE INTERPOLATION SUBROUTINE :
      DO 10 IQ = 1, NQ
      DO 20 IX = 1, NX-1
        XB0V = XB(IX)**0.5 
        XB0S = XB(IX)**(-0.2) 
        XB1 = 1.-XB(IX)
        XUVF(IX,IQ) = PARTON(1,IQ,IX) / (XB1**3 * XB0V)
        XDVF(IX,IQ) = PARTON(2,IQ,IX) / (XB1**4 * XB0V)
        XDEF(IX,IQ) = PARTON(3,IQ,IX) / (XB1**7 * XB0V) 
        XUDF(IX,IQ) = PARTON(4,IQ,IX) / (XB1**7 * XB0S)
        XSF(IX,IQ)  = PARTON(5,IQ,IX) / (XB1**7 * XB0S)
        XGF(IX,IQ)  = PARTON(6,IQ,IX) / (XB1**5 * XB0S)
  20  CONTINUE
        XUVF(NX,IQ) = 0.E0
        XDVF(NX,IQ) = 0.E0
        XDEF(NX,IQ) = 0.E0
        XUDF(NX,IQ) = 0.E0
        XSF(NX,IQ)  = 0.E0
        XGF(NX,IQ)  = 0.E0
  10  CONTINUE  
      NA(1) = NX
      NA(2) = NQ
      DO 30 IX = 1, NX
        ARRF(IX) =  LOG(XB(IX))
  30  CONTINUE
      DO 40 IQ = 1, NQ
        ARRF(NX+IQ) =  LOG(QS(IQ))
  40  CONTINUE
*
* ..CONTINUATION, IF INITIALIZATION WAS DONE PREVIOUSLY.
*
  16  CONTINUE
*
* ..INTERPOLATION :
      XT(1) =  LOG(X)
      XT(2) =  LOG(Q2)
      X1 = 1.- X
      XV = X**0.5
      XS = X**(-0.2)
      UV = DBFINT(NARG,XT,NA,ARRF,XUVF) * X1**3 * XV
      DUV = UV
      DV = DBFINT(NARG,XT,NA,ARRF,XDVF) * X1**4 * XV
      DDV = DV
      DE = DBFINT(NARG,XT,NA,ARRF,XDEF) * X1**7 * XV
      UD = DBFINT(NARG,XT,NA,ARRF,XUDF) * X1**7 * XS
      IF (DE. GT. UD) DE = ZEROD
      US = 0.5 * (UD - DE)
      DUSEA = US
      DS = 0.5 * (UD + DE)
      DDSEA = DS
      SS = DBFINT(NARG,XT,NA,ARRF,XSF)  * X1**7 * XS
      DSTR = SS
      DCHM = ZEROD
      DBOT = ZEROD
      DTOP = ZEROD
      GL = DBFINT(NARG,XT,NA,ARRF,XGF)  * X1**5 * XS 
      DGL = GL
*
 60   RETURN
      END
