(**************************************************************************)
(*  The CDuce compiler                                                    *)
(*  Alain Frisch <Alain.Frisch@inria.fr> and the CDuce team               *)
(*  Copyright CNRS,INRIA, 2003,2004 (see LICENSE for details)             *)
(**************************************************************************)

let load_url s =
  let buff = Buffer.create 4096 in 
  let conn = Curl.init () in
  Curl.set_url conn s;
  Curl.set_writefunction conn (Buffer.add_string buff);
  Curl.perform conn;
  Buffer.contents buff


let () = 
  Config.register 
    "curl" 
    "Load external URLs with curl"
    (fun () -> Url.url_loader := load_url)
