/*
 * KON2 - Kanji ON Console -
 * Copyright (C) 1992-1996 Takashi MANABE (manabe@papilio.tutics.tut.ac.jp)
 *
 * CCE - Console Chinese Environment -
 * Copyright (C) 1998-1999 Rui He (herui@cs.duke.edu)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY TAKASHI MANABE ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE TERRENCE R. LAMBERT BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * 
 */

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<unistd.h>
#include        <errno.h>

#include	<getcap.h>
#include	<defs.h>
#include	<vc.h>
#include 	<font.h>

static char *startupStr, *execProg;

int	ConfigExecProg(const char *string)
{
	execProg = strdup(string);
	return SUCCESS;
}

static int	ConfigStartup(const char *string)
{
	startupStr = strdup(string);
	return SUCCESS;
}

static void	RunStartupCmd(void)
{
	char *p;

	p = strtok(startupStr, "\n");
	while(p) {
		system(p);
		p = strtok(NULL, "\n");
	}
}

static bool startupMessage;

static int	ConfigMessage(const char *confstr)
{
	startupMessage = BoolConf(confstr);
	return SUCCESS;
}

void	ChildInit(void)
{
	DefineCap("StartupMessage", ConfigMessage, "On");
	DefineCap("StartUp", ConfigStartup, NULL);
}

void	ChildCleanup(void)
{
	free(startupStr);
}

void	ChildStart(FILE *errfp)
{
	char	*tail, *tcap;
	char	buff[80];

	setgid(getgid());
	setuid(getuid());

	RunStartupCmd();

#if defined(linux)
	sprintf(buff, "TERMCAP=:co#%d:li#%d:tc=console:",
		dispInfo.txmax, dispInfo.tymax);
#elif defined(__FreeBSD__)
	sprintf(buff,"TERM=cons25");
#endif

	tcap = strdup(buff);
	putenv(tcap);

	if (startupMessage)
        {
#if defined(linux)
	    printf("\rCCE Console Chinese Environment " VERSION
		   " using VT number %c\r\n"
                   "%s\r\n"
                   "%s\r\n"
		   "%s\r\n\r\n",
		   *(ttyname(fileno(errfp))+8),

               /* errfp = dup(2), fileno -> file descriptor,
                  ttyname = /dev/ttyX, +8 means X ?? */

   "Copyright (C) 1993-1996  Takashi MANABE (manabe@papilio.tutics.tut.ac.jp)",
   "Copyright (C) 1999-2000  ZhenChun Li (zhchli@163.net)",
   "Copyright (C) 1998-2000  Rui He (herui@cs.duke.edu)");

#elif defined(__FreeBSD__)
        printf("\rCCE Console Chinese Environment for FreeBSD " VERSION "\r\n");
        printf("        Rui He (herui@cs.duke.edu)\r\n");
        printf("        Arthur Que (arthur@turbolinux.com.cn)\r\n");
#endif
 

  /*   \r  = 13 = Ctrl+M = ^M = 0D   return   DOS uses \r\n
       \n  = 10 = Ctrl+J = ^J = 0A   new line   Unix only uses this
  */
        }

	fflush(stdout);

	if (execProg)
	    execlp(execProg, execProg, 0);
	else 
        {
	    if ((execProg = getenv("SHELL")) == NULL)
		execProg = "/bin/sh";
	    if ((tail = rindex(execProg, '/')) == NULL)
		tail = " sh";
	    sprintf(buff, "-%s", tail + 1);
	    execl(execProg, buff, 0);
	}
	fprintf(errfp, "CCE> couldn't exec shell\r\n");
	fprintf(errfp, "%s: %s\r\n", execProg, strerror(errno));
	exit(EXIT_FAILURE);
}
