;;; @file pet.s
;;; Useful PET KERNAL file handling routines and data structures
;;; @author Marko Mkel (msmakela@nic.funet.fi)
;;; @author Olaf Seibert (seibert@mbfys.kun.nl)

utilstart = $1800
;;; this is a PET
pet = 1

chkout	= $ffc9			; redirect standard output to file .X
clrchn	= $ffcc			; clear input/output redirections
chrout	= $ffd2			; write .A to standard output
stop	= $ffe1			; check for STOP key
chkin	= $ffc6			; redirect standard input to file .X
chrin	= $ffcf			; read .A from standard input

;;; zero page locations
status	= $96			; status of last KERNAL operation
fnlen	= $d1			; file name length
la	= $d2			; logical file number
sa	= $d3			; secondary address
fa	= $d4			; device number
fnadr	= $da			; pointer to the start of the file name

	;; macro => read the status to .A
#define READST lda status
	;; macro => set the file parameters
#define SETLFS sta la:stx fa:sty sa
	;; macro => set the file name (length in .A)
#define SETNAM(n) ldx #<n:ldy #>n:sta fnlen:stx fnadr:sty fnadr+1
	;; macro => set an empty file name (.A=0)
#define SETNAM0 sta fnlen
	;; macro => store device number if necessary
#define STDEV
	;; macro => set the file parameters, preserving the device number
#define SETLFSD sta la:sty sa
