;;; @file vic20.s
;;; Commodore VIC-20 definitions
;;; @author Marko Mkel (msmakela@nic.funet.fi)
host = 20

;;; start address for the server program
serverstart = $4000
;;; start address for the utility programs
utilstart = $1400

;;; in the 6522, the interrupt flag has to be reset
clearviaifr = 1
;;; in the 6526, the FLAG line may need debouncing in the C64/C128
ciadebounce = 0

;;; Commodore serial bus definitions
iecport1 = $912c
dato = 32
clko = 2
iecport2 = $911f
atno = 128
clki = 1
dati = 2
;;; Commodore cassette port definitions
c2nread = $912d			; VIA Interrupt Flag Register
c2nrdval = 2			; CA1 (cassette read)
c2nwrite = $9120		; VIA output register B
c2nwrval = 8			; PB3 (cassette write)

;;; miscellanous
strval	= $10	; strobe bit value

;;; memory locations
stemp	= $a7	; memory place that may hold the byte being received

start	= $ac	; start address of the transfer area
end	= $ae	; end address of the transfer
cinv	= $314	; interrupt vector

bstart	= $2b	; start of basic program text
bend	= $2d	; end of basic program text
blnsw	= $cc
crsw	= $d0

stack	= $104	; offset to the stack while in interrupt

clr	= $c659
linkprg = $c533
stxpt	= $c68e
newstt	= $c7ae

ackval	= $20
ack	= $911c
data	= $9110
ddr	= $9112
strobe	= $911d

	;; program header
#define header

	;; exit from an interrupt (pla tay pla tax pla rti)
#define irqexit jmp $ff56

	;; store the speed settings and enable fast speed
#define phfast
	;; restore original speed from fast speed
#define plfast
	;; store the speed settings and enable slow speed (no badlines)
#define phslow
	;; restore original speed from slow speed
#define plslow
	;; disable timer interrupts
#define deactirq lda #$40:sta $912e
	;; re-enable timer interrupts
#define reactirq jsr $fe39
