;;; @file c264.s
;;; Commodore 264 series (16, 116, plus/4) definitions
;;; @author Marko Mkel (msmakela@nic.funet.fi)
host = 16

;;; start address for the server program
serverstart = $2000
;;; start address for the utility programs
utilstart = $2400

;;; in the 6522, the interrupt flag has to be reset
clearviaifr = 0
;;; in the 6526, the FLAG line may need debouncing in the C64/C128
ciadebounce = 0

;;; Commodore serial bus definitions
iecport1 = 1
iecport2 = iecport1
dato = 1
clko = 2
atno = 4
clki = 64
dati = 128
;;; Commodore cassette port definitions
c2nread = 1
c2nrdval = 16
c2nwrite = 1
c2nwrval = 2

;;; 6551 ACIA definitions
acia = $fd00
r6551dt = acia			; transmit/receive data
r6551sr = acia + 1		; programmed reset/status register
r6551cm = acia + 2		; command register
r6551ct = acia + 3		; control register

;;; memory locations
stemp	= $a7	; memory place that may hold the byte being received

start	= $9b	; start address of the transfer area
end	= $9d	; end address of the transfer
cinv	= $314	; interrupt vector

bstart	= $2b	; start of basic program text
bend	= $2d	; end of basic program text

crsw	= $b7

linkprg	= $8818
basrun	= $8bc4

	;; program header
#define header

	;; store the speed settings and enable fast speed
#define phfast lda $ff06:pha:lda $ff13:pha:lda #$0:sta $ff06:sta $ff13
	;; restore original speed from fast speed
#define plfast pla:sta $ff13:pla:sta $ff06
	;; store the speed settings and enable slow speed (no badlines)
#define phslow lda $ff06:pha:lda $ff13:pha:lda #$2:sta $ff06:sta $ff13:\
	lda #1:.(:vblank bit $ff1c:beq vblank:.)
	;; restore original speed from slow speed
#define plslow pla:sta $ff13:pla:sta $ff06

	;; exit from an interrupt
#define irqexit jmp $fcbe
; same as the code below
; 	ldx $fb
; 	sta $fdd0,x		; restore the memory bank
; 	pla			; restore the register values
; 	tay
; 	pla
; 	tax
; 	pla
; 	rti			; exit from interrupt
	;; disable timer interrupts
#define deactirq
	;; re-enable timer interrupts
#define reactirq
