;;; @file serial.s
;;; Transfer routines for a 6551-based RS-232 connection
;;; @author Marko Mkel (msmakela@nic.funet.fi)

	;; additional commands for info mode
#define infoinit
	;; initialize the cable (programmed reset, 19200,8N1,-RTS=-DTR=low)
#define initcable sta r6551sr:lda #$1f:sta r6551ct:lda #9:sta r6551cm
	;; deinitialize the cable (disable ACIA interrupts)
#define deinitcable lda #$b:sta r6551cm
	;; determine whether a request is pending
#define isrequest lda #8:bit r6551sr:beq return
	; .A = data, .X and .Y preserved
receive_switch:
receive:
	lda #8		; wait for data (don't check for overruns)
	.(:wait bit r6551sr:beq wait:.)
rereceive:
	lda r6551dt
	rts

	; .A trashed, .Y = 00, .X preserved
send_switch:
send:
	tay
	lda #$10	; wait for transmitter register empty
	.(:wait bit r6551sr:beq wait:.)
	sty r6551dt	; send the data
	ldy #0
	rts

;;; Short introduction to the MOS 6551/CSG 8561/R6551 ACIA
;;; The chip is usually clocked by a 1.8432 MHz crystal, but some
;;; Commodore 64/128 cartridges use doubled frequency (3.6864 MHz).
;;; 
;;; RS1 RS0	Write			Read			Label
;;;   0   0	Transmit data		Receive data		r6551dt
;;;   0   1	Programmed reset	Status Register		r6551sr
;;;   1   0	Command register (read/write)			r6551cm
;;;   1   1	Control register (read/write)			r6551ct
;;; 
;;; Control register
;;; -initial state 00000000 by hardware reset; unaffected by programmed reset
;;;  b7	number of stop bits
;;; 	0=1 stop bit
;;; 	1=2 stop bits
;;; 	  (1 if word length is 8 bits + parity;
;;; 	   1 if word length is 5 bits, no parity)
;;;  b6..5	word length
;;; 	00=8 bits
;;; 	01=7 bits
;;; 	10=6 bits
;;; 	11=5 bits
;;;  b4	receiver clock source
;;; 	0=external
;;; 	1=internal baud rate generator
;;;  b3..0	baud rate generator
;;; 	0000=16external clock
;;; 	0001=50 baud (crystal/36864)
;;; 	0010=75 baud (crystal/24576)
;;; 	0011=109.92 baud (crystal/16768)
;;; 	0100=134.58 baud (crystal/13696)
;;; 	0101=150 baud (crystal/12288)
;;; 	0110=300 baud (crystal/6144)
;;; 	0111=600 baud (crystal/3072)
;;; 	1000=1200 baud (crystal/1536)
;;; 	1001=1800 baud (crystal/1024)
;;; 	1010=2400 baud (crystal/768)
;;; 	1011=3600 baud (crystal/512)
;;; 	1100=4800 baud (crystal/384)
;;; 	1101=7200 baud (crystal/256)
;;; 	1110=9600 baud (crystal/192)
;;; 	1111=19200 baud (crystal/96)
;;; 
;;; Command register
;;; -initial state 00000010 by hardware reset; ---00010 by programmed reset
;;;  b7..5	parity check controls
;;; 	--0=parity disabled
;;; 	001=odd parity, receiver and transmitter
;;; 	011=even parity, receiver and transmitter
;;; 	101=mark parity transmitted, no parity check
;;; 	111=space parity transmitted, no parity check
;;;  b4	receiver mode
;;; 	0=normal
;;; 	1=echo
;;;  b3..2	transmitter controls
;;; 	00=transmit interrupt disabled, -RTS high
;;; 	01=transmit interrupt enabled, -RTS low
;;; 	10=transmit interrupt disabled, -RTS low
;;; 	11=tranmist interrupt disabled, -RTS low, transmit BRK
;;;  b1	receiver interrupt enable
;;; 	0=-IRQ interrupt enabled from b7 of status register
;;; 	1=-IRQ interrupt disabled
;;;  b0	data terminal ready
;;; 	0=-DTR high (disable receiver/transmitter)
;;; 	1=-DTR low (enable receiver/transmitter)
;;; 
;;; Status register
;;; -initial state 0--10000 by hardware reset; -----0-- by programmed reset
;;;  b7	interrupt (IRQ)
;;; 	0=no interrupt
;;; 	1=interrupt has occurred
;;;  b6	data set ready (-DSR)
;;; 	0=-DSR low (ready)
;;; 	1=-DSR high (not ready)
;;;  b5	data carrier detect (-DCD)
;;; 	0=-DCD low (detect)
;;; 	1=-DCD high (not detected)
;;;  b4	transmitter data register empty
;;; 	0=not empty
;;; 	1=empty
;;;  b3	receiver data register full
;;; 	0=not full
;;; 	1=full
;;;  b2	overrun
;;; 	0=no overrun
;;; 	1=overrun has occurred
;;;  b1	framing error
;;; 	0=no framing error
;;; 	1=framing error detected
;;;  b0	parity error
;;; 	0=no parity error
;;; 	1=parity error detected
