;;; @file c64net.s
;;; Transfer routines for the 2-bit/4-bit PET/VIC-20/C64/C128 to PC cable
;;; used by the 64NET software
;;; @author Marko Mkel (msmakela@nic.funet.fi)

	;; additional commands for info mode
#define infoinit
	;; initialize the cable
#define initcable
	;; deinitialize the cable
#define deinitcable
	;; determine whether a request is pending
#define isrequest lda data:and #$F8:eor #8:bne return:lda #7:sta data:sta ddr
	;; wait for negative handshake
#define wait_neg .(:wait bit data:bne wait:.)
	;; wait for positive handshake
#define wait_pos .(:wait bit data:beq wait:.)
	
	; .A = data, .Y = 00, .X preserved
receive_switch:
receive:
rereceive:
	lda #8
	wait_pos
	lda data	; get the high nibble
	and #$f0
	sta stemp
	lda #8
	sta data	; acknowledge (place 0 on PB2)
	wait_neg
	ldy #4
	lda data	; get the low nibble
	sty data	; acknowledge
	ldy #0
	lsr
	lsr
	lsr
	lsr
	ora stemp
	rts

	; .A trashed, .Y = 00, .X preserved
send_switch:	; switch to sending and send
send:
	tay
	.(
hs1	lda data	; initial handshaking
	and #$f8
	eor #$f0
	bne hs1
	.)
	lda #0
	sta data
	.(
hs2	lda data
	bne hs2
	.)
	tya
	ora #4
	sta data	; send the lowest bit pair
	lda #8
	wait_pos
	tya
	lsr
	lsr
	tay
	and #3
	sta data	; send the lowest bit pair but one
	lda #8
	wait_neg
	tya
	lsr
	lsr
	tay
	ora #4
	sta data	; send the highest bit pair but one
	lda #8
	wait_pos
	tya
	lsr
	lsr
	sta data	; send the highest bit pair
	lda #8
	wait_neg
	lda #4
	sta data
	ldy #0
	rts
