/*
	dsp/util.h
	
	Copyright 2002-4 Tim Goetze <tim@quitte.de>
	
	http://quitte.de/dsp/

	common math utility functions.

*/
/*
	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
	02111-1307, USA or point your web browser to http://www.gnu.org.
*/

#ifndef _DSP_UTIL_H_
#define _DSP_UTIL_H_

namespace DSP {

inline int next_power_of_2 (int n)
{
	assert (n <= 0x40000000);

	int m = 1;
	
	while (m < n)
		m <<= 1;

	return m;
}

/* courtesy of Andrew Simper (vellocet.com) */
inline float
exp2_approx (float x)
{
	long * px = (long *) (&x); // store address of float as long pointer
	const float tx = (x - .5f) + (3 << 22); // temporary value for truncation
	const long  lx = *((long *) &tx) - 0x4b400000; // integer power of 2
	const float dx = x - (float) (lx); // float remainder of power of 2
	x = 1.f + dx * (0.6960656421638072f + // cubic apporoximation of 2^x
						dx * (0.224494337302845f +  // for x in the range [0, 1]
						dx * (0.07944023841053369f)));
	*px += (lx << 23); // add integer power of 2 to exponent

	return x;
}

inline bool
isprime (int v)
{
	if (v <= 3)
		return true;
	
	if (!(v & 1))
		return false;

	for (int i = 3; i < (int) sqrt (v) + 1; i += 2)
		if ((v % i) == 0)
			return false;

	return true;
}

inline double 
db2lin (double db)
{
	return pow (10., db * .05);
}

inline double
lin2db (double lin)
{
	return 20. * log10 (lin);
}

} /* namespace DSP */

#endif /* _DSP_UTIL_H_ */
