
#include <qstatusbar.h>

#include "tracer.h"

#include "CamStreamApp.h"
#include "CodecImage.h"
#include "WebCamCodecSubband.h"

TR_MODULE("WebCamCodecSubband");

CWebCamCodecSubband::CWebCamCodecSubband(CVideoDevice *video, QWidget *parent, const char *name)
	: CCamWindow(parent, name)
{
   int r;
   QWidget *pWidget;
   QDomNode vconfig, node;
   QStatusBar *status;
   ///QSize s;

   TR_ENTER();
   m_pSourceViewer = 0;
   m_pDiffViewer = 0;
   m_pSubbandViewer = 0;
   m_pInverseViewer = 0;
   m_pReconstructedViewer = 0;
   m_CurrentFrame = 1;
   m_PreviousFrame = 0;
   m_MaxFrames = 2;
   m_pVideo = video;

   /* Get video configuration, set nodes in dialogs & devices */
   vconfig = g_pCamApp->FindVideoDeviceConfig(m_pVideo->GetIntfName(), m_pVideo->GetNodeName(), true);
   m_pVideo->SetConfiguration(vconfig.namedItem("settings"));

   r = m_pVideo->Open();
   if (r < 0) {
     qWarning("Error opening video device: %d.", r);
     TR_RETURN();
   }
   setCaption(m_pVideo->GetIntfName());
   ///s = m_pVideo->GetSize();

   m_pSizeTimer = new QTimer(this, "size timer");
   connect(m_pSizeTimer, SIGNAL(timeout()), this, SLOT(CallAdjustSize()));

   connect(m_pVideo, SIGNAL(Error(int)), this, SLOT(DeviceError(int)));

   /* Create an empty widget upon we place our viewer and other panels */
   pWidget = new QWidget(this, "empty widget");
   ASSERT(pWidget != NULL);
   pWidget->setBackgroundMode(QWidget::PaletteBase);
   pWidget->setSizePolicy(QSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed));
   setCentralWidget(pWidget);

   m_pSourceViewer = new CImagePanelYUV(m_pVideo, pWidget);
   if (m_pSourceViewer)
   {
     connect(m_pSourceViewer, SIGNAL(ChangedVisibleSize(const QSize &)), this, SLOT(DeviceChangedSize(const QSize &)));
   }
   m_pDiffViewer = new CCodecImageViewer(&m_Diff.Y, &m_Diff.U, &m_Diff.V, this, "diff image", WStyle_DialogBorder);
   m_pSubbandViewer = new CCodecImageViewer(&m_CodecSubband.Y, &m_CodecSubband.U, &m_CodecSubband.V, this, "diff subband");
   m_pInverseViewer = new CCodecImageViewer(&m_InverseSubband.Y, &m_InverseSubband.U, &m_InverseSubband.V, this, "inverse subband");
   m_pReconstructedViewer = new CCodecImageViewer(&m_Reconstructed.Y, &m_Reconstructed.U, &m_Reconstructed.V, this, "reconstructed");

   connect(m_pVideo, SIGNAL(FrameReady()), this, SLOT(VideoFrameReady()));
   /* Create statusbar */
   status = statusBar();

   RecalcTotalViewSize();
   TR_LEAVE();
}

CWebCamCodecSubband::~CWebCamCodecSubband()
{
   TR_ENTER();
   if (m_pVideo)
   {
     m_pVideo->Close();
   }
   delete m_pSourceViewer;
   m_pSourceViewer = 0;
   delete m_pDiffViewer;
   m_pDiffViewer = 0;
   TR_LEAVE();

}

// private

/** Put widget at center of cell */
void CWebCamCodecSubband::PutAtGrid(int row, int column, QWidget *w)
{
   if (w)
   {
     QSize s(m_CellWidth, m_CellHeight);

     s -= w->size();
     s /= 2;
     w->move(column * m_CellWidth + s.width(), row * m_CellHeight + s.height());
     w->show();
   }
}



// protected
void CWebCamCodecSubband::RecalcTotalViewSize()
{
   QSize asize, osize;
   int w, h;

   TR_ENTER();
   m_Cols = 3;
   m_Rows = 2;
   asize = m_pVideo->GetSize();
   w = asize.width();
   h = asize.height();
   m_CellWidth = w * 11 / 10; // small border
   m_CellHeight = h * 33 / 20; // compensate for UV fields

   m_Diff.Resize(w, h);
   m_CodecSubband.Resize(w, h);
   m_InverseSubband.Resize(w, h);
   m_Reconstructed.Resize(w, h);

   m_pDiffViewer->Resize();
   m_pSubbandViewer->Resize();
   m_pInverseViewer->Resize();
   m_pReconstructedViewer->Resize();

   PutAtGrid(0, 0, m_pSourceViewer);
   PutAtGrid(0, 1, m_pDiffViewer);
   PutAtGrid(0, 2, m_pReconstructedViewer);
   PutAtGrid(1, 0, m_pSubbandViewer);
   PutAtGrid(1, 2, m_pInverseViewer);

   asize.setWidth(m_Cols * m_CellWidth);
   asize.setHeight(m_Rows * m_CellHeight);
   ///osize = centralWidget()->size();
   osize = size();
   if (asize != osize) // Set new viewport only when necessary
     centralWidget()->setFixedSize(asize);
   /* Bug or feature? At this point I cannot call adjustSize(), probably
      because we are in an event loop or something. So therefor we
      (ab)use a single shot timer to call adjustSize() for us, just
      after all current events have been processed (timeout = 0).
    */
   m_pSizeTimer->start(0, true);
   TR_LEAVE();
}


// protected slots

void CWebCamCodecSubband::DeviceChangedSize(const QSize &size)
{
   // place widgets at new position
   TR_ENTER();
   RecalcTotalViewSize();
   TR_LEAVE();
}

void CWebCamCodecSubband::DeviceError(int err_no)
{
}

void CWebCamCodecSubband::CallAdjustSize()
{
   TR_ENTER();
   adjustSize();
   TR_LEAVE();
}

/** \brief Called when a new video frame is finished
*/
void CWebCamCodecSubband::VideoFrameReady()
{
   CVideoFrame *frame = 0;
   const QImage *y, *u, *v;

   m_PreviousFrame = m_CurrentFrame;
   m_CurrentFrame = (m_CurrentFrame + 1) % m_MaxFrames;
   frame = m_pVideo->GetLatestVideoFrame();
   if (frame != 0)
   {
     y = frame->GetY();
     m_SourceFrame[m_CurrentFrame].Y.Load(y->width(), y->height(), y->bits());
     u = frame->GetU();
     m_SourceFrame[m_CurrentFrame].U.Load(u->width(), u->height(), u->bits());
     v = frame->GetV();
     m_SourceFrame[m_CurrentFrame].V.Load(v->width(), v->height(), v->bits());

     m_Diff = m_SourceFrame[m_CurrentFrame] - m_SourceFrame[m_PreviousFrame];
     m_pDiffViewer->Update();

     //m_CodecSubbandY = m_CodecFrameY[m_CurrentFrame];
     //m_CodecSubbandY.Load(y->width(), y->height(), y->bits());
     m_CodecSubband.Y = m_Diff.Y;
     m_CodecSubband.U = m_Diff.U;
     m_CodecSubband.V = m_Diff.V;
     m_CodecSubband.Y.SubbandForward();
     m_CodecSubband.U.SubbandForward();
     m_CodecSubband.V.SubbandForward();
     m_pSubbandViewer->Update();
   }
   delete frame;
//   update();
}


// public

// public slots
