/**********************************************************************

	--- Qt Architect generated file ---

	File: NewViewer.cc
	Last generated: Sun Aug 13 17:52:46 2000

 *********************************************************************/

#include "NewViewer.h"

#define Inherited CNewViewerData

static int SizeTable[7][2] = {
  {   0,   0 },
  { 128,  96 },
  { 160, 120 },
  { 176, 144 },
  { 320, 240 },
  { 352, 288 },
  { 640, 480 },
};
  

CNewViewer::CNewViewer(CVideoCollector *coll, 
            QWidget* parent, const char* name)
	: Inherited( parent, name ),
	InitSize(0, 0)
{
   // Fill drop down box with detected video devices
   int i, m;
   CVideoDevice *pV;
   QString dname, t;
   
   pCollector = coll;
   if (pCollector) {
     m = pCollector->NumberOfVideoDevices();
     for (i = 0; i < m; i++) {
        pV = pCollector->GetVideoDevice(i);
        dname = pV->GetIntfName();
        if (dname.isNull())
          dname = pV->GetNodeName();
        DeviceSelection->insertItem(dname);
     }
   }
}


CNewViewer::~CNewViewer()
{
}

// protected

void CNewViewer::ClickedOnSize(int n)
{
   if (n >= 0 && n <= 6) {
     InitSize.setWidth(SizeTable[n][0]);
     InitSize.setHeight(SizeTable[n][1]);
   }
}


// public

CVideoDevice *CNewViewer::GetVideoDevice() const
{
   int n;
   
   if (pCollector) {
     n = DeviceSelection->currentItem();
     if (n >= 0 && n < pCollector->NumberOfVideoDevices())
       return pCollector->GetVideoDevice(n);
    }
   return NULL;
}

QSize CNewViewer::GetInitialSize() const
{
   return InitSize;
}
