<?/* 
+-------------------------------------------------------------------------+
| Copyright (C) 2002 Ian Berry                                            |
|                                                                         |
| This program is free software; you can redistribute it and/or           |
| modify it under the terms of the GNU General Public License             |
| as published by the Free Software Foundation; either version 2          |
| of the License, or (at your option) any later version.                  |
|                                                                         |
| This program is distributed in the hope that it will be useful,         |
| but WITHOUT ANY WARRANTY; without even the implied warranty of          |
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           |
| GNU General Public License for more details.                            |
+-------------------------------------------------------------------------+
| cacti: the rrdtool frontend [php-auth, php-tree, php-form]              |
+-------------------------------------------------------------------------+
| This code is currently maintained and debugged by Ian Berry, any        |
| questions or comments regarding this code should be directed to:        |
| - iberry@raxnet.net                                                     |
+-------------------------------------------------------------------------+
| - raXnet - http://www.raxnet.net/                                       |
+-------------------------------------------------------------------------+
*/?>
<?

function LogData($string) {
	include ('include/config.php');
	
	/* fill in the current date for printing in the log */
	$date = date("m/d/Y g:i A");
	
	/* echo the data to the log (append) */
	exec("echo '$date - $string' >> $path_log");
}

function GetCronPath($dsid) {
	include ("include/database.php");
	
	$sql_id = mysql_query("select d.id, d.srcid, 
		s.formatstrin, s.formatstrout
		from rrd_ds d 
		left join src s 
		on d.srcid=s.id 
		where d.id=$dsid",$cnn_id);
	
	if (mysql_num_rows($sql_id) != 0) {
		/* make the input string */
		$sql_id_field = mysql_query("select d.fieldid, d.dsid, d.value, 
			f.srcid, f.dataname
			from src_data d
			left join src_fields f
			on d.fieldid=f.id
			where d.dsid=" . mysql_result($sql_id, $i, "id") . "
			and f.srcid=" . mysql_result($sql_id, $i, "srcid"),$cnn_id);
		$rows_field = mysql_num_rows($sql_id_field); $i_field = 0;
		
		/* put the input string into a variable for easy access (r) */
		$str = mysql_result($sql_id, $i, "formatstrin");
		
		/* loop through each input field we find in the database and do a replace on
		each one accordingly. */
		while ($i_field < $rows_field) {
			$str = ereg_replace ("<" . mysql_result($sql_id_field, $i_field, "dataname") . ">", mysql_result($sql_id_field, $i_field, "value"),$str);
			
			$i_field++;
		}
		
		/* do a little path subsitution */
		$str = ereg_replace ("<path_cacti>", $path_cacti,$str);
		$str = ereg_replace ("<path_snmpget>", $config["path_snmpget"]["value"],$str);
		$str = ereg_replace ("<path_php_binary>", $config["path_php_binary"]["value"],$str);
		
		return $str;
	}
}

function GetDataSourceName($dsid) {
	include ("include/database.php");
	
	if ($dsid == 0) { return ""; }
	
	$sql_id = mysql_query("select name, dsname from rrd_ds where id=$dsid",$cnn_id);
	
	/* use the cacti ds name by default or the user defined one, if entered */
	if (mysql_result($sql_id, 0, "dsname") == "") {
		/* limit input to 19 characters */
		return CheckDataSourceName(mysql_result($sql_id, 0, "name"));
	}else{
		return mysql_result($sql_id, 0, "dsname");
	}
}

function GetDataSourceType($dstypeid) {
	include ("include/database.php");
	
	if ($dstypeid == 0) { return ""; }
	
	$sql_id = mysql_query("select name from def_ds where id=$dstypeid",$cnn_id);
	
	if (mysql_num_rows($sql_id) != 0) {
		return mysql_result($sql_id, 0, "name");
	}
	
	return "";
}

function GetDataSourcePath($data_source_id, $expand_paths) {
	include ("include/config.php");
	include ("include/database.php");
	
	if ($data_source_id == 0) { return ""; }
	
	$sql_id = mysql_query("select name, dspath from rrd_ds where id=$data_source_id",$cnn_id);
	
	if (mysql_num_rows($sql_id) != 0) {
		if (mysql_result($sql_id, 0, "dspath") == "") {
			/* no custom path was specified */
			$data_source_path = "<path_rra>/" . CheckDataSourceName(mysql_result($sql_id, 0, "name")) . ".rrd";
		}else{
			$pos = strpos(mysql_result($sql_id, 0, "dspath"),"/");
			
			/* make sure we represent the path correctly */
			if (is_string ($pos) && !$pos) {
				$data_source_path = "<path_rra>/" . mysql_result($sql_id, 0, "dspath");
			}else{
				$data_source_path = mysql_result($sql_id, 0, "dspath");
			}
		}
		
		/* whether to show the "actual" path or the <path_rra> variable name (for edit boxes) */
		if ($expand_paths == true) {
			$data_source_path = ereg_replace ("<path_rra>", $path_rra, $data_source_path);
		}
		
		return $data_source_path;
	}
}

function CheckDataSourceName($data_source_name) {
	$new_data_source_name = str_replace(" ","_",$data_source_name);
	$new_data_source_name = ereg_replace("[*]|[/]|[\]|[*]|[&]|[%]|[\"]|[\']|[,]|[.]","",$new_data_source_name);
	$new_data_source_name = substr($new_data_source_name,0,19);
	
	return strtolower($new_data_source_name);
}

function CleanUpName($string) {
	$new_string = ereg_replace("[ ]|[.]","_",$string);
	$new_string = ereg_replace("[*]|[/]|[\]|[*]|[&]|[%]|[\"]|[\']|[,]","",$new_string);
	
	return $new_string;
}

function CreateGraphDefName($graph_item_id) {
	$lookup_table = array("a","b","c","d","e","f","g","h","i","j");
	
	for($i=0; $i<strlen($graph_item_id); $i++) {
		$current_charcter = $graph_item_id[$i];
		$result .= $lookup_table[$current_charcter];
	}
	
	return $result;
}

function GetMultiCdefID($type, $value) {
	/* 	Type codes:
		3 - Total	 staggered datasources.
		5 - Average staggered datasources. */
	
	if ($type == 3 || $type == 5) {
		parse_str($value);
		return $start;
	}
	
	return "";
}

function GetGraphDefID($graph_item_id, $def_items) {
	$result = "";
	
	for($i=0; $i<sizeof($def_items); $i++) {
		if ($def_items[$i] == $graph_item_id) {
			$result = "345" . $i;
		}
	}
	
	if ($result == "") {
		$result = $graph_item_id;
	}
	
	return $result;
}


function SyncDataSourceName($data_source_id, $saved_custom_data_source_name, $saved_custom_data_source_path) {
	include ("include/database.php");
	
	/* get old data for comparison */
	if ($data_source_id != 0) {
		$sql_id = mysql_query("select dsname,dspath,name from rrd_ds where id=$data_source_id" ,$cnn_id);
		
		if (mysql_num_rows($sql_id) != 0) {
			$old_data_source_name = mysql_result($sql_id, 0, "name");
			$old_custom_data_source_path = mysql_result($sql_id, 0, "dspath");
			$old_custom_data_source_name = mysql_result($sql_id, 0, "dsname");
		}
	}
	
	$dsname = $saved_custom_data_source_name;
	$dspath = $saved_custom_data_source_path;
	
	/* only update the dspath if there isn't already one */
	if ($old_custom_data_source_path == "") {
		$dspath = GetDataSourcePath($data_source_id, false);
	}
	
	/* only update the dsname if there isn't already one */
	if ($old_custom_data_source_name == "") {
		$dsname = GetDataSourceName($data_source_id);
	}
	
	mysql_query("update rrd_ds set dsname=\"$dsname\", dspath=\"$dspath\" where id=$data_source_id", $cnn_id);
	
	/* find out if this DS has children; if it does, then write the dspath to each child */
	$sql_id = mysql_query("update rrd_ds set dspath=\"$dspath\" where subdsid=$data_source_id", $cnn_id);
}

function CreateList($dbid,$sql,$name,$value,$prev) {
	$res_id = mysql_query("$sql",$dbid);
	$rows = mysql_num_rows($res_id);
	$i = 0;
	
	while ($i < $rows) { ?>
		<option value="<? print mysql_result($res_id, $i, $value); ?>"<? 
		if ($prev == mysql_result($res_id, $i, $value)) { 
		?> selected <? } ?>><? print mysql_result($res_id, $i, $name); ?></option>
		<?$i++;
	}
}

function CreateMultipleList($dbid,$sql,$name,$value,$prevsql,$prevsqlvalue) {
	/* make sure you order by eqivilant columns in your sql strings!
	for instance: 'order by id', 'order by cfid'
	NOT: 'order by id', 'order by name'
	these values must line up! */
	$res_id = mysql_query("$sql order by $value",$dbid);
	$res_id_prev = mysql_query("$prevsql order by $prevsqlvalue",$dbid);
	$rows = mysql_num_rows($res_id);
	$rows_prev = mysql_num_rows($res_id_prev);
	$i = 0;$i_prev = 0;
	
	while ($i < $rows) {
		?><option value="<? print mysql_result($res_id, $i, $value); ?>"<?
		if ($i_prev < $rows_prev) {
			if (mysql_result($res_id_prev, $i_prev, $prevsqlvalue) == mysql_result($res_id, $i, $value)) {
				?> selected <? $i_prev++;
			}
		}
		?>><? print mysql_result($res_id, $i, $name);
		$i++;
		?></option><?
	}
}

function GetNextItem($dbid,$tblname,$field,$startid,$lmt_field,$lmt_val) {
	$sql_id = mysql_query("select max($field) from $tblname where $lmt_field=$lmt_val",$dbid);
	$end_seq = mysql_result($sql_id, 0, "max($field)");
	$sql_id = mysql_query("select $field from $tblname where id=$startid",$dbid);
	$start_seq = mysql_result($sql_id, 0, "$field");
	
	$i = $start_seq;
	if ($end_seq!=$start_seq) {
		while ($i < $end_seq) {
			$sql_id = mysql_query("select $field from $tblname where $field=$i+1 and $lmt_field=$lmt_val",$dbid);
			if (mysql_num_rows($sql_id)!=0) {
				return mysql_result($sql_id, 0, "$field");
			}
			
			$i++;
		}
	}
	return $start_seq;
}

function GetLastItem($dbid,$tblname,$field,$startid,$lmt_field,$lmt_val) {
	$sql_id = mysql_query("select min($field) from $tblname where $lmt_field=$lmt_val",$dbid);
	$end_seq = mysql_result($sql_id, 0, "min($field)");
	$sql_id = mysql_query("select $field from $tblname where id=$startid",$dbid);
	$start_seq = mysql_result($sql_id, 0, "$field");
	
	$i = $start_seq;
	if ($end_seq!=$start_seq) {
		while ($i > $end_seq) {
			$sql_id = mysql_query("select $field from $tblname where $field=$i-1 and $lmt_field=$lmt_val",$dbid);
			if ((mysql_num_rows($sql_id)!=0) && (mysql_result($sql_id, 0, "$field") != 0)) {
				return mysql_result($sql_id, 0, "$field");
			}
			
			$i--;
		}
	}
	return $start_seq;
}

function GetSequence($id, $field, $table_name, $gid, $gid_value) {
	include (dirname(__FILE__) . "/database.php");
	
	if ($id=="0") {
		$sql_id = mysql_query("select max($field)+1 as seq from $table_name where $gid=$gid_value",$cnn_id);
		if (mysql_result($sql_id, 0, "seq") == "") {
			return 1;
		}else{
			return mysql_result($sql_id, 0, "seq");
		}
	}else{
		$sql_id = mysql_query("select $field from $table_name where id=$id",$cnn_id);
		return mysql_result($sql_id, 0, $field);
	}
}

function LoadSettingsIntoArray($user_id, $guest_account) {
	//global "cactilogin";
	
	/* get settings, use guest account if there is no user cookie */
	$user_id = GetCurrentUserID($user_id, $guest_account);
	
	$sql_id = mysql_query("select * from settings_graphs where userid=$user_id");
	
	/* whether to revert to defaults or not */
	if ($user_id == "") {
		$use_default_settings = true;
	}else{
		if (mysql_num_rows($sql_id) == 0) {
			$use_default_settings = true;
		}
	}
	
	if ($use_default_settings == true) {
		/* use defaults */
		$array_settings["preview"]["height"] = 100;
		$array_settings["preview"]["width"] = 300;
		$array_settings["preview"]["timespan"] = 60000;
		$array_settings["preview"]["rraid"] = 1;
		$array_settings["preview"]["columnnumber"] = 2;
		$array_settings["preview"]["pagerefresh"] = 300;
		$array_settings["list"]["listviewtype"] = 1;
		$array_settings["hierarchical"]["viewtype"] = 1;
	}else{
		$array_settings["preview"]["height"] = mysql_result($sql_id, 0, "height");
		$array_settings["preview"]["width"] = mysql_result($sql_id, 0, "width");
		$array_settings["preview"]["timespan"] = mysql_result($sql_id, 0, "timespan");
		$array_settings["preview"]["rraid"] = mysql_result($sql_id, 0, "rraid");
		$array_settings["preview"]["columnnumber"] = mysql_result($sql_id, 0, "columnnumber");
		$array_settings["preview"]["pagerefresh"] = mysql_result($sql_id, 0, "pagerefresh");
		$array_settings["list"]["listviewtype"] = mysql_result($sql_id, 0, "listviewtype");
		$array_settings["hierarchical"]["viewtype"] = mysql_result($sql_id, 0, "viewtype");
		$array_settings["hierarchical"]["treeid"] = mysql_result($sql_id, 0, "treeid");
	}
	
	return $array_settings;
}

function GetCurrentUserID($user_id, $guest_account) {
	if (($user_id == "") || ($user_id == 0)) {
		$sql_id = mysql_query("select id from auth_users where username=\"$guest_account\"");
		
		if (mysql_num_rows($sql_id) != 0) {
			$user_id = mysql_result($sql_id, 0, "id");
		}
	}
	
	return $user_id;
}

function ParseDelimitedLine($str,$delimiter) {
	if ($delimiter == "") {
		$fill_array[0] = $str;
		return $fill_array;
	}else{
		$fill_array = explode($delimiter, $str);
		return $fill_array;
	}
}

function exec_into_array($command_line) {
	exec($command_line,$out,$err);
	
	for($i=0; list($key, $value) = each($out); $i++) {
		$command_array[$i] = $value;
	}
	
	return $command_array;
}

function convert_mac_address($mac_address) {
	return strtolower(str_replace(" ", ":", $mac_address));
}

function hex2bin($data) {
    $len = strlen($data);
	
    for($i=0;$i<$len;$i+=2) {
        $newdata .=  pack("C",hexdec(substr($data,$i,2)));
    }
	
    return $newdata;
}

function BuildGraphTitleFromSNMP($graph_parameters) {
	include ("include/database.php");
	
	$sql_id = mysql_query("select * from snmp_hosts_interfaces where id=" . $graph_parameters["snmp_interface_id"], $cnn_id);
	
	if (mysql_num_rows($sql_id) != 0) {
		$graph_parameters["unparsed_graph_title"] = str_replace("<data_source_name>", $graph_parameters["data_source_name"], $graph_parameters["unparsed_graph_title"]);
		$graph_parameters["unparsed_graph_title"] = str_replace("<snmp_description>", mysql_result($sql_id, $i, "description"), $graph_parameters["unparsed_graph_title"]);
		$graph_parameters["unparsed_graph_title"] = str_replace("<snmp_interface_number>", mysql_result($sql_id, $i, "interfacenumber"), $graph_parameters["unparsed_graph_title"]);
		$graph_parameters["unparsed_graph_title"] = str_replace("<snmp_interface_speed>", mysql_result($sql_id, $i, "speed"), $graph_parameters["unparsed_graph_title"]);
		$graph_parameters["unparsed_graph_title"] = str_replace("<snmp_hardware_address>", mysql_result($sql_id, $i, "hardwareaddress"), $graph_parameters["unparsed_graph_title"]);
		$graph_parameters["unparsed_graph_title"] = str_replace("<snmp_ip_address>", mysql_result($sql_id, $i, "ipaddress"), $graph_parameters["unparsed_graph_title"]);
	}
	
	return $graph_parameters["unparsed_graph_title"];
}

?>
