#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <ctype.h>
#include <string.h>
#include "list.h"

List CFG;

int
ReadCFGFile (char *filename)
{
  FILE *fp;
  char *buf;
  char *line;
  char *value;
  Ptrnode p = NULL;
  elementT key;

  CFG = NewList ();
  p = HeaderList (CFG);

  buf = malloc (255);

  if ((fp = fopen (filename, "r")) == NULL)
    {
      perror ("fopen (parsecfg.c:15)");
      exit (EXIT_FAILURE);
    }

  while (fgets (buf, 255, fp) != NULL)
    {
      line = buf;

      while (isspace ((int) *line))
	line++;

      while ((strlen (line) > 0) && isspace ((int) line[strlen (line) - 1]))
	line[strlen (line) - 1] = '\0';

      if ((*line == '\n') || (*line == '\0') || (*line == '#'))
	continue;

      if ((strchr (line, '=') != NULL))
	{
	  value = strchr (line, '=');
	  *value = '\0';
	  value++;

	  while (isspace ((int) *value))
	    value++;

	  while ((strlen (line) > 0)
		 && isspace ((int) line[strlen (line) - 1]))
	    line[strlen (line) - 1] = '\0';

	  key = malloc (sizeof (element));
	  strcpy (key->jid, "CFG-FILE");
	  strcpy (key->name, line);
	  strcpy (key->resource, value);
	  strcpy (key->group, "CFG-FILE");
	  key->connected = -1;
	  InsertInList (key, p, CFG);
	  p = NextInList (p);

	  continue;
	}
      fprintf (stderr, "CFG: orphaned line \"%s\"\n", line);
    }
  return 1;
}

char *
CFGRead (char *key)
{
  Ptrnode p;
  elementT tkey;

  p = FirstInList (CFG);
  while (p != NULL)
    {
      tkey = RetrieveFromList (p);
      if (!strcmp (tkey->name, key))
	return tkey->resource;
      p = NextInList (p);
    }
  return NULL;
}
