# RPM spec file for C->Haskell                                   -*-rpm-spec-*-
#
# Copyright [1999..2005] Manuel M T Chakravarty <chak@cse.unsw.edu.au>
# Copyright 2003         Jens Petersen <petersen@haskell.org>

Summary: C->Haskell Interface Generator
Name: c2hs
Version: 0.14.3
Release: SNAP
Copyright: GPL
Group: Development/Tools
Source: http://www.cse.unsw.edu.au/~chak/haskell/c2hs/c2hs-%{version}.tar.gz
URL: http://www.cse.unsw.edu.au/~chak/haskell/c2hs/
BuildRoot: /var/tmp/c2hs-%{version}-%{release}-root
Packager: Manuel M T Chakravarty <chak@cse.unsw.edu.au>
Requires: @REQUIRES_HASKELL@

%description
C->Haskell is an interface generator that simplifies the development
of Haskell bindings to C libraries.  The tool processes existing C
header files that determine data layout and function signatures on the
C side in conjunction with Haskell modules that specify Haskell-side
type signatures and marshaling details.  Hooks embedded in the Haskell
code signal access to C structures and functions -- they are expanded
by the interfacing tool in dependence on information from the
corresponding C header file.

Haskell 98 is "the" standard lazy functional programming language.
More info plus the language definition is at http://www.haskell.org/.

%package doc
Summary: C->Haskell Interface Generator Documentation
Group: Development/Languages/Haskell

%description doc
C->Haskell is an interface generator that simplifies the development
of Haskell bindings to C libraries.  The tool processes existing C
header files that determine data layout and function signatures on the
C side in conjunction with Haskell modules that specify Haskell-side
type signatures and marshaling details.  Hooks embedded in the Haskell
code signal access to C structures and functions -- they are expanded
by the interfacing tool in dependence on information from the
corresponding C header file.

Haskell 98 is "the" standard lazy functional programming language.
More info plus the language definition is at http://www.haskell.org/.

This package contains the c2hs documentation.

%changelog
* Fri Jul 15 2005 Manuel Chakravarty
- No separate library
- New build system

* Wed Oct 15 2003 Jens Petersen <petersen@haskell.org>
- specify ghc version to build with
- don't redundantly provide c2hs
- separate library out into separate ghc version specific subpackage
- put docs into separate subpackage
- disable empty debuginfo subpackage generation
- remove buildroot before installing
- remove installed doc files, since they're explicitly listed

* Sat Sep 7 2002 Manuel Chakravarty
- add post install and uninstall scripts to register and deregister the 
  package with GHC
- fixed docu packaging

* Tue Mar 12 2002 Manuel Chakravarty
- require a specific Haskell compiler (namely, the one for which the packages 
  was compiled)

* Sun Oct 31 1999 Manuel Chakravarty
- original version

# the debuginfo subpackage is currently empty anyway, so don't generate it
%define debug_package %{nil}
%define __spec_install_post /usr/lib/rpm/brp-compress

%prep
%setup -q

%build
./Setup.hs configure --with-compiler=ghc-%{ghc_version}
./Setup.hs build
make doc

%install
rm -rf %{buildroot}
./Setup.hs install
make install-doc
rm -r %{buildroot}%{_datadir}/doc/c2hs-%{version}

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%{_bindir}/c2hs
%{_libdir}/c2hs-%{version}/
# man page is out of date
# %{_mandir}/man1/c2hs.1*

%files doc
%defattr(-,root,root)
%doc c2hs/ChangeLog c2hs/TODO c2hs/COPYING
%doc c2hs/README c2hs/AUTHORS
%doc doc/c2hs/*.html doc/c2hs/*.txt doc/c2hs/lib c2hs/tests
