# Copyright (C) 2005 Aaron Bentley
# <aaron@aaronbentley.com>
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import sys
import datetime
from bzrlib.progress import ProgressBar

class Progress(object):
    def __init__(self, units, current, total=None):
        self.units = units
        self.current = current
        self.total = total

    def _get_percent(self):
        if self.total is None:
            return None
        return 100.0 * self.current / self.total

    percent = property(_get_percent)

    def __str__(self):
        if self.total is not None:
            return "%i of %i %s %.1f%%" % (self.current, self.total, self.units,
                                         self.percent)
        else:
            return "%i %s" (self.current, self.units)

def show_progress(pi, prog):
    pi.update(prog.units, prog.current, prog.total)

def clear_progress_bar():
    sys.stderr.write('\r%s\r' % (' '*79))
