#! /usr/bin/env python

# bug-triage -- bug triage and forward tool.
# Copyright (C) 2007  Gustavo R. Montesino
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

from distutils.core import setup

setup(name = "bug-triage",
      version = "0.2.2",
      description = "Bug Triage and Forward Tool",
      author = "Gustavo R. Montesino",
      author_email = "grmontesino@gmail.com",
      license = "GPL",
      url = "http://bug-triage.alioth.debian.org/",
      package_dir = {"" : "src/lib/"},
      py_modules = ["bt_exceptions", "actions"],
      packages = ["config", "ui", "ui.gtk"],
      package_data = {"config" : ["data/*"], "ui.gtk" : ["data/*.glade"]},
      data_files = [("share/applications", ["bug-triage.desktop"])],
      scripts = ["src/bug-triage"]
      )
