/********************************************************************
 * Copyright (C) 2005 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BsC (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/
#ifndef INCLUDED_FTPSERVERINFO_H
#define INCLUDED_FTPSERVERINFO_H

#ifndef INCLUDED_QSTRING_H
#include <qstring.h>
#define INCLUDED_QSTRING_H
#endif // INCLUDED_QSTRING_H

class FtpServerInfo
{
public:
	FtpServerInfo()
	: d_name( "" )
	, d_addr( "" )
	, d_port( 21 )
	, d_dir ( "/" )
	, d_user( "" )
	, d_pass( "" )
	, d_ssl ( FALSE )
	{}
	FtpServerInfo( const QString& in_name,
						const QString& in_addr,
						const int      in_port,
						const QString& in_dir,
						const QString& in_user,
						const QString& in_pass,
						const bool     in_ssl )
	: d_name( in_name )
	, d_addr( in_addr )
	, d_port( in_port )
	, d_dir ( in_dir  )
	, d_user( in_user )
	, d_pass( in_pass )
	, d_ssl ( in_ssl  )
	{}
	FtpServerInfo& operator=( const FtpServerInfo& rhs )
	{
		if( this != &rhs ) {
			d_name = rhs.d_name;
			d_addr = rhs.d_addr;
			d_port = rhs.d_port;
			d_dir  = rhs.d_dir;
			d_user = rhs.d_user;
			d_pass = rhs.d_pass;
			d_ssl  = rhs.d_ssl;
		}
		return *this;
	}
	FtpServerInfo( const FtpServerInfo& rhs )
	{
		if( this != &rhs ) {
			d_name = rhs.d_name;
			d_addr = rhs.d_addr;
			d_port = rhs.d_port;
			d_dir  = rhs.d_dir;
			d_user = rhs.d_user;
			d_pass = rhs.d_pass;
			d_ssl  = rhs.d_ssl;
		}
	}
	void clear()
	{
		d_name = "";
		d_addr = "";
		d_port = 21;
		d_dir  = "/";
		d_user = "";
		d_pass = "";
		d_ssl  = FALSE;
	}
	void set_name( const QString& in_name ) { d_name = in_name; }
	void set_addr( const QString& in_addr ) { d_addr = in_addr; }
	void set_port( const int in_port      ) { d_port = in_port; }
	void set_dir ( const QString& in_dir  ) { d_dir  = in_dir;  }
	void set_user( const QString& in_user ) { d_user = in_user; }
	void set_pass( const QString& in_pass ) { d_pass = in_pass; }
	void set_ssl ( const bool in_ssl      ) { d_ssl  = in_ssl;  }
	
	const QString& name() const { return d_name; }
	const QString& addr() const { return d_addr; }
	const int      port() const { return d_port; }
	const QString& dir () const { return d_dir;  }
	const QString& user() const { return d_user; }
	const QString& pass() const { return d_pass; }
	const bool     ssl () const { return d_ssl;  }

// ******* MEMBERS *******
private:
	QString d_name;
	QString d_addr;
	int     d_port;
	QString d_dir;
	QString d_user;
	QString d_pass;
	bool    d_ssl;
};

#endif // INCLUDED_FTPSERVERINFO_H
