/********************************************************************
 * Copyright (C) 2005 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BsC (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/
#ifndef INCLUDED_COPYDIALOG_H
#define INCLUDED_COPYDIALOG_H

/*------- include files:
-------------------------------------------------------------------*/
#ifndef INCLUDED_QDIALOG_H
#include <qdialog.h>
#define INCLUDED_QDIALOG_H
#endif // INCLUDED_QDIALOG_H

/*------- forward declarations:
-------------------------------------------------------------------*/
class InfoField;
class QVBoxLayout;
class QHBoxLayout;
class QProgressBar;
class QCheckBox;
class QPushButton;
class QGroupBox;
class QFrame;
class QGridLayout;
class QLabel;

/*------- class declaration:
-------------------------------------------------------------------*/
class CopyDialog : public QDialog
{
    Q_OBJECT

// ******* CONSTRUCTION/DESTRUCTION *******
public:
    CopyDialog( QWidget*, bool );
private:
    CopyDialog( const CopyDialog& );
    CopyDialog& operator=( const CopyDialog& );

// ******* CONSTANTS *******
private:
    static const int         ProgressMinSize;
    static const char* const BoxInfoTitle;
    static const char* const SrcLabel;
    static const char* const DstLabel;
    static const char* const BoxProgressTitle;
    static const char* const RemoveLabel;
    static const char* const OpenReadError;
    static const char* const OpenWriteError;
    static const char* const FtpCaption;
    static const char* const LfsCaption;
// ******* MEMBERS *******
private:
    QVBoxLayout*  const d_main_layout;
    QGroupBox*    const d_info_box;
    QFrame*       const d_info_frm;
    QGridLayout*  const d_info_grid;
    QLabel*       const d_src_info_lbl;
    QLabel*       const d_dst_info_lbl;
	InfoField*    const d_src_info;
	InfoField*    const d_dst_info;
    QGroupBox*    const d_progress_box;
    QProgressBar* const d_progress_bar;
    QHBoxLayout*  const d_btn_layout;
protected:
    QCheckBox*    const d_remove_cb;
   	QPushButton*  const d_left_btn;
	QPushButton*  const d_right_btn;
private:
	InfoField*    const d_status;
protected:
    const QString       d_caption;

// ******* METHODS *******
private:
    void polish                 ();
protected:
    void runned                 ();
    void display_info           ( const QString&, const QString& );
    void set_status             ( const QString& );
    void set_progress           ( int );
    void set_progress           ( int, int );
    void set_total_progress     ( int );
    void reset_progress         ();
    void read_open_error        ( const QString& );
    void write_open_error       ( const QString& );
};

#endif // INCLUDED_COPYDIALOG_H
