/********************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/

/*------- include files:
-------------------------------------------------------------------*/
#include "About.h"
#include "Shared.h"
#include "Busy.h"
#include "Config.h"
#include <qfile.h>
#include <qlabel.h>
#include <qtabbar.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qtextstream.h>
#include <qapplication.h>
#include <qwidgetstack.h>
#include <qtextbrowser.h>
#include <qdesktopwidget.h>

/*------- local constants:
-------------------------------------------------------------------*/
const QString About::CAPTION           = QT_TR_NOOP( "About Beesoft Commander" );
const QString About::TAB_ABOUT_LABEL   = QT_TR_NOOP( "&About" );
const QString About::TAB_AUTHORS_LABEL = QT_TR_NOOP( "A&uthors" );
const QString About::TAB_LICENCE_LABEL = QT_TR_NOOP( "&Licence agreement" );

const QString About::ABOUT[] = {
	Shared::ProgramName + ", ver." + Shared::ProgramVersion,
	"(c) 2005, 2006 Piotr Pszczolkowski",
	"www.beesoft.org/bsc.html"
};
const QString About::AUTHORS [] = {
	QT_TR_NOOP( "<b><font color=blue>Project home page: www.beesoft.org</font></b>" ),
	"\n",
	QT_TR_NOOP( "<b>Piotr Pszczolkowski - piotr@beesoft.org</b>" ),
	QT_TR_NOOP( "\tProject administrator" ),
	QT_TR_NOOP( "\tProgramming" ),
	" ",
	QT_TR_NOOP( "<b>Translators:<b>" ),
	"\tJan Petrik (Czech Republic - Czech translation)",
	"\tAlexey V. Schentzev (AShen) (Novorossiysk, Russia - Russian translation)",
	"\tJavier Gutierrez Canas (Spain - Spanish translation)",
};

//*******************************************************************
// About
//*******************************************************************
About::About( QWidget* const parent )
: QDialog        ( parent )
, d_return_button( new QPushButton( tr(Shared::CloseBtnLabel), this ))
, d_widget_stack ( new QWidgetStack( this ))
, d_tab_bar      ( new QTabBar( this ))
{
	setCaption( CAPTION );
	setFont( Config::instance()->lfs_default_font() );
	
	QVBoxLayout* const main_layout = new QVBoxLayout( this );
	if( main_layout ) {
		main_layout->setMargin( Shared::LayoutMargin  );
		main_layout->setSpacing( Shared::LayoutSpacing );

		QLabel* const label = new QLabel( "<h1><font color= red>" + Shared::ProgramName + "</font></h1>", this );
		if( label ) {
			label->setAlignment( Qt::AlignHCenter | Qt::AlignVCenter );
			main_layout->addWidget( label );
		}
		
		/* Srodkowa czesc dialogu zawierajaca informacje o programie. */
		QVBoxLayout* const info_layout = new QVBoxLayout;
		if( info_layout ) {
			main_layout->addLayout( info_layout );
			main_layout->setStretchFactor( info_layout, Shared::OverStretch );

			d_tab_bar->setShape( QTabBar::TriangularAbove );
			
			d_tab_bar->addTab( new QTab( tr(TAB_ABOUT_LABEL) ));
			d_tab_bar->addTab( new QTab( tr(TAB_AUTHORS_LABEL) ));
			d_tab_bar->addTab( new QTab( tr(TAB_LICENCE_LABEL) ));
			
			connect( d_tab_bar, SIGNAL( selected( int ) ), this, SLOT( set_current_tab( int )));
			info_layout->addWidget( d_tab_bar );
			
			QTextBrowser* const about_browser = new QTextBrowser( this );
			set_about_text( about_browser );
			d_widget_stack->addWidget( about_browser, 0 );

			QTextBrowser* const authors_browser = new QTextBrowser( this );
			set_authors_text( authors_browser );
			d_widget_stack->addWidget( authors_browser, 1 );
			
			QTextBrowser* const licence_browser = new QTextBrowser( this );
			set_licence_text( licence_browser );
			d_widget_stack->addWidget( licence_browser, 2 );

			info_layout->addWidget( d_widget_stack );
		}
		
		/* Dolna czesc dialogu zawierajaca po prawej stronie */
		/* przycisk konczacy prace.                          */
		QHBoxLayout* const button_layout = new QHBoxLayout;
		if( button_layout ) {
			main_layout->addLayout( button_layout );
			
			button_layout->addStretch( Shared::OverStretch );
			button_layout->addWidget( d_return_button );
			Shared::add_icon( d_return_button, Shared::CloseIcon );
			connect( d_return_button, SIGNAL( clicked() ), this, SLOT( accept() ));
		}
	}
}
// end of About

//*******************************************************************
// set_about_text                                            PRIVATE
//*******************************************************************
void About::set_about_text( QTextBrowser* const browser )
{
	const int N = sizeof( ABOUT ) / sizeof( ABOUT[0] );
	for( int i = 0; i < N; ++i ) {
		browser->append( tr(ABOUT[i]) );
	}
}
// end of set_about_text

//*******************************************************************
// set_authors_text                                          PRIVATE
//*******************************************************************
void About::set_authors_text( QTextBrowser* const browser )
{
	const int N = sizeof( AUTHORS ) / sizeof( AUTHORS[0] );
	for( int i = 0; i < N; ++i ) {
		browser->append( tr(AUTHORS[i]) );
	}
}
// end of set_authors_text

//*******************************************************************
// set_licence_text                                          PRIVATE
//*******************************************************************
void About::set_licence_text( QTextBrowser* const browser )
{
	QString location = qApp->applicationDirPath();
	if( "/usr/bin" == location ) {
		location = "/usr/share/bsc";
	}
	QFile file( location + "/" + Shared::LicenceFileName );

	if( TRUE == file.open( IO_ReadOnly )) {
		QTextStream ts( &file );
		Busy::set_busy( TRUE );
		browser->setText( ts.read() );
		Busy::set_busy( FALSE );
		file.close();
	}
}
// end of set_licence_text

//*******************************************************************
// set_current_tab                                      PRIVATE slot
//*******************************************************************
void About::set_current_tab( const int idx )
{
	d_widget_stack->raiseWidget( idx );
}
// end of set_current_tab

//*******************************************************************
// polish                                                    PRIVATE
//*******************************************************************
void About::polish()
{
	Shared::polish( this, 40, 30 );
}
// end of polish
