#ifndef _SYSTEMITERATOR_H_
#define _SYSTEMITERATOR_H_

//
// usage:
//
// gi = new SystemIterator(_editor);  // respects left and right positions
//
// for (SystemIterator gi = SystemIterator(_editor); !gi.done(); gi++) {
//   draw(gi);
// }
//
//
//
//
//
//


#include "position.h"
#include "iterator.h"
#include "table.h"
#include "scoreBar.h"

class PrPartEditor;
class PrScoreEditor;
class Track;
class Part;
class Event;
class Note;
class Tuplet;

class SystemIterator : public Iterator
{
 private:
  PrScoreEditor * _editor;
  ScoreType _score_type;
  Table     _system;
  int       _ptr;
  int       _max;
  int       _res;
  bool      _no_overlap;
  double    _scale;
  int       _width;
  Part *    _active_part;
  struct InitState * state;
  bool      adjust;
  Position  notepos;
  void add(Event * ev, long dur=0, int dis=0, Position pos=0);
  void splitAndAdd(int, Tuplet *, Tuplet *);
  void nextbar();
  bool reallyDone(Tuplet*);
  Position truncEnd(Note * note);

 public:
  SystemIterator(const SystemIterator& i);

  // SystemIterator(ScoreType sctype, Track * track, int editorwidth, int ressolution = 96, bool nooverlap = true, Position left = 0, Position right = 0);

  SystemIterator(ScoreType sctype, Track * track, PrScoreEditor * editor, Part * activepart, long lpos=-1, long rpos=-1);

  SystemIterator(Part * part, int editorwidth, int ressolution = 96, bool nooverlap = true, Position left = 0, Position right = 0);

  SystemIterator(PrPartEditor * editor);

  ~SystemIterator();

  /** creates the System from the events
   */
  void init();

  virtual bool done() const;

  int size() const { return _system.size(); }

  Element * operator *();

  Iterator& operator++();

  Iterator operator++(int);

};

#endif
