#ifndef _TEXTFACTORY_CPP_
#define _TEXTFACTORY_CPP_

#include <dlfcn.h>
#include <iostream.h>

#include "prFactory.h"

#include "textMainEditor.h"
#include "textFactory.h"
#include "textTrack.h"
#include "textScorePainter.h"

extern "C" {
  PrFactory * libBrahmsTextPresentation() { return new TextFactory(); }
}


TextFactory::~TextFactory() {
	delete dispatcher;
}

PrMainEditor * TextFactory::createMainEditor(int argc, char** argv) {
  dispatcher = new Arts::Dispatcher();
  return new TextMainEditor(argc, argv);
}

PrTrack * TextFactory::createScoreTrack(Track * tr) {
  TextTrack * texttr = 0; // new TextScoreTrack(tr);
  return texttr;
}

PrTrack * TextFactory::createDrumTrack(Track * tr) {
  TextTrack * texttr = 0; // new TextDrumTrack(tr);
  return texttr;
}

PrTrack * TextFactory::createMasterTrack(Track * tr) {
  TextTrack * texttr = 0; // new TextMasterTrack(tr);
  return texttr;
}

PrTrack * TextFactory::createAudioTrack(Track * tr) {
  TextTrack * texttr = 0; // new TextAudioTrack(tr);
  return texttr;
}

PrTrack * TextFactory::createCommentTrack(Track * tr) {
  TextTrack * texttr = 0; // new TextCommentTrack(tr);
  return texttr;
}

PrPart * TextFactory::createPart(Part * pt) {
  return 0;
}

PrScorePainter * TextFactory::getScorePainter() {
  if (scorePainter==0) scorePainter = new TextScorePainter();
  return scorePainter;
}


#endif
