#ifndef _QTSCOREADDONS_C_
#define _QTSCOREADDONS_C_

// #include "globalEnums.h"
#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <fstream.h>
#include <math.h>

#include "qtScoreAddons.h"
#include "kdeScoreEditor.h"
//#include "kbExp.h"
//#include "kbBow.h"
//#include "kbLyrics.h"
//#include "kbStem.h"
#include <qpainter.h>
#include <qpixmap.h>

#include "reference.h"
#include "table.h"
#include "bow.h"
#include "lyrics.h"
#include "expression.h"
#include "stem.h"
#include "vector.h"

extern Table * selectioN;

// ***************************************************************************
// *
// *  Global Stuff
// *  ************
// *

extern bool colorchan;
//extern QColor chancolor[16];

//extern QPixmap noteAccent[21];
//extern QPixmap scoreSymbol[33];

extern int scrSigns[8];

extern QPixmap * imgNotePtr;
extern QPixmap * imgSignPtr;
extern QPixmap * imgFlagPtr;
extern QPixmap * imgBreakPtr;
extern QPixmap * imgNoteAccentPtr;
extern QPixmap * imgScoreSymbolPtr;

extern int sharpTab[];
extern int flatTab[];
extern int signShift[];
extern int invPitch[];
extern int sign[];
extern int enhF[5][12];
extern int enhS[5][12];
extern int yClef[];
extern int noteTab[];
extern int freqTab[];
extern int allSigns[15][7];


int b2tex[] = { 0,0,0,0,0,0,0,0,0,0,0,0,
                0,0,0,0,0,0,0,0,0,0,0,0,
                0,0,0,0,0,0,0,0,0,'A','A','B',
		'C','C','D','D','E','F','F','G','G','H','H','I',
		'J','J','K','K','L','M','M','N','N','a','a','b',
		'c','c','d','d','e','f','f','g','g','h','h','i',
		'j','j','k','k','l','m','m','n','n','o','o','p',
		'q','q','r','r','s','t','t','u','u','v','v','w',
		'x','x','y','y','z'};
		
int sign2tex[] = { '<', '_', '=', '^', '>', '=' };

int y2tex[] = { 'z','y','x','w','v','u','t',
		's','r','q','p','o','n','m',
		'l','k','j','i','h','g','f',
		'e','d','c','b','a','N','M',
		'L','K','J','I','H','G','F',
		'E','D','C','B','A',
		'A','A','A','A','A','A','A','A','A','A','A','A','A'};

int y2mup[] = { 'e','d','c','b','a','g','f' };


extern int globalStaffCounter;

MupPhrase * mupPhrase = 0;
MupLyrics * mupLyrics = 0;

void texBar() {
  if (globalStaffCounter==0) cout << "\\bar" << endl;
  else cout << "&" << endl;
}

/*
enum {
  NS_STACCATO, NS_LEGATO, NS_ACCDOWN, NS_ACCUP, NS_ACCENT1, NS_ACCENT2, NS_ACCENT3, NS_ACCENT4,
  NS_ACCENT5, NS_ACCENT6, NS_ACCENT7, NS_ACCENT8, NS_ACCENT9, NS_ACCENT10, NS_ACCENT11, NS_TRILLER,
  NS_TRILL1, NS_TRILL2, NS_INF, NS_BOWUP, NS_BOWDOWN };

enum {
  AS_LABEL1, AS_LABEL2, AS_LABEL3, AS_CASE1, AS_CASE2, AS_PEDAL1, AS_PEDAL2, AS_NOTEDOT,
  AS_NOTE3, AS_NOTE6, AS_NOTEXX, AS_8VA, AS_15VA, AS_TRILLX, AS_TRILLX2, AS_DECRESCENDO,
  AS_CRESCENDO, AS_BRACKETUP, AS_BRACKETDOWN, AS_ARPEGGIO, AS_TEXT,
  DYN_PPP, DYN_PP, DYN_P, DYN_MP, DYN_MF, DYN_F,
  DYN_FF, DYN_FFF, DYN_SFZ, DYN_SF, DYN_SFF, DYN_FP };
*/

// ***************************************************************************
// *
// *  MupPhrase
// *  *********
// *

MupPhrase::MupPhrase(Position st, int len, Part * m, int m0, int m1) : start(st), end(st+len), next(0), master(m), met0(m0), met1(m1) {
  help = new char[160];
  // cout << "s: " << start.gPosTicks() << ", len: " << len << ", end: " << end.gPosTicks() << endl; 
}

MupPhrase::~MupPhrase() {
  delete help;
}

char * MupPhrase::Range() {
  int s_bar; int s_beat; int s_tick; int s_m0 = met0; int s_m1 = met1;
  start.gBBT(s_bar,s_beat,s_tick,master,s_m0,s_m1,true);

  double sFrac =  s_tick*s_m1/1536.0;
  double sValue = s_beat + sFrac;

  int e_bar; int e_beat; int e_tick; int e_m0 = met0; int e_m1 = met1;
  end.gBBT(e_bar,e_beat,e_tick,master,e_m0,e_m1,true);

  double eFrac =  e_tick*e_m1/1536.0;
  double eValue = e_beat + eFrac;

  int mdiff = e_bar - s_bar;

  // cout << s_bar << "." << s_beat << "." << s_tick << endl;
  // cout << e_bar << "." << e_beat << "." << e_tick << endl;


  if (mdiff==0) sprintf(help,"%.4f til %.4f",sValue,eValue);
  else          sprintf(help,"%.4f til %dm + %.4f",sValue,mdiff,eValue);
  // cout << "help:" << help << endl;
  return help;
}

MupPhrase * MupPhrase::Next() {
  return next;
}

void MupPhrase::append(MupPhrase * mp) {
  if (next==0) next = mp;
  else next->append(mp);
}


// ***************************************************************************
// *
// *  MupLyrics
// *  *********
// *

MupLyrics::MupLyrics(int l, int d, const char * str) : cli(l), dot(d), next(0), lyrics((char*)strdup(str)) {
  help = new char[160];
}

MupLyrics::~MupLyrics() {
  delete help;
  delete lyrics;
}

char * MupLyrics::lengths() {
  //int cli =  10-int(1.000001*log(len/3)/log(2)); // 1 = 1, 2 = 1/2, 3 = 1/4, 4 = 1/8, 5 = 1/16, etc.
  //int dot = DOT(len);

  /*
  switch (cli) {
  case 1: out << "1"; break;
  case 2: out << "2"; break;
  case 3: out << "4"; break;
  case 4: out << "8"; break;
  case 5: out << "16"; break;
  case 6: out << "32"; break;
  case 7: out << "64"; break;
  }
  for (int i=0;i<dot;i++) out << ".";
  */

  int val = int(pow(2,cli-1));
  switch(dot) {
  case 1: sprintf(help,"%d.",val); break;
  case 2: sprintf(help,"%d..",val); break;
  case 3: sprintf(help,"%d...",val); break;
  default: sprintf(help,"%d",val); break;
  }
  return help;
}

char * MupLyrics::text() {
  return lyrics;
}

MupLyrics * MupLyrics::Next() {
  return next;
}

void MupLyrics::append(MupLyrics * mp) {
  if (next==0) next = mp;
  else next->append(mp);
}


// ***************************************************************************
// *
// *  NotePointer
// *  ***********
// *



NotePtr::NotePtr(Note * n) : note(n), next(0) {}

Note * NotePtr::gNote() { return note; }

NotePtr * NotePtr::Next() { return next; }

void NotePtr::append(NotePtr * np) {
  if (next==0) {
    next = np;
  } else {
    next->append(np);
  }
}

NotePtr * NotePtr::insert(Note * n) {
  NotePtr * cur = this;
  NotePtr * above = 0;
  NotePtr * prev = 0;
  NotePtr * newPtr = new NotePtr(n);
  NotePtr * rv = this;
  while (cur!=0) {
    if (above==0) {
      if (cur->gNote()->pitch() > n->pitch()) above = cur;
      else prev = cur;
    }
    cur = cur->Next();
  }
  
  if (above==0) {
    append(newPtr); // all notes below n.
  } else {
    if (above==this) {
      newPtr->next = above;
      rv = newPtr;
    } else {
      if (prev->Next()!=above) { cout << "PANIC NotePtr::insert" << endl; exit(0); } // remove this line sometime!
      newPtr->next = above;
      prev->next = newPtr;
    }
  }
  return rv;
}



// ***************************************************************************
// *
// *  NoteChord
// *  *********
// *

 
NoteChord::NoteChord(Note * n, Position o) : top(new NotePtr(n)), next(0), off(o), _xPos(0), _stemPos(0), _stemDir(0), _yBottom(0), _yTop(0) {}

NoteChord::~NoteChord() { 
  NotePtr * tmp;
  for (NotePtr * np = top; np!=0;) {
    tmp = np->Next();
    delete np;
    np = tmp;
  }
}

Position NoteChord::gOffset() { return off; }

NotePtr * NoteChord::Bottom() {
  NotePtr * rv = top;
  while (rv->Next()!=0) rv = rv->Next();
  return rv;
}



NoteChord * NoteChord::append(Note * n) {
  // We could extend this to create a new chord, if the freq's are too far apart!
  top = top->insert(n);
  // cout << "--------------------" << endl; print(); cout << "--------------------" << endl;
  return this;
}

int NoteChord::center() {
  int rv = int( (top->gNote()->pitch() + Bottom()->gNote()->pitch()) * 0.5 );
  return rv;
}

int NoteChord::len() {
  int min = 999999;
  int tmp = 0;
  for (NotePtr * np = top; np!=0; np = np->Next()) {
    tmp = np->gNote()->duration();
    if (tmp<min) min = tmp;
  }
  return min;
}

int NoteChord::xPos() {
  if (_xPos==0) { cout << "PANIC: using xPos() before drawing!" << endl; exit(0); }
  return (_xPos-1);
}

int NoteChord::stemPos(int stemDir) {
  if (_stemPos==0) { cout << "PANIC: using stemPos() before drawing!" << endl; exit(0); }
  if (_middle) return (_xPos+7);
  else {
    if (stemDir==0) return (_stemPos-1);
    else if (stemDir==-1) return (_xPos-1);
    else return (_xPos+7);
  }
}

int NoteChord::stemDir() {
  if (_stemDir==0) { cout << "PANIC: using stemDir() before drawing!" << endl; exit(0); }
  return _stemDir;
}

int NoteChord::stemUp() {
  if (_stemDir==0) { cout << "PANIC: using stemUp() before drawing!" << endl; exit(0); }
  return (_stemDir==1);
}

int NoteChord::stemDown() {
  if (_stemDir==0) { cout << "PANIC: using stemDown() before drawing!" << endl; exit(0); }
  return (_stemDir==-1);
}

int NoteChord::yBottom() {
  if (_yBottom==0) { cout << "PANIC: using yBottom() before drawing!" << endl; exit(0); }
  return (_yBottom);
}

int NoteChord::yTop() {
  if (_yTop==0) { cout << "PANIC: using yTop() before drawing!" << endl; exit(0); }
  return (_yTop+1);
}


Position NoteChord::Pos() {
  return top->gNote()->internalStart()+off;
}

int NoteChord::maxFreq() {
  return Bottom()->gNote()->pitch();
}

int NoteChord::minFreq() {
  return top->gNote()->pitch();
}

NoteChord * NoteChord::Next() { return next; }

void NoteChord::sNext(NoteChord * ch) { next = ch; }

void NoteChord::print() {
  cout << " Chord at pos: " << Pos().ticks() << endl;
  for (NotePtr * np = top; np!=0; np = np->Next()) {
    cout << "  Note (pos: " << np->gNote()->internalStart().ticks() << ", f: " << np->gNote()->pitch() << ", l: " << np->gNote()->duration() << ")" << endl;
  }
}

void NoteChord::draw(QPainter * score, Position relPos, double pixPerTick, int xoffset, int yoffset, int scrClef,
		     Atom* selNote, Position selX1, Position selX2, bool showVOL, bool showLYR) {
  Position pos = Pos()+relPos-off;
  xx = int ((Pos()+relPos-off)*pixPerTick + xoffset + 5);
  xxShift = 0;
  yy = 0;
  Note * note;
  int middleStem = 0;
  int yAverage = 0;
  int count = 0;
  _yBottom = 0;
  _yTop = 99;


  // Loop through this chord
  for (NotePtr * np = top; np!=0; np = np->Next()) {
    yyOld = yy;
    note = np->gNote();
    int freq = note->pitch();
    int len = note->duration();
    int enh = note->enh();
    int chan = note->chan();
    QPixmap img;

    int step = freq%12;
    yy  = invPitch[freq];
    int sg  = sign[freq];
    if (enh!=0) { yy += enhF[enh+2][step]; sg = enhS[enh+2][step]; }
    
    int sgMem = scrSigns[yy%7]; // Sign
    scrSigns[yy%7] = sg;
    if (sgMem == sg) { sg = 0; } else { if (sg==0) { sg = 3; } }
    // change yy when different clef
    if (scrClef!=0) yy += yClef[scrClef];
    if (yy<1) { yy = 1; }
    
    // if notes are only one line apart, move:
    if (abs(yyOld-yy)<2) {
      xxShift += 8;
      if (xxShift == 16) xxShift = 0;
      middleStem = 1;
    } else {
      xxShift = 0;
    }
    // draw helplines, above and below the score:
    for (int i=yy/2; i<6; i++) { score->drawLine(QPoint(xx-3,i*6+yoffset+5),QPoint(xx+9,i*6+yoffset+5)); }
    for (int i=(yy-1)/2; i>10; i--) { score->drawLine(QPoint(xx-3,i*6+yoffset+5),QPoint(xx+9,i*6+yoffset+5)); }
    // draw sign DOIT, position right ?!
    if (sg!=0) { score->drawPixmap(xx-11,yy*3+yoffset-10-2*(sg<0),imgSignPtr[sg+2]); }
    // chose and draw notebody (empty or filled):
    if (len>767) { img = imgNotePtr[0]; } else { img = imgNotePtr[1]; }
    // if ((selNote==note) || (selX1!=-1 && selX1 <= Pos() && Pos() <= selX2)) {
    if (selectioN->hasEntry(note)) {
      // score->setPen(Qt::red); // COLOR
      score->fillRect(xx+xxShift-2,yy*3+yoffset-2,11,7,Qt::darkGray);
    } else {
      /* if (colorchan && (chan>-1)) {
	score->setPen(QColor((chan*33)%360,120,240,QColor::Hsv));
      } else {
	score->setPen(Qt::black);
	}*/
    }
    score->drawPixmap(xx+xxShift,yy*3+yoffset-1,img);
    /*
    if (colorchan && (chan>-1)) { // TODO: only provisorical solution: I rather want to color the pixmap !!!
      score->drawEllipse(xx+xxShift+1,yy*3+yoffset+1,5,3);
      score->drawLine(xx+xxShift+1,yy*3+yoffset+2,xx+xxShift+5,yy*3+yoffset+2);
      score->drawLine(xx+xxShift+1,yy*3+yoffset+3,xx+xxShift+5,yy*3+yoffset+1);
      }*/

    score->setPen(Qt::black);
    // dotted?
    int dot = DOT(len);
    for (int i=0;i<dot;i++) {
      score->drawText(xx+10+5*i,yy*3+yoffset,".");
    }

    // build the y-average, set bottom/top:
    if (_yTop>yy) _yTop = yy;
    if (_yBottom<yy) _yBottom = yy;
    yAverage += yy;
    count++;

    //
    // ORNAMENTS
    //
    Vector * vec = note->ornament();
    for (Ornament * orn = (Ornament*) vec->first(); orn != 0; orn = (Ornament*) vec->next(orn)) {
      if (orn->isA()==EXPRESSION) {
	Expression * exp = (Expression*) orn;
	score->drawPixmap(xx+xxShift-7,yoffset+3*yy+exp->displacement()-8,imgNoteAccentPtr[exp->expression()]);
      } else if (orn->isA()==BOW) {
	// bow ?
	Bow * bow = (Bow*) orn;
	int bowlen = bow->length();
	int drc = bow->direction();
	if (drc==0) drc = -1;
	int x1 = xx+xxShift*8;
	int y1 = yoffset+3*yy + drc*8;
	int dx = int(bowlen*pixPerTick/3);
	int dy = int(bowlen*pixPerTick/12 * drc);
	int ddy = bow->delta()/3;
      
	QPointArray aa( 4 );
	aa.setPoint( 0, x1+4, y1 );
	aa.setPoint( 1, x1+dx, y1+dy + ddy );
	aa.setPoint( 2, x1+2*dx, y1+dy + 2*ddy );
	aa.setPoint( 3, x1+3*dx, y1 + 3*ddy );
#if QT_VERSION >= 300
	score->drawCubicBezier(aa);
#else
	score->drawQuadBezier(aa);
#endif
	aa.setPoint( 1, x1+dx, y1+dy+1 + ddy );
	aa.setPoint( 2,x1+2*dx, y1+dy+1 + 2*ddy );
#if QT_VERSION >= 300
	score->drawCubicBezier(aa);
#else
	score->drawQuadBezier(aa);
#endif
      } else if (orn->isA()==LYRICS) {
	const char * txt = note->lyrics()->get();
	score->drawText(xx+xxShift-7,yoffset+92,txt);
      } else if (orn->isA()==STEM) {
	// TODO!!!
      }
    }

    /*
      if (showLYR==true) {
      Lyrics * lyr = note->lyrics();
      if (lyr) score->drawText(xx+xxShift*8,yoffset+114,lyr->gText());
    }
    */
    
  }
  
  // and now: set x-position of note and of stem
  _xPos = xx;
  if (middleStem==1) {
    _stemPos = xx + 8;
    _middle = true;
  } else {
    yAverage /= count;
    if (yAverage > 16) _stemPos = xx + 8;
    else _stemPos = xx;
    _middle = false;
  }
  if (yAverage > 16) _stemDir = 1; else _stemDir = -1;

}

int NoteChord::DOT(int l) {

  int x0 = int(1.000000001 * log(l/3)/log(2)); l = l-3*int(pow(2,x0));
  if (l<3) l = 3;
  int x1 = int(1.000000001 * log(l/3)/log(2)); l = l-3*int(pow(2,x1));
  if (l<3) l = 3;
  int x2 = int(1.000000001 * log(l/3)/log(2)); l = l-3*int(pow(2,x2));
  return (x0-x1==1)+(x1-x2==1);

}


void NoteChord::tex(Position relPos, int scrClef) {
  int cli =  10-int(1.000001*log(len()/3)/log(2)); // 1 = 1, 2 = 1/2, 3 = 1/4, 4 = 1/8, 5 = 1/16, etc.
  int dot = DOT(len());
  int freq = 0;
  int enh = 0;
  int step = 0;
  int sg = 0;
  int sgMem = 0;
  int yy = 0;
  //char freqSymbol = ' ';
  
  for (NotePtr * np = top; np!=0; np = np->Next()) {
    freq = np->gNote()->pitch();
    enh = np->gNote()->enh();

    step = freq%12;
    yy  = invPitch[freq];
    sg  = sign[freq];
    if (enh!=0) { yy += enhF[enh+2][step]; sg = enhS[enh+2][step]; }    
    sgMem = scrSigns[yy%7]; // Sign
    scrSigns[yy%7] = sg;
    if (sgMem == sg) { sg = 0; } else { if (sg==0) { sg = 3; } }

    if (np->Next()!=0) { // all but last note:
      switch (cli) {
      case 1: cout << "\\zwh "; break;
      case 2: cout << "\\zh "; break;
      case 3: cout << "\\zq "; break;
      case 4: cout << "\\zq "; break;
      case 5: cout << "\\zq "; break;
      case 6: cout << "\\zq "; break;
      case 7: cout << "\\zq "; break;
      }
      cout << "{";
      for (int i=0;i<dot;i++) cout << ".";
      if (sg!=0) cout << (char) sign2tex[sg+2];
      cout << (char) y2tex[yy];
      cout << "}";
    } else { // last note:
      switch (cli) {
      case 1: cout << "\\wh "; break;
      case 2: cout << "\\ha "; break;
      case 3: cout << "\\qa "; break;
      case 4: cout << "\\ca "; break;
      case 5: cout << "\\cca "; break;
      case 6: cout << "\\ccca "; break;
      case 7: cout << "\\cccca "; break;
      }
      cout << "{";
      for (int i=0;i<dot;i++) cout << ".";
      if (sg!=0) cout << (char) sign2tex[sg+2];
      cout << (char) y2tex[yy];
      cout << "}";
    }
  }
}

void NoteChord::mup(Position relPos, int scrClef, ofstream * outp, Part * master, int met0, int met1) {
  ofstream & out = * outp;
  Note * note;

  int cli =  10-int(1.000001*log(len()/3)/log(2)); // 1 = 1, 2 = 1/2, 3 = 1/4, 4 = 1/8, 5 = 1/16, etc.
  int dot = DOT(len());
  int freq = 0;
  int enh = 0;
  int step = 0;
  int sg = 0;
  int sgMem = 0;
  int yy = 0;
  //char freqSymbol = ' ';

  for (NotePtr * np = top; np!=0; np = np->Next()) {
    note = np->gNote();
    freq = note->pitch();
    enh = note->enh();

    // expressions ?
    // NS_STACCATO, NS_LEGATO, NS_ACCDOWN, NS_ACCUP, NS_ACCENT1, NS_ACCENT2, NS_ACCENT3, NS_ACCENT4,
    // NS_ACCENT5, NS_ACCENT6, NS_ACCENT7, NS_ACCENT8, NS_ACCENT9, NS_ACCENT10, NS_ACCENT11, NS_TRILLER,
    // NS_TRILL1, NS_TRILL2, NS_INF, NS_BOWUP, NS_BOWDOWN

    
    Vector * vec = note->ornament();
    for (Ornament * orn = (Ornament*) vec->first(); orn != 0; orn = (Ornament*) vec->next(orn)) {
      if (orn->isA()==EXPRESSION) {
	Expression * expr = (Expression*) orn;
	if (expr) {
	  int attr = 0;
	    switch (expr->expression()) {
	    case NS_STACCATO: specifyAtts(attr,&out); out << "."; attr++; break;
	    case NS_LEGATO: specifyAtts(attr,&out); out << "-"; attr++; break;
	    case NS_ACCDOWN: specifyAtts(attr,&out); out << "\"\\(dnbow)\""; attr++; break;
	    case NS_ACCUP: specifyAtts(attr,&out); out << "\"\\(upbow)\""; attr++; break;
	    case NS_ACCENT1: specifyAtts(attr,&out); out << "\"\\(acc_hat)\""; attr++; break;
	    case NS_ACCENT2: specifyAtts(attr,&out); out << "\"\\(acc_gt)\""; attr++; break;
	    case NS_ACCENT3: specifyAtts(attr,&out); out << "\"\\(dim)\""; attr++; break;
	    case NS_ACCENT4: specifyAtts(attr,&out); out << "\"+\""; attr++; break;
	      // case NS_ACCENT5: specifyAtts(attr,&out); out << "\"\""; attr++; break;
	    case NS_ACCENT6: specifyAtts(attr,&out); out << "-,."; attr++; break;
	    case NS_ACCENT7: specifyAtts(attr,&out); out << ".,-"; attr++; break;
	    case NS_ACCENT8: specifyAtts(attr,&out); out << "-,\"\\(acc_gt)\""; attr++; break;
	    case NS_ACCENT9: specifyAtts(attr,&out); out << "\"\\(acc_gt)\",-"; attr++; break;
	    case NS_ACCENT10: specifyAtts(attr,&out); out << ".,\"\\(acc_gt)\""; attr++; break;
	    case NS_ACCENT11: specifyAtts(attr,&out); out << "\"\\(acc_gt)\",."; attr++; break;
	    case NS_TRILLER: specifyAtts(attr,&out); out << "\"\\(tr)\""; attr++; break;
	    case NS_TRILL1: specifyAtts(attr,&out); out << "\"\\(invmor)\""; attr++; break;
	    case NS_TRILL2: specifyAtts(attr,&out); out << "\"\\(mor)\""; attr++; break;
	    case NS_INF: specifyAtts(attr,&out); out << "\"\\(turn)\""; attr++; break;
	      //case NS_BOWUP: specifyAtts(attr,&out); out << "\"\""; attr++; break;
	      //case NS_BOWDOWN: specifyAtts(attr,&out); out << "\"\""; attr++; break;
	    }
	  if (attr>0) out << "] ";
	}
      }
    }
    

    if (np==top) {
      switch (cli) {
      case 1: out << "1"; break;
      case 2: out << "2"; break;
      case 3: out << "4"; break;
      case 4: out << "8"; break;
      case 5: out << "16"; break;
      case 6: out << "32"; break;
      case 7: out << "64"; break;
      }
      for (int i=0;i<dot;i++) out << ".";
    }

    step = freq%12;
    yy  = invPitch[freq];
    sg  = sign[freq];
    if (enh!=0) { yy += enhF[enh+2][step]; sg = enhS[enh+2][step]; }    
    sgMem = scrSigns[yy%7]; // Sign
    scrSigns[yy%7] = sg;
    if (sgMem == sg) { sg = 0; } else { if (sg==0) { sg = 3; } }
  
    out << (char) y2mup[yy%7];
    yy -= 3;
    out << 6-(yy-(yy%7))/7;
    if (sg!=0) {
      switch (sg+2) {
      case 0: out << "&&"; break;
      case 1: out << "&"; break;
      case 2: out << "n"; break;
      case 3: out << "#"; break;
      case 4: out << "x"; break;
      case 5: out << "n"; break;
      }
    }

    // bow ?
    for (Ornament * orn = (Ornament*) vec->first(); orn != 0; orn = (Ornament*) vec->next(orn)) {
      if (orn->isA()==BOW) {
	Bow * bow = (Bow*) orn;
	if (bow) {
	  if (bow->length()<=len()) out << "<>";
	  else {
	    if (mupPhrase!=0) mupPhrase->append(new MupPhrase(Pos(),bow->length(),master,met0,met1));
	    else              mupPhrase = new MupPhrase(Pos(),bow->length(),master,met0,met1);
	  }
	}
      } else if (orn->isA()==LYRICS) {
	Lyrics * lyr = (Lyrics*) orn;
	if (mupLyrics!=0) mupLyrics->append(new MupLyrics(cli,dot,lyr->get()));
	else              mupLyrics = new MupLyrics(cli,dot,lyr->get());
      }
    }
    /*
    // lyrics ?
    Lyrics * lyr = note->lyrics();
    if (lyr) {
      if (mupLyrics!=0) mupLyrics->append(new MupLyrics(cli,dot,lyr->gText()));
      else              mupLyrics = new MupLyrics(cli,dot,lyr->gText());
    }
    */
	
  }
  out << ";";
}

void NoteChord::specifyAtts(int attr, ofstream * outp) {
  ofstream & out = * outp;
  if (attr==0) {out << "[with ";}
  if (attr>0) {out << ",";}
}


int NoteChord::xx = 0;
int NoteChord::xxShift = 0;
int NoteChord::yy = 0;
int NoteChord::yyOld = 0;


// ***************************************************************************
// *
// *  NoteGroup
// *  *********
// *

QtScoreGroup::QtScoreGroup() : next(0) {}

QtScoreGroup::~QtScoreGroup() {}

// ---------------------------------------------------------------------------

NoteGroup::NoteGroup(NoteChord * ch, NoteGroup * gr) : first(ch) { next = gr; }

NoteGroup::NoteGroup(Note * n, Position off) : first(new NoteChord(n,off)) {}

NoteGroup::~NoteGroup() {
  NoteChord * tmp;
  for (NoteChord * ch = first; ch != 0;) {
    tmp = ch->Next();
    delete ch;
    ch = tmp;
  }
}

Position NoteGroup::start() { return first->Pos(); }

Position NoteGroup::end() {
  NoteChord * cur = first;
  while (cur->Next()!=0) cur = cur->Next();
  Position pos = cur->Pos() + cur->len();
  return pos;
}

NoteChord * NoteGroup::last() {
  NoteChord * cur = first;
  while (cur->Next()!=0) cur = cur->Next();
  return cur;
}

Position NoteGroup::gOffset() { return first->gOffset(); }

int NoteGroup::center() {
  int rv = 0;
  NoteChord * cur = first;
  while (cur!=0) {
    rv = rv + cur->center();
    cur = cur->Next();
  }
  return rv;
}


void createBreakGroups(QtScoreGroup *& grp, QtScoreGroup *& grp1, Position pos, int length, Position off, Part * master, int met0, int met1) {
  // cout << "create breakgroup in" << endl;
  grp = 0;
  QtScoreGroup * cur = 0;
  Position nextBar = pos;
  nextBar.nextBar();
  int ldiff = int(nextBar-pos.ticks());

  // cout << "ld: " << ldiff << ", len: " << length << endl;
  // if (pos.negative()>0) ldiff= length;

  while (length > ldiff) {
    // drawBreak(ldiff*1.0/3,xx,yy,score,tpbeat,xoffset,pixPerTick);
    if (grp==0) { grp = new BreakGroup(pos,ldiff,off); cur = grp; }
    else { grp1 = new BreakGroup(pos,ldiff,off); cur->sNext(grp1); cur = grp1; }
    pos = nextBar;
    nextBar.nextBar();
    length -= ldiff;
    ldiff = int(nextBar-pos.ticks());
  }
  if (length>0) {
    // drawBreak(length*1.0/3,xx,yy,score,tpbeat,xoffset,pixPerTick);
    if (grp==0) { grp = new BreakGroup(pos,length,off); cur = grp; }
    else { grp1 = new BreakGroup(pos,length,off); cur->sNext(grp1); cur = grp1; }
  }
  if (grp1==0) grp1 = grp;
  // cout << "grp: " << grp << ", grp1: " << grp1 << endl;
  // cout << "create breakgroup out" << endl << endl;
}

QtScoreGroup * NoteGroup::append(Note * note, Position off, Part * master, int met0, int met1) {
  //cout << "note append in" << endl;

  int newlen = note->duration();
  int lastlen = last()->len();

  bool tri = false;
  bool triLast = false;
  if (newlen==512 || newlen==256 || newlen==128 || newlen==64 || newlen==32 || newlen==16) tri = true; // triole
  if (lastlen==512 || lastlen==256 || lastlen==128 || lastlen==64 || lastlen==32 || lastlen==16) triLast = true; // triole

  Position notePos = note->internalStart()+off;
  QtScoreGroup * grp = this;
  QtScoreGroup * grp1 = 0;
  QtScoreGroup * grp2 = 0;
  QtScoreGroup * curGroup = 0;
  int cl =  10-int(1.000001*log(note->duration()/3)/log(2))-3; // 1 = 1/8, 2 = 1/16, etc.
  int my_cl = 10-int(1.000001*log(first->len()/3)/log(2))-3;

  // first check, if there is a chord at the same position:
  NoteChord * cur = first;
  NoteChord * targetChord = 0;
  NoteChord * newChord = 0;
  while (cur!=0) {
    if (cur->Pos()==notePos) targetChord = cur;
    if (targetChord==0) cur = cur->Next();
    else cur = 0;
  }
  if (targetChord != 0) { // We try to add the note to the targetChord. If there are reasons, another chord is created:
    newChord = targetChord->append(note);
    if (newChord == targetChord) newChord = 0;
  } else { // We have to create a new Chord.
    newChord = new NoteChord(note,off);
  }
  if (newChord != 0) { // We have to add a new chord, or even a new group:
    int gbar = start().bar();
    int nbar = notePos.bar();
    int brk = notePos - end().ticks();
    if (triLast!=tri) { // new group, if mode (triplet/non-triplet) changes
      grp = new NoteGroup(newChord);
    } else {
      if (tri) { // triplets: DOIT: what if break is part of triplet?
	if (number()>2) grp = new NoteGroup(newChord);
	else if (gbar!=nbar) grp = new NoteGroup(newChord); // new group, if newChord is in next bar
	else append(newChord);
      } else { // non-triplets
	if (brk>0) { // new group, if break between last chord of this group and beginning of newChord
	  createBreakGroups(grp, grp1, end(), brk, off, master, met0, met1); // grp: first BreakGroup, grp1: last BreakGroup
	  grp2 = new NoteGroup(newChord);
	  grp1->sNext(grp2);
	}    
	else if (my_cl < 1) grp = new NoteGroup(newChord); // new group, if (first) chord of this group has no flags (length >= 1/4), i.e. group is a single chord
	else if (cl < 1) grp = new NoteGroup(newChord); // new group, if newChord has no flags (length >= 1/4)
	else if (notePos.beat()!=last()->Pos().beat()) grp = new NoteGroup(newChord); // new group, with new beat
	else if (gbar!=nbar) grp = new NoteGroup(newChord); // new group, if newChord is in next bar
	else append(newChord);
      }
    }
  }
  if (this!=grp) next = grp;
  curGroup = grp;
  if (grp2!=0) curGroup = grp2;

  // cout << "note append out" << endl << endl;
  return curGroup;
}

int NoteGroup::number() {
  int rv = 0;
  for (NoteChord * ch = first; ch != 0; ch = ch->Next()) rv++;
  return rv;
}

void NoteGroup::append(NoteChord * ch) {
  NoteChord * cur = first;
  while (cur->Next()!=0) cur = cur->Next();
  cur->sNext(ch);
}

QtScoreGroup * NoteGroup::Next() { return next; }

void NoteGroup::sNext(QtScoreGroup * g) { next = g; }

void NoteGroup::print() {
  cout << "Group " << start().ticks() << " - " << end().ticks() << endl;
  for (NoteChord * ch = first; ch != 0; ch = ch->Next()) ch->print();
}

void NoteGroup::draw(QPainter * score, Position relPos, double pixPerTick, int xoffset, int yoffset, int scrClef, Part * master, int met0, int met1,
		     Atom* selNote, Position selX1, Position selX2, bool showVOL, bool showLYR) {
  // int xx = (start()+relPos)*pixPerTick + xoffset;
  // int xx1 = (end()+relPos)*pixPerTick + xoffset - xx;
  // score->drawRect(xx,100,xx1,200);
  // cout << "note draw in" << endl;

  int akkordlen = first->len();

  int cl2 = 0;
  int cl1 = 0;
  int cl = 10-int(1.000001*log(akkordlen/3)/log(2))-3;
  //int dy = (cl-1)*5;
  int yBottom = 0;
  int yTop = 99;
  int yAverage = 0;
  int yBottom0 = 0;
  int yBottom1 = 0;
  int yTop0 = 0;
  int yTop1 = 0;
  NoteChord * last = 0;
  int xFirstStP = 0;
  int xTopStP = 0;
  int xBottomStP = 0;
  int xCurStP = 0;
  int xNextStP = 0;
  int xLastStP = 0;
  double slope = 0;


  // draw note bodies.
  for (NoteChord * ch = first; ch != 0; ch = ch->Next()) {
    
    ch->draw(score,relPos,pixPerTick,xoffset,yoffset,scrClef,selNote,selX1,selX2,showVOL,showLYR);

    if (yTop > ch->yTop())       { yTop = ch->yTop(); xTopStP = ch->stemPos(1); }
    if (yBottom < ch->yBottom()) { yBottom = ch->yBottom(); xBottomStP = ch->stemPos(-1); }
    if (ch->Next()==0) last = ch;
  }
  yBottom0 = first->yBottom();
  yBottom1 = last->yBottom();
  yTop0 = first->yTop();
  yTop1 = last->yTop();

  if (number() == 1) {
    if (cl > -2) { // one chord only!
      if (first->stemUp()) {
	score->drawLine(first->stemPos(),yoffset+3*yBottom,first->stemPos(),yoffset+3*yTop - 19);
	for (int i=0; i<cl; i++)
	  score->drawPixmap(first->stemPos(), yoffset+3*yTop-25+i*5, imgFlagPtr[0]);
      } else {
	score->drawLine(first->stemPos(),yoffset+3*yBottom + 19,first->stemPos(),yoffset+3*yTop);
	for (int i=0; i<cl; i++)
	  score->drawPixmap(first->stemPos(), yoffset+3*yBottom+12-i*5, imgFlagPtr[1]);
      }
    }

  } else { // multiple chords!
    yAverage = int((yTop+yBottom)*0.5);
    bool tri = false;
    if (akkordlen==512 || akkordlen==256 || akkordlen==128 || akkordlen==64 || akkordlen==32 || akkordlen==16) tri = true; // triole

    if (yAverage>16) { // stems up
      xFirstStP = first->stemPos(1);
      xLastStP = last->stemPos(1);
      slope = (yTop1 - yTop0)*3.0/(xLastStP - xFirstStP);
      for (NoteChord * ch = first; ch != 0; ch = ch->Next()) {
	xCurStP = ch->stemPos(1);
	// score->drawLine(xCurStP, yoffset+3*ch->yBottom() , xCurStP, yoffset+3*yTop0+int(slope*(xCurStP-xFirstStP)) -19 );
	score->drawLine(xCurStP, yoffset+3*ch->yBottom() , xCurStP, yoffset+3*yTop+int(slope*(xCurStP-xTopStP)) -19 );
      }
      QPen flagPen = score->pen(); flagPen.setWidth(3); score->setPen(flagPen);
      for (NoteChord * ch = first; ch->Next() != 0; ch = ch->Next()) {
	xCurStP = ch->stemPos(1);
	xNextStP = ch->Next()->stemPos(1);
	cl2 = cl1;
	cl1 = cl;
	cl = 10-int(1.000001*log(ch->Next()->len()/3)/log(2))-3;
	
	if (cl==cl1) { // both notes have the same length!
	  for (int i=0; i<cl; i++)
	    score->drawLine(xCurStP, yoffset+3*yTop+int(slope*(xCurStP-xTopStP))-19+i*5, xNextStP, yoffset+3*yTop+int(slope*(xNextStP-xTopStP))-19+i*5);
	}
	if (cl<cl1) { // left note is shorter than right note
	  for (int i=0; i<cl; i++)
	    score->drawLine(xCurStP, yoffset+3*yTop+int(slope*(xCurStP-xTopStP))-19+i*5, xNextStP, yoffset+3*yTop+int(slope*(xNextStP-xTopStP))-19+i*5);
	  if (cl1 != cl2)
	    for (int i=cl; i<cl1; i++)
	      score->drawLine(xCurStP, yoffset+3*yTop+int(slope*(xCurStP-xTopStP))-19+i*5, (xNextStP+xCurStP)*0.5, yoffset+3*yTop+int(slope*((xNextStP+xCurStP)*0.5-xTopStP))-19+i*5);
	}
	if (cl>cl1) { // right note is shorter than left note
	  for (int i=0; i<cl1; i++)
	    score->drawLine(xCurStP, yoffset+3*yTop+int(slope*(xCurStP-xTopStP))-19+i*5, xNextStP, yoffset+3*yTop+int(slope*(xNextStP-xTopStP))-19+i*5);
	  if ((cl1 != cl2) && (ch->Next()->Next()==0))
	    for (int i=cl1; i<cl; i++)
	      score->drawLine((xNextStP+xCurStP)*0.5, yoffset+3*yTop+int(slope*(xCurStP-xTopStP))-19+i*5, xNextStP, yoffset+3*yTop+int(slope*((xNextStP+xCurStP)*0.5-xTopStP))-19+i*5);
	}
	
      }
      if (tri) {
	int xCurStP = xFirstStP+int((xLastStP-xFirstStP)*0.5);
	score->drawText(xCurStP,yoffset+3*yTop+int(slope*(xCurStP-xTopStP))-19-4,"3");
	// score->drawLine(xFirstStP,yoffset+3*yBottom0,xLastStP,yoffset+3*yBottom1);
      }
      flagPen = score->pen(); flagPen.setWidth(0); score->setPen(flagPen);
    } else { //stems down
      xFirstStP = first->stemPos(-1);
      xLastStP = last->stemPos(-1);
      slope = (yBottom1 - yBottom0)*3.0/(xLastStP - xFirstStP);
      for (NoteChord * ch = first; ch != 0; ch = ch->Next()) {
	xCurStP = ch->stemPos(-1);
	// score->drawLine(xCurStP, yoffset+3*yBottom0+int(slope*(xCurStP-xFirstStP)) +19, xCurStP, yoffset+3*ch->yTop());
	score->drawLine(xCurStP, yoffset+3*yBottom+int(slope*(xCurStP-xBottomStP)) +19, xCurStP, yoffset+3*ch->yTop());
      }
      QPen flagPen = score->pen(); flagPen.setWidth(3); score->setPen(flagPen);
      for (NoteChord * ch = first; ch->Next() != 0; ch = ch->Next()) {
	xCurStP = ch->stemPos(-1);
	xNextStP = ch->Next()->stemPos(-1);
	cl2 = cl1;
	cl1 = cl;
	cl = 10-int(1.000001*log(ch->Next()->len()/3)/log(2))-3;
	
	if (cl==cl1) { // both notes have the same length!
	  for (int i=0; i<cl; i++)
	    score->drawLine(xCurStP, yoffset+3*yBottom+int(slope*(xCurStP-xBottomStP))+19-i*5, xNextStP, yoffset+3*yBottom+int(slope*(xNextStP-xBottomStP)) +19-i*5);
	}
	if (cl<cl1) { // left note is shorter than right note
	  for (int i=0; i<cl; i++)
	    score->drawLine(xCurStP, yoffset+3*yBottom+int(slope*(xCurStP-xBottomStP))+19-i*5, xNextStP, yoffset+3*yBottom+int(slope*(xNextStP-xBottomStP)) +19-i*5);
	  if (cl1 != cl2)
	    for (int i=cl; i<cl1; i++)
	      score->drawLine(xCurStP, yoffset+3*yBottom+int(slope*(xCurStP-xBottomStP))+19-i*5, (xNextStP+xCurStP)*0.5, yoffset+3*yBottom+int(slope*((xNextStP+xCurStP)*0.5-xBottomStP)) +19-i*5);
	}
	if (cl>cl1) { // right note is shorter than left note
	  for (int i=0; i<cl1; i++)
	    score->drawLine(xCurStP, yoffset+3*yBottom+int(slope*(xCurStP-xBottomStP))+19-i*5, xNextStP, yoffset+3*yBottom+int(slope*(xNextStP-xBottomStP)) +19-i*5);
	  if ((cl1 != cl2) && (ch->Next()->Next()==0))
	    for (int i=cl1; i<cl; i++)
	      score->drawLine((xNextStP+xCurStP)*0.5, yoffset+3*yBottom+int(slope*(xCurStP-xBottomStP))+19-i*5, xNextStP, yoffset+3*yBottom+int(slope*((xNextStP+xCurStP)*0.5-xBottomStP)) +19-i*5);
	}
	
      }
      if (tri) {
	int xCurStP = int( xFirstStP+(xLastStP-xFirstStP)*0.5 );
	score->drawText(xCurStP,yoffset+3*yBottom+int(slope*(xCurStP-xBottomStP))+19+16,"3");
	// score->drawLine(xFirstStP,yoffset+3*yBottom0,xLastStP,yoffset+3*yBottom1);
      }
      flagPen = score->pen(); flagPen.setWidth(0); score->setPen(flagPen);
    }

  }
  // cout << "note draw out" << endl << endl;

}

void NoteGroup::tex(Position relPos, int scrClef, Part * master, int met0, int met1) {
  int bar; int beat; int tick;
  Position position = first->Pos();
  position.gBBT(bar,beat,tick,master,met0,met1); bar--; beat--;
  // if ((bar!=0) && (beat==0) && (tick==0)) { texBar();  }
  // cout << "\\Notes";
  for (NoteChord * ch = first; ch != 0; ch = ch->Next()) ch->tex(relPos,scrClef);
  // cout << "\\en" << endl;

}

void NoteGroup::mup(Position relPos, int scrClef, Part * master, int met0, int met1, ofstream * outp) {
  int bar; int beat; int tick;
  Position position = first->Pos();
  position.gBBT(bar,beat,tick,master,met0,met1); bar--; beat--;
  for (NoteChord * ch = first; ch != 0; ch = ch->Next()) ch->mup(relPos,scrClef,outp,master,met0,met1);
}



// ***************************************************************************
// *
// *  BreakGroup
// *  **********
// *

BreakGroup::BreakGroup(Position p, int l, Position o) : pos(p), length(l), off(o) {}

BreakGroup::~BreakGroup() {}

Position BreakGroup::start() { return pos; }

Position BreakGroup::end() { return (pos+length); }

Position BreakGroup::gOffset() { return off; }

QtScoreGroup * BreakGroup::append(Note * note, Position off, Part * master, int met0, int met1) {
  cout << "PANIC: cannot append note to break!" << endl;
  return this;
}

QtScoreGroup * BreakGroup::Next() { return next; }

void BreakGroup::sNext(QtScoreGroup * g) { next = g; }

void BreakGroup::print() {
  cout << "Break: " << pos << ": " << length << endl;
}

void BreakGroup::draw(QPainter * score, Position relPos, double pixPerTick, int xoffset, int yoffset, int scrClef, Part * master, int met0, int met1,
		      Atom* selNote, Position selX1, Position selX2,bool showVOL, bool showLYR) {
  // cout << "break draw in" << endl;
  //  Position xx = (pos+relPos)*pixPerTick + xoffset + 5;
  Position xx = pos+relPos-off;
  // cout << "p: " << xx << ", b: " << length << endl;
  int yy = yoffset;
  // int mem = 0;

  int m0 = met0;
  int m1 = met1;
  int bar; int beat; int tick;
  xx.gBBT(bar,beat,tick,master,m0,m1,true); bar--; beat--;
  int tpbeat = int((1536.0/m1) / 3);

  /*
  Position nextBar = xx;
  nextBar.nextBar(master,met0,met1);
  int ldiff = int(nextBar-xx.ticks());
  if (length > ldiff) { mem = length - ldiff; length = ldiff;}
  */

  int l = length / 3;

  int xxx = int( (tick+beat*1536.0/m1) / 3); // xxx is position in ticks within bar div by 3.
  xxx = xxx >> 2; // after one more shift the 64th-note flag is found on the first bit!
  int _compl = 4; // _complement = 1/64th note after one more (left-) shift (already div. by 3)
  while (l > 0) {
    xxx = xxx >> 1;
    _compl = _compl << 1;
    if (xxx==0) {
      for (int i = 0x200; i > 4; i = i >> 1) { // 0x200 equals a whole break
	if (l&i) {
	  drawBreak(i,xx,yy,score,tpbeat,xoffset,pixPerTick);
	  l -= i;
	  xx += 3*i;
	}
      }
      if (l>0) { cout << "PANIC: BreakGroup: l > 0" << endl; l = 0; }
    } else {
      if (xxx&1) {
	if (_compl <= l) drawBreak(_compl,xx,yy,score,tpbeat,xoffset,pixPerTick);
	else drawBreak(l,xx,yy,score,tpbeat,xoffset,pixPerTick);
	l -= _compl;
	xx += 3*_compl;
      }
    }
  }

  /*  
  if (mem>0) {
    length = mem;
    xx = nextBar;
    xx.gBBT(bar,beat,tick,master,m0,m1,true); bar--; beat--;
    tpbeat = int((1536.0/m1) / 3);
    nextBar.nextBar(master,met0,met1);
    ldiff = int(nextBar-xx.ticks());
    while (length > ldiff) {
      drawBreak(ldiff*1.0/3,xx,yy,score,tpbeat,xoffset,pixPerTick);
      xx = nextBar;
      xx.gBBT(bar,beat,tick,master,m0,m1,true); bar--; beat--;
      tpbeat = int((1536.0/m1) / 3);
      nextBar.nextBar(master,met0,met1);
      length -= ldiff;
      ldiff = int(nextBar-xx.ticks());
    }
    if (length>0) {
      drawBreak(length*1.0/3,xx,yy,score,tpbeat,xoffset,pixPerTick);
    }
  }
  */

  // cout << "break draw out" << endl << endl;
  
}

void BreakGroup::drawBreak(int brk, Position position, int y, QPainter * score, int tpbeat, int xoffset, double pixPerTick) {
  // cout << brk << ", " << position << endl;
  // TODO: if (colorchan) score->setPen(Qt::gray);
  // cout << "break drawBreak in" << endl;

  y += 2;
  if (brk==512) {
    score->drawPixmap(xoffset+(position+0.5*1536)*pixPerTick,y+39,imgBreakPtr[9]);
  } else {
    while (brk>0) {
      int myBreak = 0;
      if (brk>tpbeat) myBreak = tpbeat; else myBreak =brk;
      int b=0;
      int bk = myBreak;
      for (b=0;bk>1;b++) bk = bk >> 1;
      if (b>6) score->drawPixmap(xoffset+(position+0.5*3*myBreak)*pixPerTick,y+39,imgBreakPtr[b]); // for Quarters, Halfs & Wholes, add half of break to position!
      else score->drawPixmap(xoffset+position*pixPerTick,y+39,imgBreakPtr[b]);
      brk -= tpbeat;
      position += 3*tpbeat;
    }
  }
  // TODO: if (colorchan) score->setPen(Qt::black);
  // cout << "break drawBreak out" << endl << endl;
}


void BreakGroup::tex(Position relPos, int scrClef, Part * master, int met0, int met1) {
  Position xx = pos+relPos-off;
  int yy = 0;

  int m0 = met0;
  int m1 = met1;
  int bar; int beat; int tick;
  xx.gBBT(bar,beat,tick,master,m0,m1,true); bar--; beat--;
  int tpbeat = int((1536.0/m1) / 3);

  /*
  Position nextBar = xx;
  nextBar.nextBar(master,met0,met1);
  int ldiff = int(nextBar-xx.ticks());
  while (length > ldiff) {
    texBreak(ldiff*1.0/3,xx,yy,tpbeat,master,met0,met1);
    xx = nextBar;
    xx.gBBT(bar,beat,tick,master,m0,m1,true); bar--; beat--;
    tpbeat = int((1536.0/m1) / 3);
    nextBar.nextBar(master,met0,met1);
    length -= ldiff;
    ldiff = int(nextBar-xx.ticks());
  }
  */

  int l = length / 3;

  int xxx = int( (tick+beat*1536.0/m1) / 3); // xxx is position in ticks within bar div by 3.
  xxx = xxx >> 2; // after one more shift the 64th-note flag is found on the first bit!
  int _compl = 4; // _complement = 1/64th note after one more (left-) shift (already div. by 3)
  while (l > 0) {
    xxx = xxx >> 1;
    _compl = _compl << 1;
    if (xxx==0) {
      for (int i = 0x200; i > 4; i = i >> 1) { // 0x200 equals a whole break
	if (l&i) {
	  texBreak(i,xx,yy,tpbeat,master,met0,met1);
	  l -= i;
	  xx += 3*i;
	}
      }
      if (l>0) { cout << "PANIC: BreakGroup: l > 0" << endl; l = 0; }
    } else {
      if (xxx&1) {
	if (_compl <= l) texBreak(_compl,xx,yy,tpbeat,master,met0,met1);
	else texBreak(l,xx,yy,tpbeat,master,met0,met1);
	l -= _compl;
	xx += 3*_compl;
      }
    }
  }

}

void BreakGroup::mup(Position relPos, int scrClef, Part * master, int met0, int met1, ofstream * outp) {

  Position xx = pos+relPos;
  int yy = 0;

  int m0 = met0;
  int m1 = met1;
  int bar; int beat; int tick;
  xx.gBBT(bar,beat,tick,master,m0,m1,true); bar--; beat--;
  int tpbeat = int((1536.0/m1) / 3);

  int l = length / 3;

  int xxx = int( (tick+beat*1536.0/m1) / 3); // xxx is position in ticks within bar div by 3.
  xxx = xxx >> 2; // after one more shift the 64th-note flag is found on the first bit!
  int _compl = 4; // _complement = 1/64th note after one more (left-) shift (already div. by 3)
  while (l > 0) {
    xxx = xxx >> 1;
    _compl = _compl << 1;
    if (xxx==0) {
      for (int i = 0x200; i > 4; i = i >> 1) { // 0x200 equals a whole break
	if (l&i) {
	  mupBreak(i,xx,yy,tpbeat,master,met0,met1,outp);
	  l -= i;
	  xx += 3*i;
	}
      }
      if (l>0) { cout << "PANIC: BreakGroup: l > 0" << endl; l = 0; }
    } else {
      if (xxx&1) {
	if (_compl <= l) mupBreak(_compl,xx,yy,tpbeat,master,met0,met1,outp);
	else mupBreak(l,xx,yy,tpbeat,master,met0,met1,outp);
	l -= _compl;
	xx += 3*_compl;
      }
    }
  }
}

void BreakGroup::texBreak(int brk, Position position, int y, int tpbeat, Part * master, int met0, int met1) {
  // cout << brk << ", " << position << endl;
  int bar; int beat; int tick;
  position.gBBT(bar,beat,tick,master,met0,met1); bar--; beat--;
  // if ((bar!=0) && (beat==0) && (tick==0)) { texBar(); }
  //cout << "\\Notes";
  if (brk==512) {
    // score->drawPixmap(xoffset+(position+0.5*1536)*pixPerTick,y+39,imgBreakPtr[9]);
    cout << "\\pause";
  } else {
    while (brk>0) {
      int myBreak = 0;
      if (brk>tpbeat) myBreak = tpbeat; else myBreak =brk;
      int b=0;
      int bk = myBreak;
      for (b=0;bk>1;b++) bk = bk >> 1;
      /* if (b>6) {
	 score->drawPixmap(xoffset+(position+0.5*3*myBreak)*pixPerTick,y+39,imgBreakPtr[b]); // for Quarters, Halfs & Wholes, add half of break to position!
	 } else {
	 score->drawPixmap(xoffset+position*pixPerTick,y+39,imgBreakPtr[b]);
	 }*/
      switch (b) {
      case 1: cout << "PANIC, note too short"; break;
      case 2: cout << "PANIC, note too short"; break;
      case 3: cout << "\\qqs"; break;
      case 4: cout << "\\hs"; break;
      case 5: cout << "\\qs"; break;
      case 6: cout << "\\ds"; break;
      case 7: cout << "\\qp"; break;
      case 8: cout << "\\hpause"; break;
      case 9: cout << "\\pause"; break;
      }
      brk -= tpbeat;
      position += 3*tpbeat;
    }
  }
  // cout << "\\en" << endl;
  // if (colorchan) score->setPen(black);
}

void BreakGroup::mupBreak(int brk, Position position, int y, int tpbeat, Part * master, int met0, int met1, ofstream * outp) {
  ofstream & out = * outp;

  int bar; int beat; int tick;
  position.gBBT(bar,beat,tick,master,met0,met1); bar--; beat--;
  if (brk==512) {
    out << "1r;";
  } else {
    while (brk>0) {
      int myBreak = 0;
      if (brk>tpbeat) myBreak = tpbeat; else myBreak =brk;
      int b=0;
      int bk = myBreak;
      for (b=0;bk>1;b++) bk = bk >> 1;
      switch (b) {
      case 1: cout << "PANIC, note too short"; break;
      case 2: cout << "PANIC, note too short"; break;
      case 3: out << "64r;"; break;
      case 4: out << "32r;"; break;
      case 5: out << "16r;"; break;
      case 6: out << "8r;"; break;
      case 7: out << "4r;"; break;
      case 8: out << "2r;"; break;
      case 9: out << "1r;"; break;
      }
      brk -= tpbeat;
      position += 3*tpbeat;
    }
  }
}


// ***************************************************************************
// *
// *  NoteBar
// *  ***
// *



NoteBar::NoteBar(QtScoreGroup * g) : top(g), next(0) {}

void NoteBar::sNext(NoteBar * n) { next = n; }

NoteBar * NoteBar::Next() { return next; }

Position NoteBar::start() { if (top) return top->start(); else return 0; }

void NoteBar::fill(Part * master, int met0, int met1) {
  QtScoreGroup * cur = top;
  if (cur) {
    while(cur->Next()!=0) {
      cur = cur->Next();
    }
    Position nextBar = start();
    nextBar.nextBar();
    int ldiff = nextBar - cur->end().ticks();
    if (ldiff>0) cur->sNext(new BreakGroup(cur->end(),ldiff,cur->gOffset()));
  }
}

NoteBar * NoteBar::append(QtScoreGroup * grp, Part * master, int met0, int met1) {
  Position nextBar = top->start();
  nextBar.nextBar();
  if (grp->start() >= nextBar) {
    NoteBar * newBar = new NoteBar(grp);
    sNext(newBar);
    return newBar;
  } else 
    return this;
}

void NoteBar::tex(Position relPos, int scrClef, Part * master, int met0, int met1) {
  Position nextBar = top->start();
  nextBar.nextBar();
  QtScoreGroup * cur = top;
  while(cur!=0) {
    cur->tex(relPos,scrClef,master,met0,met1);
    cur = cur->Next();
    if (cur!=0)
      if (cur->start() >= nextBar) cur = 0;
  }
}

void NoteBar::mup(Position relPos, int scrClef, Part * master, int met0, int met1, ofstream * outp, int index) {
  ofstream & out = * outp;
  Position nextBar = top->start();
  nextBar.nextBar();
  QtScoreGroup * cur = top;
  while(cur!=0) {
    cur->mup(relPos,scrClef,master,met0,met1,outp);
    cur = cur->Next();
    if (cur!=0)
      if (cur->start() >= nextBar) cur = 0;
  }
  while (mupPhrase!=0) {
    out << endl << "\tphrase " << index+1 << ": " << mupPhrase->Range() << ";";
    MupPhrase * nxt = mupPhrase->Next();
    delete mupPhrase;
    mupPhrase = nxt;
  }
  mupPhrase = 0;

  if (mupLyrics!=0) {
    out << endl << "\tlyrics " << index+1 << ": ";
    for (MupLyrics * ml = mupLyrics; ml!=0; ml = ml->Next()) out << ml->lengths() << ";";
    out << " \"";
    for (MupLyrics * ml = mupLyrics; ml!=0; ml = ml->Next()) {
      out << ml->text();
      if (ml->Next()!=0) out << " ";
    }
    out << "\";";
    while (mupLyrics!=0) {
      MupLyrics * nxt = mupLyrics->Next();
      delete mupLyrics;
      mupLyrics = nxt;
    }
  }
  mupLyrics = 0;
}

void NoteBar::print(Part* master, int met0, int met1) {
  cout << "\nNew Bar:" << endl;
  Position nextBar = top->start();
  nextBar.nextBar();
  QtScoreGroup * cur = top;
  while(cur!=0) {
    cur->print();
    cur = cur->Next();
    if (cur!=0)
      if (cur->start() >= nextBar) cur = 0;
  }
}


#endif
