#ifndef _KDESCOREPAINTER_CPP_
#define _KDESCOREPAINTER_CPP_

#include <iostream.h>
#include <stdlib.h>

#include "qpainter.h"
#include <kiconloader.h>

#include "scoreBar.h"
#include "scoreGroup.h"
#include "scoreChord.h"
#include "scoreBreak.h"
#include "part.h"
#include "note.h"
#include "reference.h"
#include "table.h"
#include "vector.h"
#include "lyrics.h"
#include "riemannFunction.h"
#include "symbol.h"

#include "kdeScorePainter.h"
#include "kdeScoreEditor2.h"
#include "kdeScoreContent2.h"


extern Table * selectioN;

extern QPixmap * imgNoteAccentPtr;
extern QPixmap * imgScoreSymbolPtr;

KdeScorePainter::KdeScorePainter() {
  KIconLoader * loader = KGlobal::iconLoader();
  QBitmap maske;

  /*
  cursorPM = loader->loadIcon( "cnote0",KIcon::Toolbar ); cursorBM[0] = cursorPM; cursor[0] = new QCursor( cursorBM[0], cursorBM[0],5,18);
  cursorPM = loader->loadIcon( "cnote1",KIcon::Toolbar ); cursorBM[1] = cursorPM; cursor[1] = new QCursor( cursorBM[1], cursorBM[1],5,18);
  cursorPM = loader->loadIcon( "cnote2",KIcon::Toolbar ); cursorBM[2] = cursorPM; cursor[2] = new QCursor( cursorBM[2], cursorBM[2],5,18);
  cursorPM = loader->loadIcon( "cnote3",KIcon::Toolbar ); cursorBM[3] = cursorPM; cursor[3] = new QCursor( cursorBM[3], cursorBM[3],5,18);
  cursorPM = loader->loadIcon( "cnote4",KIcon::Toolbar ); cursorBM[4] = cursorPM; cursor[4] = new QCursor( cursorBM[4], cursorBM[4],5,18);
  cursorPM = loader->loadIcon( "cnote5",KIcon::Toolbar ); cursorBM[5] = cursorPM; cursor[5] = new QCursor( cursorBM[5], cursorBM[5],5,18);
  cursorPM = loader->loadIcon( "cnote6",KIcon::Toolbar ); cursorBM[6] = cursorPM; cursor[6] = new QCursor( cursorBM[6], cursorBM[6],5,18);
  cursorPM = loader->loadIcon( "caddns",KIcon::Toolbar ); cursorBM[7] = cursorPM;
  cursorPM = loader->loadIcon( "caddns1",KIcon::Toolbar ); maske = cursorPM; cursor[7] = new QCursor( cursorBM[7], maske,7,10);
  cursorPM = loader->loadIcon( "caddos",KIcon::Toolbar ); cursorBM[8] = cursorPM;
  cursorPM = loader->loadIcon( "caddos1",KIcon::Toolbar ); maske = cursorPM; cursor[8] = new QCursor( cursorBM[8], maske,7,10);
  */

  imgNote[0] = loader->loadIcon( "note0",KIcon::Toolbar ); maske = imgNote[0]; imgNote[0].setMask( maske );
  imgNote[1] = loader->loadIcon( "note1",KIcon::Toolbar ); maske = imgNote[1]; imgNote[1].setMask( maske );

  imgSign[0] = loader->loadIcon( "sgnFlat2",KIcon::Toolbar ); maske = imgSign[0]; imgSign[0].setMask( maske );
  imgSign[1] = loader->loadIcon( "sgnFlat",KIcon::Toolbar ); maske = imgSign[1]; imgSign[1].setMask( maske );
  imgSign[2] = loader->loadIcon( "note1",KIcon::Toolbar );
  imgSign[3] = loader->loadIcon( "sgnSharp",KIcon::Toolbar );  maske = imgSign[3]; imgSign[3].setMask( maske );
  imgSign[4] = loader->loadIcon( "sgnSharp2",KIcon::Toolbar );  maske = imgSign[4]; imgSign[4].setMask( maske );
  imgSign[5] = loader->loadIcon( "sgnNat",KIcon::Toolbar );  maske = imgSign[5]; imgSign[5].setMask( maske );

  imgClef[0] = loader->loadIcon( "key0",KIcon::Toolbar ); maske = imgClef[0]; imgClef[0].setMask( maske );
  imgClef[1] = loader->loadIcon( "key1",KIcon::Toolbar ); maske = imgClef[1]; imgClef[1].setMask( maske );
  imgClef[2] = loader->loadIcon( "key2",KIcon::Toolbar ); maske = imgClef[2]; imgClef[2].setMask( maske );
  imgClef[3] = loader->loadIcon( "key3",KIcon::Toolbar ); maske = imgClef[3]; imgClef[3].setMask( maske );
  imgClef[4] = loader->loadIcon( "key4",KIcon::Toolbar ); maske = imgClef[4]; imgClef[4].setMask( maske );
  imgClef[5] = loader->loadIcon( "key5",KIcon::Toolbar ); maske = imgClef[5]; imgClef[5].setMask( maske );
  imgClef[6] = loader->loadIcon( "key6",KIcon::Toolbar ); maske = imgClef[6]; imgClef[6].setMask( maske );
  imgClef[7] = loader->loadIcon( "key7",KIcon::Toolbar ); maske = imgClef[7]; imgClef[7].setMask( maske );
  imgClef[8] = loader->loadIcon( "key8",KIcon::Toolbar ); maske = imgClef[8]; imgClef[8].setMask( maske );
  imgClef[9] = loader->loadIcon( "key9",KIcon::Toolbar ); maske = imgClef[9]; imgClef[9].setMask( maske );
  imgClef[10] = loader->loadIcon( "key10",KIcon::Toolbar ); maske = imgClef[10]; imgClef[10].setMask( maske );
  imgClef[11] = loader->loadIcon( "key11",KIcon::Toolbar ); maske = imgClef[11]; imgClef[11].setMask( maske );
  imgClef[12] = loader->loadIcon( "key12",KIcon::Toolbar ); maske = imgClef[12]; imgClef[12].setMask( maske );
  imgClef[13] = loader->loadIcon( "key13",KIcon::Toolbar ); maske = imgClef[13]; imgClef[13].setMask( maske );

  imgFlat  = loader->loadIcon( "sgnFlat",KIcon::Toolbar );  maske = imgFlat; imgFlat.setMask( maske );
  imgSharp = loader->loadIcon( "sgnSharp",KIcon::Toolbar ); maske = imgSharp; imgSharp.setMask( maske );

  imgFlag[0] = loader->loadIcon( "flagX",KIcon::Toolbar ); QBitmap BMflag; BMflag = imgFlag[0]; imgFlag[0].setMask( BMflag );
  imgFlag[1] = loader->loadIcon( "flagI",KIcon::Toolbar ); QBitmap BMflag1; BMflag1 = imgFlag[1]; imgFlag[1].setMask( BMflag1 );

  arrBreak[9] = loader->loadIcon( "b1",KIcon::Toolbar ); maske = arrBreak[9]; arrBreak[9].setMask( maske );
  arrBreak[8] = loader->loadIcon( "b2",KIcon::Toolbar ); maske = arrBreak[8]; arrBreak[8].setMask( maske );
  arrBreak[7] = loader->loadIcon( "b4",KIcon::Toolbar ); maske = arrBreak[7]; arrBreak[7].setMask( maske );
  arrBreak[6] = loader->loadIcon( "b8",KIcon::Toolbar ); maske = arrBreak[6]; arrBreak[6].setMask( maske );
  arrBreak[5] = loader->loadIcon( "b16",KIcon::Toolbar ); maske = arrBreak[5]; arrBreak[5].setMask( maske );
  arrBreak[4] = loader->loadIcon( "b32",KIcon::Toolbar ); maske = arrBreak[4]; arrBreak[4].setMask( maske );
}



int KdeScorePainter::indentSystem(ScoreBar * bar) {
  if (!bar->isFirst()) return 6;
  else return 2 + 60 + 6*abs(bar->key());
}

// *********************************************
// **                                         **
// **                                         **
// **                  BAR                    **
// **                                         **
// **                                         **
// *********************************************


void KdeScorePainter::paintBar(ScoreBar * bar, PrScoreEditor * ed, Table * grps, int x, int y, int style) {
  //
  // style: 0 = center, 1 = top, 2 = bottom
  //
  clef = bar->clef();
  key = bar->key();

  score = ((KdeScoreEditor2*) ed)->score();
  int wd = bar->width() - 1;
  int yoffset = 40 + YTOP + y;
  int ind = indent(bar);
  unitsPerTick = bar->unitsPerTick();

  // score->drawRect(x, y, wd, 2); score->drawRect(x, y+4, ind, 2);

  for (int i=0;i<5;i++) {
    score->drawLine(x, yoffset + i*6, x + wd, yoffset + i*6);
  }
  int ydraw = style<2? YDELTA : 0;
  score->drawLine(x, yoffset, x, yoffset+24+ydraw);
  score->drawLine(x + wd, yoffset, x + wd, yoffset+24+ydraw);

  if (bar->isLast()) {
    score->drawLine(x + wd+1, yoffset, x + wd+1, yoffset+24+ydraw);
    score->drawLine(x + wd-4, yoffset, x + wd-4, yoffset+24+ydraw);
  }

  if (bar->isFirst()) {

    score->drawLine(x-1, yoffset, x-1, yoffset+24+ydraw);
    score->drawLine(x+4, yoffset, x+4, yoffset+24+ydraw);
    if (style==1) { // TOP
      score->drawLine(x, yoffset, x+4, yoffset-6);
      score->drawLine(x, yoffset-1, x+4, yoffset-7);
    } else if (style==2) {
      score->drawLine(x, yoffset+24, x+4, yoffset+24+6);
      score->drawLine(x, yoffset+24+1, x+4, yoffset+24+7);
    }

    if (bar->isActive()) {
      score->fillRect(x+2, yoffset+1, 4, 23, Qt::red);
    }

    //
    // Draw Clef:
    // **********
    //
    score->drawPixmap(x + 4, yoffset - 8, imgClef[clef]); // draw Clef

    //
    // Draw Key:
    // *********
    //
    for (int i=0; i<abs(key); i++) {
      if (key>0) { score->drawPixmap(x + 45+i*6-8, yoffset + (sharpTab[i]+signShift[clef])*3 -11, imgSharp); // draw sharps
      } else { score->drawPixmap(x + 45+i*6-8, yoffset + (flatTab[i]+signShift[clef])*3 -14, imgFlat);         // draw flats
      }
    }

    //
    // Draw Meter:
    // ***********
    //
    score->drawText(x+ind-14, yoffset+11, string(bar->meter(0)));
    score->drawText(x+ind-14, yoffset+23, string(bar->meter(1)));

    //
    // Draw Program:
    // *************
    //
    int prg = bar->program();
    score->drawText(x+2, 14, programName(prg));

    //
    // Draw Position:
    // **************
    //
    score->drawText(x+2, 26, bar->position());
  }

  //
  // reset signs
  //
  resetSigns(key);

  long left = bar->start().ticks();
  for (int i=0; i<grps->size(); i++) {
    ScoreGroup * grp = (ScoreGroup*) grps->get(i);
    grp->paint(ed, x+ind+int(unitsPerTick*(grp->start() - left)), y+YTOP);
  }

  //
  // Symbols:
  //
  Symbol * sym = 0;
  int xx = 0;
  int yy = 0;
  for (Reference * ref = bar->symbols(); ref != 0; ref = (Reference*) grps->next(ref)) {
    sym = (Symbol*) ref->getValue();
    cout << "sym: " << sym << endl;
    // score->drawPixmap(x+ind+int(unitsPerTick*(ed->part()->start(sym)-left)), y+YTOP+sym->displacement()-8, imgScoreSymbolPtr[sym->symbol()]);

    xx = x+ind+int(unitsPerTick*(ed->part()->start(sym)-left));
    yy = y+YTOP+sym->displacement()-8;
    if (sym->isText()) score->drawText(xx, yy, sym->text());
    else if (!sym->isParameterized())
      score->drawPixmap(xx, yy, imgScoreSymbolPtr[sym->symbol()]);
    else { // parameterized score symbol!
      // int par = int( sym->parameter()*unitsPerTick );
      int par = ed->xposition(ed->part()->start(sym) + sym->parameter()) - ed->xposition(ed->part()->start(sym));
      switch (sym->symbol()) {
      case AS_DECRESCENDO:
	score->drawLine(xx,yy-4,xx+par,yy);
	score->drawLine(xx,yy+4,xx+par,yy);
	break;
      case AS_CRESCENDO:
	score->drawLine(xx,yy,xx+par,yy-4);
	score->drawLine(xx,yy,xx+par,yy+4);
	break;
      case AS_8VA:
	score->drawPixmap(xx, yy - 9, imgScoreSymbolPtr[sym->symbol()]);
	if (par>20) { score->setPen(Qt::DotLine); score->drawLine(xx+20, yy-5, xx+par, yy-5); score->setPen(Qt::SolidLine); }
	break;
      case AS_15VA:
	score->drawPixmap(xx, yy - 9, imgScoreSymbolPtr[sym->symbol()]);
	if (par>20) { score->setPen(Qt::DotLine); score->drawLine(xx+20, yy-5, xx+par, yy-5); score->setPen(Qt::SolidLine); }
	break;
      case AS_TRILLX:
	score->drawPixmap(xx, yy - 9, imgScoreSymbolPtr[sym->symbol()]);
	if (par>20) {
	  for (int i=0;int(i/20)<int(par/20);i += 20)
	    score->drawPixmap(xx+20+i, yy - 10, imgScoreSymbolPtr[AS_TRILLX2]);
	}
	break;
      case AS_TRILLX2:
	score->drawPixmap(xx, yy - 9, imgScoreSymbolPtr[AS_TRILLX2]);
	for (int i=0;int(i/20)<int(par/20);i += 20)
	  score->drawPixmap(xx+20+i, yy - 9, imgScoreSymbolPtr[AS_TRILLX2]);
	break;
      }
    }



  }


}



// *********************************************
// **                                         **
// **                                         **
// **                 GROUP                   **
// **                                         **
// **                                         **
// *********************************************


void KdeScorePainter::paintGroup(ScoreGroup * group, PrScoreEditor * ed, Table * elements, int xoff, int yoff) {
  // score->drawRect(xoff,2,group->duration()*unitsPerTick-2,1);

  initGroupGeometry(group, xoff, 7);
  long left = group->start().ticks();
  ScoreElement * nx = 0;
  ScoreElement * pv = 0;

  //
  // The chords all have to be painted once before the beams are drawn.
  //
  for (ScoreElement * el = (ScoreElement *) elements->first(); el != 0; el = nx) {
    nx = (ScoreElement*) elements->next(el);
    //
    // nx may possibly be zero, el may not!
    //
    el->paint(ed, xoff+int((el->start() - left) * unitsPerTick), yoff); // this initializes the c_geometry structure

    if (el->isBreak()) {
      //
      // break
      //
      use(BREAK, 0, xoff+int((el->start() - left) * unitsPerTick));
    } else if (!hasFlags()) {
      //
      // chord without flags (quarter and up)
      //
      use(SINGLE, c_geometry, xoff+int((el->start() - left) * unitsPerTick));
      if ( hasStem() ) {
	if ( c_geometry->stemDir == STEM_UP ) score->drawLine(c_geometry->stemPos, yoff + c_geometry->yBottom+1, c_geometry->stemPos, yoff + c_geometry->yTop+3 - stemLength());
	else  score->drawLine(c_geometry->stemPos, yoff + c_geometry->yTop+1, c_geometry->stemPos, yoff + c_geometry->yBottom+3 + stemLength());
      }
    } else {
      if ( ( !nx || nx->hasNoFlags() ) && ( !pv || pv->hasNoFlags() ) ) {
	//
	// one single chord with flags
	//
	if (ed->beamsExceedBreaks() && !group->single()) {
	  use(MULTIPLE, c_geometry, xoff+int((el->start() - left) * unitsPerTick));
	} else {
	  if ( c_geometry->stemDir == STEM_UP ) {
	    score->drawLine(c_geometry->stemPos, yoff + c_geometry->yBottom+1, c_geometry->stemPos, yoff + c_geometry->yTop+3 - stemLength());
	    for (int i=0; i<flags(); i++)
	      score->drawPixmap(c_geometry->stemPos, yoff + c_geometry->yTop-21+i*5, imgFlag[0]);
	  } else {
	    score->drawLine(c_geometry->stemPos, yoff + c_geometry->yTop+1, c_geometry->stemPos, yoff + c_geometry->yBottom+3 + stemLength());
	    for (int i=0; i<flags(); i++)
	      score->drawPixmap(c_geometry->stemPos, yoff+c_geometry->yBottom+12-i*5, imgFlag[1]);
	  }
	  use(SINGLE, c_geometry, xoff+int((el->start() - left) * unitsPerTick));
	}
      } else {
	//
	// chord with flags
	// as part of a group
	//
	use(MULTIPLE, c_geometry, xoff+int((el->start() - left) * unitsPerTick));
      }
    }

    pv = el;
  }

  makeGroupGeometry(ed->horizontalBeams());

  if ( g_geometry->dir == STEM_DOWN ) {
    //
    // STEM DOWN
    //
    if (!group->single()) {
      int j = 0;
      bool mm = false; // mm is true, if chord i has as many beams as chord i+1 or i-1
      for (int i=g_geometry->elements-1; i>=0; i--) {
	j = i==g_geometry->elements-1 ? i-1 : i+1;
	xpos  = g_geometry->xPosLeft[i];
	xpos1 = g_geometry->xPosLeft[j]; // if right most note, xpos1 is left from current note
	xpos2 = int(0.5 * (xpos + xpos1));
	ypos  = g_geometry->yPos[i]+1;
	ypos1 = g_geometry->yPos[j]+1;
	ypos2 = int(0.5 * (ypos + ypos1));
	mm = false;
	if ( ( (j == i+1) && (g_geometry->flags[i] == g_geometry->flags[i+1]) ) ||
	     ( (i != 0)   && (g_geometry->flags[i] == g_geometry->flags[i-1]) ) )
	  mm = true;
	
	score->drawLine(xpos, yoff + g_geometry->yTop[i]+1, xpos, yoff + ypos);
	
	QPen flagPen = score->pen(); flagPen.setWidth(3); score->setPen(flagPen);
	common_beams = g_geometry->flags[i] < g_geometry->flags[j] ? g_geometry->flags[i] : g_geometry->flags[j];
	
	//
	// draw common beams
	//
	if (i != g_geometry->elements-1)
	  for (int k = common_beams-1; k>=0; k--)
	    score->drawLine(xpos, yoff + ypos - k*5, xpos1, yoff + ypos1 - k*5);
	//
	// draw own beams
	
	if (!mm)
	  for (int k = common_beams; k < g_geometry->flags[i]; k++)
	    score->drawLine(xpos, yoff + ypos - k*5, xpos2, yoff + ypos2 - k*5);
	
	flagPen = score->pen(); flagPen.setWidth(0); score->setPen(flagPen);
      }
    }
    if (g_geometry->tuplet != 0) {
      int x = int(0.5 * (g_geometry->xTupletLeft + g_geometry->xTupletRight));
      int y = int(0.5 * (g_geometry->yTupletLeft + g_geometry->yTupletRight));
      score->drawLine(g_geometry->xTupletLeft, yoff + g_geometry->yTupletLeft, g_geometry->xTupletLeft, yoff + g_geometry->yTupletLeft+4);
      score->drawLine(g_geometry->xTupletRight, yoff + g_geometry->yTupletRight, g_geometry->xTupletRight, yoff + g_geometry->yTupletRight+4);
      score->drawLine(g_geometry->xTupletLeft, yoff + g_geometry->yTupletLeft, g_geometry->xTupletRight, yoff + g_geometry->yTupletRight);
      score->drawText(x, yoff + y-8, string(g_geometry->tuplet));
    }
  } else {
    //
    // STEM UP
    //
    if (!group->single()) {
      int j = 0;
      bool mm = false; // mm is true, if chord i has as many beams as chord i+1 or i-1
      for (int i=g_geometry->elements-1; i>=0; i--) {
	j = i==g_geometry->elements-1 ? i-1 : i+1;
	xpos  = g_geometry->xPosRight[i];
	xpos1 = g_geometry->xPosRight[j]; // if right most note, xpos1 is left from current note
	xpos2 = int(0.5 * (xpos + xpos1));
	ypos  = g_geometry->yPos[i]+1;
	ypos1 = g_geometry->yPos[j]+1;
	ypos2 = int(0.5 * (ypos + ypos1));
	mm = false;
	if ( ( (j == i+1) && (g_geometry->flags[i] == g_geometry->flags[i+1]) ) ||
	     ( (i != 0)   && (g_geometry->flags[i] == g_geometry->flags[i-1]) ) )
	  mm = true;
	
	score->drawLine(xpos, yoff + g_geometry->yBottom[i]+1, xpos, yoff + ypos);
	
	QPen flagPen = score->pen(); flagPen.setWidth(3); score->setPen(flagPen);
	common_beams = g_geometry->flags[i] < g_geometry->flags[j] ? g_geometry->flags[i] : g_geometry->flags[j];
	
	//
	// draw common beams
	//
	if (i != g_geometry->elements-1)
	  for (int k = common_beams-1; k>=0; k--)
	    score->drawLine(xpos, yoff + ypos + k*5, xpos1, yoff + ypos1 + k*5);
	//
	// draw own beams
	//
	if (!mm)
	  for (int k = common_beams; k < g_geometry->flags[i]; k++)
	    score->drawLine(xpos, yoff + ypos + k*5, xpos2, yoff + ypos2 + k*5);
	
	flagPen = score->pen(); flagPen.setWidth(0); score->setPen(flagPen);
      }
    }
    if (g_geometry->tuplet != 0) {
      int x = int(0.5 * (g_geometry->xTupletLeft + g_geometry->xTupletRight));
      int y = int(0.5 * (g_geometry->yTupletLeft + g_geometry->yTupletRight));
      score->drawLine(g_geometry->xTupletLeft, yoff + g_geometry->yTupletLeft, g_geometry->xTupletLeft, yoff + g_geometry->yTupletLeft-4);
      score->drawLine(g_geometry->xTupletRight, yoff + g_geometry->yTupletRight, g_geometry->xTupletRight, yoff + g_geometry->yTupletRight-4);
      score->drawLine(g_geometry->xTupletLeft, yoff + g_geometry->yTupletLeft, g_geometry->xTupletRight, yoff + g_geometry->yTupletRight);
      score->drawText(x, yoff + y+16, string(g_geometry->tuplet));
    }
  }


}



// *********************************************
// **                                         **
// **                                         **
// **                 CHORD                   **
// **                                         **
// **                                         **
// *********************************************


void KdeScorePainter::paintChord(ScoreChord * chord, PrScoreEditor * ed, Table * notes, int xoff, int yoff) {
  // score->drawRect(xoff,0,2,2);

  yoff --;
  xoff += 2;

  // score = ((KdeScoreEditor2*) ed)->score();
  initChordGeometry(7,3);
  Note * note = 0;
  QPixmap noteImg;

  for (int i=0; i<notes->size(); i++) {
    note = ((Note*)((Reference*)notes->get(i))->getValue());
    if (note!=0) {
      use(note, chord);
      //
      // draw helplines, above and below the score:
      //
      for (int i=c_geometry->ypos/6; i<6; i++) { score->drawLine(xoff-3, i*6+yoff+5, xoff+9, i*6+yoff+5); }
      for (int i=(c_geometry->ypos/3-1)/2; i>10; i--) { score->drawLine(xoff-3, i*6+yoff+5, xoff+9, i*6+yoff+5); }
      //
      // draw sign:
      //
      if (c_geometry->sgn != 0) { score->drawPixmap(xoff-10, c_geometry->ypos + yoff-(c_geometry->sgn<0)*2-9, imgSign[c_geometry->sgn+2]); }
      //
      // chose notebody (empty or filled):
      //
      if (c_geometry->len>767) { noteImg = imgNote[0]; } else { noteImg = imgNote[1]; }

      //
      // draw note body:
      //
      score->drawPixmap(xoff + (c_geometry->neighbour_offset?8:0), c_geometry->ypos + yoff, noteImg);
      score->setPen(Qt::black);
      //
      // draw dot:
      //
      for (int i=0;i<dot();i++)
	score->drawPoint(xoff + (c_geometry->neighbour_offset?8:0) +8+3*i, c_geometry->ypos + yoff);
      //
      // draw ornaments:
      //
      Vector * vec = note->ornament();
      for (Ornament * orn = (Ornament*) vec->first(); orn != 0; orn = (Ornament*) vec->next(orn)) {
	if (orn->isA()==EXPRESSION) {
	  Expression * exp = (Expression*) orn;
	  score->drawPixmap(xoff + (c_geometry->neighbour_offset?8:0)-4, c_geometry->ypos + yoff + exp->displacement()-8, imgNoteAccentPtr[exp->expression()]);
	} else if (orn->isA()==BOW) {
	  // bow ?
	  Bow * bow = (Bow*) orn;
	  int bowlen = ed->xposition(chord->start() + bow->length()) - ed->xposition(chord->start()); // now bowlen specified the pixels
	  // int bowlen = bow->length();
	  int drc = bow->direction();
	  if (drc==0) drc = -1;
	  int x1 = xoff + (c_geometry->neighbour_offset?8:0);
	  int y1 = c_geometry->ypos + yoff + drc*8;
	  // int dx = int(bowlen*unitsPerTick/3);
	  // int dy = int(bowlen*unitsPerTick/12 * drc);
	  int dx = int(bowlen*1.0/3);
	  int dy = int(bowlen*1.0/12 * drc);
	  int ddy = bow->delta()/3;
	
	  QPointArray aa( 4 );
	  aa.setPoint( 0, x1+4, y1 );
	  aa.setPoint( 1, x1+dx, y1+dy + ddy );
	  aa.setPoint( 2, x1+2*dx, y1+dy + 2*ddy );
	  aa.setPoint( 3, x1+3*dx, y1 + 3*ddy );
#if QT_VERSION >= 300
	  score->drawCubicBezier(aa);
#else
	  score->drawQuadBezier(aa);
#endif
	  aa.setPoint( 1, x1+dx, y1+dy+1 + ddy );
	  aa.setPoint( 2,x1+2*dx, y1+dy+1 + 2*ddy );
#if QT_VERSION >= 300
	  score->drawCubicBezier(aa);
#else
	  score->drawQuadBezier(aa);
#endif
	} else if (orn->isA()==LYRICS) {
	  const char * txt = note->lyrics()->get();
	  score->drawText(xoff + (c_geometry->neighbour_offset?8:0), yoff + 92, txt);
	} else if (orn->isA()==RIEMANNFUNCTION) {
	  const char * txt = note->function()->get();
	  score->drawText(xoff + (c_geometry->neighbour_offset?8:0), yoff + 22, txt);
	}
      }

      //
      // draw xor box around selected note:
      //
      if (selectioN->hasEntry(note)) {
	score->setRasterOp(Qt::NotROP);
    	score->fillRect(xoff + (c_geometry->neighbour_offset?8:0)-2, c_geometry->ypos + yoff-1, 11, 7, Qt::darkGray);
	score->setRasterOp(Qt::CopyROP);
      } else {
	//
	// color channels?
	//
	if (ed->color() && (note->chan() > -1)) {
	  // score->setPen(QColor((note->chan()*33)%360, 120, 240, QColor::Hsv));
	  score->setRasterOp(Qt::OrROP);
	  score->fillRect(xoff + (c_geometry->neighbour_offset?8:0)-2, c_geometry->ypos + yoff-1, 11, 7, QColor((note->chan()*33)%360, 120, 240, QColor::Hsv));
	  score->setRasterOp(Qt::CopyROP);

	} else {
	  // score->setPen(Qt::black);
	}
      }



    } else cout << "i(size): " << i << " (" << notes->size() << ") at:" << chord->start() << endl;
  }

  makeChordGeometry(xoff);

}



// *********************************************
// **                                         **
// **                                         **
// **                 BREAK                   **
// **                                         **
// **                                         **
// *********************************************


void KdeScorePainter::paintBreak(ScoreBreak * brk, PrScoreEditor * ed, int x, int y) {
  // 4 = 1/32, 9 = whole!
  // cout << "brk: " << brk->length() << endl;

  int len = 9 - lengthOrd(brk->display());
  len = len<4 ? 4 : len;
  len = len>9 ? 9 : len;

  if (len >= 7) x += int(brk->display()*0.5*unitsPerTick); // half and whole breaks are centered
  else          x += 6; // shorter breaks are pushed a litte bit

  score->drawPixmap(x - 6, y+41 , arrBreak[len]);
}

#endif
