#ifndef _KDEEVENTFRAME_CPP_
#define _KDEEVENTFRAME_CPP_

#include <iostream.h>

#include <qpainter.h>
#include <qheader.h>

#include "kdeEventFrame.h"
#include "kdeEventEditor.h"

#include "part.h"
#include "song.h"
#include "note.h"
#include "position.h"
#include "iterator.h"

extern Song * sonG;


KdeEventFrame::KdeEventFrame( KdeEventEditor * qte, Part * pt, QWidget * parent ) : QFrame(parent), ee(qte), part(pt) {}

void KdeEventFrame::paintEvent( QPaintEvent * pe ) {
  QFrame::paintEvent(pe);
  // JAN ee->rewind();
  QPainter p;
  p.begin(this);
  
  KdeEventContent * lw = ee->content();
  
  QListViewItem * item = lw->firstChild();
  
  int pos;
  int yoff = lw->header()->height() + 2; // + lw->verticalScrollBar()->value();
  int barlen = int(width()*0.25);
  int len = 0;
  int indent = 18;
  unsigned long xoff = 0;
  int line = 0;
  /* JAN bool ok = true;
  while (ok) {
  Event * ev = part->current();*/

  for (Iterator i = Iterator(ee); !i.done(); i++) {
    Event * ev = (Event*) *i;
    if (ev!=0) {
      if (line == 0) xoff = part->start(ev).ticks();
      pos = int(ev->internalStart().ticks() - xoff);
      pos = (pos*barlen)/1536;
      len = 2;
      len = ((Note*)ev)->duration(); len = (len*barlen)/1536;

      QRect r( lw->itemRect( item ) );
      if (r.height()>-1) {
	r.setY(r.y() + yoff);
	// r.setHeight( (QCOORD)(QMIN( item->totalHeight(), lw->viewport()->height() - r.y() ) ) );
	r.setHeight( item->totalHeight() );
	r.setX(pos + indent);
	r.setWidth(len);
	p.fillRect(r,gray);
	p.drawRect(r);
      }
      item = item->nextSibling();
      line++;
    }
    // JAN ok = ee->currentInc();
  }

  /*
  int barlen = int(width()*0.25);
  int barnum = 4;
  int yScale = 16; // ee->itemHeight();
  int pos;
  int line = 1;
  int len = 0;
  int indent = 18;
  unsigned long xoff = 0;
  bool ok = true;
  while (ok) {
    Event * ev = part->current();
    if (ev!=0) {
      if (line==1) xoff = ev->start().ticks() + part->start().ticks();
      pos = int(ev->start().ticks() - xoff);
      pos = (pos*barlen)/1536;
      len = 2;
      len = ((Note*)ev)->duration(); len = (len*barlen)/1536;
      p.fillRect(pos+indent,1+(yScale*line)+2,len,yScale-2,black);
      line++;
    }
    ok = ee->currentInc();
  }
  */
  p.end();
}



#endif
#include "kdeEventFrame.moc"
