#ifndef _KDENOTEBAR_H_
#define _KDENOTEBAR_H_

#include <ktoolbar.h>
#include <qlabel.h>
#include <qcombobox.h>

class PrPartEditor;

class KdeEditorNoteBar : public KToolBar
{
  Q_OBJECT

private:
  PrPartEditor * _editor;
  int pos;
  char position[32];
  char lengths[12];
  char pitch[12];
  char velocity[12];
  char channel[12];
  QLabel * qlPosition;
  int enhValue;
  QComboBox * enhLabel;
  QLineEdit * start;
  QLineEdit * length;
  QLineEdit * freq;
  QLineEdit * vel;
  QLineEdit * chan;

public:
  KdeEditorNoteBar( QWidget * parent, PrPartEditor * ed );
  
  void setStart(int,int,int);
  void setLength(int);
  void setPitch(int);
  void setVelocity(int);
  void setEnh(int);
  void setChan(int);
  void clear();
  void update();

public slots:
  void startCF();
  void lengthCF();
  void freqCF();
  void velCF();
  void chanCF();
  void enhCF();
  void startEnter();
  void lengthEnter();
  void freqEnter();
  void velEnter();
  void chanEnter();
  void enhEnter();
};



#endif
