#ifndef _KDEDRUMTRACK_H_
#define _KDEDRUMTRACK_H_

#include "kdeTrack.h"

class QSpinBox;
class QComboBox;

class KdeDrumTrack : public KdeTrack
{
  Q_OBJECT

 private:
  QSpinBox * _chanbox;
  QComboBox * _instbox;
  QComboBox * _output;
  QSpinBox * _vol;
  QSpinBox * _tra;
  QSpinBox * _del;

 public:
  KdeDrumTrack(Track*);
  virtual void update(bool menu=false);
  virtual void erase();

  int gProgram();
  void sProgram(int n);

 public slots:
  void updateChan(int);
  void updateInst(int);
  void updateOut(int);
  void updateVol(int);
  void updateTra(int);
  void updateDel(int);
};


#endif
