#ifndef _TUPLET_H_
#define _TUPLET_H_


class Tuplet
{
 private:
  short int _base;
  short int _duration;

 public:
  /** default contructor */
  Tuplet();

  /** creates a tuplet with base and duration */
  Tuplet(int base, int dur = 384);

  /** returns the base */
  int base() const { return (int) _base; }

  /** returns the duration */
  int duration() const { return (int) _duration; }

  /** sets the base */
  void setBase(int);

  /** sets the duration */
  void setDuration(int);

  /** converts display (value to be displayed) to duration (ticks to be heared), e.g. duration(192) = 128 */
  int duration(int disp) const { return int(disp*(_base+1)*0.5 / _base); }

  /** converts duration (ticks to be heared) to display (value to be displayed), e.g. display(128) = 192 */
  int display(int dur) const { return int(dur*_base*2.0 / (_base+1)); }
};

#endif
