#ifndef _SCOREELEMENT_CPP_
#define _SCOREELEMENT_CPP_

#include <iostream.h>

#include "scoreElement.h"


ScoreElement::ScoreElement() : _start(0), _dur(0), _disp(0), _tuplet(0) {}

ScoreElement::~ScoreElement() {}

const Position & ScoreElement::start() const {
  return _start;
}

long ScoreElement::end() const {
  long x = _start.ticks();
  x += _dur;
  return x;
}

long ScoreElement::duration() const { return _dur; }

int ScoreElement::display() const { return _disp; }

void ScoreElement::setStart(Position pos) {
  _start = pos;
}

void ScoreElement::setDuration(long l) {
  _dur = l;
}

void ScoreElement::setDisplay(int i) {
  _disp = i;
}

void ScoreElement::snapStart(int i) {
  _start.snap(i);
}



#endif
