#ifndef _REMOVEELEMENT_H_
#define _REMOVEELEMENT_H_

#include "operation.h"

class Element;
class Compound;

/** This operation removes an element, but keeps it inside the operation instance.
 * When operation-instance is deleted, the element is deleted or kept, depending on the state of the operation (undone, redone...)
 */
class RemoveElement : public Operation
{
 private:
  Element *  _element;
  Compound * _list;
  int        _ord;
  Element *  _delete;

 public:
  RemoveElement(Element * e, Compound * list);
  RemoveElement(const RemoveElement&);
  ~RemoveElement();

  void undo();
  void redo();


  virtual ostream & print(int,ostream&) const;
  virtual void flush(const char*) const;
  virtual Element * copy() const;
};



#endif
