#ifndef _REMOVEELEMENT_CPP_
#define _REMOVEELEMENT_CPP_

#include <iostream.h>

#include "removeElement.h"
#include "element.h"
#include "compound.h"

RemoveElement::RemoveElement(Element * e, Compound * list) : _element(e), _list(list), _ord(-1) {
  _type = REMOVEELEMENT;
  _description = "remove element";
  _to_be_undone = true;
  if (list) {
    if (e) {
      _ord = _element->ord(_list);
      _element->hide();
      _list->remove(_element);
      _delete = _element;
    }
  }
}

RemoveElement::RemoveElement(const RemoveElement& el) : Operation(el) {
  _type = REMOVEELEMENT;
  _element = el._element;
  _list = el._list;
  _delete = el._delete;
}

RemoveElement::~RemoveElement() {
  delete _delete;
}

void RemoveElement::undo() {
  if (_list) {
    if (_element) {
      _list->insertAt(_ord,_element);
      _element->show();
      _delete = 0;
    }
  }
}

void RemoveElement::redo() {
  if (_list) {
    if (_element) {
      _element->hide();
      _list->remove(_element);
      _delete = _element;
    }
  }
}



// ---------------
// virtuals:
//

ostream & RemoveElement::print(int dep, ostream & s) const {
  s << spc(dep) << "<REMOVEELEMENT element=\"" << _element->ctype() << "\" compound=\"" << _list->ctype() << "\" />" << endl;
  return s;
}

void RemoveElement::flush(const char * c) const {
  cout << c << "REMOVEELEMENT" << endl;
}

Element * RemoveElement::copy() const {
  return new RemoveElement(*this);
}


#endif
