#ifndef _PRPARTEDITOR_CPP_
#define _PRPARTEDITOR_CPP_

#include <stdio.h>
#include <iostream.h>
#include <math.h>

#include "prMainEditor.h"
#include "prPartEditor.h"
#include "table.h"
#include "note.h"
#include "part.h"
#include "track.h"
#include "reference.h"
#include "str.h"
#include "song.h"
#include "event.h"
#include "iterator.h"
#include "selectLeft.h"
#include "selectRight.h"
#include "unselect.h"

extern Song * sonG;
extern Table * selectioN;
extern PrMainEditor * mainEditor;

// tracktypes: SCORETRACK, DRUMTRACK, MASTERTRACK, AUDIOTRACK, COMMENTTRACK

bool EditorMatrix[7][5] = {
  { true, false, false, false, false }, // NOTEEDITOR
  { true, false, false, false, false }, // PREDITOR
  { true, false, false, false, false }, // SCOREEDITOR
  { false, false, true, false, false }, // MASTEREDITOR
  { true, true, true, true, false    }, // EVENTEDITOR
  { false, false, false, true, false }, // AUDIOEDITOR
  { false, true, false, false, false }  // DRUMEDITOR
};

PrPartEditor::PrPartEditor(EditorType type) : _parts(new Table()), _current(0), _leftPos(0), _rightPos(0),
			       _current_length(192), _current_enh(0), _current_vel(87), _current_dot(0), _current_tuplet(0), _current_tuplet_dur(0),
			       _cLeft(new char [13]), _cRight(new char[13]), _bars(4), _grid(192), _resolution(96), _no_overlap(true), _color(false), _speaker(true),
			       _type(type) {
  // no parameter means: edit song:
  char * name = 0;
  int imax = sonG->size();
  Track * tr = 0;
  //Part * pt = 0;
  for (int i=0; i<imax; i++) {
    name = 0;
    tr = (Track*) sonG->get(i);
    if ( (tr != 0) && (!tr->mute()) && (tr->content()!=0) && (handles(tr)) ) {
      String * s = tr->name();
      if (s) name = (char*) s->getValue();
      if (name==0) { name = new char[2]; name[0] = '-'; name[1] = 0; }
      _parts->add(new Reference(name,tr->first()));
    }
  }
  _current = (Reference*) _parts->first();
  if (_current && _current->getValue())
    wind(((Part*)_current->getValue())->start());

  sonG->doo(new Unselect());
}

PrPartEditor::PrPartEditor(Part * p) : _parts(new Table()), _current(0), _leftPos(0), _rightPos(0),
				       _current_length(192), _current_enh(0), _current_vel(87), _current_dot(0), _current_tuplet(0), _current_tuplet_dur(0),
				       _cLeft(new char [13]), _cRight(new char[13]), _bars(4), _grid(192), _resolution(96), _no_overlap(true), _color(false), _speaker(true) {
  _current = new Reference((char*)p->ctype(),p);
  _parts->add(_current);
  if (_current && _current->getValue())
    wind(((Part*)_current->getValue())->start());

  sonG->doo(new Unselect());
}

PrPartEditor::PrPartEditor(Track * t) : _parts(new Table()), _current(0), _leftPos(0), _rightPos(0),
					_current_length(192), _current_enh(0), _current_vel(87), _current_dot(0), _current_tuplet(0), _current_tuplet_dur(0),
					_cLeft(new char [13]), _cRight(new char[13]), _bars(4), _grid(192), _resolution(96), _no_overlap(true), _color(false), _speaker(true) {

  char * name = 0;
  Part * p = 0;
  if (t!=0) {
    p = (Part*) t->first(); // TODO: What to do with the following parts?
    String * s = t->name();
    if (s) name = (char*) s->getValue();
  }
  if (name==0) { name = new char[2]; name[0] = '-'; name[1] = 0; }
  if (p!=0) {
    _current = new Reference(name,p);
    _parts->add(_current);
  }
  if (_current && _current->getValue())
    wind(((Part*)_current->getValue())->start());

  sonG->doo(new Unselect());
  cout << "TODO: set flag to use all parts in track or so..." << endl;
}

PrPartEditor::~PrPartEditor() {
  mainEditor->removeEditor(this);
  mainEditor->update();
  delete _parts;
  delete _cLeft;
  delete _cRight;
}

void PrPartEditor::adjustEventParameters() {
  Event * cur = currentEvent();
  if (cur!=0) {
    _current_length = cur->duration();
    // TODO: _current_dot;
    // TODO: _current_tri;
    if (cur->isA()==NOTE) {
      _current_enh = ((Note*)cur)->enh();
      _current_vel = ((Note*)cur)->vel();
    }
    update();
  }
}

bool PrPartEditor::handles(Track * tr) const {
  return EditorMatrix[_type][tr->isA()];
}

bool PrPartEditor::isOfType(EditorType t) const { return (_type==t); }

Part * PrPartEditor::part() const {
  Part * pt = 0;
  if (_current) pt = (Part*) _current->getValue();
  return pt;
}

int PrPartEditor::partIndex() {
  int ret = 0;
  Reference * ref = 0;
  Part * mypt = part();
  for (ref = (Reference*) _parts->first(); ref!=0 && (Part*)ref->getValue()!=mypt; ref = (Reference*)_parts->next(ref)) {
    ret++;
  }
  if (ref == 0) ret = -1;
  return ret;
}

Part * PrPartEditor::part(int i) {
  Part * pt = 0;
  Reference * ref = (Reference*) _parts->get(i);
  if (ref) pt = (Part*) ref->getValue();
  return pt;
}

Part * PrPartEditor::setPart(int i) {
  Reference * ref = _current;
  _current = (Reference*) _parts->get(i);
  if (_current==0) _current = ref;
  return part();
}

int PrPartEditor::parts() const { return _parts->size(); }

void PrPartEditor::adjustRightPos() {
  _rightPos = _leftPos;
  // for (int k=0; k<_bars; k++) _rightPos.nextBar(sonG->master(), sonG->meter0(), sonG->meter1()); // DOIT: wech
  for (int k=0; k<_bars; k++) _rightPos.nextBar();
}

const char * PrPartEditor::name() const {
  const char * rv = 0;
  if (_current) rv = _current->getKey();
  return rv;
}

Part * PrPartEditor::moveDown() {
  _current = (Reference*) _parts->next(_current);
  if (_current==0) _current = (Reference*) _parts->first();
  return (Part*) _current->getValue();
}

Part * PrPartEditor::moveUp() {
  _current = (Reference*) _parts->prev(_current);
  if (_current==0) _current = (Reference*) _parts->last();
  return (Part*) _current->getValue();
}


char * PrPartEditor::cLeft() {
  // format: bbb.bb.ttt
  int bar; int beat; int tick;
  sonG->bbt(bar,beat,tick,_leftPos);
  sprintf(_cLeft,"%3d.%2d.%3d",bar,beat,tick);
  return _cLeft;
}

char * PrPartEditor::cRight() {
  // format: bbb.bb.ttt
  int bar; int beat; int tick;
  sonG->bbt(bar,beat,tick,_rightPos);
  sprintf(_cRight,"%3d.%2d.%3d",bar,beat,tick);
  return _cRight;
}

void PrPartEditor::moveleft(int i) {
  for (int k=0; k<i; k++) {
    //_leftPos.nextBar(sonG->master(), sonG->meter0(), sonG->meter1()); // DOIT: wech
    //_rightPos.nextBar(sonG->master(), sonG->meter0(), sonG->meter1());
    _leftPos.nextBar();
    _rightPos.nextBar();
  }
  update();
}

void PrPartEditor::moveright(int i) {
  for (int k=0; k<i; k++) {
    _leftPos.prevBar();
    _rightPos.prevBar();
  }
  update();
}

void PrPartEditor::moveselleft() {
  sonG->doo(new SelectLeft(part(),_rightPos));
  if (sonG->editorAppearance()==ADJUSTPARAMETERS) adjustEventParameters();
}

void PrPartEditor::moveselright() {
  sonG->doo(new SelectRight(part(),_leftPos));
  if (sonG->editorAppearance()==ADJUSTPARAMETERS) adjustEventParameters();
}

void PrPartEditor::wind(int bar) {
  _leftPos.set(bar+1, 1, 0, sonG->master(), sonG->meter0(), sonG->meter1());
  _rightPos = _leftPos;
   for (int k=0; k<_bars; k++) {
    _rightPos.nextBar();
  }
}

void PrPartEditor::wind(Position p) {
  _leftPos = p;
  _rightPos = _leftPos;
  for (int k=0; k<_bars; k++) {
    _rightPos.nextBar();
  }
}


void PrPartEditor::zoomin() {
  _bars--;
  if (_bars<1) {
    _bars = 1;
  } else {
    adjustRightPos();
    update();
  }
}

void PrPartEditor::zoomout() {
  _bars++;
  if (_bars>20) {
    _bars = 20;
  } else {
    adjustRightPos();
    update();
  }
}

int PrPartEditor::totalLength() const {
  int ret = _current_length;
  for (int i=0; i<_current_dot; i++) ret = int(ret*1.5);
  return ret;
}

int PrPartEditor::lengthOrd() const { return 10-int(1.000001*log(_current_length/3)/log(2)); }

void PrPartEditor::setLength(int l) { _current_length = l; }

void PrPartEditor::setLengthOrd(int l) { // 1536 = 1, 768 = 2, 384 = 3, 192 = 4, etc
  _current_length = int(3*pow(2,10-l));
}

void PrPartEditor::setDot(int d) { _current_dot = d; }

void PrPartEditor::setTuplet(int base, int duration) {
  if (base >= 0 && base < 20) {
    _current_tuplet = base;
    _current_tuplet_dur = duration<0 ? int(_current_length*0.5*(base+1)) : duration;
  }
}


void PrPartEditor::setEnharmonicShift(int e) { _current_enh = e; }

void PrPartEditor::setVelocity(int v) { _current_vel = v; }


Note * PrPartEditor::getGrabNote(long mpos, int mpitch, bool & tail) {
  Note * ret = 0;
  Part * _part = part();
  Note * n = 0;
  long pos = 0;
  int len = 0;
  int pi = 0;
  bool loop = true;
  for (Iterator i = Iterator(_part); !i.done() && loop; i++) {
    if ((*i)->isA() == NOTE) {
      n = (Note*) *i;
      pos = _part->start(n).ticks();
      len = n->duration();
      pi = n->pitch();
      // check:
      if ((pos <= mpos) && (mpos < pos+len) && (mpitch==pi)) {
	ret = n;
	if (mpos > pos+len - 16) tail = true;
	loop = false;
      }
    }
  }
  return ret;
}

Event * PrPartEditor::getGrabEvent(long mpos) {
  Event * ret = 0;
  Part * _part = part();
  Event * ev = 0;
  long pos = 0;
  int len = 0;
  bool loop = true;
  for (Iterator i = Iterator(_part); !i.done() && loop; i++) {
    if ((*i)->isEvent()) {
      ev = (Event*) *i;
      pos = _part->start(ev).ticks();
      len = ev->duration();
      // check:
      if ((pos <= mpos) && (mpos < pos+len)) {
	ret = ev;
	loop = false;
      }
    }
  }
  return ret;
}

long PrPartEditor::snap(long pos) const {
  int gr = _grid;
  if (_current_tuplet > 1) gr = int(gr*0.5*(_current_tuplet+1)/_current_tuplet);
  // cout << _current_tuplet << ", " << gr << endl;
  return (gr==0 ? pos : (pos - (pos%gr)));
}

void PrPartEditor::setGrid(int i) { _grid = i; mainEditor->setGrid(i); }

void PrPartEditor::setPartResolution(int i) { _resolution = i; }

void PrPartEditor::setNoOverlap(bool b) { _no_overlap = b; }

Event * PrPartEditor::currentEvent() {
  if (selectioN->size()==1) return (Event*) ((Reference*)selectioN->first())->getValue();
  else                      return 0;
}


void PrPartEditor::setColor(bool c) { _color = c; }

void PrPartEditor::setSpeaker(bool s) { _speaker = s; }

int PrPartEditor::editorWidth() const { return 1; }

bool PrPartEditor::isScoreEditor() const { return false; }


#endif
