#ifndef _MUPPRINTER_CPP_
#define _MUPPRINTER_CPP_

#include <iostream.h>
#include <fstream.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include "stdio.h"

#include "mupPrinter.h"

#include "prScoreEditor.h"
#include "scoreTrack.h"
#include "scoreIterator.h"
#include "song.h"
#include "part.h"
#include "str.h"
#include "scoreBar.h"
#include "scoreGroup.h"
#include "scoreChord.h"
#include "scoreBreak.h"
#include "ornament.h"
#include "lyrics.h"
#include "expression.h"
#include "reference.h"
#include "note.h"
#include "vector.h"

extern Song * sonG;
extern const char * bClef2mClef[];

int y2mup[] = { 'e','d','c','b','a','g','f' };


MupPrinter::MupPrinter() : mupLyrics(0), mupPhrase(0) {

}

void MupPrinter::print(PrScoreEditor * _editor, const char * filename, bool pp, bool pps) {
  int parts = _editor->parts();
  mupLyrics = 0;
  mupPhrase = 0;
  _system_counter = 0;

  if ((filename!=0)&&(strlen(filename)>0)) {
    char * fname = (char*) strdup(filename); // new char[strlen(filename)+8];
    // sprintf(fname,"%s.mup",filename);
    int flen = strlen(fname);
    fname[flen-3] = 'm'; fname[flen-2] = 'u'; fname[flen-1] = 'p';

    ofstream out(fname);
    // ostream & out = cout;

    _out = &out;

    mupLyrics = 0;
    mupPhrase = 0;

    ScoreTrack * scTrack;
    /*    NoteBar * firstBar[parts];
	  NoteBar * myBar[parts];*/
    Part * part = 0;
    int absKey = 0;
    char keyChar = 0;
    int met0 = sonG->meter0();
    int met1 = sonG->meter1();

    // systems:
    int systems = 0;
    int psystem = 0;
    int totalsystems = 0;
    int N;
    if (pp) { // partiture
      for (N=0;N<parts;N++)
	if (((ScoreTrack*)_editor->part(N)->track())->PiP()==true) systems++;
    }
    totalsystems = systems;
    _lyrics_systems = systems;
    if (pps) { totalsystems += 2; psystem = 1; } // pianosystem

    // cout << "systems: " << systems << ", ts: " << totalsystems << endl;
    if (totalsystems>0) {
      out << "header\n"
          "\ttitle (18) \"" << sonG->title() << "\"\n"
          "\ttitle (14) \"" << sonG->comment() << "\"\n"
          "\ttitle \"\"   \"" <<sonG->author() << "\"\n\n"

          "footer\n"
          "\ttitle \" created with Brahms/Linux\"\n\n"

          "header2\n"
          "\ttitle \"- \\\% -\"\n\n"

          "score\n"
          "\ttime = " << _editor->part(0)->meter0() << "/" << _editor->part(0)->meter1() << "\n"
          "\tbeamstyle = ";

      for (int i=0;i<met0;i++) {
	out << met1;
	if (i < met0-1) out << ", ";
      }

      out << "\n"
          "\tscale = 0.8\n"
          "\tmeasnum = y\n"
          "\tstaffs = " << totalsystems << endl;
      // bracket:
      out << "\n"
          "\tbracket = ";
      if (systems>0) {
	out << "1-" << systems;
	if (psystem>0) out << ", ";
      }
      if (psystem>0) {
	out << systems+1 << "-" << totalsystems;
      }
      out << endl;
      // barstyle:
      out << "\n"
          "\tbarstyle = ";
      if (systems>0) {
	out << "1-" << systems;
	if (psystem>0) out << ", ";
      }
      if (psystem>0) {
	out << systems+1 << "-" << totalsystems;
      }
      out << endl;

      if (psystem>0) { // pianosystem
	out << "\n"
            "\tvscheme = 2o" << endl;
      }
      int pNum = 0;
      if (systems>0) { // partiture
	for (N=0;N<parts;N++) {
	  part = _editor->part(N);
	  if (((ScoreTrack*)part->track())->PiP()) {
	    // int pNum = N+1;
	    pNum++;
	    absKey = abs(part->key());
	    keyChar = '#';
	    if (part->key()<0) keyChar = '&';
	    scTrack = (ScoreTrack*) part->track();
	
	    out << "staff " << pNum << "\n"
                "\tlabel = \"" << scTrack->name()->getValue() << "\"\n"
                "\tkey = " << absKey << keyChar << "\n"
                "\tclef = " << bClef2mClef[part->clef()] << endl;
	  }
	}
      }
      if ( psystem > 0 ) { // pianosystem
	absKey = abs(_editor->part(0)->key());
	keyChar = '#';
	if (part->key()<0) keyChar = '&';
	out << "staff " << totalsystems-1 << "\n"
            "\tkey = " << absKey << keyChar << "\n"
            "\tclef = treble" << endl;
	out << "staff " << totalsystems << "\n"
            "\tkey = " << absKey << keyChar << "\n"
            "\tclef = bass" << endl;
      }
      out << "music" << endl;

      Position relPos = 0;
      Position lpos = sonG->left();
      Position rpos = sonG->right();
      pNum = 0;


      ScoreIterator * iterator = new ScoreIterator(_editor, 0, lpos, rpos);
      for (; !iterator->done(); (*iterator)++) {
	_system_counter = 1;
	iterator->print(out);
	(*_out) << endl << "bar" << endl;
      }
      delete iterator;


      out << endl;
      // TODO: out.close();
      char * command = new char[3*strlen(fname)+30];
      char * fname1 = new char[strlen(fname)+1];
      strcpy(fname1,fname);
      flen = strlen(fname1);
      fname1[flen-3] = 'p';
      fname1[flen-2] = 's';
      fname1[flen-1] = 0;
      sprintf(command,"mup %s > %s", fname, fname1);
      int e = ::system(command);
      if (e!=0) cout << "An error has occured using mup" << endl;
      delete fname;
      delete fname1;
      delete command;


	/*
      for (N=0;N<parts;N++) {
	part = _editor->part(N);
	// if (part->gTrack()->PiP()) {
	  pNum++;
	  globalStaffCounter = parts-N-1;
	
	  for (int i=0;i<7;i++) scrSigns[i]=allSigns[scrKey+7][i];
	
	  QtScoreGroup * myGroup = 0;
	  QtScoreGroup * tmp = 0;
	  lpos = 0; // DOIT: posLeft;
	  // relPos = 0 - part->start();
	  Event * atom = (Event*) part->first();
	  while (atom!=0) {
	    if (atom->isA()==NOTE) {
	      Note * note = (Note*) atom;
	      if (myGroup == 0) {
		myGroup = new NoteGroup(note,part->start());
		if (part->start(note).ticks() > 0) {
		  createBreakGroups(firstGroup, tmp, lpos, part->start(note).ticks(), part->start(), master, met0, met1);
		  tmp->sNext(myGroup);
		} else {
		  firstGroup = myGroup;
		}
	      } else {
		myGroup = myGroup->append(note,part->start(),master,met0,met1);
	      }
	    }
	
	    atom = (Event*) part->next(atom);
	    bool allParts = TRUE;
	    if (allParts==TRUE && atom==0 && part->next(part)!=0) { // to the following part ;-)
	      part = (Part*) part->next(part);
	      atom = (Event*)part->first();
	      scrKey = part->key();
	      clef = part->clef();
	    }
	  }
	
	
	  // now everything is packed up in groups, lets pack the
	  // groups into bars:
	
	
	  if (firstGroup) {
	    firstBar[N] = new NoteBar(firstGroup);
	    NoteBar * curBar = firstBar[N];
	    for (myGroup = firstGroup->Next(); myGroup!=0; myGroup = myGroup->Next()) {
	      curBar = curBar->append(myGroup,master,met0,met1);
	    }
	    if (curBar) curBar->fill(master,met0,met1);
	  }
	  // }
      }

      for (int i=0;i<parts;i++) myBar[i] = firstBar[i];
      int loop = 1;
      int iTreble = 0;
      int iBass = 0;
      while (loop) {
	if (systems>0) { // partiture
	  pNum = 0;
	  for (int i=0;i<parts;i++) {
	    if (((ScoreTrack*)_editor->part(i)->track())->PiP()) {
	      pNum++;
	      scrKey = _editor->part(i)->key();
	      for (int ii=0;ii<7;ii++) scrSigns[ii]=allSigns[scrKey+7][ii];
	      out << endl << "\t" << pNum << ": ";
	      relPos = _editor->part(i)->start() - lpos;
	      myBar[i]->mup(relPos,scrClef,master,met0,met1,&out,pNum-1); // error? ok, statt i pNum-1
	    }
	  }
	}
	if (psystem>0) { // piano system
	  pNum = totalsystems-1;
	  // scrKey?
	  // treble:
	  iTreble = 0;
	  for (int ii=0;ii<7;ii++) scrSigns[ii]=allSigns[scrKey+7][ii];
	  for (int i=0;i<parts;i++) {
	    if (((ScoreTrack*)_editor->part(i)->track())->PiPS()==1) { // 0: skip, 1: treble, 2: bass
	      iTreble++;
	      out << endl << "\t" << pNum << " " << iTreble << ": ";
	      relPos = _editor->part(i)->start() - lpos;
	      myBar[i]->mup(relPos,0,master,met0,met1,&out,pNum-1); // "0": treble-clef! error? ok, statt i pNum-1
	    }
	  }
	  // bass:
	  iBass = 0;
	  pNum = totalsystems;
	  for (int ii=0;ii<7;ii++) scrSigns[ii]=allSigns[scrKey+7][ii];
	  for (int i=0;i<parts;i++) {
	    if (((ScoreTrack*)_editor->part(i)->track())->PiPS()==2) { // 0: skip, 1: treble, 2: bass
	      iBass++;
	      out << endl << "\t" << pNum << " " << iBass << ": ";
	      relPos = _editor->part(i)->start() - lpos;
	      myBar[i]->mup(relPos,1,master,met0,met1,&out,pNum-1); // "0": treble-clef! error? ok, statt i pNum-1
	    }
	  }
	}
	out << endl << "bar";
	for (int i=0;i<parts;i++)
	  // if (_editor->part(i)->gTrack()->PiP())
	  myBar[i] = myBar[i]->Next();
	for (int i=0;i<parts;i++)
	  // if (_editor->part(i)->gTrack()->PiP())
	  if (myBar[i]==0) loop = 0;
      }*/
    }
  }
  // DOIT: remove bars and groups, etc !!!

}


void MupPrinter::paintBar(ScoreBar * bar, PrScoreEditor * ed, Table * grps, int x, int y, int style) {
  // (*_out) << " - bar" << endl;
  clef = bar->clef();
  key = bar->key();

  //
  // reset signs
  //
  resetSigns(key);

  // long left = bar->start().ticks();
  for (int i=0; i<grps->size(); i++) {
    ScoreGroup * grp = (ScoreGroup*) grps->get(i);
    grp->print(ed, x, y);
  }

  //
  // bow
  //
  
  while (mupPhrase!=0) {
    (*_out) << endl << "\tphrase " << _system_counter << ": " << mupPhrase->Range() << ";";
    MupPhrase * nxt = mupPhrase->Next();
    delete mupPhrase;
    mupPhrase = nxt;
  }
  mupPhrase = 0;
  
  //
  // lyrics
  //
  if (mupLyrics != 0) {
    if (_system_counter <= _lyrics_systems) {
      (*_out) << endl << "\tlyrics " << _system_counter++ << ": ";
      for (MupLyrics * ml = mupLyrics; ml!=0; ml = ml->Next()) (*_out) << ml->lengths() << ";";
      (*_out) << " \"";
      for (MupLyrics * ml = mupLyrics; ml!=0; ml = ml->Next()) {
	(*_out) << ml->text();
	if (ml->Next()!=0) (*_out) << " ";
      }
      (*_out) << "\";";
      while (mupLyrics!=0) {
	MupLyrics * nxt = mupLyrics->Next();
	delete mupLyrics;
	mupLyrics = nxt;
      }
    }
    mupLyrics = 0;
  }

}

void MupPrinter::paintGroup(ScoreGroup * group, PrScoreEditor * ed, Table * elements, int xoff, int yoff) {
  // (*_out) << " - group" << endl;
  tupbas = 0;
  tupdur = 0;
  ScoreElement * nx = 0;
  for (ScoreElement * el = (ScoreElement *) elements->first(); el != 0; el = nx) {
    nx = (ScoreElement*) elements->next(el);
    el->print(ed, xoff, yoff);
  }
}

void MupPrinter::specifyAtts(int attr, ostream * outp) {
  ostream & out = * outp;
  if (attr==0) {out << "[with ";}
  if (attr>0) {out << ",";}
}

void MupPrinter::paintChord(ScoreChord * chord, PrScoreEditor * ed, Table * notes, int xoff, int yoff) {
  // (*_out) << " - chord" << endl;

  yoff -= 8;

  initChordGeometry(1, 1);
  Note * note = 0;
  cli = 0;
  for (int i=0; i<notes->size(); i++) {
    note = ((Note*)((Reference*)notes->get(i))->getValue());
    if (note!=0) {
      use(note, chord);

      // sign: c_geometry->sgn
      // len:  c_geometry->len
      // dot:  dot();
      
      tupbas = note->tupletBase();
      
      Vector * vec = note->ornament();
      for (Ornament * orn = (Ornament*) vec->first(); orn != 0; orn = (Ornament*) vec->next(orn)) {
	if (orn->isA()==EXPRESSION) {
	  Expression * expr = (Expression*) orn;
	  if (expr) {
	    int attr = 0;
	    switch (expr->expression()) {
	    case NS_STACCATO: specifyAtts(attr,_out); (*_out) << "."; attr++; break;
	    case NS_LEGATO: specifyAtts(attr,_out); (*_out) << "-"; attr++; break;
	    case NS_ACCDOWN: specifyAtts(attr,_out); (*_out) << "\"\\(dnbow)\""; attr++; break;
	    case NS_ACCUP: specifyAtts(attr,_out); (*_out) << "\"\\(upbow)\""; attr++; break;
	    case NS_ACCENT1: specifyAtts(attr,_out); (*_out) << "\"\\(acc_hat)\""; attr++; break;
	    case NS_ACCENT2: specifyAtts(attr,_out); (*_out) << "\"\\(acc_gt)\""; attr++; break;
	    case NS_ACCENT3: specifyAtts(attr,_out); (*_out) << "\"\\(dim)\""; attr++; break;
	    case NS_ACCENT4: specifyAtts(attr,_out); (*_out) << "\"+\""; attr++; break;
	      // case NS_ACCENT5: specifyAtts(attr,_out); (*_out) << "\"\""; attr++; break;
	    case NS_ACCENT6: specifyAtts(attr,_out); (*_out) << "-,."; attr++; break;
	    case NS_ACCENT7: specifyAtts(attr,_out); (*_out) << ".,-"; attr++; break;
	    case NS_ACCENT8: specifyAtts(attr,_out); (*_out) << "-,\"\\(acc_gt)\""; attr++; break;
	    case NS_ACCENT9: specifyAtts(attr,_out); (*_out) << "\"\\(acc_gt)\",-"; attr++; break;
	    case NS_ACCENT10: specifyAtts(attr,_out); (*_out) << ".,\"\\(acc_gt)\""; attr++; break;
	    case NS_ACCENT11: specifyAtts(attr,_out); (*_out) << "\"\\(acc_gt)\",."; attr++; break;
	    case NS_TRILLER: specifyAtts(attr,_out); (*_out) << "\"\\(tr)\""; attr++; break;
	    case NS_TRILL1: specifyAtts(attr,_out); (*_out) << "\"\\(invmor)\""; attr++; break;
	    case NS_TRILL2: specifyAtts(attr,_out); (*_out) << "\"\\(mor)\""; attr++; break;
	    case NS_INF: specifyAtts(attr,_out); (*_out) << "\"\\(turn)\""; attr++; break;
	      //case NS_BOWUP: specifyAtts(attr,_out); (*_out) << "\"\""; attr++; break;
	      //case NS_BOWDOWN: specifyAtts(attr,_out); (*_out) << "\"\""; attr++; break;
	    }
	    if (attr>0) (*_out) << "] ";
	  }
	}
      }
      
      tupcoef = tupbas==0 ? 1 : tupbas*2.0/(tupbas+1);
      cli = 10-int(1.000001*log(tupcoef*c_geometry->len/3)/log(2));
      
      if (i == 0) {
	if (tupbas>1) {
	  if (tupdur==0) {
	    //
	    // start of a tuplet
	    //
	    tupdur = note->tupletDuration();
	    (*_out) << "{";
	  }
	  tupdur -= c_geometry->len;
	}
	switch (cli) {
	case 1: (*_out) << "1"; break;
	case 2: (*_out) << "2"; break;
	case 3: (*_out) << "4"; break;
	case 4: (*_out) << "8"; break;
	case 5: (*_out) << "16"; break;
	case 6: (*_out) << "32"; break;
	case 7: (*_out) << "64"; break;
	}
	int dt = dot();
	for (int i=0;i<dt;i++) (*_out) << ".";
      }

      int freq = note->pitch();
      int step = freq%12;
      int yy  = invPitch[freq];
      int sg  = sign[freq];
      int enh = note->enh();
      if (enh!=0) { yy += enhF[enh+2][step]; sg = enhS[enh+2][step]; }
      int sgMem = scrSigns[yy%7]; // Sign
      scrSigns[yy%7] = sg;
      if (sgMem == sg) { sg = 0; } else { if (sg==0) { sg = 3; } }

      (*_out) << (char) y2mup[yy%7];
      yy -= 3;
      (*_out) << 6-(yy-(yy%7))/7;
      sg = c_geometry->sgn;
      // cout << sg << " =? " << c_geometry->sgn << endl;
      if (sg!=0) {
	switch (sg+2) {
	case 0: (*_out) << "&&"; break;
	case 1: (*_out) << "&"; break;
	case 2: (*_out) << "n"; break;
	case 3: (*_out) << "#"; break;
	case 4: (*_out) << "x"; break;
	case 5: (*_out) << "n"; break;
	}
      }

      // bow ?
      for (Ornament * orn = (Ornament*) vec->first(); orn != 0; orn = (Ornament*) vec->next(orn)) {
	if (orn->isA()==BOW) {
	  Bow * bow = (Bow*) orn;
	  if (bow) {
	    if (bow->length()<=chord->duration()) (*_out) << "<>";
	    else {
	      if (mupPhrase!=0) mupPhrase->append(new MupPhrase(chord->start(),bow->length()));
	      else              mupPhrase = new MupPhrase(chord->start(),bow->length());
	    }
	  }
	} else if (orn->isA()==LYRICS) {
	  Lyrics * lyr = (Lyrics*) orn;
	  if (mupLyrics!=0) mupLyrics->append(new MupLyrics(cli,dot(),lyr->get()));
	  else              mupLyrics = new MupLyrics(cli,dot(),lyr->get());
	}
      }
      
    } else cout << "i(size): " << i << " (" << notes->size() << ") at:" << chord->start() << endl;
  }
  
  makeChordGeometry(xoff);
  (*_out) << ";";
  
  if (tupbas>1) {
    if (tupdur==0) (*_out) << " }" << tupbas << "; ";
  }
  
  // lyrics: lyrics()
}

void MupPrinter::paintBreak(ScoreBreak * bb, PrScoreEditor*, int, int) {
  // (*_out) << "                       - break" << bb->duration() << endl;

  if (bb->duration() != bb->display()) {
    if (tupdur==0) {
      //
      // start of a tuplet
      //
      tupdur = bb->duration();
      (*_out) << "{";
    }
    tupdur -= bb->duration();
  }
  
  int cli = 10-int(1.000001*log(bb->display()/3)/log(2));
  switch (cli) {
  case 1: (*_out) << "1r;"; break;
  case 2: (*_out) << "2r;"; break;
  case 3: (*_out) << "4r;"; break;
  case 4: (*_out) << "8r;"; break;
  case 5: (*_out) << "16r;"; break;
  case 6: (*_out) << "32r;"; break;
  case 7: (*_out) << "64r;"; break;
  case 8: (*_out) << "128r;"; break;
  }

  if (mupLyrics!=0) mupLyrics->append(new MupLyrics(cli,dot(),"<>"));

}

int MupPrinter::indentSystem(ScoreBar*) {
    return 0; // ### dummy
}

// ***************************************************************************
// *
// *  MupLyrics
// *  *********
// *

MupPrinter::MupLyrics::MupLyrics(int l, int d, const char * str) : cli(l), dot(d), next(0), lyrics((char*)strdup(str)) {
  help = new char[160];
}

MupPrinter::MupLyrics::~MupLyrics() {
  delete help;
  delete lyrics;
}

char * MupPrinter::MupLyrics::lengths() {

  int val = int(pow(2,cli-1));
  switch(dot) {
  case 1: sprintf(help,"%d.",val); break;
  case 2: sprintf(help,"%d..",val); break;
  case 3: sprintf(help,"%d...",val); break;
  default: sprintf(help,"%d",val); break;
  }
  return help;
}

char * MupPrinter::MupLyrics::text() {
  return lyrics;
}

MupPrinter::MupLyrics * MupPrinter::MupLyrics::Next() {
  return next;
}

void MupPrinter::MupLyrics::append(MupLyrics * mp) {
  if (next==0) next = mp;
  else next->append(mp);
}


// ***************************************************************************
// *
// *  MupPhrase
// *  *********
// *

MupPrinter::MupPhrase::MupPhrase(Position st, int len) : start(st), end(st+len), next(0) {
  help = new char[160];
  master = sonG->master();
  met0 = sonG->meter0();
  met1 = sonG->meter1();
  // cout << "s: " << start.gPosTicks() << ", len: " << len << ", end: " << end.gPosTicks() << endl;
}

MupPrinter::MupPhrase::~MupPhrase() {
  delete help;
}

char * MupPrinter::MupPhrase::Range() {
  int s_bar; int s_beat; int s_tick; int s_m0 = met0; int s_m1 = met1;
  start.gBBT(s_bar,s_beat,s_tick,master,s_m0,s_m1,true);

  double sFrac =  s_tick*s_m1/1536.0;
  double sValue = s_beat + sFrac;

  int e_bar; int e_beat; int e_tick; int e_m0 = met0; int e_m1 = met1;
  end.gBBT(e_bar,e_beat,e_tick,master,e_m0,e_m1,true);

  double eFrac =  e_tick*e_m1/1536.0;
  double eValue = e_beat + eFrac;

  int mdiff = e_bar - s_bar;

  // cout << s_bar << "." << s_beat << "." << s_tick << endl;
  // cout << e_bar << "." << e_beat << "." << e_tick << endl;


  if (mdiff==0) sprintf(help,"%.4f til %.4f",sValue,eValue);
  else          sprintf(help,"%.4f til %dm + %.4f",sValue,mdiff,eValue);
  // cout << "help:" << help << endl;
  return help;
}

MupPrinter::MupPhrase * MupPrinter::MupPhrase::Next() {
  return next;
}

void MupPrinter::MupPhrase::append(MupPhrase * mp) {
  if (next==0) next = mp;
  else next->append(mp);
}


#endif
