#ifndef _MOVEEVENT_H_
#define _MOVEEVENT_H_

#include "operation.h"
#include "position.h"

class Element;
class Compound;
class Event;
class Part;
class Table;

/** This operation moves one or more events to the position p
 */
class MoveEvent : public Operation
{
 private:
  Event * _event;
  Part  * _part;
  long    _delta_pos;
  int     _delta_pitch;
  Table * _selection;

 public:
  MoveEvent(Position p, Event * ev, Part * pt, int pitch = 0);
  MoveEvent(const MoveEvent&);
  ~MoveEvent();

  void undo();
  void redo();


  virtual ostream & print(int,ostream&) const;
  virtual void flush(const char*) const;
  virtual Element * copy() const;
};



#endif
