#ifndef _MOVEEVENT_CPP_
#define _MOVEEVENT_CPP_

#include <iostream.h>

#include "moveEvent.h"
#include "element.h"
#include "compound.h"
#include "reference.h"

#include "event.h"
#include "part.h"
#include "track.h"
#include "song.h"
#include "note.h"

extern Song * sonG;
extern Table * selectioN;

MoveEvent::MoveEvent(Position p, Event * ev, Part * pt, int pi) : _event(ev), _part(pt), _delta_pos(0), _delta_pitch(0), _selection(0) {
  _type = MOVEEVENT;
  _description = "move event";
  _to_be_undone = true;
  if (_event) {
    _delta_pos = (p - pt->start()) - _event->internalStart().ticks();
    if (_event->isA()==NOTE) if (pi!=0) _delta_pitch = pi - ((Note*) _event)->pitch();

    //
    // because of the strict order inside a part, event has to be removed and added again!
    //

    if (!selectioN->hasEntry(_event)) {
      //
      // single event:
      //
      _part->remove(_event);
      _event->setInternalStart(_event->internalStart() + _delta_pos);
      //
      // apply pitch-shift, when note:
      //
      if (_event->isA()==NOTE) {
	Note * n = (Note*) _event;
	if (_delta_pitch != 0) n->setPitch(n->pitch() + _delta_pitch);
      }
      _part->add(_event);
    } else {
      //
      // selection:
      //
      _selection = new Table();
      _description = "move events";
      for (Reference * r = (Reference*)selectioN->first(); r != 0; r = (Reference*) Element::next(r)) {
	Event * ev = (Event*) r->getValue();
	_selection->add(new Reference(ev));
	_part->remove(ev);
	ev->setInternalStart(ev->internalStart() + _delta_pos);
	//
	// apply pitch-shift, when note:
	//
	if (ev->isA()==NOTE) {
	  Note * n = (Note*) ev;
	  if (_delta_pitch != 0) n->setPitch(n->pitch() + _delta_pitch);
	}
	_part->add(ev);
      }
    }

  }
}

MoveEvent::MoveEvent(const MoveEvent& el) : Operation(el) {
  _type = MOVEEVENT;
  _event = el._event;
  _part = el._part;
  _delta_pos = el._delta_pos;
  _delta_pitch = el._delta_pitch;
  _selection = el._selection;
}

MoveEvent::~MoveEvent() {
  if (_selection!=0) {
    ((Compound*)_selection)->scratch();
    delete _selection;
  }
}

void MoveEvent::undo() {
  if (_event) {
    if (_selection==0) { // single event:
      _part->remove(_event);
      _event->setInternalStart(_event->internalStart() - _delta_pos);
      if (_event->isA()==NOTE) ((Note*) _event)->setPitch(((Note*)_event)->pitch() - _delta_pitch);
      _part->add(_event);
    } else {                            // selection:
      for (Reference * r = (Reference*)_selection->first(); r != 0; r = (Reference*) Element::next(r)) {
	Event * ev = (Event*) r->getValue();
	_part->remove(ev);
	ev->setInternalStart(ev->internalStart() - _delta_pos);
	if (ev->isA()==NOTE) ((Note*) ev)->setPitch(((Note*)ev)->pitch() - _delta_pitch);
	_part->add(ev);
      }
    }
  }
}

void MoveEvent::redo() {
  if (_event) {
    if (_selection==0) { // single event:
      _part->remove(_event);
      _event->setInternalStart(_event->internalStart() + _delta_pos);
      if (_event->isA()==NOTE) ((Note*) _event)->setPitch(((Note*)_event)->pitch() + _delta_pitch);
      _part->add(_event);
    } else {                            // selection:
      for (Reference * r = (Reference*)_selection->first(); r != 0; r = (Reference*) Element::next(r)) {
	Event * ev = (Event*) r->getValue();
	_part->remove(ev);
	ev->setInternalStart(ev->internalStart() + _delta_pos);
	if (ev->isA()==NOTE) ((Note*) ev)->setPitch(((Note*)ev)->pitch() + _delta_pitch);
	_part->add(ev);
      }
    }
  }
}



// ---------------
// virtuals:
//

ostream & MoveEvent::print(int dep, ostream & s) const {
  s << spc(dep) << "<MOVEEVENT event=\"" << _event << "\" _part=\"" << _part << "\" />" << endl;
  return s;
}

void MoveEvent::flush(const char * c) const {
  cout << c << "MOVEEVENT" << endl;
}

Element * MoveEvent::copy() const {
  return new MoveEvent(*this);
}




#endif
