#ifndef _LYRICS_CPP_
#define _LYRICS_CPP_

#include <string.h>
#include <iostream.h>
#include <stdlib.h>
#include <fstream.h>
#include "note.h"
#include "lyrics.h"
#include "part.h"
#include "loader.h"
#include "table.h"
#include "str.h"

extern char * getcmd(char*);

Lyrics::Lyrics() : _text(0) { _type = LYRICS; }

Lyrics::Lyrics(Note * n, char * txt) : _text(txt) {
  _type = LYRICS;
  // cout << "Lyrics: shall we add the lyrics to the note " << n << " here?" << endl; <- NO !
}

Lyrics::Lyrics(const Lyrics& o) : Ornament(o) {
  _type = LYRICS;
  _text = strdup(o.get());
}

void Lyrics::set(const char * c) { _text = c; }



// virtuals:


ostream & Lyrics::print(int dep, ostream & s) const {
  s << spc(dep) << "<LYRICS value=\"" << _text << "\" />" << endl;
  return s;
}

void Lyrics::flush(const char * c) const {
  cout << c << "LYRICS " << _text << endl;

}

Element * Lyrics::copy() const {
  return new Lyrics(*this);
}


Element * Lyrics::load(char * aline, ifstream *& , Element *) { // inPtr, parent
    Lyrics * lyr = new Lyrics();

  Table * attr = Loader::getAttributes("LYRICS",aline);
  if (attr!=0) {
    char * word = 0;

    if (attr->getEntry("value")) word = strdup(((String*) attr->getEntry("value"))->getValue());

    lyr->set(word);

    attr->scratch();
    delete attr;
  }
  return lyr;
}

#endif
