#ifndef _GLUEPARTS_H_
#define _GLUEPARTS_H_

#include "operation.h"
#include "position.h"

class Element;
class Compound;
class Part;

/** This operation glues two parts together
 */
class GlueParts : public Operation
{
 private:
  Part * _part;
  Part * _lost;
  Position _relpos;

 public:
  GlueParts(Part * pt);
  GlueParts(const GlueParts&);
  ~GlueParts();

  void undo();
  void redo();


  virtual ostream & print(int,ostream&) const;
  virtual void flush(const char*) const;
  virtual Element * copy() const;
};



#endif
