#ifndef _CHANGENOTE_H_
#define _CHANGENOTE_H_

#include "operation.h"
#include "position.h"

class Element;
class Compound;
class Note;
class Part;
class Table;

/** This operation changes the qualities of a note
 */
class ChangeNote : public Operation
{
 private:
  Note *  _note;
  Part *  _part;
  int      _delta_pitch;
  int      _delta_len;
  int      _delta_vel;
  int      _delta_enh;
  int      _delta_chan;
  // bool     _selection;
  Table *  _selection;

 public:
  ChangeNote(Note * nt, Part * pt, int pitch = 0, int len = 0, int vel = -1, int enh = -4, int chan = -2 );
  ChangeNote(const ChangeNote&);
  ~ChangeNote();

  void undo();
  void redo();


  virtual ostream & print(int,ostream&) const;
  virtual void flush(const char*) const;
  virtual Element * copy() const;
};



#endif
