#ifndef _GLOBALS_H_
#define _GLOBALS_H_

#define STEP 12
#define KEY 22
#define INTERVAL 14
#define GENUS 4

enum Key { UNDEFKEY, FES, CES, GES, DES, AS, ES, B, F, C, G, D, A, E, H, FIS, CIS, GIS, DIS, AIS, EIS, HIS };
enum Interval { UNDEFINT, PRIME, MINORSECOND, MAJORSECOND, MINORTHIRD, MAJORTHIRD, FOURTH, TRITONUS, FIFTH, MINORSIXTH, MAJORSIXTH, MINORSEVENTH, MAJORSEVENTH, OCTAVE };
enum Genus { UNDEFGEN, MINOR, MAJOR, DIMINISHED };

Key keyOfStep(int step, int enh);
int toneOfStep(Key key, int step);
int weight(Key, Genus, Key, int);
int harmonic_correlation(Key qkey, Genus qgenus, Key base, Genus genus);

extern const char * sKey[];
extern const char * sInterval[];
extern const char * sGenus[];


#endif
