// *************************************************************************
//
// Copyright (C) 2004-2006 Bruno PAGES  All rights reserved.
//
// This file is part of the BOUML Uml Toolkit.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// e-mail : bouml@free.fr
// home   : http://bouml.free.fr
//
// *************************************************************************

#ifndef BROWSER_PACKAGE_H
#define BROWSER_PACKAGE_H

#include <qintdict.h> 

#include "BrowserNode.h"
#include "Labeled.h"
#include "Settings.h"

class PackageData;
class BrowserClassDiagram;
class StereotypesDialog;

class BrowserPackage : public BrowserNode, public Labeled<BrowserPackage> {
  friend class StereotypesDialog;
  
  protected:
    static QList<BrowserPackage> removed;
    static IdDict<BrowserPackage> all;
      
    static QStringList its_default_stereotypes;
    static QStringList relation_default_stereotypes;
    
    PackageData * def;
    BrowserNode * associated_diagram;
    ClassDiagramSettings classdiagram_settings;
    ClassSettings class_settings;
    UseCaseDiagramSettings usecasediagram_settings;
    SequenceDiagramSettings sequencediagram_settings;
    CollaborationDiagramSettings collaborationdiagram_settings;
    ObjectDiagramSettings objectdiagram_settings;
    ComponentDiagramSettings componentdiagram_settings;
    DeploymentDiagramSettings deploymentdiagram_settings;
    StateDiagramSettings statediagram_settings;
    ActivityDiagramSettings activitydiagram_settings;
    UmlColor class_color;
    UmlColor package_color;
    UmlColor note_color;
    UmlColor fragment_color;
    UmlColor subject_color;
    UmlColor usecase_color;
    UmlColor component_color;
    UmlColor artifact_color;
    UmlColor deploymentnode_color;
    UmlColor duration_color;
    UmlColor continuation_color;
    UmlColor state_color;
    UmlColor stateaction_color;
    UmlColor activity_color;
    UmlColor activityregion_color;
    UmlColor activityaction_color;
    UmlColor parameterpin_color;
    bool is_imported;
    
  protected:
    BrowserPackage(int id);
    BrowserPackage * find_it(const char * s, const MyStr & (PackageData::* pf)() const);
    void make();
      
  public:
    BrowserPackage(QString s, BrowserNode * parent, int id = 0);
    BrowserPackage(QString s, BrowserView * parent, int id = 0);
    BrowserPackage(const BrowserPackage * model, BrowserNode * p);
    virtual ~BrowserPackage();
    
    virtual BrowserNode * get_associated() const;
    void set_associated_diagram(BrowserNode *, bool on_read = FALSE);
  
    virtual BrowserNode * duplicate(BrowserNode * p,
				    QString name = QString::null);
    virtual QString full_name(bool rev = FALSE, bool itself = TRUE) const;
    virtual void menu();
    virtual void open(bool force_edit);
    virtual void on_close();
    virtual UmlCode get_type() const;
    virtual bool may_contains_them(const QList<BrowserNode> &,
				   bool & duplicable) const;
    virtual BasicData * get_data() const;
    virtual const QStringList & default_stereotypes(UmlCode);
    virtual void get_classdiagramsettings(ClassDiagramSettings &) const;
    virtual void get_usecasediagramsettings(UseCaseDiagramSettings &) const;
    virtual void get_sequencediagramsettings(SequenceDiagramSettings &) const;
    virtual void get_collaborationdiagramsettings(CollaborationDiagramSettings &) const;
    virtual void get_objectdiagramsettings(ObjectDiagramSettings &) const;
    virtual void get_componentdiagramsettings(ComponentDiagramSettings &) const;
    virtual void get_deploymentdiagramsettings(DeploymentDiagramSettings &) const;
    virtual void get_statediagramsettings(StateDiagramSettings & r) const;
    virtual void get_activitydiagramsettings(ActivityDiagramSettings & r) const;
    virtual UmlColor get_color(UmlCode) const;
    virtual bool get_shadow(UmlCode) const;
    virtual bool get_classinstwritehorizontally(UmlCode k) const;
    virtual void get_componentdrawingsettings(bool depl, ComponentDrawingSettings & r) const;
    virtual void get_statedrawingsettings(StateDrawingSettings & r) const;
    virtual void get_activitydrawingsettings(ActivityDrawingSettings & r) const;
    virtual UmlVisibility get_visibility(UmlCode) const;
    virtual bool get_auto_label_position(UmlCode who) const ;
    virtual bool get_write_label_horizontally(UmlCode who) const ;
    virtual bool get_show_trans_definition(UmlCode who) const;
    virtual bool get_show_opaque_action_definition(UmlCode who) const;
    virtual DrawingLanguage get_language(UmlCode who) const;
    virtual void on_delete();
    virtual const char * check_inherit(const BrowserNode * parent) const;
    const char * may_connect(UmlCode & l, const BrowserNode * dest) const;
    virtual void referenced_by(QList<BrowserNode> &);
    
    virtual bool tool_cmd(ToolCom * com, const char * args);
    static bool tool_global_cmd(ToolCom * com, const char * args);
    virtual void write_id(ToolCom * com);
    virtual void save(QTextStream &, bool ref, QString & warning);
    virtual void package_modified();
    
    void save_session(QTextStream & st);
    void read_session(char * &, const char * k);
    static BrowserNode * get_it(const char * k, int id);
    
    void edit_gen_settings();
    void edit_stereotypes();
    void edit_class_settings();
    void edit_drawing_settings();
    
    virtual const QPixmap* pixmap (int) const;
    virtual void DragMoveEvent(QDragMoveEvent * e);
    virtual void DropEvent(QDropEvent * e);
    virtual void DragMoveInsideEvent(QDragMoveEvent * e);
    virtual void DropAfterEvent(QDropEvent * e, BrowserNode * after);
    
    void add_package();
    void add_use_case_view();
    void add_class_view();
    void add_component_view();
    void add_deployment_view();
    unsigned load(bool recursive, int id = -1);
    void import_project();
    
    static BrowserNodeList & instances(BrowserNodeList &);
    static BrowserPackage * get_package();
    
    static void init();
    static const QStringList & default_stereotypes();
    static void read_stereotypes(char * &, char * &);
    static bool read_stereotypes(const char * = 0);
    static bool import_stereotypes();
    static void save_stereotypes();
    
    static BrowserPackage * read_ref(char * &);
    static BrowserPackage * read(char * &, char *, BrowserNode *, bool);
    static void save_all(bool modified_only);
    static bool must_be_saved();
    virtual void init_save_counter();
    
    static void clear(bool old);
    static void update_idmax_for_root();
    virtual void renumber(int phase);
};

#endif
