[-- template default.template --]
[-- define title=Command Line Operation --]
[-- define chapter_title=3. Using BookmarkBridge --]
[-- define prev_link=online_help.html --]
[-- define prev_title=Online Help --]
[-- define next_link=# --]
[-- define next_title=None --]

<p>
BookmarkBridge has limited support for command line operation.  Originally developed
for automated regression testing during development, the command line switches can
perform bookmark merge operations and accept specifications for configuration files.
Future versions of BookmarkBridge will have a richer set of command line options.
This feature is meant for advanced users.  If you are not comfortable in your
operating system's command line environment then you can safely skip this section.
Typing bookmarkbridge -h will provide a summary of available options.
</p>

<h3>Summary: [-b file] [-f file] [-m [-r]] [-t]</h3>
<p>
The brackets, &quot;[&quot; and &quot;]&quot;, surround optional switches.  Technically,
all command line options in BookmarkBridge are optional.
</p>

<dl>
	<dt>-b file</dt>
	<dd>
		Specify bookmark tree file.  This is the file BookmarkBridge uses to
		store information on the bookmarks and folders stored in each
		browser.  Between invocations, a complete copy of the bookmarks and
		folders are stored in this file so BookmarkBridge knows when an item
		has been deleted from a browser.  This file is typically named
		bookmarks.xbel.
	</dd>
	<dt>-f file</dt>
	<dd>
		Specify configuration file.  This file stores BookmarkBridge's
		configuration options, including the list of browsers and which
		ones are configured as sources and destinations.  This file is
		typically names bridgeconf.xml.
	</dd>
	<dt>-m</dt>
	<dd>
		This options tells BookmarkBridge to perform a bookmark merge
		then exit.  No user interface is shown.  In fact, no user interaction
		is performed at all.  If a problem or error occurs during the
		merge process, an error code of 5 is returned to the operating
		system's command interpretor.
	</dd>
	<dt>-r</dt>
	<dd>
		This option makes sense only when <b>-m</b> is also provided.  It
		tells BookmarkBridge to not save changes to the bookmark tree file,
		briefly described above with the <b>-b</b> option.  If this option
		is not specified, BookmarkBridge saves the results of the merge
		to this file, in addition to each browser specified as a destination.
	</dd>
	<dt>-t</dt>
	<dd>
		This option is really only for testing purposes.  It tells
		BookmarkBridge to not save dates, such as date of last modification
		for a bookmark or the date of last visit.  Typically, BookmarkBridge
		saves these dates for each bookmark and folder.  These dates, however,
		interfere with testing.
	</dd>
</dl>
