// Parser.H  -*- C++ -*-
// Copyright (c) 1997, 1998 Etienne BERNARD

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef PARSER_H
#define PARSER_H

#include "String.H"
#include "Person.H"
#include "ServerConnection.H"

#ifdef USESCRIPTS
#include "Interp.H"
extern "C" {
#include <guile/gh.h>
}
#endif

struct userFunctionsStruct {
  const char * name;
  void (*function)(ServerConnection *, Person *, String, String);
  int minLevel;
  bool needsChannelName;
};

class userFunction {
public:
  String name;
  void (*function)(ServerConnection *, Person *, String, String);
  int minLevel;
  bool needsChannelName;
#ifdef USESCRIPTS
  int argsCount;
  SCM scmFunc;
#endif

  userFunction(String na,
               void (*f)(ServerConnection *, Person *,
                         String, String),
               int m, bool n
#ifdef USESCRIPTS
               , int a = -1, SCM scm_f = 0
#endif
               )
    : name(na), function(f), minLevel(m), needsChannelName(n)
#ifdef USESCRIPTS
      ,argsCount(a), scmFunc(scm_f)
#endif
    {
#ifdef USESCRIPTS
//      scm_protect_object(scm_f);
#endif
    }

#ifdef USESCRIPTS
//  ~userFunction()
//    { scm_unprotect_object(scmFunc); };
#endif
};

class Parser {
public:
  static void parseLine(ServerConnection *, String);

  static void parse001(ServerConnection *, Person *, String);
  static void parse302(ServerConnection *, Person *, String);
  static void parse311(ServerConnection *, Person *, String);
  static void parse315(ServerConnection *, Person *, String);
  static void parse324(ServerConnection *, Person *, String);
  static void parse332(ServerConnection *, Person *, String);
  static void parse352(ServerConnection *, Person *, String);
  static void parse353(ServerConnection *, Person *, String);
  static void parse366(ServerConnection *, Person *, String);
  static void parse367(ServerConnection *, Person *, String);
  static void parse401(ServerConnection *, Person *, String);
  static void parse433(ServerConnection *, Person *, String);
  static void parse473(ServerConnection *, Person *, String);
  static void parseError(ServerConnection *, Person *, String);
  static void parseInvite(ServerConnection *, Person *, String);
  static void parseJoin(ServerConnection *, Person *, String);
  static void parseKick(ServerConnection *, Person *, String);
  static void parseMode(ServerConnection *, Person *, String);
  static void parseNick(ServerConnection *, Person *, String);
  static void parseNotice(ServerConnection *, Person *, String); 
  static void parsePart(ServerConnection *, Person *, String);
  static void parsePing(ServerConnection *, Person *, String);
  static void parsePong(ServerConnection *, Person *, String);
  static void parsePrivmsg(ServerConnection *, Person *, String);
  static void parseQuit(ServerConnection *, Person *, String);
  static void parseTopic(ServerConnection *, Person *, String);

  static void parseCTCP(ServerConnection *, Person *, String,
                        String);
  static void parseMessage(ServerConnection *, Person *, String,
                           String);
#ifdef USESCRIPTS
  static void parseScriptFunction(ServerConnection *, String, bool,
                                  SCM, int, String);
#endif

  static void sendNotice(Person *, String);
};

#endif
