{-
    BNF Converter: Main file
    Copyright (C) 2004  Authors: 
    Bjrn Bringert, Markus Forberg, Peter Gammie, Patrik Jansson,
    Antti-Juhani Kaijanaho, Michael Pellauer, Aarne Ranta

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-}


module Main where

-- import Utils
-- import CF
import HaskellTop
import ProfileTop
import JavaTop
import JavaTop15
import CPPTop
import CTop
import CFtoXML
import System
import Char

title = unlines [
  "The BNF Converter, 2.2", 
  "(c) Bjorn Bringert, Markus Forsberg, Peter Gammie, Patrik Jansson,",
  "Antti-Juhani Kaijanaho, Michael Pellauer, and Aarne Ranta 2002 - 2004.",
  "Free software under GNU General Public License (GPL).",
  "Bug reports to {markus,aarne}@cs.chalmers.se."
 ]
 
main :: IO ()
main = do
  xx <- getArgs
  if xx == []
    then printUsage
    else do
      let args = (map (filter (not . isSpace)) xx)
      let file = last args
      let make = elem "-m" args
      let c = elem "-c" args
      let cpp = elem "-cpp" args
      let java = elem "-java" args
      let java15 = elem "-java1.5" args
      let haskell = elem "-haskell" args
      let profile = elem "-prof" args
      let alex1 = "-alex1" `elem` args
          alex2 = "-alex2" `elem` args
	  alex1or2 = alex1
          alex2StringSharing = elem "-sharestrings" args
          glr = "-glr" `elem` args
      let xml = if elem "-xml"  args then 1 else 
                if elem "-xmlt" args then 2 else 0
      let inDir = elem "-d" args
      let name = takeWhile (/= '.') file
      if checkUsage False [c, cpp, java, haskell, profile] then
       do
       if (isCF (reverse file)) then 
        do 
         putStrLn title
         case () of
           _ | c      -> makeC make file
           _ | cpp    -> makeCPP make file
           _ | java   -> makeJava make file
           _ | java15 -> makeJava15 make file
           _ | profile-> makeAllProfile make alex1or2 False xml file
           _          -> makeAll make alex1or2 inDir alex2StringSharing glr xml file
	 else endFileErr
       else endLanguageErr
 where isCF ('f':'c':'.':_) = True
       isCF _               = False
       endFileErr = do 
                      putStr title
                      putStrLn "Error: the input file must end with .cf"
		      exitFailure
       endLanguageErr = do 
                          putStr title
                          putStrLn "Error: only one language mode may be chosen"
			  exitFailure
       printUsage = do 
                      putStr title
		      putStrLn 
                        "Usage     : bnfc <makeoption>* <language>? <special>* file.cf"
		      putStrLn "Make option:"
		      putStrLn "          : -m         generate Makefile"
		      putStrLn "Languages :"
		      putStrLn "          : (Only one language mode may be selected.)"
		      putStrLn "          : -java      Output Java code for use with JLex and CUP"
		      putStrLn "          : -java1.5   Output Java 1.5 code for use with JLex and CUP"
		      putStrLn "          : -c         Output C code for use with FLex and Bison"
		      putStrLn "          : -cpp       Output C++ code for use with FLex and Bison"
		      putStrLn "          : -haskell   Output Haskell code for use with Alex and Happy (default)"
		      putStrLn "          : -prof      Output Haskell code for rules with permutation profiles"
		      putStrLn "Special (Haskell-related) options :"
		      putStrLn "          : -d <dir>   Output Haskell code in directory <dir>"
		      putStrLn "          : -alex1     Use Alex 1.1 as Haskell lexer tool"
		      putStrLn "          : -alex2     Use Alex 2 as Haskell lexer tool (default)"
		      putStrLn "          : -sharestrings Use string sharing in Alex 2 lexer"
		      putStrLn "          : -glr       Output Happy GLR parser"
		      putStrLn "          : -xml       Also generate a DTD and an XML printer"
		      putStrLn "          : -xmlt      DTD and an XML printer, another encoding"
		      exitFailure
--		      putStrLn "          : -gf        write GF files"


checkUsage _ [] = True
checkUsage True (True:xs) = False
checkUsage False (True:xs) = checkUsage True xs
checkUsage old (x:xs) = checkUsage old xs
