/*
 * Copyright (C) 1998,1999  Ross Combs (rocombs@cs.nmsu.edu)
 * Copyright (C) 1999  Rob Crittenden (rcrit@greyoak.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* make bnchat, etc print debug messages */
#undef CLIENTDEBUG

#ifdef USE_MEM_TEST /* set by configure */

#include "mem_test_user.h"

/* test memory allocation by poisoning freed memory */
#define MEM_POISON

/* I have a hacked up mem_test.c that puts magic numbers in
 * newly allocated memory and freed memory. Instead of making
 * the library remember the size of each allocation, I have
 * a special free() called pfree() that takes a second parameter
 * which is the size of the area to free.
 */
#ifndef MEM_POISON
#define pfree(ptr,size) free(ptr)
#endif

#else
#define pfree(ptr,size) free(ptr)
#endif

/* this will test get/unget memory management in account.c */
#undef TESTUNGET

/* to enable /connections for all users */
#define CONNDEBUG

/* length of listen socket queue */
#define LISTEN_QUEUE 10

/* the format of timestamps in the logfile */
#define EVENT_TIME_FORMAT "%b %d %H:%M:%S"
#define EVENT_TIME_MAXLEN 32

/* the format of the stat times in bnstat */
#define STAT_TIME_FORMAT "%Y %b %d %H:%M:%S"
#define STAT_TIME_MAXLEN 32

/* the format of the file modification time in bnftp */
#define FILE_TIME_FORMAT "%Y %b %d %H:%M:%S"
#define FILE_TIME_MAXLEN 32

#ifndef BNETD_DEFAULT_CONF_FILE
#define BNETD_DEFAULT_CONF_FILE "conf/bnetd.conf"
#endif
#define BNETD_FILE_DIR          "files"
#define BNETD_USER_DIR          "users"
#define BNETD_REPORT_DIR        "reports"
#define BNETD_LOG_FILE          "logs/bnetd.log"
#define BNETD_TEMPLATE_FILE     "conf/account_template.txt"
#define BNETD_MOTD_FILE         "conf/bnmotd.txt"
#define BNETD_NEWS_DIR          "news"
#define BNETD_AD_FILE           "conf/ad.conf"
#define BNETD_CHANNEL_FILE      "conf/channel.conf"
#define BNETD_PID_FILE          "" /* this means "none" */
#define BNETD_ACCOUNT_TMP       ".bnetd_acct_temp"

/* files relative to FILE_DIR */
#define BNETD_TOS_FILE    "tos.txt"
#define BNETD_ICON_FILE   "icons.bni"
#define BNETD_MPQ_FILE    "missing.mpq"
#define BNETD_MPQ_VERSION 0

/* Other default values */
#define BNETD_LOG_LEVELS          "warn,error"
#define BNETD_SERV_ADDRS          ":" /* this means "all" */
#define BNETD_SERV_PORT           6112 /* use this port if not specified */
#define BNETD_TRACK_ADDRS         "track.bnetd.org"
#define BNETD_TRACK_PORT          6114 /* use this port if not specified */
#define BNETD_GAME_PORT           6112
#define BNETD_TEST_PORT           6112
#define BNETD_USERSYNC            300
#define BNETD_USERFLUSH           1000
#define BNETD_LATENCY             10
#define BNETD_TRACK_TIME          0
#define BNETD_POLL_INTERVAL       20000 /* 20 ms */
#define BNETD_SHUTDELAY           300
#define BNETD_SHUTDECR            60
#define BNETD_DEFAULT_OWNER       "Bob"
#define BNETD_DEFAULT_KEY         "3310541526205"
#define BNETD_DEFAULT_HOST        "localhost"

/* adjustable constants */
#define BNETD_LADDER_DEFAULT_TIME "19764578 0" /* 0:00 1 Jan 1970 GMT */

