/*
** console.h -- prototypes for support routines
*/

#ifndef PP
#define PP(x)	x
#endif

/*
** Backspace character
*/

#define	CONSOLE_BS	0

/*
** TRUE if the current multi-screen is active
*/

extern boolean console_is_active;

/*
** Initialize, returns 0 if OK
**
** repaint is routine that will repaint the screen
**   needed because switches out of graphics mode do not preserve the image
*/

int console_init PP(( void (*repaint) PP(( void )) ));

/*
** Finish, returns 0 if OK
*/

int console_finish PP(( void ));

/*
** Return TRUE if console is in graphics mode
*/

int console_in_graphics_mode PP(( void ));

/*
** Enter text mode
*/

int console_text_mode PP(( int force ));

/*
** Return to graphics mode
*/

int console_graphics_mode PP(( int force ));

/*
** Set the current colors
*/

void console_setcolor PP(( int color ));

/*
** Set the current screen location
*/

void console_gotorc PP(( int row, int col ));

/*
** Write a string at the current cell, can handle backspaces
*/

void console_putstr PP(( const char *str, int len ));

/*
** Clear the screen to black
*/

int console_clear PP(( void ));

/*
** get size of display area in pixels
*/

void console_displaysize PP(( int *len, int *wid ));

/*
** get size of a character cell in pixels
*/

void console_fontsize PP(( int *len, int *wid ));

/*
** Draw a string within a pixel area, does not change background
*/

void console_drawstr PP(( int row, int col, int len, int wid,
		const char *str, int slen, int color ));

/*
** Fill in a box
*/

void console_box PP(( int row, int col, int len, int wid, int color ));

/*
** Draw the mouse
**   clears the previous mouse image
**   set to -1 -1 to make the mouse go away
*/

void console_place_mouse PP(( int row, int col));

/*
** Beep
*/

void console_beep PP(( void ));
