;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Llib/tar.scm                 */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Mar 23 17:07:04 2006                          */
;*    Last change :  Wed Mar 29 10:05:30 2006 (serrano)                */
;*    Copyright   :  2006 Manuel Serrano                               */
;*    -------------------------------------------------------------    */
;*    Read TAR files (rfc1505)                                         */
;*    -------------------------------------------------------------    */
;*    Based on Chicken's tar implementation (Felix L. Winkelmann).     */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __tar
   
   (import  __error
	    __r4_ports_6_10_1
	    __r4_output_6_10_3
	    __r5_control_features_6_4
	    __object
	    __rgc)
   
   (use     __type
	    __bigloo
	    __param
	    __tvector
	    __structure
	    __tvector
	    __bit
	    __date
	    
	    __r4_numbers_6_5
	    __r4_numbers_6_5_fixnum
	    __r4_numbers_6_5_flonum
	    __r4_characters_6_6
	    __r4_equivalence_6_2
	    __r4_booleans_6_1
	    __r4_symbols_6_4
	    __r4_strings_6_7
	    __r4_pairs_and_lists_6_3
	    __r4_input_6_10_2
	    __r4_control_features_6_9
	    __r4_vectors_6_8
	    __r4_ports_6_10_1
	    __evenv)
   
   (export (class tar-header
	      (name::bstring read-only)
	      (mode::long read-only)
	      (uid::long read-only)
	      (gid::long read-only)
	      (size::elong read-only)
	      (mtime::date read-only)
	      (checksum::long read-only)
	      (type::symbol read-only)
	      (linkname::bstring read-only)
	      (magic::bstring read-only)
	      (uname::bstring read-only)
	      (gname::bstring read-only)
	      (devmajor::long read-only)
	      (devminor::long read-only))
	   
	   (tar-read-header #!optional (port (current-input-port)))
	   (tar-read-block ::tar-header #!optional (p (current-input-port)))
	   (tar-round-up-to-record-size::long ::long)))

;*---------------------------------------------------------------------*/
;*    tar-error ...                                                    */
;*---------------------------------------------------------------------*/
(define (tar-error msg obj)
   (raise (instantiate::&io-parse-error
	     (proc 'tar)
	     (msg msg)
	     (obj obj))))

;*---------------------------------------------------------------------*/
;*    tar constants ...                                                */
;*---------------------------------------------------------------------*/
(define (tar-record-size) 512)
(define (tar-name-size) 100)
(define (tar-tunmlen) 32)
(define (tar-tgnmlen) 32)
(define (tar-tmagic) "ustar  ")
(define (tar-gnumagic) "GNUtar ")

;*---------------------------------------------------------------------*/
;*    tar-type-name ...                                                */
;*---------------------------------------------------------------------*/
(define (tar-type-name c)
   (case c
      ((#\null) 'oldnormal)
      ((#\0) 'normal)
      ((#\1) 'link)
      ((#\2) 'symlink)
      ((#\3) 'chr)
      ((#\4) 'blk)
      ((#\5) 'dir)
      ((#\6) 'fifo)
      ((#\7) 'contig)
      (else (tar-error "invalid file type" c))))

;*---------------------------------------------------------------------*/
;*    str->octal ...                                                   */
;*---------------------------------------------------------------------*/
(define (str->octal str #!optional (err #t))
   (or (string->integer str 8)
       (if err
	   (tar-error "invalid octal record item" str)
	   0)))

;*---------------------------------------------------------------------*/
;*    checksum ...                                                     */
;*---------------------------------------------------------------------*/
(define (checksum buf)
   (let* ((p (+fx (tar-name-size) 48))
	  (b2 (string-append
	       (substring buf 0 p)
	       "        "
	       (substring buf (+fx p 8) (string-length buf)))))
      (do ((i 0 (+fx 1 i))
	   (s 0 (+fx s (char->integer (string-ref b2 i)))))
	  ((>=fx i (tar-record-size)) s))))

;*---------------------------------------------------------------------*/
;*    tar-read-header ...                                              */
;*---------------------------------------------------------------------*/
(define (tar-read-header #!optional (port (current-input-port)))
   (let ((ptr 0)
	 (data (read-chars (tar-record-size) port)))
      (define (extract size)
	 (let loop ((i 0))
	    (if (>=fx i size)
		(tar-error
		 (format "no terminator for zero-terminated string found: ~a"
			 i)
		 size)
		(let ((c (string-ref data (+fx ptr i))))
		   (cond ((char=? #\null c)
			  (let* ((nptr (+fx ptr i))
				 (sub (substring data ptr nptr)))
			     (set! ptr (+fx ptr size))
			     sub))
			 (else
			  (loop (+fx 1 i))))))))
      (define (fetch)
	 (let ((c (string-ref data ptr)))
	    (set! ptr (+fx 1 ptr))
	    c))
      (let ((name (if (or (not (string? data)) (=fx (string-length data) 0))
		      ""
		      (extract (tar-name-size)))))
	 (when (>fx (string-length name) 0)
	    (let* ((mode (str->octal (extract 8)))
		   (uid (str->octal (extract 8)))
		   (gid (str->octal (extract 8)))
		   (size (string->elong (extract 12) 8))
		   (mtime (string->elong (extract 12) 8))
		   (chksum (str->octal (extract 8)))
		   (linkflag (fetch))
		   (linkname (extract (tar-name-size)))
		   (magic (extract 8))
		   (uname (extract (tar-tunmlen)))
		   (gname (extract (tar-tgnmlen)))
		   (devmajor (str->octal (extract 8) #f))
		   (devminor (str->octal (extract 8) #f)) 
		   (csum2 (checksum data)))
	       (cond
		  ((not (or (string=? (tar-tmagic) magic)
			    (string=? (tar-gnumagic) magic)))
		   (tar-error "invalid magic number" magic))
		  ((not (=fx csum2 chksum))
		   (tar-error
		    (format "invalid checksum (expected: ~s)" chksum)
		    csum2))
		  (else
		   (instantiate::tar-header
		      (name name)
		      (mode mode)
		      (uid uid)
		      (gid gid)
		      (size size)
		      (mtime (seconds->date mtime))
		      (checksum chksum)
		      (type (tar-type-name linkflag))
		      (linkname linkname)
		      (magic magic)
		      (uname uname)
		      (gname gname)
		      (devmajor devmajor)
		      (devminor devminor)))))))))

;*---------------------------------------------------------------------*/
;*    tar-round-up-to-record-size ...                                  */
;*---------------------------------------------------------------------*/
(define (tar-round-up-to-record-size n)
  (*fx (tar-record-size)
       (/fx (+fx n (-fx (tar-record-size) 1)) (tar-record-size))))

;*---------------------------------------------------------------------*/
;*    tar-read-block ...                                               */
;*---------------------------------------------------------------------*/
(define (tar-read-block h #!optional (p (current-input-port)))
   (if (tar-header? h)
       (let ((n (elong->fixnum (tar-header-size h))))
	  (if (=fx n 0)
	      #f
	      (let ((s (read-chars n p)))
		 (if (<fx (string-length s) n)
		     (error 'tar-read-block
			    "Illegal block"
			    (tar-header-name h))
		     (read-chars (-fx (tar-round-up-to-record-size n) n) p))
		 s)))
       (bigloo-type-error 'tar-read-block "tar-header" h)))
