using System;
using System.Net.Sockets;
using System.IO;

namespace bigloo
{
  public class output_socket_port: output_port
  {
    public Socket _socket;

    public output_socket_port( Socket  _socket )
    {
      this._socket= _socket;
    }

    public override Object close()
    {
      _socket= null;
      return this;
    }

    public override Object flush()
    {
      // Nothing to flush...
      return bbool.vrai;
    }

    public override void write( int  cn ) 
    {
      try
      {
        byte[] buffer= { (byte)cn };

        _socket.Send( buffer );
      }
      catch (Exception e)
      {
        if (_socket != null)
	   foreign.fail( "write", e.Message, this );
      }
    }

    public override void write( byte[]  s ) 
    {
      try
      {
	 _socket.Send( s );
      }
      catch (Exception e)
      {
        if (_socket != null)
          foreign.fail( "write", e.Message, this );
      }
    }

    public override void write( byte[]  s, int start, int end ) 
    {
      try
      {
	 byte[] r = new byte[ end - start ];
	 int j = 0;

	 for ( int i= start ; i < end ; ++i, ++j ) r[j]= s[i];

	 _socket.Send( r );
      }
      catch (Exception e)
      {
        if (_socket != null)
          foreign.fail( "write", e.Message, this );
      }
    }

    public override void write( String  s )
    {
      try
      {
        byte[] buffer= foreign.getbytes( s );

        _socket.Send( buffer );
      }
      catch (Exception e)
      {
        if (_socket != null)
          foreign.fail( "write", e.Message, this );
      }
    }
  }
}
