/*=====================================================================*/
/*    serrano/prgm/project/bigloo/api/pthread/src/Posix/bglsetup.c     */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Thu Oct 21 15:57:25 2004                          */
/*    Last change :  Mon Oct 10 10:57:34 2005 (serrano)                */
/*    Copyright   :  2004-05 Manuel Serrano                            */
/*    -------------------------------------------------------------    */
/*    The pthread setup                                                */
/*=====================================================================*/
#include <pthread.h>

#define GC_PRIVATE_H
#include <gc.h>
#include <bigloo.h>
#include <bglpthread.h>

/*---------------------------------------------------------------------*/
/*    Imports                                                          */
/*---------------------------------------------------------------------*/
extern void bglpth_setup_mutex();
extern void bglpth_setup_condvar();
extern void bglpth_setup_thread();
extern void bglpth_setup_bmem();

/*---------------------------------------------------------------------*/
/*    void                                                             */
/*    bglpth_setup_gc ...                                              */
/*---------------------------------------------------------------------*/
void
bglpth_setup_gc() {
#if( BGL_GC == BGL_BOEHM_GC && BGL_GC_HAVE_BLOCKING )
   extern void GC_start_blocking();
   extern void GC_end_blocking();

   bgl_gc_start_blocking = &GC_start_blocking;
   bgl_gc_stop_blocking = &GC_end_blocking;
#endif
   
   GC_init();
}

/*---------------------------------------------------------------------*/
/*    void                                                             */
/*    bglpth_setup ...                                                 */
/*---------------------------------------------------------------------*/
BGL_EXPORTED_DEF
void
bglpth_setup( int argc, char *argv, char **env ) {
#ifdef PTW32_VERSION
   /* Pthreads-win32 initialization */
   pthread_win32_process_attach_np();
#endif

   bglpth_setup_gc();
   bglpth_setup_bmem();
   bglpth_setup_mutex();
   bglpth_setup_condvar();
   bglpth_setup_thread();
}
